"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBasemapLayerDescriptor = createBasemapLayerDescriptor;
var _lodash = _interopRequireDefault(require("lodash"));
var _util = require("../../util");
var _kibana_services = require("../../kibana_services");
var _kibana_tilemap_source = require("../sources/kibana_tilemap_source");
var _raster_tile_layer = require("./raster_tile_layer/raster_tile_layer");
var _ems_vector_tile_layer = require("./ems_vector_tile_layer/ems_vector_tile_layer");
var _ems_tms_source = require("../sources/ems_tms_source");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createBasemapLayerDescriptor() {
  const tilemapSourceFromKibana = (0, _util.getKibanaTileMap)();
  if (_lodash.default.get(tilemapSourceFromKibana, 'url')) {
    const layerDescriptor = _raster_tile_layer.RasterTileLayer.createDescriptor({
      sourceDescriptor: _kibana_tilemap_source.KibanaTilemapSource.createDescriptor()
    });
    return layerDescriptor;
  }
  const isEmsEnabled = (0, _kibana_services.getEMSSettings)().isEMSEnabled();
  if (isEmsEnabled) {
    const layerDescriptor = _ems_vector_tile_layer.EmsVectorTileLayer.createDescriptor({
      locale: _constants.AUTOSELECT_EMS_LOCALE,
      sourceDescriptor: _ems_tms_source.EMSTMSSource.createDescriptor({
        isAutoSelect: true
      })
    });
    return layerDescriptor;
  }
  return null;
}