"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InlineField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _field = require("./field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InlineField extends _field.AbstractField {
  constructor({
    fieldName,
    label,
    source,
    origin,
    dataType
  }) {
    super({
      fieldName,
      origin
    });
    (0, _defineProperty2.default)(this, "_label", void 0);
    (0, _defineProperty2.default)(this, "_source", void 0);
    (0, _defineProperty2.default)(this, "_dataType", void 0);
    this._label = label;
    this._source = source;
    this._dataType = dataType;
  }
  supportsFieldMetaFromEs() {
    return false;
  }
  supportsFieldMetaFromLocalData() {
    return true;
  }
  getSource() {
    return this._source;
  }
  async getLabel() {
    return this._label ? this._label : this.getName();
  }
  async getDataType() {
    return this._dataType;
  }
}
exports.InlineField = InlineField;