"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkerDecorationPosition = MarkerDecorationPosition;
exports.hasIcon = hasIcon;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _visualizationUtils = require("@kbn/visualization-utils");
var _dimension_editor = require("../dimension_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/shared/marker_decoration_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function hasIcon(icon) {
  return icon != null && icon !== 'empty';
}
const topLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.above', {
  defaultMessage: 'Top'
});
const bottomLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.below', {
  defaultMessage: 'Bottom'
});
const leftLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.left', {
  defaultMessage: 'Left'
});
const rightLabel = _i18n.i18n.translate('xpack.lens.xyChart.markerPosition.right', {
  defaultMessage: 'Right'
});
function getIconPositionOptions({
  isHorizontal,
  axisMode
}) {
  const autoOption = {
    id: `${_dimension_editor.idPrefix}auto`,
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.auto', {
      defaultMessage: 'Auto'
    }),
    'data-test-subj': 'lnsXY_markerPosition_auto'
  };
  if (axisMode === 'bottom') {
    return [{
      id: `${_dimension_editor.idPrefix}below`,
      label: isHorizontal ? leftLabel : bottomLabel,
      'data-test-subj': 'lnsXY_markerPosition_below'
    }, autoOption, {
      id: `${_dimension_editor.idPrefix}above`,
      label: isHorizontal ? rightLabel : topLabel,
      'data-test-subj': 'lnsXY_markerPosition_above'
    }];
  }
  return [{
    id: `${_dimension_editor.idPrefix}left`,
    label: isHorizontal ? bottomLabel : leftLabel,
    'data-test-subj': 'lnsXY_markerPosition_left'
  }, autoOption, {
    id: `${_dimension_editor.idPrefix}right`,
    label: isHorizontal ? topLabel : rightLabel,
    'data-test-subj': 'lnsXY_markerPosition_right'
  }];
}
function MarkerDecorationPosition({
  currentConfig,
  setConfig,
  isHorizontal
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasIcon(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) || currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    isDisabled: !hasIcon(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) && !(currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility),
    label: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.position', {
      defaultMessage: 'Decoration position'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('xpack.lens.lineMarker.positionRequirementTooltip', {
      defaultMessage: 'You must select an icon or show the name in order to alter its position'
    }),
    condition: !hasIcon(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) && !(currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility),
    position: "top",
    delay: "regular",
    display: "block",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.lineMarker.position', {
      defaultMessage: 'Decoration position'
    }),
    "data-test-subj": "lnsXY_markerPosition",
    isDisabled: !hasIcon(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.icon) && !(currentConfig !== null && currentConfig !== void 0 && currentConfig.textVisibility),
    buttonSize: "compressed",
    options: getIconPositionOptions({
      isHorizontal,
      axisMode: currentConfig.axisMode
    }),
    idSelected: `${_dimension_editor.idPrefix}${(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.iconPosition) || 'auto'}`,
    onChange: id => {
      const newMode = id.replace(_dimension_editor.idPrefix, '');
      setConfig({
        iconPosition: newMode
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }))) : null);
}