"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XyFlyoutToolbar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _visualizationUtils = require("@kbn/visualization-utils");
var _shared_components = require("../../../shared_components");
var _flyout_toolbar = require("../../../shared_components/flyout_toolbar");
var _visual_options_popover = require("./visual_options_popover");
var _titles_and_text_popover = require("./titles_and_text_popover");
var _axis_settings_popover = require("./axis_settings_popover");
var _axes_configuration = require("../axes_configuration");
var _visualization_helpers = require("../visualization_helpers");
var _state_helpers = require("../state_helpers");
var _ = require(".");
var _to_expression = require("../to_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/toolbar/flyout_toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const XyFlyoutToolbar = props => {
  const xyToolbarContentMap = {
    style: XyStyleSettings
  };
  return /*#__PURE__*/_react.default.createElement(_flyout_toolbar.FlyoutToolbar, (0, _extends2.default)({}, props, {
    contentMap: xyToolbarContentMap,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 10
    }
  }));
};
exports.XyFlyoutToolbar = XyFlyoutToolbar;
const XyStyleSettings = props => {
  var _state$tickLabelsVisi, _state$tickLabelsVisi2, _state$tickLabelsVisi3, _state$tickLabelsVisi4, _state$tickLabelsVisi5, _state$tickLabelsVisi6, _state$gridlinesVisib, _state$gridlinesVisib2, _state$gridlinesVisib3, _state$gridlinesVisib4, _state$gridlinesVisib5, _state$gridlinesVisib6, _state$labelsOrientat, _state$labelsOrientat2, _state$labelsOrientat3, _state$labelsOrientat4, _state$labelsOrientat5, _state$labelsOrientat6, _state$axisTitlesVisi7, _state$axisTitlesVisi8, _state$axisTitlesVisi9, _axisGroups$find, _axisGroups$find$seri, _axisGroups$find2, _axisGroups$find2$ser, _state$layers;
  const {
    state,
    setState,
    frame
  } = props;
  const dataLayers = (0, _visualization_helpers.getDataLayers)(state === null || state === void 0 ? void 0 : state.layers);
  const shouldRotate = state !== null && state !== void 0 && state.layers.length ? (0, _state_helpers.isHorizontalChart)(state.layers) : false;
  const axisGroups = (0, _axes_configuration.getAxesConfiguration)(dataLayers, shouldRotate, frame.activeData);
  const dataBounds = (0, _.getDataBounds)(frame.activeData, axisGroups);
  const xDataBounds = (0, _axes_configuration.getXDomain)(dataLayers, frame.activeData);
  const isAreaPercentage = dataLayers.some(({
    seriesType
  }) => seriesType === 'area_percentage_stacked');
  const isHasNonBarSeries = (0, _state_helpers.hasNonBarSeries)(dataLayers);
  const isHistogramSeries = Boolean((0, _state_helpers.hasHistogramSeries)(dataLayers, frame.datasourceLayers));
  const isFittingEnabled = isHasNonBarSeries && !isAreaPercentage;
  const isCurveTypeEnabled = isHasNonBarSeries || isAreaPercentage;
  const valueLabelsDisabledReason = (0, _visual_options_popover.getValueLabelDisableReason)({
    isAreaPercentage,
    isHistogramSeries
  });
  const isAppearanceSettingDisabled = !isFittingEnabled && !isCurveTypeEnabled && isHasNonBarSeries;
  const tickLabelsVisibilitySettings = {
    x: (_state$tickLabelsVisi = state === null || state === void 0 ? void 0 : (_state$tickLabelsVisi2 = state.tickLabelsVisibilitySettings) === null || _state$tickLabelsVisi2 === void 0 ? void 0 : _state$tickLabelsVisi2.x) !== null && _state$tickLabelsVisi !== void 0 ? _state$tickLabelsVisi : true,
    yLeft: (_state$tickLabelsVisi3 = state === null || state === void 0 ? void 0 : (_state$tickLabelsVisi4 = state.tickLabelsVisibilitySettings) === null || _state$tickLabelsVisi4 === void 0 ? void 0 : _state$tickLabelsVisi4.yLeft) !== null && _state$tickLabelsVisi3 !== void 0 ? _state$tickLabelsVisi3 : true,
    yRight: (_state$tickLabelsVisi5 = state === null || state === void 0 ? void 0 : (_state$tickLabelsVisi6 = state.tickLabelsVisibilitySettings) === null || _state$tickLabelsVisi6 === void 0 ? void 0 : _state$tickLabelsVisi6.yRight) !== null && _state$tickLabelsVisi5 !== void 0 ? _state$tickLabelsVisi5 : true
  };
  const onTickLabelsVisibilitySettingsChange = optionId => {
    const newTickLabelsVisibilitySettings = {
      ...tickLabelsVisibilitySettings,
      ...{
        [optionId]: !tickLabelsVisibilitySettings[optionId]
      }
    };
    setState({
      ...state,
      tickLabelsVisibilitySettings: newTickLabelsVisibilitySettings
    });
  };
  const gridlinesVisibilitySettings = {
    x: (_state$gridlinesVisib = state === null || state === void 0 ? void 0 : (_state$gridlinesVisib2 = state.gridlinesVisibilitySettings) === null || _state$gridlinesVisib2 === void 0 ? void 0 : _state$gridlinesVisib2.x) !== null && _state$gridlinesVisib !== void 0 ? _state$gridlinesVisib : true,
    yLeft: (_state$gridlinesVisib3 = state === null || state === void 0 ? void 0 : (_state$gridlinesVisib4 = state.gridlinesVisibilitySettings) === null || _state$gridlinesVisib4 === void 0 ? void 0 : _state$gridlinesVisib4.yLeft) !== null && _state$gridlinesVisib3 !== void 0 ? _state$gridlinesVisib3 : true,
    yRight: (_state$gridlinesVisib5 = state === null || state === void 0 ? void 0 : (_state$gridlinesVisib6 = state.gridlinesVisibilitySettings) === null || _state$gridlinesVisib6 === void 0 ? void 0 : _state$gridlinesVisib6.yRight) !== null && _state$gridlinesVisib5 !== void 0 ? _state$gridlinesVisib5 : true
  };
  const onGridlinesVisibilitySettingsChange = optionId => {
    const newGridlinesVisibilitySettings = {
      ...gridlinesVisibilitySettings,
      ...{
        [optionId]: !gridlinesVisibilitySettings[optionId]
      }
    };
    setState({
      ...state,
      gridlinesVisibilitySettings: newGridlinesVisibilitySettings
    });
  };
  const labelsOrientation = {
    x: (_state$labelsOrientat = state === null || state === void 0 ? void 0 : (_state$labelsOrientat2 = state.labelsOrientation) === null || _state$labelsOrientat2 === void 0 ? void 0 : _state$labelsOrientat2.x) !== null && _state$labelsOrientat !== void 0 ? _state$labelsOrientat : 0,
    yLeft: (_state$labelsOrientat3 = state === null || state === void 0 ? void 0 : (_state$labelsOrientat4 = state.labelsOrientation) === null || _state$labelsOrientat4 === void 0 ? void 0 : _state$labelsOrientat4.yLeft) !== null && _state$labelsOrientat3 !== void 0 ? _state$labelsOrientat3 : 0,
    yRight: (_state$labelsOrientat5 = state === null || state === void 0 ? void 0 : (_state$labelsOrientat6 = state.labelsOrientation) === null || _state$labelsOrientat6 === void 0 ? void 0 : _state$labelsOrientat6.yRight) !== null && _state$labelsOrientat5 !== void 0 ? _state$labelsOrientat5 : 0
  };
  const onLabelsOrientationChange = (axis, orientation) => {
    const newLabelsOrientation = {
      ...labelsOrientation,
      ...{
        [axis]: orientation
      }
    };
    setState({
      ...state,
      labelsOrientation: newLabelsOrientation
    });
  };
  const axisTitlesVisibilitySettings = (0, _react.useMemo)(() => {
    var _state$axisTitlesVisi, _state$axisTitlesVisi2, _state$axisTitlesVisi3, _state$axisTitlesVisi4, _state$axisTitlesVisi5, _state$axisTitlesVisi6;
    return {
      x: (_state$axisTitlesVisi = state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi2 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi2 === void 0 ? void 0 : _state$axisTitlesVisi2.x) !== null && _state$axisTitlesVisi !== void 0 ? _state$axisTitlesVisi : true,
      yLeft: (_state$axisTitlesVisi3 = state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi4 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi4 === void 0 ? void 0 : _state$axisTitlesVisi4.yLeft) !== null && _state$axisTitlesVisi3 !== void 0 ? _state$axisTitlesVisi3 : true,
      yRight: (_state$axisTitlesVisi5 = state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi6 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi6 === void 0 ? void 0 : _state$axisTitlesVisi6.yRight) !== null && _state$axisTitlesVisi5 !== void 0 ? _state$axisTitlesVisi5 : true
    };
  }, [state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi7 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi7 === void 0 ? void 0 : _state$axisTitlesVisi7.x, state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi8 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi8 === void 0 ? void 0 : _state$axisTitlesVisi8.yLeft, state === null || state === void 0 ? void 0 : (_state$axisTitlesVisi9 = state.axisTitlesVisibilitySettings) === null || _state$axisTitlesVisi9 === void 0 ? void 0 : _state$axisTitlesVisi9.yRight]);
  const onTitleStateChange = (0, _react.useCallback)(({
    title,
    visible
  }, axis) => setState({
    ...state,
    [_.axisKeyToTitleMapping[axis]]: title,
    axisTitlesVisibilitySettings: {
      ...axisTitlesVisibilitySettings,
      [axis]: visible
    }
  }), [axisTitlesVisibilitySettings, setState, state]);
  const isTimeVis = dataLayers.every(layer => {
    var _frame$datasourceLaye, _frame$datasourceLaye2;
    return layer.xAccessor && (0, _to_expression.getScaleType)((_frame$datasourceLaye = (_frame$datasourceLaye2 = frame.datasourceLayers[layer.layerId]) === null || _frame$datasourceLaye2 === void 0 ? void 0 : _frame$datasourceLaye2.getOperationForColumnId(layer.xAccessor)) !== null && _frame$datasourceLaye !== void 0 ? _frame$datasourceLaye : null, _charts.ScaleType.Linear) === _charts.ScaleType.Time;
  });

  // only allow changing endzone visibility if it could show up theoretically (if it's a time viz)
  const onChangeEndzoneVisiblity = isTimeVis ? checked => {
    setState({
      ...state,
      hideEndzones: !checked
    });
  } : undefined;
  const onChangeCurrentTimeMarkerVisibility = isTimeVis ? checked => {
    setState({
      ...state,
      showCurrentTimeMarker: checked
    });
  } : undefined;
  const hasBarOrAreaOnLeftAxis = Boolean((_axisGroups$find = axisGroups.find(group => group.groupId === 'left')) === null || _axisGroups$find === void 0 ? void 0 : (_axisGroups$find$seri = _axisGroups$find.series) === null || _axisGroups$find$seri === void 0 ? void 0 : _axisGroups$find$seri.some(series => {
    var _dataLayers$find;
    const seriesType = (_dataLayers$find = dataLayers.find(l => l.layerId === series.layer)) === null || _dataLayers$find === void 0 ? void 0 : _dataLayers$find.seriesType;
    return (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('bar')) || (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('area'));
  }));
  const setScaleWithExtentFn = (0, _react.useCallback)((extentKey, scaleKey) => (extent, scale) => {
    setState({
      ...state,
      [extentKey]: extent,
      [scaleKey]: scale
    });
  }, [setState, state]);
  const setExtentFn = (0, _react.useCallback)(extentKey => extent => {
    setState({
      ...state,
      [extentKey]: extent
    });
  }, [setState, state]);
  const setScaleFn = (0, _react.useCallback)(scaleKey => scale => {
    setState({
      ...state,
      [scaleKey]: scale
    });
  }, [setState, state]);
  const hasBarOrAreaOnRightAxis = Boolean((_axisGroups$find2 = axisGroups.find(group => group.groupId === 'right')) === null || _axisGroups$find2 === void 0 ? void 0 : (_axisGroups$find2$ser = _axisGroups$find2.series) === null || _axisGroups$find2$ser === void 0 ? void 0 : _axisGroups$find2$ser.some(series => {
    var _dataLayers$find2;
    const seriesType = (_dataLayers$find2 = dataLayers.find(l => l.layerId === series.layer)) === null || _dataLayers$find2 === void 0 ? void 0 : _dataLayers$find2.seriesType;
    return (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('bar')) || (seriesType === null || seriesType === void 0 ? void 0 : seriesType.includes('area'));
  }));
  const filteredBarLayers = dataLayers.filter(layer => layer.seriesType.includes('bar'));
  const chartHasMoreThanOneBarSeries = filteredBarLayers.length > 1 || filteredBarLayers.some(layer => layer.accessors.length > 1 || layer.splitAccessor);
  const isTimeHistogramModeEnabled = dataLayers.some(({
    xAccessor,
    layerId,
    seriesType,
    splitAccessor
  }) => {
    var _frame$datasourceLaye3, _frame$datasourceLaye4;
    if (!xAccessor) {
      return false;
    }
    const xAccessorOp = (_frame$datasourceLaye3 = (_frame$datasourceLaye4 = frame.datasourceLayers[layerId]) === null || _frame$datasourceLaye4 === void 0 ? void 0 : _frame$datasourceLaye4.getOperationForColumnId(xAccessor)) !== null && _frame$datasourceLaye3 !== void 0 ? _frame$datasourceLaye3 : null;
    return (0, _to_expression.getScaleType)(xAccessorOp, _charts.ScaleType.Linear) === _charts.ScaleType.Time && (xAccessorOp === null || xAccessorOp === void 0 ? void 0 : xAccessorOp.isBucketed) && (seriesType.includes('stacked') || !splitAccessor) && (seriesType.includes('stacked') || !seriesType.includes('bar') || !chartHasMoreThanOneBarSeries);
  });
  const hasNumberHistogram = dataLayers.some(({
    layerId,
    xAccessor
  }) => (0, _shared_components.hasNumericHistogramDimension)(frame.datasourceLayers[layerId], xAccessor));
  const isHorizontal = (_state$layers = state.layers) !== null && _state$layers !== void 0 && _state$layers.length ? (0, _state_helpers.isHorizontalChart)(state.layers) : false;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '',
    buttonContent: /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
      tooltipContent: valueLabelsDisabledReason,
      condition: isAppearanceSettingDisabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.lens.visualization.toolbar.appearance', {
      defaultMessage: 'Appearance'
    }))),
    paddingSize: "s",
    initialIsOpen: true,
    isDisabled: isAppearanceSettingDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_visual_options_popover.XyAppearanceSettings, (0, _extends2.default)({
    datasourceLayers: frame.datasourceLayers
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }), (0, _state_helpers.hasBarSeries)(state.layers) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '',
    buttonContent: _i18n.i18n.translate('xpack.lens.visualization.toolbar.titlesAndText', {
      defaultMessage: 'Titles and text'
    }),
    paddingSize: "s",
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_titles_and_text_popover.XyTitlesAndTextSettings, (0, _extends2.default)({
    datasourceLayers: props.frame.datasourceLayers
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({
    id: '',
    buttonContent: /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
      tooltipContent: shouldRotate ? _i18n.i18n.translate('xpack.lens.xyChart.bottomAxisDisabledHelpText', {
        defaultMessage: 'This setting only applies when bottom axis is enabled.'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.leftAxisDisabledHelpText', {
        defaultMessage: 'This setting only applies when left axis is enabled.'
      }),
      condition: Object.keys(axisGroups.find(group => group.groupId === 'left') || {}).length === 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 13
      }
    }, (0, _axis_settings_popover.popoverConfig)('yLeft', isHorizontal).popoverTitle)),
    paddingSize: "s",
    initialIsOpen: true,
    isDisabled: Object.keys(axisGroups.find(group => group.groupId === 'left') || {}).length === 0
  }, Object.keys(axisGroups.find(group => group.groupId === 'left') || {}).length === 0 && {
    forceState: 'closed'
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_axis_settings_popover.XyAxisSettings, {
    axis: "yLeft",
    layers: state === null || state === void 0 ? void 0 : state.layers,
    axisTitle: state === null || state === void 0 ? void 0 : state.yTitle,
    updateTitleState: onTitleStateChange,
    areTickLabelsVisible: tickLabelsVisibilitySettings.yLeft,
    toggleTickLabelsVisibility: onTickLabelsVisibilitySettingsChange,
    areGridlinesVisible: gridlinesVisibilitySettings.yLeft,
    toggleGridlinesVisibility: onGridlinesVisibilitySettingsChange,
    orientation: labelsOrientation.yLeft,
    setOrientation: onLabelsOrientationChange,
    isTitleVisible: axisTitlesVisibilitySettings.yLeft,
    extent: (state === null || state === void 0 ? void 0 : state.yLeftExtent) || {
      mode: 'full'
    },
    setExtent: setExtentFn('yLeftExtent'),
    hasBarOrAreaOnAxis: hasBarOrAreaOnLeftAxis,
    dataBounds: dataBounds.left,
    hasPercentageAxis: (0, _.hasPercentageAxis)(axisGroups, 'left', state),
    scale: state === null || state === void 0 ? void 0 : state.yLeftScale,
    setScale: setScaleFn('yLeftScale'),
    setScaleWithExtent: setScaleWithExtentFn('yLeftExtent', 'yLeftScale'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 350,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: '',
    buttonContent: (0, _axis_settings_popover.popoverConfig)('x', isHorizontal).popoverTitle,
    paddingSize: "s",
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_axis_settings_popover.XyAxisSettings, {
    axis: "x",
    layers: state === null || state === void 0 ? void 0 : state.layers,
    axisTitle: state === null || state === void 0 ? void 0 : state.xTitle,
    updateTitleState: onTitleStateChange,
    areTickLabelsVisible: tickLabelsVisibilitySettings.x,
    toggleTickLabelsVisibility: onTickLabelsVisibilitySettingsChange,
    areGridlinesVisible: gridlinesVisibilitySettings.x,
    toggleGridlinesVisibility: onGridlinesVisibilitySettingsChange,
    orientation: labelsOrientation.x,
    setOrientation: onLabelsOrientationChange,
    isTitleVisible: axisTitlesVisibilitySettings.x,
    endzonesVisible: !(state !== null && state !== void 0 && state.hideEndzones),
    setEndzoneVisibility: onChangeEndzoneVisiblity,
    currentTimeMarkerVisible: state === null || state === void 0 ? void 0 : state.showCurrentTimeMarker,
    setCurrentTimeMarkerVisibility: onChangeCurrentTimeMarkerVisibility,
    hasBarOrAreaOnAxis: false,
    hasPercentageAxis: false,
    useMultilayerTimeAxis: isTimeHistogramModeEnabled && !shouldRotate,
    extent: hasNumberHistogram ? (state === null || state === void 0 ? void 0 : state.xExtent) || {
      mode: 'dataBounds'
    } : undefined,
    setExtent: setExtentFn('xExtent'),
    dataBounds: xDataBounds,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, (0, _extends2.default)({
    id: '',
    buttonContent: /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
      tooltipContent: shouldRotate ? _i18n.i18n.translate('xpack.lens.xyChart.topAxisDisabledHelpText', {
        defaultMessage: 'This setting only applies when top axis is enabled.'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.rightAxisDisabledHelpText', {
        defaultMessage: 'This setting only applies when right axis is enabled.'
      }),
      condition: Object.keys(axisGroups.find(group => group.groupId === 'right') || {}).length === 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 387,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 13
      }
    }, (0, _axis_settings_popover.popoverConfig)('yRight', isHorizontal).popoverTitle)),
    paddingSize: "s",
    initialIsOpen: true,
    isDisabled: Object.keys(axisGroups.find(group => group.groupId === 'right') || {}).length === 0
  }, Object.keys(axisGroups.find(group => group.groupId === 'right') || {}).length === 0 && {
    forceState: 'closed'
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_axis_settings_popover.XyAxisSettings, {
    axis: "yRight",
    layers: state === null || state === void 0 ? void 0 : state.layers,
    axisTitle: state === null || state === void 0 ? void 0 : state.yRightTitle,
    updateTitleState: onTitleStateChange,
    areTickLabelsVisible: tickLabelsVisibilitySettings.yRight,
    toggleTickLabelsVisibility: onTickLabelsVisibilitySettingsChange,
    areGridlinesVisible: gridlinesVisibilitySettings.yRight,
    toggleGridlinesVisibility: onGridlinesVisibilitySettingsChange,
    orientation: labelsOrientation.yRight,
    setOrientation: onLabelsOrientationChange,
    hasPercentageAxis: (0, _.hasPercentageAxis)(axisGroups, 'right', state),
    isTitleVisible: axisTitlesVisibilitySettings.yRight,
    extent: (state === null || state === void 0 ? void 0 : state.yRightExtent) || {
      mode: 'full'
    },
    setExtent: setExtentFn('yRightExtent'),
    hasBarOrAreaOnAxis: hasBarOrAreaOnRightAxis,
    dataBounds: dataBounds.right,
    scale: state === null || state === void 0 ? void 0 : state.yRightScale,
    setScale: setScaleFn('yRightScale'),
    setScaleWithExtent: setScaleWithExtentFn('yRightExtent', 'yRightScale'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 9
    }
  })));
};