"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesCreateFromCsv = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _fileSaver = _interopRequireDefault(require("file-saver"));
var _types = require("../../../../common/types");
var _shared_imports = require("../../../shared_imports");
var _pipelines_csv_uploader = require("./pipelines_csv_uploader");
var _pipelines_preview = require("./pipelines_preview");
var _error_display = require("./error_display");
var _instructions = require("./instructions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_create_from_csv/main.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PipelinesCreateFromCsv = ({
  history
}) => {
  var _services$consolePlug;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [isUploaded, setIsUploaded] = (0, _react.useState)(false);
  const [pipelineProcessors, setPipelineProcessors] = (0, _react.useState)([]);
  const [errorInfo, setErrorInfo] = (0, _react.useState)(null);
  const [file, setFile] = (0, _react.useState)(null);
  const hasError = errorInfo !== null;
  const {
    services
  } = (0, _shared_imports.useKibana)();
  (0, _react.useEffect)(() => {
    services.breadcrumbs.setBreadcrumbs('create');
  }, [services]);
  const onFilePickerChange = files => {
    setErrorInfo(null);
    setFile(files);
  };
  const onFileUpload = async action => {
    if (file != null && file.length > 0) {
      await processFile(file[0], action);
    }
  };
  const onUpdateProcessors = updatedProcessors => {
    setPipelineProcessors(updatedProcessors);
  };
  const onDownload = () => {
    const jsonBlob = new Blob([JSON.stringify(pipelineProcessors)], {
      type: 'application/json'
    });
    _fileSaver.default.saveAs(jsonBlob, `my-mappings.json`);
  };
  const onClickToCreatePipeline = () => {
    history.push({
      pathname: '/create',
      state: {
        sourcePipeline: pipelineProcessors
      }
    });
  };
  const processFile = async (csv, action) => {
    const maxBytes = services.fileUpload.getMaxBytes();
    if (csv.size === 0) {
      setErrorInfo({
        title: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.processFile.emptyFileErrorTitle', {
          defaultMessage: 'File is empty'
        }),
        message: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.processFile.emptyFileError', {
          defaultMessage: 'The file provided is empty.'
        })
      });
    } else if (csv.size > maxBytes) {
      setErrorInfo({
        title: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.processFile.fileTooLargeErrorTitle', {
          defaultMessage: 'File too large'
        }),
        message: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.processFile.fileTooLargeError', {
          defaultMessage: 'File is greater than allowed size of {maxBytes} bytes.',
          values: {
            maxBytes
          }
        })
      });
    } else {
      try {
        setIsLoading(true);
        setIsUploaded(false);
        const fileContents = await services.fileReader.readFile(csv, maxBytes);
        const success = await fetchPipelineFromMapping(fileContents, action);
        setIsLoading(false);
        if (success) {
          setIsUploaded(true);
        }
      } catch (e) {
        setIsLoading(false);
        setErrorInfo({
          title: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.processFile.unexpectedErrorTitle', {
            defaultMessage: 'Error reading file'
          }),
          message: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.processFile.unexpectedError', {
            defaultMessage: 'The file provided could not be read.'
          })
        });
      }
    }
  };
  const fetchPipelineFromMapping = async (fileContents, action) => {
    const {
      error,
      data: processors
    } = await services.api.parseCsv({
      file: fileContents,
      copyAction: action
    });
    setPipelineProcessors(processors);
    if (!!error) {
      try {
        const errorParts = error.message.split(':');
        setErrorInfo({
          title: errorParts[0],
          message: errorParts[1]
        });
      } catch (e) {
        setErrorInfo({
          title: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.fetchPipeline.unexpectedErrorTitle', {
            defaultMessage: 'Something went wrong'
          }),
          message: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.fetchPipeline.unexpectedErrorDetails', {
            defaultMessage: 'Unexpected error'
          })
        });
      }
    }
    return error === null;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.createFromCsv.pageTitle",
      defaultMessage: "Create pipeline from CSV",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    })),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: services.documentation.getCreatePipelineCSVUrl(),
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.createFromCSV.docsButtonLabel",
      defaultMessage: "CSV to pipeline docs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 13
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_instructions.Instructions, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }), hasError && /*#__PURE__*/_react.default.createElement(_error_display.Error, {
    error: errorInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 20
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }), (!isUploaded || hasError) && /*#__PURE__*/_react.default.createElement(_pipelines_csv_uploader.PipelinesCsvUploader, {
    onFilePickerChange: onFilePickerChange,
    onFileUpload: onFileUpload,
    actionOptions: Object.values(_types.FieldCopyAction),
    isLoading: isLoading,
    isUploaded: isUploaded,
    hasError: hasError,
    hasFile: !!file && file.length > 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }), isUploaded && /*#__PURE__*/_react.default.createElement(_pipelines_preview.PipelinesPreview, {
    processors: pipelineProcessors,
    onDownload: onDownload,
    onUpdateProcessors: onUpdateProcessors,
    onClickToCreatePipeline: onClickToCreatePipeline,
    hasError: hasError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  }), (_services$consolePlug = services.consolePlugin) !== null && _services$consolePlug !== void 0 && _services$consolePlug.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(services.consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }) : null);
};
exports.PipelinesCreateFromCsv = PipelinesCreateFromCsv;