"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesClone = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../shared_imports");
var _normalize_pipeline_name_from_params = require("../../lib/normalize_pipeline_name_from_params");
var _pipelines_create = require("../pipelines_create");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_clone/pipelines_clone.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This section is a wrapper around the create section where we receive a pipeline name
 * to load and set as the source pipeline for the {@link PipelinesCreate} form.
 */
const PipelinesClone = props => {
  var _normalizePipelineNam;
  const {
    sourceName
  } = props.match.params;
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const decodedSourceName = (_normalizePipelineNam = (0, _normalize_pipeline_name_from_params.normalizePipelineNameFromParams)(sourceName)) !== null && _normalizePipelineNam !== void 0 ? _normalizePipelineNam : '';
  const {
    error,
    data: pipeline,
    isLoading,
    isInitialRequest
  } = services.api.useLoadPipeline(decodedSourceName);
  (0, _react.useEffect)(() => {
    if (error && !isLoading) {
      services.notifications.toasts.addError(new Error((0, _utils.getErrorText)(error)), {
        title: _i18n.i18n.translate('xpack.ingestPipelines.clone.loadSourcePipelineErrorTitle', {
          defaultMessage: 'Cannot load {name}.',
          values: {
            name: sourceName
          }
        })
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [error, isLoading]);
  if (isLoading && isInitialRequest) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.clone.loadingPipelinesDescription",
      defaultMessage: "Loading pipeline\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }));
  } else {
    // We still show the create form even if we were not able to load the
    // latest pipeline data.
    const sourcePipeline = pipeline ? {
      ...pipeline,
      name: `${pipeline.name}-copy`
    } : undefined;
    return /*#__PURE__*/_react.default.createElement(_pipelines_create.PipelinesCreate, (0, _extends2.default)({}, props, {
      sourcePipeline: sourcePipeline,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 12
      }
    }));
  }
};
exports.PipelinesClone = PipelinesClone;