"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipelineActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _context = require("../../context");
var _documents_dropdown = require("./documents_dropdown");
var _add_documents_button = require("./add_documents_button");
var _test_output_button = require("./test_output_button");
var _test_pipeline_flyout = require("./test_pipeline_flyout.container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/test_pipeline/test_pipeline_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  testPipelineActionsLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.testPipelineActionsLabel', {
    defaultMessage: 'Test pipeline:'
  })
};
const TestPipelineActions = () => {
  const {
    testPipelineData,
    testPipelineDataDispatch
  } = (0, _context.useTestPipelineContext)();
  const {
    state: {
      processors
    }
  } = (0, _context.usePipelineProcessorsContext)();
  const {
    testOutputPerProcessor,
    config: {
      documents,
      selectedDocumentIndex
    }
  } = testPipelineData;
  const [openTestPipelineFlyout, setOpenTestPipelineFlyout] = (0, _react.useState)(false);
  const [activeFlyoutTab, setActiveFlyoutTab] = (0, _react.useState)('documents');
  const updateSelectedDocument = index => {
    testPipelineDataDispatch({
      type: 'updateActiveDocument',
      payload: {
        config: {
          selectedDocumentIndex: index
        }
      }
    });
  };
  const openFlyout = activeTab => {
    setOpenTestPipelineFlyout(true);
    setActiveFlyoutTab(activeTab);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "baseline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, i18nTexts.testPipelineActionsLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, documents ? /*#__PURE__*/_react.default.createElement(_documents_dropdown.DocumentsDropdown, {
    documents: documents,
    selectedDocumentIndex: selectedDocumentIndex,
    updateSelectedDocument: updateSelectedDocument,
    openFlyout: openFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_add_documents_button.AddDocumentsButton, {
    openFlyout: openFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  })), testOutputPerProcessor && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_test_output_button.TestOutputButton, {
    openFlyout: openFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }))), openTestPipelineFlyout && /*#__PURE__*/_react.default.createElement(_test_pipeline_flyout.TestPipelineFlyout, {
    activeTab: activeFlyoutTab,
    setActiveTab: setActiveFlyoutTab,
    processors: {
      processors: processors.state.processors,
      onFailure: processors.state.onFailure
    },
    onClose: () => setOpenTestPipelineFlyout(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }));
};
exports.TestPipelineActions = TestPipelineActions;