"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _get_custom_metric_label = require("../../../../../../../common/formatters/get_custom_metric_label");
var _snapshot_api = require("../../../../../../../common/http_api/snapshot_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/metric_control/metrics_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsContextMenu = ({
  onClose,
  onChange,
  metric,
  options,
  customMetrics
}) => {
  const id = _snapshot_api.SnapshotCustomMetricInputRT.is(metric) && metric.id ? metric.id : metric.type;
  const handleClick = (0, _react.useCallback)(val => {
    if (!_common.SnapshotMetricTypeRT.is(val)) {
      const selectedMetric = customMetrics.find(m => m.id === val);
      if (selectedMetric) {
        onChange(selectedMetric);
      }
    } else {
      onChange({
        type: val
      });
    }
    onClose();
  }, [customMetrics, onChange, onClose]);
  const panels = [{
    id: 0,
    title: '',
    items: [...options.map(o => {
      const icon = o.value === id ? 'check' : 'empty';
      const panel = {
        name: o.text,
        onClick: () => handleClick(o.value),
        icon
      };
      return panel;
    }), ...customMetrics.map(m => {
      const icon = m.id === id ? 'check' : 'empty';
      const panel = {
        name: (0, _get_custom_metric_label.getCustomMetricLabel)(m),
        onClick: () => handleClick(m.id),
        icon
      };
      return panel;
    })]
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": "infraInventoryMetricsContextMenu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
};
exports.MetricsContextMenu = MetricsContextMenu;