"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewportDimensions = useViewportDimensions;
var _react = require("react");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getViewportWidth = () => window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
const getViewportHeight = () => window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
function useViewportDimensions() {
  const [dimensions, setDimensions] = (0, _react.useState)({
    width: getViewportWidth(),
    height: getViewportHeight()
  });
  (0, _react.useEffect)(() => {
    const updateDimensions = (0, _lodash.throttle)(() => {
      setDimensions({
        width: getViewportWidth(),
        height: getViewportHeight()
      });
    }, 250);
    window.addEventListener('resize', updateDimensions);
    return () => window.removeEventListener('resize', updateDimensions);
  }, []);
  return dimensions;
}