"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Popover = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/common/popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Popover = ({
  children,
  icon,
  iconColor,
  iconSize,
  ...props
}) => {
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "s",
    focusTrapProps: {
      returnFocus: true
    },
    button: /*#__PURE__*/_react2.default.createElement("button", {
      "aria-label": props['aria-label'],
      onClick: e => {
        e.stopPropagation();
        togglePopover();
      },
      css: (0, _react.css)`
            display: flex;
          `,
      "data-test-subj": props['data-test-subj'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "question",
      color: iconColor !== null && iconColor !== void 0 ? iconColor : 'text',
      size: iconSize !== null && iconSize !== void 0 ? iconSize : 'original',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    })),
    isOpen: isPopoverOpen,
    offset: 10,
    closePopover: closePopover,
    repositionOnScroll: true,
    anchorPosition: "upCenter",
    panelStyle: {
      maxWidth: 350
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, children);
};
exports.Popover = Popover;