"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tableState = exports.defaultTableState = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultTableState = exports.defaultTableState = {
  filter: '',
  pageSize: 10,
  currentPage: 0,
  sortField: 'index.name',
  isSortAscending: true,
  toggleNameToVisibleMap: {}
};
const tableState = exports.tableState = (0, _reduxActions.handleActions)({
  [_actions.filterChanged](state, action) {
    const {
      filter
    } = action.payload;
    return {
      ...state,
      filter,
      currentPage: 0
    };
  },
  [_actions.toggleChanged](state, action) {
    const {
      toggleName,
      toggleValue
    } = action.payload;
    const toggleNameToVisibleMap = {
      ...state.toggleNameToVisibleMap
    };
    toggleNameToVisibleMap[toggleName] = toggleValue;
    return {
      ...state,
      toggleNameToVisibleMap
    };
  },
  [_actions.sortChanged](state, action) {
    const {
      sortField,
      isSortAscending
    } = action.payload;
    return {
      ...state,
      sortField,
      isSortAscending
    };
  },
  [_actions.pageChanged](state, action) {
    const {
      pageNumber
    } = action.payload;
    return {
      ...state,
      currentPage: pageNumber
    };
  },
  [_actions.pageSizeChanged](state, action) {
    const {
      pageSize
    } = action.payload;
    return {
      ...state,
      pageSize
    };
  }
}, defaultTableState);