"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateCreate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _queryString = require("query-string");
var _components = require("../../components");
var _breadcrumbs = require("../../services/breadcrumbs");
var _api = require("../../services/api");
var _routing = require("../../services/routing");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/template_create/template_create.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TemplateCreate = ({
  history
}) => {
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    config: {
      enableLegacyTemplates
    }
  } = (0, _app_context.useAppContext)();
  const search = (0, _queryString.parse)((0, _reactRouterDom.useLocation)().search.substring(1));
  // We don't expect the `legacy` query to be used when legacy templates are disabled, however, we add the `enableLegacyTemplates` check as a safeguard
  const isLegacy = enableLegacyTemplates && Boolean(search.legacy);
  const onSave = async template => {
    const {
      name
    } = template;
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await (0, _api.saveTemplate)(template);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
      return;
    }
    history.push((0, _routing.getTemplateDetailsLink)(name, template._kbnMeta.isLegacy));
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.templateCreate);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_components.TemplateForm, {
    title: isLegacy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.createTemplate.createLegacyTemplatePageTitle",
      defaultMessage: "Create legacy template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.createTemplate.createTemplatePageTitle",
      defaultMessage: "Create template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }),
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isLegacy: isLegacy,
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.TemplateCreate = TemplateCreate;