"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageMappingsContent = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireWildcard(require("react"));
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _utils = require("../../../../components/mappings_editor/lib/utils");
var _use_details_page_mappings_model_management = require("../../../../../hooks/use_details_page_mappings_model_management");
var _app_context = require("../../../../app_context");
var _components = require("../../../../components/mappings_editor/components");
var _document_fields_search = require("../../../../components/mappings_editor/components/document_fields/document_fields_search");
var _fields = require("../../../../components/mappings_editor/components/document_fields/fields");
var _search_fields = require("../../../../components/mappings_editor/components/document_fields/search_fields");
var _multiple_mappings_warning = require("../../../../components/mappings_editor/components/multiple_mappings_warning");
var _lib = require("../../../../components/mappings_editor/lib");
var _mappings_state_context = require("../../../../components/mappings_editor/mappings_state_context");
var _details_page_filter_fields = require("./details_page_filter_fields");
var _use_state_listener = require("../../../../components/mappings_editor/use_state_listener");
var _services = require("../../../../services");
var _api = require("../../../../services/api");
var _notification = require("../../../../services/notification");
var _semantic_text_banner = require("./semantic_text_banner");
var _trained_models_deployment_modal = require("./trained_models_deployment_modal");
var _parse_mappings = require("../../../../shared/parse_mappings");
var _details_page_empty_mappings = require("./details_page_empty_mappings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_mappings_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isInferencePreconfigured = inferenceId => inferenceId.startsWith('.');
const DetailsPageMappingsContent = ({
  index,
  data,
  jsonData,
  refetchMapping,
  showAboutMappings,
  hasUpdateMappingsPrivilege
}) => {
  var _capabilities$ml;
  const {
    core: {
      application: {
        capabilities,
        navigateToUrl
      },
      http
    },
    plugins: {
      ml,
      licensing
    },
    config,
    overlays,
    history
  } = (0, _app_context.useAppContext)();
  const pendingFieldsRef = (0, _react2.useRef)(null);
  const [isPlatinumLicense, setIsPlatinumLicense] = (0, _react2.useState)(false);
  (0, _react2.useEffect)(() => {
    const subscription = licensing === null || licensing === void 0 ? void 0 : licensing.license$.subscribe(license => {
      setIsPlatinumLicense(license.isActive && license.hasAtLeast('platinum'));
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [licensing]);
  const {
    enableSemanticText: isSemanticTextEnabled
  } = config;
  const [errorsInTrainedModelDeployment, setErrorsInTrainedModelDeployment] = (0, _react2.useState)({});
  const hasMLPermissions = capabilities !== null && capabilities !== void 0 && (_capabilities$ml = capabilities.ml) !== null && _capabilities$ml !== void 0 && _capabilities$ml.canGetTrainedModels ? true : false;
  const semanticTextInfo = {
    isSemanticTextEnabled: isSemanticTextEnabled && hasMLPermissions && isPlatinumLicense,
    indexName: index.name,
    ml,
    setErrorsInTrainedModelDeployment
  };
  const state = (0, _mappings_state_context.useMappingsState)();
  const hasMappings = state.mappingViewFields.rootLevelFields.length > 0;
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const indexName = index.name;
  const pendingFieldListId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'pendingFieldListId'
  });
  const hasSemanticText = hasSemanticTextField(state.fields);
  const [isAddingFields, setAddingFields] = (0, _react2.useState)(false);
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    titleText: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.unsavedChangesPromptTitle', {
      defaultMessage: 'Exit without saving changes?'
    }),
    messageText: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.unsavedChangesPromptMessage', {
      defaultMessage: 'Your changes will be lost if you leave this page without saving the mapping.'
    }),
    hasUnsavedChanges: isAddingFields,
    openConfirm: overlays.openConfirm,
    history,
    http,
    navigateToUrl
  });
  const newFieldsLength = (0, _react2.useMemo)(() => {
    return Object.keys(state.fields.byId).length;
  }, [state.fields.byId]);
  const [previousState, setPreviousState] = (0, _react2.useState)(state);
  const previousStateSelectedDataTypes = (0, _react2.useMemo)(() => {
    return previousState.filter.selectedOptions.filter(option => option.checked === 'on').map(option => option.label);
  }, [previousState.filter.selectedOptions]);
  const [saveMappingError, setSaveMappingError] = (0, _react2.useState)(undefined);
  const [isJSONVisible, setIsJSONVisible] = (0, _react2.useState)(false);
  const onToggleChange = () => {
    setIsJSONVisible(!isJSONVisible);
  };
  const {
    parsedDefaultValue,
    multipleMappingsDeclared
  } = (0, _react2.useMemo)(() => (0, _parse_mappings.parseMappings)(jsonData), [jsonData]);
  const [hasSavedFields, setHasSavedFields] = (0, _react2.useState)(false);
  const [isUpdatingMappings, setIsUpdatingMappings] = (0, _react2.useState)(false);
  (0, _use_state_listener.useMappingsStateListener)({
    value: parsedDefaultValue,
    status: 'disabled'
  });
  const {
    fetchInferenceToModelIdMap
  } = (0, _use_details_page_mappings_model_management.useDetailsPageMappingsModelManagement)();
  const onCancelAddingNewFields = (0, _react2.useCallback)(() => {
    setAddingFields(!isAddingFields);

    //  reset mappings to previous state
    dispatch({
      type: 'editor.replaceMappings',
      value: {
        ...previousState,
        documentFields: {
          status: 'disabled',
          editor: 'default'
        }
      }
    });
  }, [isAddingFields, dispatch, previousState]);
  const addFieldButtonOnClick = (0, _react2.useCallback)(() => {
    setAddingFields(!isAddingFields);

    // when adding new field, save previous state. This state is then used by FieldsList component to show only saved mappings.
    setPreviousState(state);

    // reset mappings and change status to create field.
    dispatch({
      type: 'editor.replaceMappings',
      value: {
        ...state,
        fields: {
          ...state.fields,
          byId: {},
          rootLevelFields: []
        },
        filter: {
          filteredFields: [],
          selectedOptions: [],
          selectedDataTypes: []
        },
        documentFields: {
          status: 'creatingField',
          editor: 'default'
        }
      }
    });
  }, [dispatch, isAddingFields, state]);
  (0, _react2.useEffect)(() => {
    if (!isSemanticTextEnabled || !hasMLPermissions) {
      return;
    }
    const fetchData = async () => {
      await fetchInferenceToModelIdMap();
    };
    fetchData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isSemanticTextEnabled, hasMLPermissions]);
  const updateMappings = (0, _react2.useCallback)(async forceSaveMappings => {
    let inferenceToModelIdMap = state.inferenceToModelIdMap;
    setIsUpdatingMappings(true);
    try {
      var _ml$mlApi;
      await (ml === null || ml === void 0 ? void 0 : (_ml$mlApi = ml.mlApi) === null || _ml$mlApi === void 0 ? void 0 : _ml$mlApi.savedObjects.syncSavedObjects());
      if (isSemanticTextEnabled && hasMLPermissions && hasSemanticText && !forceSaveMappings) {
        inferenceToModelIdMap = await fetchInferenceToModelIdMap();
      }
      const fields = hasSemanticText ? (0, _utils.getStateWithCopyToFields)(state).fields : state.fields;
      const denormalizedFields = (0, _lib.deNormalize)(fields);
      const inferenceIdsInPendingList = forceSaveMappings ? [] : Object.values(denormalizedFields).filter(_utils.isSemanticTextField).map(field => field.inference_id).filter(inferenceId => {
        var _inferenceToModelIdMa, _inferenceToModelIdMa2;
        return inferenceId && ((_inferenceToModelIdMa = inferenceToModelIdMap) === null || _inferenceToModelIdMa === void 0 ? void 0 : _inferenceToModelIdMa[inferenceId].trainedModelId) &&
        // third-party inference models don't have trainedModelId
        !((_inferenceToModelIdMa2 = inferenceToModelIdMap) !== null && _inferenceToModelIdMa2 !== void 0 && _inferenceToModelIdMa2[inferenceId].isDeployed) && !isInferencePreconfigured(inferenceId);
      });
      setHasSavedFields(true);
      if (inferenceIdsInPendingList.length === 0) {
        const {
          error
        } = await (0, _api.updateIndexMappings)(indexName, denormalizedFields);
        if (!error) {
          _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.successfullyUpdatedIndexMappings', {
            defaultMessage: 'Updated index mapping'
          }));
          refetchMapping();
          setHasSavedFields(false);
        } else {
          setSaveMappingError(error.message);
        }
      }
    } catch (exception) {
      setSaveMappingError(exception.message);
    }
    setIsUpdatingMappings(false);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [state.fields]);
  const onSearchChange = (0, _react2.useCallback)(value => {
    if (isAddingFields) {
      setPreviousState({
        ...previousState,
        search: {
          term: value,
          result: (0, _lib.searchFields)(value, previousStateSelectedDataTypes.length > 0 ? (0, _lib.getFieldsMatchingFilterFromState)(previousState, previousStateSelectedDataTypes) : previousState.fields.byId)
        }
      });
    } else {
      dispatch({
        type: 'search:update',
        value
      });
    }
  }, [dispatch, previousState, isAddingFields, previousStateSelectedDataTypes]);
  const onClearSearch = (0, _react2.useCallback)(() => {
    setPreviousState({
      ...previousState,
      search: {
        term: '',
        result: (0, _lib.searchFields)('', previousState.filter.selectedDataTypes.length > 0 ? (0, _lib.getFieldsMatchingFilterFromState)(previousState, previousState.filter.selectedDataTypes) : previousState.fields.byId)
      }
    });
  }, [previousState]);
  const searchTerm = isAddingFields ? previousState.search.term.trim() : state.search.term.trim();
  const jsonBlock = /*#__PURE__*/_react2.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    "data-test-subj": "indexDetailsMappingsCodeBlock",
    css: (0, _react.css)`
        height: 100%;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 5
    }
  }, data);
  const searchResultComponent = isAddingFields ? /*#__PURE__*/_react2.default.createElement(_search_fields.SearchResult, {
    result: previousState.search.result,
    documentFieldsState: previousState.documentFields,
    onClearSearch: onClearSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react2.default.createElement(_search_fields.SearchResult, {
    result: state.search.result,
    documentFieldsState: state.documentFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 5
    }
  });
  const fieldsListComponent = isAddingFields ? /*#__PURE__*/_react2.default.createElement(_fields.FieldsList, {
    fields: previousStateSelectedDataTypes.length > 0 ? previousState.filter.filteredFields : (0, _lib.getFieldsFromState)(previousState.fields),
    state: previousState,
    setPreviousState: setPreviousState,
    isAddingFields: isAddingFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react2.default.createElement(_fields.FieldsList, {
    fields: state.filter.selectedDataTypes.length > 0 ? state.filter.filteredFields : (0, _lib.getFieldsFromState)(state.fields),
    state: state,
    isAddingFields: isAddingFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 5
    }
  });
  const fieldSearchComponent = isAddingFields ? /*#__PURE__*/_react2.default.createElement(_document_fields_search.DocumentFieldsSearch, {
    searchValue: previousState.search.term,
    onSearchChange: onSearchChange,
    disabled: isJSONVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react2.default.createElement(_document_fields_search.DocumentFieldsSearch, {
    searchValue: state.search.term,
    onSearchChange: onSearchChange,
    disabled: isJSONVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 5
    }
  });
  const treeViewBlock = /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, multipleMappingsDeclared ? /*#__PURE__*/_react2.default.createElement(_multiple_mappings_warning.MultipleMappingsWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 9
    }
  }) : searchTerm !== '' ? searchResultComponent : fieldsListComponent);
  const errorSavingMappings = saveMappingError && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    "data-test-subj": "indexDetailsSaveMappingsError",
    iconType: "error",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.error.title', {
      defaultMessage: 'Error saving mapping'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.error.description",
    defaultMessage: "Error saving mapping: {errorMessage}",
    values: {
      errorMessage: saveMappingError
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 401,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 7
    }
  }));
  const showAboutMappingsStyles = (0, _react.css)`
    ${(0, _eui.useEuiBreakpoint)(['xl'])} {
      max-width: 480px;
    }
  `;
  const mappingsWrapperStyles = (0, _react.css)`
    height: 100%;
    ${(0, _eui.useEuiBreakpoint)(['xl'])} {
      flex-wrap: nowrap;
    }
  `;
  const saveMappingsButton = /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    onClick: () => updateMappings(),
    color: "success",
    fill: true,
    disabled: newFieldsLength === 0,
    "data-test-subj": "indexDetailsMappingsSaveMappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexDetails.mappings.saveMappings",
    defaultMessage: "Save mapping",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 7
    }
  }));
  const AddFieldButton = ({
    color
  }) => {
    const isDisabled = hasUpdateMappingsPrivilege === false;
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      "data-test-subj": "indexDetailsMappingsAddFieldTooltip",
      content: isDisabled ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.addNewFieldToolTip', {
        defaultMessage: 'You do not have permission to add fields in an Index'
      }) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 443,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: addFieldButtonOnClick,
      iconType: "plusInCircle",
      color: color,
      size: "m",
      "data-test-subj": "indexDetailsMappingsAddField",
      isDisabled: isDisabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 454,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.addNewField",
      defaultMessage: "Add field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 11
      }
    })));
  };
  return (
    /*#__PURE__*/
    // using "rowReverse" to keep docs links on the top of the mappings code block on smaller screen
    _react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      direction: "rowReverse",
      css: mappingsWrapperStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 7
      }
    }, showAboutMappings && hasMappings && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: showAboutMappingsStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 476,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      grow: false,
      paddingSize: "l",
      hasShadow: false,
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 477,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 478,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 479,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 480,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 482,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 483,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 484,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardTitle",
      defaultMessage: "About index mappings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 485,
        columnNumber: 23
      }
    }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 493,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 494,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 495,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardDescription",
      defaultMessage: "Your documents are made up of a set of fields. Index mappings give each field a type (such as keyword, number, or date) and additional subfields. These index mappings determine the functions available in your relevance tuning and search experience.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 496,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 504,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      "data-test-subj": "indexDetailsMappingsDocsLink",
      href: _services.documentationService.getMappingDocumentationLink(),
      target: "_blank",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 505,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.docsCardLink",
      defaultMessage: "Learn more about mappings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 511,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 517,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      grow: false,
      paddingSize: "l",
      hasShadow: false,
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 518,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 519,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 520,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "info",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 521,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 523,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 524,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 525,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.transform.title",
      defaultMessage: "Transform your searchable content",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 526,
        columnNumber: 23
      }
    }))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 535,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 536,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 537,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.transform.description",
      defaultMessage: "Want to add custom fields, or use trained ML models  to analyze and enrich your indexed documents? Use index-specific ingest pipelines  to customize documents to your needs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 538,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 546,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      "data-test-subj": "indexDetailsMappingsLearnMoreLink",
      href: _services.documentationService.docLinks.enterpriseSearch.ingestPipelines,
      target: "_blank",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 547,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.transform.docLink",
      defaultMessage: "Learn more",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 553,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 561,
        columnNumber: 9
      }
    }, hasMLPermissions && !hasSemanticText && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 563,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_semantic_text_banner.SemanticTextBanner, {
      isSemanticTextEnabled: isSemanticTextEnabled,
      isPlatinumLicense: isPlatinumLicense,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 564,
        columnNumber: 15
      }
    })), !hasMappings && (!isAddingFields ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 572,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_details_page_empty_mappings.EmptyMappingsContent, {
      addFieldButton: AddFieldButton,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 573,
        columnNumber: 17
      }
    })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 576,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 577,
        columnNumber: 17
      }
    }, saveMappingsButton))), hasMappings && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 581,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 582,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_details_page_filter_fields.MappingsFilter, {
      isAddingFields: isAddingFields,
      isJSONVisible: isJSONVisible,
      previousState: previousState,
      setPreviousState: setPreviousState,
      state: state,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 583,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 591,
        columnNumber: 15
      }
    }, fieldSearchComponent), !index.hidden && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 593,
        columnNumber: 17
      }
    }, !isAddingFields ? /*#__PURE__*/_react2.default.createElement(AddFieldButton, {
      color: 'text',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 594,
        columnNumber: 38
      }
    }) : saveMappingsButton), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 598,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterGroup, {
      "data-test-subj": "indexDetailsMappingsToggleViewButton",
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexDetails.mappings.mappingsViewButtonGroupAriaLabel', {
        defaultMessage: 'Mappings View Button Group'
      }),
      onClick: onToggleChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 599,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
      isToggle: true,
      isSelected: !isJSONVisible,
      hasActiveFilters: !isJSONVisible,
      withNext: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 609,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.tableView",
      defaultMessage: "List",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 615,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
      isToggle: true,
      isSelected: isJSONVisible,
      hasActiveFilters: isJSONVisible,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 620,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.mappings.json",
      defaultMessage: "JSON",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 625,
        columnNumber: 21
      }
    }))))), errorSavingMappings, isAddingFields && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      ref: pendingFieldsRef,
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 636,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 637,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
      id: pendingFieldListId,
      initialIsOpen: true,
      buttonContent: /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
        paddingSize: "s",
        hasShadow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 642,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "baseline",
        "data-test-subj": "indexDetailsMappingsPendingBlock",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 643,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: 6,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 648,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 649,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.mappings.addMappingPendingBlock",
        defaultMessage: "Pending fields",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 650,
          columnNumber: 29
        }
      }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 656,
          columnNumber: 25
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiNotificationBadge, {
        color: newFieldsLength > 0 ? 'accent' : 'subdued',
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 657,
          columnNumber: 27
        }
      }, newFieldsLength)))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 638,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 668,
        columnNumber: 19
      }
    }, newFieldsLength <= 0 ? /*#__PURE__*/_react2.default.createElement(_components.DocumentFields, {
      onCancelAddingNewFields: onCancelAddingNewFields,
      isAddingFields: isAddingFields,
      semanticTextInfo: semanticTextInfo,
      pendingFieldsRef: pendingFieldsRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 670,
        columnNumber: 23
      }
    }) : /*#__PURE__*/_react2.default.createElement(_components.DocumentFields, {
      isAddingFields: isAddingFields,
      semanticTextInfo: semanticTextInfo,
      pendingFieldsRef: pendingFieldsRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 677,
        columnNumber: 23
      }
    }))))), hasMappings && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: (0, _react.css)`
                min-width: 600px;
                height: 100%;
              `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 689,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      paddingSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 696,
        columnNumber: 15
      }
    }, isJSONVisible ? jsonBlock : treeViewBlock)))), isSemanticTextEnabled && isAddingFields && hasSavedFields && /*#__PURE__*/_react2.default.createElement(_trained_models_deployment_modal.TrainedModelsDeploymentModal, {
      errorsInTrainedModelDeployment: errorsInTrainedModelDeployment,
      forceSaveMappings: () => updateMappings(true),
      saveMappings: () => updateMappings(),
      saveMappingsLoading: isUpdatingMappings,
      setErrorsInTrainedModelDeployment: setErrorsInTrainedModelDeployment,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 704,
        columnNumber: 9
      }
    }))
  );
};
exports.DetailsPageMappingsContent = DetailsPageMappingsContent;
function hasSemanticTextField(fields) {
  return Object.values(fields.byId).some(field => field.source.type === 'semantic_text');
}