"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PathParameter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _edit_field = require("../fields/edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/path_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const targetFieldTypeNotAllowed = _constants.PARAMETERS_DEFINITION.path.targetTypesNotAllowed;
const getSuggestedFields = (allFields, currentField) => Object.entries(allFields).filter(([id, field]) => {
  if (currentField && id === currentField.id) {
    return false;
  }

  // An alias cannot point certain field types ("object", "nested", "alias")
  if (targetFieldTypeNotAllowed.includes(field.source.type)) {
    return false;
  }
  return true;
}).map(([id, field]) => ({
  id,
  label: field.path.join(' > ')
})).sort((a, b) => a.label > b.label ? 1 : a.label < b.label ? -1 : 0);
const getDeserializer = allFields => value => {
  if (typeof value === 'string' && Boolean(value)) {
    return [{
      id: value,
      label: allFields[value].path.join(' > ')
    }];
  }
  return [];
};
const PathParameter = ({
  field,
  allFields
}) => {
  const suggestedFields = getSuggestedFields(allFields, field);
  const fieldConfig = (0, _react.useMemo)(() => ({
    ...(0, _lib.getFieldConfig)('path'),
    deserializer: getDeserializer(allFields)
  }), [allFields]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "path",
    config: fieldConfig,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, pathField => {
    const error = pathField.getErrorsMessages();
    const isInvalid = error ? Boolean(error.length) : false;
    return /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
      title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.aliasTargetFieldTitle', {
        defaultMessage: 'Alias target'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.aliasTargetFieldDescription', {
        defaultMessage: 'Select the field you want your alias to point to. You will then be able to use the alias instead of the target field in search requests and select other APIs like field capabilities.'
      }),
      withToggle: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !Boolean(suggestedFields.length) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "s",
      color: "warning",
      title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.noFieldsAddedWarningMessage', {
        defaultMessage: 'You need to add at least one field before creating an alias.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: pathField.label,
      helpText: pathField.helpText,
      error: error,
      isInvalid: isInvalid,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isInvalid,
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.aliasType.pathPlaceholderLabel', {
        defaultMessage: 'Select a field'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: suggestedFields,
      selectedOptions: pathField.value,
      onChange: value => pathField.setValue(value),
      isClearable: false,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 17
      }
    }))));
  });
};
exports.PathParameter = PathParameter;