"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tutorial = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _footer = require("./footer");
var _introduction = require("./introduction");
var _instruction_set = require("./instruction_set");
var StatusCheckStates = _interopRequireWildcard(require("./status_check_states"));
var _kibana_services = require("../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/home/public/application/components/tutorial/tutorial.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INSTRUCTIONS_TYPE = {
  ELASTIC_CLOUD: 'elasticCloud',
  ON_PREM: 'onPrem',
  ON_PREM_ELASTIC_CLOUD: 'onPremElasticCloud'
};
const integrationsTitle = _i18n.i18n.translate('home.breadcrumbs.integrationsAppTitle', {
  defaultMessage: 'Integrations'
});
class TutorialUi extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", void 0);
    (0, _defineProperty2.default)(this, "getInstructions", () => {
      if (!this.state.tutorial) {
        return {
          instructionSets: []
        };
      }
      switch (this.state.visibleInstructions) {
        case INSTRUCTIONS_TYPE.ELASTIC_CLOUD:
          return this.state.tutorial.elasticCloud;
        case INSTRUCTIONS_TYPE.ON_PREM:
          return this.state.tutorial.onPrem;
        case INSTRUCTIONS_TYPE.ON_PREM_ELASTIC_CLOUD:
          return this.state.tutorial.onPremElasticCloud;
        default:
          throw new Error(this.props.intl.formatMessage({
            id: 'home.tutorial.unhandledInstructionTypeErrorDescription',
            defaultMessage: 'Unhandled instruction type {visibleInstructions}'
          }, {
            visibleInstructions: this.state.visibleInstructions
          }));
      }
    });
    (0, _defineProperty2.default)(this, "getInstructionSets", () => {
      var _this$getInstructions, _this$getInstructions2;
      return (_this$getInstructions = (_this$getInstructions2 = this.getInstructions()) === null || _this$getInstructions2 === void 0 ? void 0 : _this$getInstructions2.instructionSets) !== null && _this$getInstructions !== void 0 ? _this$getInstructions : [];
    });
    (0, _defineProperty2.default)(this, "initInstructionsState", () => {
      var _instructions$instruc, _instructions$instruc2;
      const instructions = this.getInstructions() || {
        instructionSets: []
      };
      const statusCheckStates = new Array((_instructions$instruc = instructions === null || instructions === void 0 ? void 0 : (_instructions$instruc2 = instructions.instructionSets) === null || _instructions$instruc2 === void 0 ? void 0 : _instructions$instruc2.length) !== null && _instructions$instruc !== void 0 ? _instructions$instruc : 0).fill(StatusCheckStates.NOT_CHECKED);
      this.setState({
        statusCheckStates
      });
    });
    (0, _defineProperty2.default)(this, "setVisibleInstructions", instructionsType => {
      this.setState({
        visibleInstructions: instructionsType
      }, this.initInstructionsState);
    });
    (0, _defineProperty2.default)(this, "checkInstructionSetStatus", async instructionSetIndex => {
      var _instructionSet$statu;
      const instructionSets = this.getInstructionSets();
      if (!instructionSets) return;
      const instructionSet = instructionSets[instructionSetIndex];
      if (!instructionSet) return;
      const esHitsCheckConfig = (_instructionSet$statu = instructionSet.statusCheck) === null || _instructionSet$statu === void 0 ? void 0 : _instructionSet$statu.esHitsCheck;
      if (!this.state.tutorial) return;
      const customStatusCheckCallback = this.state.tutorial.customStatusCheckName ? (0, _kibana_services.getServices)().tutorialService.getCustomStatusCheck(this.state.tutorial.customStatusCheckName) : undefined;
      const [esHitsStatusCheck, customStatusCheck] = await Promise.all([...(esHitsCheckConfig ? [this.fetchEsHitsStatus(esHitsCheckConfig)] : []), ...(customStatusCheckCallback ? [this.fetchCustomStatusCheck(customStatusCheckCallback)] : [])]);
      const nextStatusCheckState = esHitsStatusCheck === StatusCheckStates.HAS_DATA || customStatusCheck === StatusCheckStates.HAS_DATA ? StatusCheckStates.HAS_DATA : StatusCheckStates.NO_DATA;
      this.setState(prevState => {
        const newStatusCheckStates = [...prevState.statusCheckStates];
        newStatusCheckStates[instructionSetIndex] = nextStatusCheckState;
        return {
          statusCheckStates: newStatusCheckStates
        };
      });
    });
    (0, _defineProperty2.default)(this, "fetchCustomStatusCheck", async customStatusCheckCallback => {
      try {
        const response = await customStatusCheckCallback();
        return response ? StatusCheckStates.HAS_DATA : StatusCheckStates.NO_DATA;
      } catch (e) {
        return StatusCheckStates.ERROR;
      }
    });
    (0, _defineProperty2.default)(this, "fetchEsHitsStatus", async esHitsCheckConfig => {
      const {
        http
      } = (0, _kibana_services.getServices)();
      try {
        const index = Array.isArray(esHitsCheckConfig.index) ? esHitsCheckConfig.index.join(',') : esHitsCheckConfig.index;
        const response = await http.post('/api/home/hits_status', {
          body: JSON.stringify({
            index,
            query: esHitsCheckConfig.query
          })
        });
        return response.count > 0 ? StatusCheckStates.HAS_DATA : StatusCheckStates.NO_DATA;
      } catch (e) {
        return StatusCheckStates.ERROR;
      }
    });
    (0, _defineProperty2.default)(this, "renderInstructionSetsToggle", () => {
      var _this$state$tutorial;
      if (!this.props.isCloudEnabled && (_this$state$tutorial = this.state.tutorial) !== null && _this$state$tutorial !== void 0 && _this$state$tutorial.onPremElasticCloud) {
        const selfManagedLabel = this.props.intl.formatMessage({
          id: 'home.tutorial.selfManagedButtonLabel',
          defaultMessage: 'Self managed'
        });
        const cloudLabel = this.props.intl.formatMessage({
          id: 'home.tutorial.elasticCloudButtonLabel',
          defaultMessage: 'Elastic Cloud'
        });
        const radioButtons = [{
          id: INSTRUCTIONS_TYPE.ON_PREM,
          label: selfManagedLabel,
          'data-test-subj': 'selfManagedTutorial'
        }, {
          id: INSTRUCTIONS_TYPE.ON_PREM_ELASTIC_CLOUD,
          label: cloudLabel,
          'data-test-subj': 'onCloudTutorial'
        }];
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 258,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 259,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
          isFullWidth: true,
          buttonSize: "m",
          options: radioButtons,
          idSelected: this.state.visibleInstructions,
          onChange: this.setVisibleInstructions,
          color: "text",
          legend: _i18n.i18n.translate('home.tutorial.selectionLegend', {
            defaultMessage: 'Deployment type'
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 260,
            columnNumber: 13
          }
        })));
      }
    });
    (0, _defineProperty2.default)(this, "onStatusCheck", instructionSetIndex => {
      this.setState(prevState => ({
        statusCheckStates: [...prevState.statusCheckStates.slice(0, instructionSetIndex), StatusCheckStates.FETCHING, ...prevState.statusCheckStates.slice(instructionSetIndex + 1)]
      }), () => this.checkInstructionSetStatus(instructionSetIndex));
    });
    (0, _defineProperty2.default)(this, "renderInstructionSets", ({
      instructionSets
    }) => {
      let offset = 1;
      return instructionSets.map((instructionSet, index) => {
        const currentOffset = offset;
        offset += instructionSet.instructionVariants[0].instructions.length;
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          key: index,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 296,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_instruction_set.InstructionSet, {
          title: instructionSet.title,
          callOut: instructionSet.callOut,
          instructionVariants: instructionSet.instructionVariants,
          statusCheckConfig: instructionSet.statusCheck,
          statusCheckState: this.state.statusCheckStates[index],
          onStatusCheck: () => {
            this.onStatusCheck(index);
          },
          offset: currentOffset,
          replaceTemplateStrings: this.props.replaceTemplateStrings,
          isCloudEnabled: this.props.isCloudEnabled,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 297,
            columnNumber: 11
          }
        }), index < instructionSets.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 310,
            columnNumber: 50
          }
        }));
      });
    });
    (0, _defineProperty2.default)(this, "renderFooter", () => {
      let label;
      let url;
      if (_lodash.default.has(this.state, 'tutorial.artifacts.application')) {
        var _this$state$tutorial$, _this$state$tutorial2, _this$state$tutorial3, _this$state$tutorial4;
        label = (_this$state$tutorial$ = (_this$state$tutorial2 = this.state.tutorial) === null || _this$state$tutorial2 === void 0 ? void 0 : (_this$state$tutorial3 = _this$state$tutorial2.artifacts) === null || _this$state$tutorial3 === void 0 ? void 0 : (_this$state$tutorial4 = _this$state$tutorial3.application) === null || _this$state$tutorial4 === void 0 ? void 0 : _this$state$tutorial4.label) !== null && _this$state$tutorial$ !== void 0 ? _this$state$tutorial$ : '';
        url = this.props.addBasePath(this.state.tutorial.artifacts.application.path);
      } else if (_lodash.default.has(this.state, 'tutorial.artifacts.dashboards')) {
        var _this$state$tutorial5, _this$state$tutorial6;
        const overviewDashboard = (_this$state$tutorial5 = this.state.tutorial) === null || _this$state$tutorial5 === void 0 ? void 0 : (_this$state$tutorial6 = _this$state$tutorial5.artifacts) === null || _this$state$tutorial6 === void 0 ? void 0 : _this$state$tutorial6.dashboards.find(dashboard => {
          return dashboard.isOverview;
        });
        if (overviewDashboard) {
          label = overviewDashboard.linkLabel;
          url = this.props.addBasePath(`/app/dashboards#/view/${overviewDashboard.id}`);
        }
      }
      if (url && label) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 335,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
          paddingSize: "l",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 336,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_footer.Footer, {
          label: label,
          url: url,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 337,
            columnNumber: 13
          }
        })));
      }
    });
    this.state = {
      notFound: false,
      statusCheckStates: [],
      tutorial: null,
      visibleInstructions: props.isCloudEnabled ? INSTRUCTIONS_TYPE.ELASTIC_CLOUD : INSTRUCTIONS_TYPE.ON_PREM
    };
    this._isMounted = false;
  }
  UNSAFE_componentWillMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async componentDidMount() {
    const tutorial = await this.props.getTutorial(this.props.tutorialId);
    if (!this._isMounted) {
      return;
    }
    if (tutorial) {
      this.setState({
        tutorial
      }, this.initInstructionsState);
    } else {
      this.setState({
        notFound: true
      });
    }
    const breadcrumbs = [{
      text: integrationsTitle,
      href: this.props.addBasePath('/app/integrations/browse')
    }, {
      text: tutorial ? tutorial.name : this.props.tutorialId
    }];
    (0, _kibana_services.getServices)().chrome.setBreadcrumbs(breadcrumbs, {
      project: {
        value: breadcrumbs
      }
    });
  }
  renderModuleNotices() {
    var _this$state$tutorial7;
    const notices = (0, _kibana_services.getServices)().tutorialService.getModuleNotices();
    if (notices.length && (_this$state$tutorial7 = this.state.tutorial) !== null && _this$state$tutorial7 !== void 0 && _this$state$tutorial7.moduleName) {
      return notices.map((ModuleNotice, index) => /*#__PURE__*/_react.default.createElement(ModuleNotice, {
        key: index,
        moduleName: this.state.tutorial.moduleName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 348,
          columnNumber: 9
        }
      }));
    } else {
      return null;
    }
  }
  render() {
    let content;
    if (this.state.notFound) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
        isEmptyState: true,
        pageHeader: {
          iconType: 'faceSad',
          iconProps: {
            color: 'subdued'
          },
          pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "home.tutorial.noTutorialLabel",
            defaultMessage: "Unable to find tutorial {tutorialId}",
            values: {
              tutorialId: this.props.tutorialId
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 367,
              columnNumber: 15
            }
          }),
          rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            href: this.props.addBasePath('/app/home#/tutorial_directory'),
            fill: true,
            iconType: "sortLeft",
            iconSide: "left",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 374,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('home.tutorial.backToDirectory', {
            defaultMessage: 'Back to directory'
          }))]
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 9
        }
      });
    }
    if (this.state.tutorial) {
      let previewUrl;
      if (this.state.tutorial.previewImagePath) {
        previewUrl = this.props.addBasePath(this.state.tutorial.previewImagePath);
      }
      let exportedFieldsUrl;
      if (_lodash.default.has(this.state, 'tutorial.artifacts.exportedFields')) {
        var _this$state$tutorial$2, _this$state$tutorial$3, _this$state$tutorial$4;
        exportedFieldsUrl = this.props.replaceTemplateStrings((_this$state$tutorial$2 = (_this$state$tutorial$3 = this.state.tutorial.artifacts) === null || _this$state$tutorial$3 === void 0 ? void 0 : (_this$state$tutorial$4 = _this$state$tutorial$3.exportedFields) === null || _this$state$tutorial$4 === void 0 ? void 0 : _this$state$tutorial$4.documentationUrl) !== null && _this$state$tutorial$2 !== void 0 ? _this$state$tutorial$2 : '');
      }
      let icon = this.state.tutorial.euiIconType;
      if (icon && icon.includes('/')) {
        icon = this.props.addBasePath(icon);
      }
      const instructions = this.getInstructions();
      content = /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 410,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_introduction.Introduction, {
        category: this.state.tutorial.category,
        title: this.state.tutorial.name,
        description: this.props.replaceTemplateStrings(this.state.tutorial.longDescription),
        previewUrl: previewUrl,
        exportedFieldsUrl: exportedFieldsUrl,
        iconType: icon,
        isBeta: this.state.tutorial.isBeta,
        notices: this.renderModuleNotices(),
        basePath: (0, _kibana_services.getServices)().http.basePath,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 411,
          columnNumber: 11
        }
      }), this.renderInstructionSetsToggle(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 425,
          columnNumber: 11
        }
      }), instructions && this.renderInstructionSets(instructions), this.renderFooter());
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 432,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 433,
        columnNumber: 9
      }
    }, content));
  }
}
const Tutorial = exports.Tutorial = (0, _i18nReact.injectI18n)(TutorialUi);