"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenAiSettingsPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class GenAiSettingsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  async setup(core, {
    management
  }) {
    var _capabilities$actions, _capabilities$actions2;
    const [coreStart, {
      licensing
    }] = await core.getStartServices();
    const capabilities = coreStart.application.capabilities;
    const hasEnterpriseLicense = licensing ? (await (0, _rxjs.firstValueFrom)(licensing.license$)).hasAtLeast('enterprise') : false;

    // This section depends mainly on Connectors feature, but should have its own Kibana feature setting in the future.
    if (
    // Connectors 'Read' privilege
    ((_capabilities$actions = capabilities.actions) === null || _capabilities$actions === void 0 ? void 0 : _capabilities$actions.show) === true && ((_capabilities$actions2 = capabilities.actions) === null || _capabilities$actions2 === void 0 ? void 0 : _capabilities$actions2.execute) === true && hasEnterpriseLicense) {
      management.sections.section.ai.registerApp({
        id: 'genAiSettings',
        title: _i18n.i18n.translate('genAiSettings.managementSectionLabel', {
          defaultMessage: 'GenAI Settings'
        }),
        order: 1,
        keywords: ['ai', 'generative', 'settings', 'configuration'],
        mount: async mountParams => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_section/mount_section')));
          return mountManagementSection({
            core,
            mountParams,
            config: this.initializerContext.config.get()
          });
        }
      });
    }
    return {};
  }
  start(coreStart) {
    return {};
  }
  stop() {}
}
exports.GenAiSettingsPlugin = GenAiSettingsPlugin;