/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.fleet_bundle_jsonpfunction=self.fleet_bundle_jsonpfunction||[]).push([[546],{28707:(e,t,a)=>{a.r(t),a.d(t,{ALLOWED_JOB_CONTENT_TYPES:()=>s,AuthenticationExpiredError:()=>AuthenticationExpiredError,BrowserCouldNotLaunchError:()=>BrowserCouldNotLaunchError,BrowserScreenshotError:()=>BrowserScreenshotError,BrowserUnexpectedlyClosedError:()=>BrowserUnexpectedlyClosedError,CancellationToken:()=>CancellationToken,DisallowedOutgoingUrl:()=>DisallowedOutgoingUrl,ILM_POLICY_NAME:()=>v,INTERNAL_ROUTES:()=>_,InvalidLayoutParametersError:()=>InvalidLayoutParametersError,JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY:()=>m,JOB_STATUS:()=>k,KibanaShuttingDownError:()=>KibanaShuttingDownError,LICENSE_TYPE_BASIC:()=>r,LICENSE_TYPE_CLOUD_STANDARD:()=>u,LICENSE_TYPE_ENTERPRISE:()=>g,LICENSE_TYPE_GOLD:()=>d,LICENSE_TYPE_PLATINUM:()=>c,LICENSE_TYPE_TRIAL:()=>o,MissingAuthenticationError:()=>MissingAuthenticationError,PUBLIC_ROUTES:()=>O,PdfWorkerOutOfMemoryError:()=>PdfWorkerOutOfMemoryError,QueueTimeoutError:()=>QueueTimeoutError,REPORTING_MANAGEMENT_HOME:()=>y,REPORTING_MANAGEMENT_SCHEDULES:()=>E,REPORTING_REDIRECT_ALLOWED_LOCATOR_TYPES:()=>f,REPORTING_REDIRECT_APP:()=>x,REPORTING_REDIRECT_LOCATOR_STORE_KEY:()=>h,REPORT_TABLE_ID:()=>j,REPORT_TABLE_ROW_ID:()=>b,ReportingError:()=>ReportingError,ReportingSavedObjectNotFoundError:()=>ReportingSavedObjectNotFoundError,SCHEDULED_REPORT_VALID_LICENSES:()=>p,UI_SETTINGS_CUSTOM_PDF_LOGO:()=>n,UI_SETTINGS_DATEFORMAT_TZ:()=>i,UI_SETTINGS_SEARCH_INCLUDE_FROZEN:()=>l,UnknownError:()=>UnknownError,VisualReportingSoftDisabledError:()=>VisualReportingSoftDisabledError,buildKibanaPath:()=>P,byteSizeValueToNumber:()=>A,durationToNumber:()=>T,numberToDuration:()=>w});const s=["application/json","application/pdf","text/csv","image/png","text/plain"],l="search:includeFrozen",n="xpackReporting:customPdfLogo",i="dateFormat:tz",o="trial",r="basic",u="standard",d="gold",c="platinum",g="enterprise",p=[o,u,d,c,g],m="xpack.reporting.jobCompletionNotifications",f=["DISCOVER_APP_LOCATOR","CANVAS_APP_LOCATOR","DASHBOARD_APP_LOCATOR","LENS_APP_LOCATOR","VISUALIZE_APP_LOCATOR"],x="/app/reportingRedirect",h="__REPORTING_REDIRECT_LOCATOR_STORE_KEY__",y="/app/management/insightsAndAlerting/reporting",E="/app/management/insightsAndAlerting/reporting/schedules",v="kibana-reporting";let k=function(e){return e.PENDING="pending",e.PROCESSING="processing",e.COMPLETED="completed",e.FAILED="failed",e.WARNINGS="completed_with_warnings",e}({});const j="reportJobListing",b="reportJobRow";var S=a(68915),F=a(75008);class ReportingError extends Error{constructor(e){super(),this.details=e}get message(){const e="ReportingError";return this.details?`${e}(code: ${this.code}) "${this.details}"`:`${e}(code: ${this.code})`}toString(){return this.message}}class InvalidLayoutParametersError extends ReportingError{get code(){return InvalidLayoutParametersError.code}}(0,S.default)(InvalidLayoutParametersError,"code","invalid_layout_parameters_error");class DisallowedOutgoingUrl extends ReportingError{get code(){return DisallowedOutgoingUrl.code}}(0,S.default)(DisallowedOutgoingUrl,"code","disallowed_outgoing_url_error");class AuthenticationExpiredError extends ReportingError{get code(){return AuthenticationExpiredError.code}}(0,S.default)(AuthenticationExpiredError,"code","authentication_expired_error");class MissingAuthenticationError extends ReportingError{get code(){return MissingAuthenticationError.code}}(0,S.default)(MissingAuthenticationError,"code","missing_authentication_header_error");class QueueTimeoutError extends ReportingError{get code(){return QueueTimeoutError.code}}(0,S.default)(QueueTimeoutError,"code","queue_timeout_error");class UnknownError extends ReportingError{get code(){return UnknownError.code}}(0,S.default)(UnknownError,"code","unknown_error");class PdfWorkerOutOfMemoryError extends ReportingError{get code(){return PdfWorkerOutOfMemoryError.code}humanFriendlyMessage(){return F.i18n.translate("reporting.common.pdfWorkerOutOfMemoryErrorMessage",{defaultMessage:"Can't generate a PDF due to insufficient memory. Try making a smaller PDF and retrying this report."})}}(0,S.default)(PdfWorkerOutOfMemoryError,"code","pdf_worker_out_of_memory_error");class BrowserCouldNotLaunchError extends ReportingError{get code(){return BrowserCouldNotLaunchError.code}humanFriendlyMessage(){return F.i18n.translate("reporting.common.browserCouldNotLaunchErrorMessage",{defaultMessage:"Can't generate screenshots because the browser did not launch. See the server logs for more information."})}}(0,S.default)(BrowserCouldNotLaunchError,"code","browser_could_not_launch_error");class BrowserUnexpectedlyClosedError extends ReportingError{get code(){return BrowserUnexpectedlyClosedError.code}}(0,S.default)(BrowserUnexpectedlyClosedError,"code","browser_unexpectedly_closed_error");class BrowserScreenshotError extends ReportingError{get code(){return BrowserScreenshotError.code}}(0,S.default)(BrowserScreenshotError,"code","browser_screenshot_error");class KibanaShuttingDownError extends ReportingError{get code(){return KibanaShuttingDownError.code}}(0,S.default)(KibanaShuttingDownError,"code","kibana_shutting_down_error");class VisualReportingSoftDisabledError extends ReportingError{get code(){return VisualReportingSoftDisabledError.code}humanFriendlyMessage(){return F.i18n.translate("reporting.common.cloud.insufficientSystemMemoryError",{defaultMessage:"Can't generate this report due to insufficient memory."})}}(0,S.default)(VisualReportingSoftDisabledError,"code","visual_reporting_soft_disabled_error");class ReportingSavedObjectNotFoundError extends ReportingError{get code(){return ReportingSavedObjectNotFoundError.code}}(0,S.default)(ReportingSavedObjectNotFoundError,"code","reporting_saved_object_not_found_error");var M=a(51783),I=a.n(M);const T=e=>"number"==typeof e?e:e.asMilliseconds(),w=e=>"number"==typeof e?I().duration(e,"milliseconds"):e,A=e=>"number"==typeof e?e:e.getValueInBytes();var C=a(30770);class CancellationToken{constructor(){(0,S.default)(this,"_isCancelled",void 0),(0,S.default)(this,"_callbacks",void 0),(0,S.default)(this,"on",(e=>{if(!(0,C.isFunction)(e))throw new Error("Expected callback to be a function");this._isCancelled?e():this._callbacks.push(e)})),(0,S.default)(this,"cancel",(()=>{this._isCancelled=!0,this._callbacks.forEach((e=>e()))})),this._isCancelled=!1,this._callbacks=[]}isCancelled(){return this._isCancelled}}const P=({basePath:e,appPath:t,spaceId:a})=>void 0===a||"default"===a.toLowerCase()?`${e}${t}`:`${e}/s/${a}${t}`,L="/internal/reporting",_={MIGRATE:{MIGRATE_ILM_POLICY:L+"/deprecations/migrate_ilm_policy",GET_ILM_POLICY_STATUS:L+"/ilm_policy_status"},DIAGNOSE:{BROWSER:L+"/diagnose/browser",SCREENSHOT:L+"/diagnose/screenshot"},JOBS:{COUNT:L+"/jobs/count",LIST:L+"/jobs/list",INFO_PREFIX:L+"/jobs/info",DELETE_PREFIX:L+"/jobs/delete",DOWNLOAD_PREFIX:L+"/jobs/download"},SCHEDULED:{LIST:L+"/scheduled/list",BULK_DISABLE:L+"/scheduled/bulk_disable",BULK_DELETE:L+"/scheduled/bulk_delete"},HEALTH:L+"/_health",GENERATE_PREFIX:L+"/generate",SCHEDULE_PREFIX:L+"/schedule"},D="/api/reporting",O={GENERATE_PREFIX:D+"/generate",JOBS:{DOWNLOAD_PREFIX:D+"/jobs/download",DELETE_PREFIX:D+"/jobs/delete"}}},34127:(e,t,a)=>{a.r(t),a.d(t,{InternalApiClientProvider:()=>v,Job:()=>Job,ReportingAPIClient:()=>ReportingAPIClient,checkLicense:()=>w,jobCompletionNotifications:()=>y,useCheckIlmPolicyStatus:()=>b,useInternalApiClient:()=>k,useKibana:()=>C});var s=a(68915),l=a(51783),n=a.n(l),i=a(84286),o=a.n(i),r=a(81319),u=a(75008),d=a(28707),c=a(96791);const{COMPLETED:g,FAILED:p,PENDING:m,PROCESSING:f,WARNINGS:x}=d.JOB_STATUS;class Job{constructor(e){var t,a,l,n,i,o;(0,s.default)(this,"payload",void 0),(0,s.default)(this,"id",void 0),(0,s.default)(this,"index",void 0),(0,s.default)(this,"objectType",void 0),(0,s.default)(this,"title",void 0),(0,s.default)(this,"isDeprecated",void 0),(0,s.default)(this,"spaceId",void 0),(0,s.default)(this,"browserTimezone",void 0),(0,s.default)(this,"layout",void 0),(0,s.default)(this,"pagingStrategy",void 0),(0,s.default)(this,"version",void 0),(0,s.default)(this,"jobtype",void 0),(0,s.default)(this,"created_by",void 0),(0,s.default)(this,"created_at",void 0),(0,s.default)(this,"started_at",void 0),(0,s.default)(this,"completed_at",void 0),(0,s.default)(this,"status",void 0),(0,s.default)(this,"attempts",void 0),(0,s.default)(this,"max_attempts",void 0),(0,s.default)(this,"timeout",void 0),(0,s.default)(this,"kibana_name",void 0),(0,s.default)(this,"kibana_id",void 0),(0,s.default)(this,"size",void 0),(0,s.default)(this,"content_type",void 0),(0,s.default)(this,"csv_contains_formulas",void 0),(0,s.default)(this,"max_size_reached",void 0),(0,s.default)(this,"metrics",void 0),(0,s.default)(this,"warnings",void 0),(0,s.default)(this,"error_code",void 0),(0,s.default)(this,"locatorParams",void 0),(0,s.default)(this,"queue_time_ms",void 0),(0,s.default)(this,"execution_time_ms",void 0),(0,s.default)(this,"scheduled_report_id",void 0),this.id=e.id,this.index=e.index,this.payload=e.payload,this.jobtype=e.jobtype,this.objectType=e.payload.objectType,this.title=e.payload.title,this.layout=e.payload.layout,this.pagingStrategy=e.payload.pagingStrategy,this.version=e.payload.version,this.created_by=e.created_by,this.created_at=e.created_at,this.started_at=e.started_at,this.completed_at=e.completed_at,this.status=e.status,this.attempts=e.attempts,this.max_attempts=e.max_attempts,this.timeout=e.timeout,this.kibana_name=e.kibana_name,this.kibana_id=e.kibana_id,this.browserTimezone=e.payload.browserTimezone,this.size=null===(t=e.output)||void 0===t?void 0:t.size,this.content_type=null===(a=e.output)||void 0===a?void 0:a.content_type,this.isDeprecated=e.payload.isDeprecated||!1,this.spaceId=e.payload.spaceId,this.csv_contains_formulas=null===(l=e.output)||void 0===l?void 0:l.csv_contains_formulas,this.max_size_reached=null===(n=e.output)||void 0===n?void 0:n.max_size_reached,this.warnings=null===(i=e.output)||void 0===i?void 0:i.warnings,this.error_code=null===(o=e.output)||void 0===o?void 0:o.error_code,this.locatorParams=e.payload.locatorParams,this.metrics=e.metrics,this.queue_time_ms=e.queue_time_ms,this.execution_time_ms=e.execution_time_ms,this.scheduled_report_id=e.scheduled_report_id}isSearch(){return"search"===this.objectType}getStatusMessage(){const e=this.status;let t,a;return e===m?t=u.i18n.translate("reporting.jobStatusDetail.pendingStatusReachedText",{defaultMessage:"Waiting for job to process."}):e===f?t=u.i18n.translate("reporting.jobStatusDetail.attemptXofY",{defaultMessage:"Attempt {attempts} of {max_attempts}.",values:{attempts:this.attempts,max_attempts:this.max_attempts}}):this.getWarnings()?t=u.i18n.translate("reporting.jobStatusDetail.warningsText",{defaultMessage:"See report info for warnings."}):this.getError()&&(t=u.i18n.translate("reporting.jobStatusDetail.errorText",{defaultMessage:"See report info for error details."})),this.isDeprecated&&(a=(0,c.jsx)(r.EuiText,{size:"s"}," ",(0,c.jsx)(r.EuiTextColor,{color:"warning"},u.i18n.translate("reporting.jobStatusDetail.deprecatedText",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})))),t?(0,c.jsx)(o().Fragment,null,(0,c.jsx)(r.EuiText,{size:"s"},(0,c.jsx)(r.EuiTextColor,{color:"subdued"},t)),a||null):null}get prettyStatus(){var e;return null!==(e=h.get(this.status))&&void 0!==e?e:u.i18n.translate("reporting.jobStatusDetail.unknownText",{defaultMessage:"Unknown"})}get canLinkToKibanaApp(){return Boolean(this.locatorParams)}get isDownloadReady(){return this.status===d.JOB_STATUS.COMPLETED||this.status===d.JOB_STATUS.WARNINGS}get prettyJobTypeName(){switch(this.jobtype){case"printable_pdf":case"printable_pdf_v2":return u.i18n.translate("reporting.jobType.pdfOutputName",{defaultMessage:"PDF"});case"PNG":case"PNGV2":return u.i18n.translate("reporting.jobType.pngOutputName",{defaultMessage:"PNG"});case"csv_v2":case"csv_searchsource":return u.i18n.translate("reporting.jobType.csvOutputName",{defaultMessage:"CSV"});default:return}}get prettyTimeout(){if(null==this.timeout)return u.i18n.translate("reporting.jobStatusDetail.timeoutSecondsUnknown",{defaultMessage:"Unknown"});const e=this.timeout/1e3;return u.i18n.translate("reporting.jobStatusDetail.timeoutSeconds",{defaultMessage:"{timeout} seconds",values:{timeout:e}})}getCreatedAtDate(){return this.formatDate(this.created_at)}getCreatedBy(){return this.created_by||u.i18n.translate("reporting.jobCreatedBy.unknownUserPlaceholderText",{defaultMessage:"Unknown"})}getCreatedAtLabel(){return this.created_by?(0,c.jsx)(o().Fragment,null,(0,c.jsx)("div",null,this.formatDate(this.created_at)),(0,c.jsx)("span",null,this.created_by)):this.formatDate(this.created_at)}getError(){if(this.status===p)return this.warnings}getDeprecatedMessage(){if(this.isDeprecated)return u.i18n.translate("reporting.jobWarning.exportTypeDeprecated",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})}getWarnings(){var e;const t=[],a=this.getDeprecatedMessage();if(a&&t.push(a),this.csv_contains_formulas&&t.push(u.i18n.translate("reporting.jobWarning.csvContainsFormulas",{defaultMessage:"Your CSV contains characters that spreadsheet applications might interpret as formulas."})),this.max_size_reached&&t.push(u.i18n.translate("reporting.jobWarning.maxSizeReachedTooltip",{defaultMessage:"Your search reached the max size and contains partial data."})),this.status!==p&&null!==(e=this.warnings)&&void 0!==e&&e.length&&t.push(...this.warnings),t.length)return(0,c.jsx)("ul",null,t.map(((e,t)=>(0,c.jsx)("li",{key:`warning-key-${t}`},e))))}getPrettyStatusTimestamp(){return this.formatDate(this.getStatusTimestamp())}formatDate(e){try{return n()(e).format("YYYY-MM-DD @ hh:mm A")}catch(t){return e}}getStatusTimestamp(){const e=this.status;return e===f&&this.started_at?this.started_at:this.completed_at&&[g,p,x].includes(e)?this.completed_at:this.created_at}}const h=new Map([[m,u.i18n.translate("reporting.jobStatuses.pendingText",{defaultMessage:"Pending"})],[f,u.i18n.translate("reporting.jobStatuses.processingText",{defaultMessage:"Processing"})],[g,u.i18n.translate("reporting.jobStatuses.completedText",{defaultMessage:"Completed"})],[x,u.i18n.translate("reporting.jobStatuses.warningText",{defaultMessage:"Completed"})],[p,u.i18n.translate("reporting.jobStatuses.failedText",{defaultMessage:"Failed"})]]);function y(){return{getPendingJobIds:function(){const e=[];for(const t in localStorage)if(0===t.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)){const a=t.replace(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-`,"");e.push(a)}return e},addPendingJobId:function(e){localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${e}`,e)},setPendingJobIds:function(e){for(const e in localStorage)0===e.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)&&localStorage.removeItem(e);for(let t=0;t<e.length;t++){const a=e[t];localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${a}`,a)}}}}const E=(0,i.createContext)(void 0),v=({apiClient:e,http:t,children:a})=>(0,c.jsx)(E.Provider,{value:{http:t,apiClient:e}},a),k=()=>{const e=(0,i.useContext)(E);if(!e)throw new Error('"useInternalApiClient" can only be used inside of "InternalApiClientContext"');return e};var j=a(18744);const b=()=>{const{services:{http:e}}=C();return(0,j.useRequest)(e,{path:d.INTERNAL_ROUTES.MIGRATE.GET_ILM_POLICY_STATUS,method:"get"})};var S=a(47400),F=a(45995),M=a.n(F),I=a(20151),T=a(43721);class ReportingAPIClient{constructor(e,t,a){(0,s.default)(this,"http",void 0),(0,s.default)(this,"addPendingJobId",y().addPendingJobId),(0,s.default)(this,"getManagementLink",(()=>this.http.basePath.prepend(d.REPORTING_MANAGEMENT_HOME))),(0,s.default)(this,"getDownloadLink",(e=>this.getReportURL(e))),(0,s.default)(this,"getServerBasePath",(()=>this.http.basePath.serverBasePath)),this.uiSettings=t,this.kibanaVersion=a,this.http=e}getKibanaAppHref(e){const t=(0,I.stringify)({jobId:e.id,...e.scheduled_report_id?{scheduledReportId:e.scheduled_report_id}:{}});return`${(0,d.buildKibanaPath)({basePath:this.http.basePath.serverBasePath,spaceId:e.spaceId,appPath:d.REPORTING_REDIRECT_APP})}?${t}`}getReportURL(e){return this.http.basePath.prepend(`${d.INTERNAL_ROUTES.JOBS.DOWNLOAD_PREFIX}/${e}?${S.SX}=true`)}downloadReport(e){const t=this.getReportURL(e);window.open(t)}async deleteReport(e){return await this.http.delete(`${d.INTERNAL_ROUTES.JOBS.DELETE_PREFIX}/${e}`)}async list(e=0,t=50,a=[]){const s={page:e,size:t};return a.length>0&&(s.ids=a.slice(0,t).join(",")),(await this.http.get(d.INTERNAL_ROUTES.JOBS.LIST,{query:s,asSystemRequest:!0})).map((e=>new Job(e)))}async total(){return await this.http.get(d.INTERNAL_ROUTES.JOBS.COUNT,{asSystemRequest:!0})}async getError(e){var t;const a=await this.getInfo(e);return null!==(t=a.warnings)&&void 0!==t&&t[0]?a.warnings[0]:u.i18n.translate("reporting.apiClient.unknownError",{defaultMessage:"Report job {job} failed. Error unknown.",values:{job:e}})}async getInfo(e){const t=await this.http.get(`${d.INTERNAL_ROUTES.JOBS.INFO_PREFIX}/${e}`);return new Job(t)}async getScheduledReportInfo(e,t=0,a=50){const{data:s=[]}=await this.http.get(`${d.INTERNAL_ROUTES.SCHEDULED.LIST}`,{query:{page:t,size:a}});return s.find((t=>t.id===e))}async findForJobIds(e){return(await this.http.fetch(d.INTERNAL_ROUTES.JOBS.LIST,{query:{page:0,ids:e.join(",")},method:"GET"})).map((e=>new Job(e)))}getReportingPublicJobPath(e,t){const a=(0,I.stringify)({jobParams:M().encode(t)});return`${this.http.basePath.prepend(d.PUBLIC_ROUTES.GENERATE_PREFIX)}/${e}?${a}`}async createReportingShareJob(e,t){const a=M().encode(t),s=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=s&&s.job)return this.addPendingJobId(s.job.id),new Job(s.job)}async createReportingJob(e,t){const a=M().encode(t);try{const t=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=t&&t.job)return this.addPendingJobId(t.job.id),new Job(t.job)}catch(e){var s;throw T.error(e),new Error(`${null===(s=e.body)||void 0===s?void 0:s.message}`)}}getDecoratedJobParams(e){return{browserTimezone:"Browser"===this.uiSettings.get("dateFormat:tz")?n().tz.guess():this.uiSettings.get("dateFormat:tz"),version:this.kibanaVersion,...e}}verifyBrowser(){return this.http.get(d.INTERNAL_ROUTES.DIAGNOSE.BROWSER)}verifyScreenCapture(){return this.http.post(d.INTERNAL_ROUTES.DIAGNOSE.SCREENSHOT)}migrateReportingIndicesIlmPolicy(){return this.http.put(d.INTERNAL_ROUTES.MIGRATE.MIGRATE_ILM_POLICY)}}const w=e=>{switch(e.state){case"valid":default:return{showLinks:!0,enableLinks:!0,message:""};case"invalid":return{showLinks:!1,enableLinks:!1,message:"Your license does not support Reporting. Please upgrade your license."};case"unavailable":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because license information is not available at this time."};case"expired":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because your license has expired."}}};var A=a(20409);const C=()=>(0,A.useKibana)()},88546:(e,t,a)=>{a.d(t,{renderApp:()=>$i,teardownFleet:()=>Yi});var s=a(84286),l=a.n(s),n=a(22874),i=a.n(n),o=a(1493),r=a(30193),u=a(51155),d=a(3185),c=a(77880),g=a(81319),p=a(20482),m=a(75879),f=a(75008),x=a(13530),h=a(45692),y=a(44081),E=a(20409),v=a(15006),k=a(52137),j=a(13528),b=a(26333),S=a(22e3),F=a(66720),M=a(42413),I=a(92045),T=a(84624),w=a(1363),A=a(3138),C=a(26768),P=a.n(C),L=a(46787),_=a(83424);const D=P()(g.EuiFlyout).withConfig({displayName:"FlyoutWithHigherZIndex",componentId:"sc-1pwanx7-0"})(["z-index:",";"],(e=>e.theme.eui.euiZLevel5)),O=({onClose:e,as:t,...a})=>{const{notifications:n}=(0,u.WeA)(),i=(0,u.iO7)().fleet.allAgentPolicies,o=(0,b.I)(),[r,c]=(0,s.useState)((0,_.b)({namespace:o.defaultNamespace})),[p,x]=(0,s.useState)(!1),[h,y]=(0,s.useState)(!0),E=(0,A.FS)(r,{allowedNamespacePrefixes:null==o?void 0:o.allowedNamespacePrefixes}),[v,k]=(0,s.useState)(!1),[j,S]=(0,s.useState)(!1),I=l().createElement(g.EuiFlyoutHeader,{hasBorder:!0,"aria-labelledby":"CreateAgentPolicyFlyoutTitle"},l().createElement(g.EuiTitle,{size:"m"},l().createElement("h2",{id:"CreateAgentPolicyFlyoutTitle","data-test-subj":"createAgentPolicyFlyoutTitle"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitle",defaultMessage:"Create agent policy"}))),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(g.EuiText,{size:"s"},l().createElement("p",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitleDescription",defaultMessage:"Agent policies are used to manage settings across a group of agents. You can add integrations to your agent policy to specify what data your agents collect. When you edit an agent policy, you can use Fleet to deploy updates to a specified group of agents."})))),T=l().createElement(g.EuiFlyoutBody,null,l().createElement(A.Kb,{agentPolicy:r,updateAgentPolicy:e=>{c({...r,...e})},withSysMonitoring:h,updateSysMonitoring:e=>y(e),validation:E,updateAdvancedSettingsHasErrors:k,setInvalidSpaceError:S})),w=(0,s.useMemo)((()=>(0,L.gF)(r,h)),[r,h]),C=l().createElement(g.EuiFlyoutFooter,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.cancelButtonLabel",defaultMessage:"Cancel"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexGroup,{gutterSize:"none"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(F.T_,{isDisabled:p||Object.keys(E).length>0||v||j,description:f.i18n.translate("xpack.fleet.createAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request creates a new agent policy."}),request:w})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{fill:!0,isLoading:p,isDisabled:!i||p||Object.keys(E).length>0||v||j,onClick:async()=>{x(!0);try{const{data:t,error:a}=await(async()=>await(0,u.iF6)(r,{withSysMonitoring:h}))();x(!1),t?(n.toasts.addSuccess(f.i18n.translate("xpack.fleet.createAgentPolicy.successNotificationTitle",{defaultMessage:"Agent policy ''{name}'' created",values:{name:r.name}})),e(t.item)):n.toasts.addDanger(a?a.message:f.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}catch(e){x(!1),n.toasts.addDanger(f.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}},"data-test-subj":"createAgentPolicyFlyoutBtn"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.submitButtonLabel",defaultMessage:"Create agent policy"})))))));return l().createElement(D,(0,d.default)({onClose:()=>e()},a,{maxWidth:M.MW}),I,T,C)};var R=a(96791);const B=()=>{var e,t;(0,u.ifo)("policies_list");const{getPath:a}=(0,u.iEg)(),n=(0,u.iO7)().fleet.allAgentPolicies,i=M.mm,{agents:{enabled:r}}=(0,u.UKg)(),{urlParams:d,toUrlParams:c}=(0,u.zmo)(),{showAgentless:p}=(0,u.jXQ)(),[x,h]=(0,s.useState)(Array.isArray(d.kuery)?d.kuery[d.kuery.length-1]:null!==(e=d.kuery)&&void 0!==e?e:""),{pagination:y,pageSizeOptions:E,setPagination:v}=(0,u.WQC)(),{sorting:k,setSorting:j}=(0,u.KEg)({field:"updated_at",direction:"desc"}),b=(0,o.useHistory)(),S="create"in d,I=(0,s.useCallback)((e=>{if(e!==S)if(e)b.push(`${a("policies_list")}?${c({...d,create:null})}`);else{const{create:e,...t}=d;b.push(`${a("policies_list")}?${c(t)}`)}}),[a,b,S,c,d]),{isLoading:C,data:P,refetch:L}=(0,u.BOQ)({page:y.currentPage,perPage:y.pageSize,sortField:null==k?void 0:k.field,sortOrder:null==k?void 0:k.direction,kuery:(e=>{if(p)return e;const t=`NOT ${i}.supports_agentless:true`;return e.trim()?`(${t}) AND (${e})`:t})(x),withAgentCount:!0,full:!0}),_=(0,s.useMemo)((()=>{const e=[{field:"name",sortable:!0,name:f.i18n.translate("xpack.fleet.agentPolicyList.nameColumnTitle",{defaultMessage:"Name"}),width:"35%",render:(e,t)=>(0,R.jsx)(w.an,{policy:t,withDescription:!0})},{field:"updated_at",sortable:!0,name:f.i18n.translate("xpack.fleet.agentPolicyList.updatedOnColumnTitle",{defaultMessage:"Last updated on"}),render:e=>(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})},{field:"agents",name:f.i18n.translate("xpack.fleet.agentPolicyList.agentsColumnTitle",{defaultMessage:"Unprivileged / Privileged"}),dataType:"number",render:(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"xs",justifyContent:"flexEnd"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.unprivilegedAgentsTooltip",defaultMessage:"Unprivileged agents"})},(0,R.jsx)(A.Oy,{count:t.unprivileged_agents||0,agentPolicyId:t.id,showAgentText:!1,privilegeMode:"unprivileged"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},"/"),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.privilegedAgentsTooltip",defaultMessage:"Privileged agents"})},(0,R.jsx)(A.Oy,{count:e-(t.unprivileged_agents||0),agentPolicyId:t.id,showAgentText:!1,privilegeMode:"privileged"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("span",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltipWrapper",defaultMessage:"({message})",values:{message:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltip",defaultMessage:"Total agents"})},(0,R.jsx)(A.Oy,{count:e,agentPolicyId:t.id,showAgentText:!1}))}}))),(0,T.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",color:"warning",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})})))},{field:"package_policies",name:f.i18n.translate("xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle",{defaultMessage:"Integrations"}),dataType:"number",render:e=>e?e.length:0},{field:"actions",name:f.i18n.translate("xpack.fleet.agentPolicyList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,R.jsx)(A.Nu,{agentPolicy:e,onCopySuccess:()=>L()})}]}];return r?e:e.filter((e=>!("field"in e)||"agents"!==e.field))}),[r,L]),D=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!n,onClick:()=>I(!0),"data-test-subj":"createAgentPolicyButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[n,I]),B=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!n,onClick:()=>I(!0),"data-test-subj":"emptyPromptCreateAgentPolicyButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[n,I]),N=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiEmptyPrompt,{title:(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",defaultMessage:"No agent policies"})),actions:B})),[B]);return(0,R.jsx)(l().Fragment,null,S?(0,R.jsx)(O,{onClose:()=>{I(!1),L()}}):null,(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},(0,R.jsx)(g.EuiFlexItem,{grow:4},(0,R.jsx)(F.IW,{value:x,indexPattern:M.yb,fieldPrefix:i,onChange:e=>{v({...y,currentPage:1}),h(e)},dataTestSubj:"agentPolicyList.queryInput"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{color:"primary",iconType:"refresh",onClick:()=>L()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",defaultMessage:"Reload"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},D)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiBasicTable,{loading:C,"data-test-subj":"agentPoliciesTable",noItemsMessage:C?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",defaultMessage:"Loading agent policies…"}):x.trim()||0!==(null!==(t=null==P?void 0:P.total)&&void 0!==t?t:0)?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",defaultMessage:"No agent policies found. {clearFiltersLink}",values:{clearFiltersLink:(0,R.jsx)(g.EuiLink,{onClick:()=>h("")},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):N,items:P?P.items:[],itemId:"id",columns:_,pagination:{pageIndex:y.currentPage-1,pageSize:y.pageSize,totalItemCount:P?P.total:0,pageSizeOptions:E},sorting:{sort:k},onChange:e=>{const t={...y,currentPage:e.page.index+1,pageSize:e.page.size};v(t),j(e.sort)}}))};var N=a(53684),z=a(57421),U=a(86955),H=a(89423),W=a(61372);const G=({onClose:e,agentPolicy:t})=>{var a,n,i;const o=(0,g.useGeneratedHtmlId)(),[r,d]=l().useState(!1),{data:c}=(0,u.ZwD)();(0,s.useEffect)((()=>{const e=Boolean(null==c?void 0:c.item.prerelease_integrations_enabled);null!=c&&c.item&&d(e)}),[null==c?void 0:c.item]);const{filteredCards:p,isLoading:x}=(0,W.useAvailablePackages)({prereleaseIntegrationsEnabled:r}),h=(0,s.useMemo)((()=>p.filter((e=>{var t;return["integration","input"].includes(null!==(t=e.type)&&void 0!==t?t:"")})).map((e=>({label:e.title,value:e.name,integration:e.integration,prepend:(0,R.jsx)(w.qD,{packageName:e.name,version:e.version,integrationName:e.integration,size:"l",tryApi:!0})})))),[p]),[y,E]=(0,s.useState)([]),[v,k]=(0,s.useState)(!1),[j,b]=(0,s.useState)(!1),S=(0,s.useCallback)((e=>{b(e)}),[b]),F=(0,s.useCallback)((e=>{E(e)}),[]),M={title:f.i18n.translate("xpack.fleet.addIntegrationFlyout.selectIntegrationTitle",{defaultMessage:"Select integration"}),"data-test-subj":"selectIntegrationStep",children:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"m",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.selectIntegrationDescription",defaultMessage:"Search our integrations collection."}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiComboBox,{fullWidth:!0,"aria-label":"Select integration",placeholder:"Select integrations...",singleSelection:{asPlainText:!0},options:h,selectedOptions:y,onChange:F,isLoading:x})))),(0,R.jsx)(g.EuiSpacer,{size:"l"})),headingElement:"h2"},I=(0,s.useCallback)((()=>{k(!1),e()}),[e]);return(0,R.jsx)(s.Suspense,{fallback:(0,R.jsx)(U.Rh,null)},(0,R.jsx)(g.EuiErrorBoundary,null,(0,R.jsx)(g.EuiFlyout,{onClose:e,"data-test-subj":"addIntegrationFlyout","aria-labelledby":o},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h2",{id:o},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.flyoutHeaderTitle",defaultMessage:"Add integration to policy"})))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiBadge,{color:"subdued"},t.name)))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"m",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.flyoutHeaderDescription",defaultMessage:"You are adding an integration to the selected policy."}))))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(l().Fragment,null,(0,R.jsx)(H.M,{from:"policy",queryParamsPolicyId:t.id,prerelease:r,pkgLabel:null===(a=y[0])||void 0===a?void 0:a.label,pkgName:null===(n=y[0])||void 0===n?void 0:n.value,integration:null===(i=y[0])||void 0===i?void 0:i.integration,addIntegrationFlyoutProps:{selectIntegrationStep:M,onSubmitCompleted:I,isSubmitted:v,agentPolicy:t,updateHasErrors:S}}),v&&(0,R.jsx)(g.EuiOverlayMask,{headerZindexLocation:"below"},(0,R.jsx)(U.Rh,null)))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:e,flush:"left","data-test-subj":"addIntegrationFlyout.cancelBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},j?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.errorOnSaveText",defaultMessage:"Your integration policy has errors."}):null),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,disabled:v||0===y.length||j,isLoading:v,onClick:()=>{k(!0)},"data-test-subj":"addIntegrationFlyout.submitBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.submitButton",defaultMessage:"Add integration"}))))))))},K=(e,t)=>e.localeCompare(t),q=e=>({name:e,value:e}),V=({packagePolicies:e,agentPolicy:t,refreshAgentPolicy:a,...n})=>{var i,o;const r=(0,u.iO7)(),c=r.integrations.writeIntegrationPolicies,p=r.fleet.readAgentPolicies,x=r.integrations.readIntegrationPolicies,{isPackagePolicyUpgradable:h}=(0,u.hhZ)(),{getHref:y}=(0,u.iEg)(),{canUseMultipleAgentPolicies:E}=(0,u.phy)(),[v,k]=l().useState(!1),{enableOtelIntegrations:j}=N.ZX.get(),b=(0,u.B6B)(),S=!(null!==(i=b.data)&&void 0!==i&&i.success)&&"MISSING_SECURITY"===(null===(o=b.data)||void 0===o?void 0:o.error),[M,I]=(0,s.useMemo)((()=>{const t=new Set;return[e.map((e=>{var a,s,l,n,i,o;e.namespace&&t.add(e.namespace);const r=h(e);return{...e,packageName:null!==(a=null===(s=e.package)||void 0===s?void 0:s.name)&&void 0!==a?a:"",packageTitle:null!==(l=null===(n=e.package)||void 0===n?void 0:n.title)&&void 0!==l?l:"",packageVersion:null!==(i=null===(o=e.package)||void 0===o?void 0:o.version)&&void 0!==i?i:"",hasUpgrade:r}})),[...t].sort(K).map(q)]}),[e,h]),T=(0,s.useCallback)((e=>e.policy_ids.length||0),[]),{data:w,isLoading:A}=(0,u.Eiq)(),{output:C}=(0,u.OmG)(),P=(0,s.useMemo)((()=>{var e;return(null!==(e=null==w?void 0:w.items)&&void 0!==e?e:[]).reduce(((e,t)=>(e[t.id]=t.name,e)),{})}),[w]),L=(0,s.useMemo)((()=>[{field:"name",sortable:!0,truncateText:!0,name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.nameColumnTitle",{defaultMessage:"Integration policy"}),width:"35%",render:(e,a)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableName",grow:!1},(0,R.jsx)(g.EuiLink,(0,d.default)({title:e},x?{href:y("edit_integration",{policyId:t.id,packagePolicyId:a.id})}:{disabled:!0}),(0,R.jsx)("span",{className:"eui-textTruncate"},e),a.description?(0,R.jsx)("span",null," ",(0,R.jsx)(g.EuiIconTip,{content:a.description,type:"question"})):null)),j&&(0,z.Wo)(null==a?void 0:a.inputs)&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",color:"warning",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.containsOtelPackages",defaultMessage:"The {integrationTitle} integration collects OpenTelemetry data adhering to semantic conventions and is available in technical preview. To collect OTel data, Elastic Agents must be on version {minVersion} or later.",values:{integrationTitle:a.packageTitle,minVersion:z.DP}})})),E&&p&&x&&T(a)>1&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedTooltip",defaultMessage:"This integration is shared by {numberShared} agent policies",values:{numberShared:T(a)}})},(0,R.jsx)(g.EuiText,{"data-test-subj":"PackagePoliciesTableSharedLabel",color:"subdued",size:"xs",className:"eui-textNoWrap",tabIndex:0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedText",defaultMessage:"Shared"})," ",(0,R.jsx)(g.EuiIcon,{type:"info"})))))},{field:"packageTitle",sortable:!0,name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.packageNameColumnTitle",{defaultMessage:"Integration"}),render:(e,a)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableLink",grow:!1},(0,R.jsx)(g.EuiLink,{href:a.package&&y("integration_details_overview",{pkgkey:(0,N.Ku)(a.package)})},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},a.package&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(F.qD,{packageName:a.package.name,version:a.package.version,size:"m",tryApi:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},e),a.package&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.packageVersion",defaultMessage:"v{version}",values:{version:a.package.version}})))))),a.hasUpgrade&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",color:"warning",content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.upgradeAvailable",{defaultMessage:"Upgrade Available"})})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{"data-test-subj":"PackagePoliciesTableUpgradeButton",size:"s",minWidth:"0",isDisabled:!c,href:`${y("upgrade_package_policy",{policyId:t.id,packagePolicyId:a.id})}?from=fleet-policy-list`},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",defaultMessage:"Upgrade"})))))},{field:"namespace",name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,R.jsx)(g.EuiBadge,{color:"hollow"},e):(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiBadge,{color:"default"},t.namespace),(0,R.jsx)(g.EuiIconTip,{content:"Namespace defined in parent agent policy",position:"right",type:"info",color:"subdued"}))},{field:"output_id",name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputColumnTitle",{defaultMessage:"Output"}),render:e=>A?null:e?(0,R.jsx)(g.EuiBadge,{color:"hollow"},P[e]||e):t.data_output_id?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiBadge,{color:"default"},P[t.data_output_id]||t.data_output_id)," ",(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromParentPolicyText",{defaultMessage:"Output defined in parent agent policy"}),position:"right",type:"info",color:"subdued"})):C?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiBadge,{color:"default"},P[C.id]||C.id)," ",(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromFleetSettingsText",{defaultMessage:"Output defined in Fleet settings"}),position:"right",type:"info",color:"subdued"})):void 0},{name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.actionsColumnTitle",{defaultMessage:"Actions"}),width:"70px",actions:[{render:e=>c?(0,R.jsx)(F.Py,{agentPolicies:[t],from:"fleet-policy-list",packagePolicy:e,upgradePackagePolicyHref:`${y("upgrade_package_policy",{policyId:t.id,packagePolicyId:e.id})}?from=fleet-policy-list`}):(0,R.jsx)(l().Fragment,null)}]}]),[x,y,t,j,E,p,T,c,A,C,P]);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiInMemoryTable,(0,d.default)({itemId:"id",items:M,columns:L,sorting:{sort:{field:"name",direction:"asc"}}},n,{search:{toolsRight:t.is_managed||t.supports_agentless?[]:[(0,R.jsx)(F.rj,{key:"addPackagePolicyButton",fill:!0,isDisabled:!c,iconType:"plusInCircle",onClick:()=>{k(!0)},"data-test-subj":"addPackagePolicyButton",tooltip:c?void 0:{content:S?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonSecurityRequiredTooltip",defaultMessage:"To add Elastic Agent Integrations, you must have security enabled and have the All privilege for Fleet. Contact your administrator."}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonPrivilegesRequiredTooltip",defaultMessage:"Elastic Agent Integrations require the All privilege for Agent policies and All privilege for Integrations. Contact your administrator."})}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.addPackagePolicyButtonText",defaultMessage:"Add integration"}))],box:{incremental:!0,schema:!0},filters:[{type:"field_value_selection",field:"namespace",name:"Namespace",options:I,multiSelect:"or",operator:"exact"}]}})),v&&(0,R.jsx)(G,{onClose:()=>{k(!1),a()},agentPolicy:t}))},$=(0,s.memo)((({agentPolicy:e,refreshAgentPolicy:t})=>{const a=(0,u.iO7)(),s=a.integrations.writeIntegrationPolicies&&a.fleet.allAgentPolicies,[n,i]=l().useState(!1);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiEmptyPrompt,{iconType:"plusInCircle",title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstTitle",defaultMessage:"Add your first integration"})),body:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstMessage",defaultMessage:"This policy does not have any integrations yet."}),actions:(0,R.jsx)(g.EuiButton,{iconType:"plusInCircle",isDisabled:!s,fill:!0,onClick:()=>{i(!0)},"data-test-subj":"addPackagePolicyButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstButtonText",defaultMessage:"Add integration"}))}),n&&(0,R.jsx)(G,{onClose:()=>{i(!1),t()},agentPolicy:e}))})),Y=(0,s.memo)((({agentPolicy:e,refreshAgentPolicy:t})=>((0,u.ifo)("policy_details",{policyName:e.name}),e.package_policies&&0!==e.package_policies.length?(0,R.jsx)(V,{agentPolicy:e,packagePolicies:e.package_policies,refreshAgentPolicy:t}):(0,R.jsx)($,{agentPolicy:e,refreshAgentPolicy:t}))));var Q=a(4513),X=a.n(Q),J=a(30770),Z=a(21254),ee=a(82794),te=a(65216);const ae=e=>{var t;return{...(0,J.pick)(e,["name","description","namespace","monitoring_enabled","unenroll_timeout","inactivity_timeout","data_output_id","monitoring_output_id","download_source_id","fleet_server_host_id","agent_features","is_protected","advanced_settings","global_data_tags","monitoring_pprof_enabled","monitoring_http","monitoring_diagnostics"]),...!(null!==(t=e.space_ids)&&void 0!==t&&t.includes(te.eWz))&&{space_ids:e.space_ids}}},se=P().div.withConfig({displayName:"FormWrapper",componentId:"sc-1lbh22t-0"})(["max-width:1200px;margin-right:auto;margin-left:auto;"]),le=(0,s.memo)((({agentPolicy:e})=>{(0,u.ifo)("policy_details",{policyName:e.name});const{notifications:t}=(0,u.WeA)(),{spaceId:a}=(0,u.YI3)(),{agents:{enabled:n}}=(0,u.UKg)(),{getPath:i}=(0,u.iEg)(),r=(0,u.iO7)().fleet.allAgentPolicies,d=(0,u.gCF)(),[c,p]=(0,s.useState)({...e}),x=(0,o.useHistory)(),h=(0,b.I)(),[y,E]=(0,s.useState)(!1),[v,k]=(0,s.useState)(!1),[j,S]=(0,s.useState)(0),[M,I]=(0,s.useState)(!0),T=(0,A.FS)(c,{allowedNamespacePrefixes:null==h?void 0:h.allowedNamespacePrefixes}),[w,C]=(0,s.useState)(!1),[P,_]=(0,s.useState)(!1),D=async()=>{E(!0);try{const n=ae(c);if(await(0,u.Tp2)(c.id,ae(c)),n.space_ids&&!X()(e.space_ids,n.space_ids)){var s,l;const a=(0,J.uniqBy)(null!==(s=null===(l=e.package_policies)||void 0===l?void 0:l.map((e=>e.package?{pkgName:e.package.name,pkgVersion:e.package.version}:void 0)).filter((e=>void 0!==e)))&&void 0!==s?s:[],"pkgName");for(const{pkgName:e,pkgVersion:s}of a)await(0,ee.i)({spaceIds:n.space_ids,pkgName:e,pkgVersion:s,toasts:t.toasts})}t.toasts.addSuccess(f.i18n.translate("xpack.fleet.editAgentPolicy.successNotificationTitle",{defaultMessage:"Successfully updated ''{name}'' settings",values:{name:c.name}})),c.space_ids&&!c.space_ids.includes(null!=a?a:Z.DEFAULT_SPACE_ID)?x.replace(i("policies_list")):(d(),k(!1))}catch(e){t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"})})}E(!1)},O=(0,s.useMemo)((()=>(0,L.Rq)(c.id,ae(c))),[c]);return l().createElement(se,null,j?l().createElement(A.oR,{agentCount:j,agentPolicies:[c],onConfirm:()=>{S(0),D()},onCancel:()=>{S(0),E(!1)}}):null,l().createElement(A.Kb,{agentPolicy:c,updateAgentPolicy:e=>{p({...c,...e}),k(!0)},withSysMonitoring:M,updateSysMonitoring:e=>I(e),validation:T,isEditing:!0,updateAdvancedSettingsHasErrors:C,setInvalidSpaceError:_}),v?l().createElement(l().Fragment,null,l().createElement(g.EuiSpacer,{size:"xl"}),l().createElement(g.EuiSpacer,{size:"xl"}),l().createElement(g.EuiBottomBar,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.unsavedChangesText",defaultMessage:"You have unsaved changes"})),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",onClick:()=>{p({...e}),k(!1)}},l().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.cancelButtonText",defaultMessage:"Cancel"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(F.T_,{isDisabled:y||Object.keys(T).length>0||w||P,btnProps:{color:"text"},description:f.i18n.translate("xpack.fleet.editAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request updates an agent policy."}),request:O})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{onClick:async()=>{if(n){E(!0);const{data:e}=await(0,u.Wwg)({policyId:c.id});null!=e&&e.results.active?S(e.results.active):await D()}else await D()},isLoading:y,isDisabled:!r||y||Object.keys(T).length>0||w||P,"data-test-subj":"agentPolicyDetailsSaveButton",iconType:"save",color:"primary",fill:!0},y?l().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.savingButtonText",defaultMessage:"Saving…"}):l().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.saveButtonText",defaultMessage:"Save changes"})))))))):null)})),ne=({isLoading:e,policyId:t,agentPolicy:a})=>{const{getHref:s}=(0,u.iEg)();return(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiButtonEmpty,{iconType:"arrowLeft",href:s("policies_list"),flush:"left",size:"xs"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.viewAgentListTitle",defaultMessage:"View all agent policies"}))),(0,R.jsx)(g.EuiFlexItem,null,e?(0,R.jsx)(F.Rh,null):(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",wrap:!0,responsive:!1,gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h1",null,a&&a.name||(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.policyDetailsTitle",defaultMessage:"Policy ''{id}''",values:{id:t}})))),(null==a?void 0:a.is_managed)&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{title:"Hosted agent policy",content:f.i18n.translate("xpack.fleet.policyDetails.policyDetailsHostedPolicyTooltip",{defaultMessage:"This policy is managed outside of Fleet. Most actions related to this policy are unavailable."}),type:"lock",size:"l",color:"subdued"})))),a&&a.description?(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"s",className:"eui-textBreakWord"},a.description)):null)};var ie=a(95030),oe=a(87086),re=a(8627);const ue=({agentPolicy:e,isManageAutoUpgradeAgentsModalOpen:t,setIsManageAutoUpgradeAgentsModalOpen:a})=>{var l,n,i;const{data:o}=(0,u.t$K)(e.id),r=(null!==(l=e.required_versions)&&void 0!==l?l:[]).map((e=>e.version)),d=(0,s.useMemo)((()=>null==o?void 0:o.currentVersions.filter((e=>r.includes(e.version))).some((e=>e.failedUpgradeAgents>0))),[o,r]);return(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs",justifyContent:"flexEnd",alignItems:"center",id:"auto-upgrade-manage-button"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLink,{onClick:()=>{a(!t)}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.autoUpgradeButton",defaultMessage:"Manage"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiNotificationBadge,{color:null!==(n=e.required_versions)&&void 0!==n&&n.length?"accent":"subdued"},(null===(i=e.required_versions)||void 0===i?void 0:i.length)||0)),d&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.manageAutoUpgradeAgents.failedUpgradeTooltip",defaultMessage:"Some agents failed to upgrade, click on Manage to see details."}),type:"warning",color:"danger"})))},de=P().div.withConfig({displayName:"Divider",componentId:"sc-zpeocb-0"})(["width:0;height:100%;border-left:",";"],(e=>e.theme.eui.euiBorderThin)),ce=({isLoading:e,agentPolicy:t,addAgent:a,onCancelEnrollment:n,isAddAgentHelpPopoverOpen:i,setIsAddAgentHelpPopoverOpen:r})=>{var d;const c=(0,u.iO7)(),{getPath:p}=(0,u.iEg)(),x=(0,o.useHistory)(),[h,y]=(0,s.useState)(!1),E=(0,u.gCF)(),v=(0,re.o)(),k=(0,s.useMemo)((()=>{var e;return null==t||null===(e=t.package_policies)||void 0===e?void 0:e.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===te.k7N}))}),[t]);if(!t)return null;const j=l().createElement(g.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.addFleetServerButton",defaultMessage:"Add Fleet Server"})),b=l().createElement(g.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.addAgentButton",defaultMessage:"Add agent"}));return l().createElement(l().Fragment,null,l().createElement(g.EuiFlexGroup,{justifyContent:"flexEnd",direction:"row"},e||!t?null:[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.revision",{defaultMessage:"Revision"}),content:null!==(d=t.revision)&&void 0!==d?d:0},{isDivider:!0},{label:f.i18n.translate("xpack.fleet.policyDetails.summary.integrations",{defaultMessage:"Integrations"}),content:l().createElement(g.EuiI18nNumber,{value:t.package_policies&&t.package_policies.length||0})},{isDivider:!0},...!c.fleet.readAgents||null!=t&&t.supports_agentless?[]:[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.usedBy",{defaultMessage:"Agents"}),content:!t.agents&&k&&c.fleet.addFleetServers?l().createElement(F.xt,{button:j,isOpen:i,offset:15,closePopover:()=>{r(!1)}}):t.agents||k||!c.fleet.addAgents?l().createElement(g.EuiFlexGroup,{direction:"row",gutterSize:"xs",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiToolTip,{content:l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"xs"},l().createElement(g.EuiFlexItem,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByUnprivilegedTooltip",defaultMessage:"{count, plural, one {# unprivileged agent} other {# unprivileged agents}}",values:{count:t.unprivileged_agents||0}})),l().createElement(g.EuiFlexItem,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByPrivilegedTooltip",defaultMessage:"{count, plural, one {# privileged agent} other {# privileged agents}}",values:{count:(t.agents||0)-(t.unprivileged_agents||0)}})))},l().createElement(A.Oy,{count:t.agents||0,agentPolicyId:t.id,showAgentText:!0}))),(0,T.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{type:"warning",color:"warning",content:l().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})}))):l().createElement(F.xt,{button:b,isOpen:i,offset:15,closePopover:()=>{r(!1)}})},{isDivider:!0}],{label:f.i18n.translate("xpack.fleet.policyDetails.summary.lastUpdated",{defaultMessage:"Last updated on"}),content:t&&l().createElement(m.FormattedDate,{value:null==t?void 0:t.updated_at,year:"numeric",month:"short",day:"2-digit"})||""},{isDivider:!0},...v&&c.fleet.allAgentPolicies&&c.fleet.allAgents&&!t.is_managed?[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.autoUpgrade",{defaultMessage:"Auto-upgrade agents"}),content:l().createElement(ue,{agentPolicy:t,isManageAutoUpgradeAgentsModalOpen:h,setIsManageAutoUpgradeAgentsModalOpen:y})},{isDivider:!0}]:[],{content:t&&l().createElement(A.Nu,{agentPolicy:t,fullButton:!0,onCopySuccess:e=>{x.push(p("policy_details",{policyId:e.id}))},onCancelEnrollment:n})}].map(((e,t)=>{var a;return l().createElement(g.EuiFlexItem,{grow:!1,key:t},null!==(a=e.isDivider)&&void 0!==a&&a?l().createElement(de,null):e.label?l().createElement(ge,{compressed:!0,textStyle:"reverse"},l().createElement(g.EuiDescriptionListTitle,{className:"eui-textNoWrap"},e.label),l().createElement(g.EuiDescriptionListDescription,{className:"eui-textNoWrap"},e.content)):e.content)}))),h&&l().createElement(g.EuiPortal,null,l().createElement(ie.i,{agentPolicy:t,agentCount:t.agents||0,onClose:e=>{y(!1),e&&E()}})),v?l().createElement(oe.i,{anchor:"#auto-upgrade-manage-button"}):null)};var ge=P()(g.EuiDescriptionList).withConfig({displayName:"_StyledEuiDescriptionList",componentId:"sc-zpeocb-1"})({textAlign:"right"});const pe=()=>{var e;const{params:{policyId:t,tabId:a=""}}=(0,o.useRouteMatch)(),{getHref:n}=(0,u.iEg)(),{urlParams:i}=(0,u.zmo)(),{showAgentless:r}=(0,u.jXQ)(),d=(0,u.ZJQ)(t),c=null===(e=d.data)||void 0===e||!e.item||d.data.item.supports_agentless&&!r?null:d.data.item,{isLoading:p,error:x,sendRequest:h}=d,y="true"===i.openEnrollmentFlyout,E="true"===i.showAddAgentHelp,[v]=(0,s.useState)(!1),[k,j]=(0,s.useState)(y),[b,S]=(0,s.useState)(E),{application:{navigateToApp:M}}=(0,u.WeA)(),T=(0,u.g7J)(),{isReady:w}=(0,u.YI3)(),A=(0,s.useMemo)((()=>{if(T&&T.onDoneNavigateTo&&w){const[e,t]=T.onDoneNavigateTo;return()=>M(e,t)}}),[w,M,T]),C=(0,s.useCallback)((()=>{S(!1),j(!0)}),[]),P=(0,s.useMemo)((()=>[{id:"integrations",name:f.i18n.translate("xpack.fleet.policyDetails.subTabs.packagePoliciesTabText",{defaultMessage:"Integrations"}),href:n("policy_details",{policyId:t,tabId:"integrations"}),isSelected:""===a||"integrations"===a},{id:"settings",name:f.i18n.translate("xpack.fleet.policyDetails.subTabs.settingsTabText",{defaultMessage:"Settings"}),"data-test-subj":"agentPolicySettingsTab",href:n("policy_details",{policyId:t,tabId:"settings"}),isSelected:"settings"===a}]),[n,t,a]),L=(0,s.useMemo)((()=>v?(0,R.jsx)(o.Redirect,{to:"/"}):p?(0,R.jsx)(F.Rh,null):x?(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:x}):c?(0,R.jsx)(l().Fragment,null,k&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.rt,{agentPolicy:c,onClose:A||(()=>j(!1))})),(0,R.jsx)(me,{agentPolicy:c,refreshAgentPolicy:h})):(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:f.i18n.translate("xpack.fleet.policyDetails.policyNotFoundErrorTitle",{defaultMessage:"Policy ''{id}'' not found",values:{id:t}})})),[v,p,x,c,k,A,t,h]),_=(0,R.jsx)(ne,{agentPolicy:c,policyId:t,isLoading:p}),D=(0,R.jsx)(ce,{agentPolicy:c,onCancelEnrollment:A,isLoading:p,isAddAgentHelpPopoverOpen:b,setIsAddAgentHelpPopoverOpen:S,addAgent:C});return(0,R.jsx)(u.qfp.Provider,{value:{refresh:h}},(0,R.jsx)(I.QA,{leftColumn:_,rightColumn:D,tabs:P},L))},me=({agentPolicy:e,refreshAgentPolicy:t})=>((0,u.ifo)("policy_details",{policyName:e.name}),(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.policy_details_settings,render:()=>(0,R.jsx)(le,{agentPolicy:e})}),(0,R.jsx)(r.Route,{path:M.X5.policy_details,render:()=>(0,R.jsx)(Y,{agentPolicy:e,refreshAgentPolicy:t})})));var fe=a(70940);const xe=(0,s.memo)((()=>{const{params:{packagePolicyId:e,policyId:t}}=(0,o.useRouteMatch)(),{search:a}=(0,o.useLocation)(),s=new URLSearchParams(a).get("from");let l;return s&&"fleet-policy-list"===s?l="upgrade-from-fleet-policy-list":s&&"integrations-policy-list"===s&&(l="upgrade-from-integrations-policy-list"),(0,R.jsx)(fe.R,{packagePolicyId:e,policyId:t,from:l,forceUpgrade:!0})})),he=()=>((0,u.ifo)("policies"),(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.edit_integration},(0,R.jsx)(fe.k,null)),(0,R.jsx)(r.Route,{path:M.X5.upgrade_package_policy},(0,R.jsx)(xe,null)),(0,R.jsx)(r.Route,{path:M.X5.policy_details},(0,R.jsx)(pe,null)),(0,R.jsx)(r.Route,{path:M.X5.policies_list},(0,R.jsx)(I.iW,{section:"agent_policies"},(0,R.jsx)(B,null)))));var ye=a(49358);const Ee=(0,s.memo)((({datastream:e})=>{const{dashboards:t}=e,a=(0,u.e3j)(),s=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardActionText",defaultMessage:"View dashboard"}),l=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardsActionText",defaultMessage:"View dashboards"}),n=f.i18n.translate("xpack.fleet.dataStreamList.viewDashboardsPanelTitle",{defaultMessage:"View dashboards"}),i=f.i18n.translate("xpack.fleet.dataStreamList.viewInApmActionText",{defaultMessage:"View in APM"}),{isSuccessful:o,href:r}=(0,ye.V)(e);if(o&&r){const e=[{id:0,items:[{icon:"apmApp",href:r,name:i}]}];return(0,R.jsx)(F.AK,{panels:e})}if(!t||0===t.length){const e=[{id:0,items:[{icon:"dashboardApp",disabled:!0,name:s}]}];return(0,R.jsx)(F.AK,{panels:e})}if(1===t.length){var d;const e=[{id:0,items:[{icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null===(d=t[0])||void 0===d?void 0:d.id}||""),name:s}]}];return(0,R.jsx)(F.AK,{panels:e})}const c=[{id:0,items:[{icon:"dashboardApp",panel:1,name:l}]},{id:1,title:n,items:t.map((e=>({icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null==e?void 0:e.id}||""),name:e.title})))}];return(0,R.jsx)(F.AK,{panels:c})})),ve=()=>{(0,u.ifo)("data_streams");const{pagination:e,pageSizeOptions:t}=(0,u.WQC)(),{isLoading:a,data:n,resendRequest:i}=(0,u.FM)(),o=(0,s.useMemo)((()=>[{field:"dataset",sortable:!0,width:"25%",name:f.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"})},{field:"type",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"})},{field:"namespace",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,R.jsx)(g.EuiBadge,{color:"hollow"},e):""},{field:"package",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),render:(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},t.package_version&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(F.qD,{packageName:e,version:t.package_version,size:"m",tryApi:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},e))},{field:"last_activity_ms",sortable:!0,width:"25%",dataType:"date",name:f.i18n.translate("xpack.fleet.dataStreamList.lastActivityColumnTitle",{defaultMessage:"Last activity"}),render:e=>(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"numeric"}),(0,R.jsx)(l().Fragment,null," @ "),(0,R.jsx)(m.FormattedTime,{value:e,hour:"numeric",minute:"numeric",second:"numeric"}))},{field:"size_in_bytes",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.sizeColumnTitle",{defaultMessage:"Size"}),render:(e,t)=>(0,R.jsx)(l().Fragment,null,t.size_in_bytes_formatted)},{name:f.i18n.translate("xpack.fleet.dataStreamList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,R.jsx)(Ee,{datastream:e})}]}]),[]),r=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiEmptyPrompt,{title:(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.noDataStreamsPrompt",defaultMessage:"No data streams"}))})),[]),d={dataset:[],type:[],namespace:[],package:[]};if(n&&n.data_streams.length){const e={dataset:[],type:[],namespace:[],package:[]};n.data_streams.forEach((t=>{const{dataset:a,type:s,namespace:l,package:n}=t;e.dataset.includes(a)||e.dataset.push(a),e.type.includes(s)||e.type.push(s),e.namespace.includes(l)||e.namespace.push(l),e.package.includes(n)||e.package.push(n)}));for(const t in e)d[t]&&(d[t]=e[t].sort().map((e=>({value:e,name:e}))))}return(0,R.jsx)(g.EuiInMemoryTable,{loading:a,tableLayout:"auto",message:a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.loadingDataStreamsMessage",defaultMessage:"Loading data streams…"}):n&&!n.data_streams.length?r:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.noFilteredDataStreamsMessage",defaultMessage:"No matching data streams found"}),items:n?n.data_streams:[],itemId:"index",columns:o,pagination:{initialPageSize:e.pageSize,pageSizeOptions:t},sorting:!0,search:{toolsRight:[(0,R.jsx)(g.EuiButton,{key:"reloadButton",color:"primary",iconType:"refresh",onClick:()=>i()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.reloadDataStreamsButtonText",defaultMessage:"Reload"}))],box:{placeholder:f.i18n.translate("xpack.fleet.dataStreamList.searchPlaceholderTitle",{defaultMessage:"Filter data streams"}),incremental:!0},filters:[{type:"field_value_selection",field:"dataset",name:f.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"}),multiSelect:"or",operator:"exact",options:d.dataset},{type:"field_value_selection",field:"type",name:f.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"}),multiSelect:"or",operator:"exact",options:d.type},{type:"field_value_selection",field:"namespace",name:f.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),multiSelect:"or",operator:"exact",options:d.namespace},{type:"field_value_selection",field:"package",name:f.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),multiSelect:"or",operator:"exact",options:d.package}]}})},ke=()=>(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.data_streams},(0,R.jsx)(I.iW,{section:"data_streams"},(0,R.jsx)(ve,null))));var je=a(30135),be=a(5850),Se=a(19573);const Fe=({onClose:e,agents:t,agentCount:a})=>{const l=(0,g.useGeneratedHtmlId)(),{notifications:n}=(0,u.WeA)(),[i,r]=(0,s.useState)(!1),d=Array.isArray(t)&&1===t.length,{getPath:c}=(0,u.iEg)(),p=(0,o.useHistory)(),[x,h]=(0,s.useState)(!1);return(0,R.jsx)(g.EuiConfirmModal,{"data-test-subj":"requestDiagnosticsModal","aria-labelledby":l,title:d?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.singleTitle",defaultMessage:"Request diagnostics"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.multipleTitle",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),titleProps:{id:l},onCancel:e,onConfirm:async function(){try{r(!0);const a=x?[Se.m_.CPU]:[],{error:s}=d?await(0,u.o6X)(t[0].id,{additional_metrics:a}):await(0,u.aJz)({agents:"string"==typeof t?t:t.map((e=>e.id)),additional_metrics:a});if(s)throw s;r(!1);const l=f.i18n.translate("xpack.fleet.requestDiagnostics.successSingleNotificationTitle",{defaultMessage:"Request diagnostics submitted"});if(n.toasts.addSuccess(l),d){const e=c("agent_details_diagnostics",{agentId:t[0].id});p.push(e)}e()}catch(e){r(!1),n.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.requestDiagnostics.fatalErrorNotificationTitle",{defaultMessage:"Error requesting diagnostics {count, plural, one {agent} other {agents}}",values:{count:a}})})}},cancelButtonText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonDisabled:i,confirmButtonText:d?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmSingleButtonLabel",defaultMessage:"Request diagnostics"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmMultipleButtonLabel",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),buttonColor:"primary"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.description",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."})),(0,R.jsx)("p",null,(0,R.jsx)(g.EuiCheckbox,{id:"cpuMetricsCheckbox","data-test-subj":"cpuMetricsCheckbox",label:"Collect additional CPU metrics",checked:x,onChange:()=>h(!x)})))};function Me(e){return e.length>20?`${e.substring(0,20)}...`:e}function Ie(e){return e.replace(/[^a-zA-Z0-9 \-_]/g,"").slice(0,20)}const Te=P().div.withConfig({displayName:"Wrapped",componentId:"sc-rnfjm9-0"})(["display:flex;.wrappedText{white-space:pre-wrap;}"]),we=({tags:e,color:t,size:a})=>l().createElement(l().Fragment,null,l().createElement(Te,null,l().createElement(g.EuiToolTip,{anchorClassName:"wrappedText",content:l().createElement("span",{"data-test-subj":"agentTagsTooltip"},e.join(", "))},l().createElement(g.EuiText,{size:a,color:t,tabIndex:0},l().createElement("span",{"data-test-subj":"agentTags"},(0,J.take)(e,3).map(Me).join(", "),e.length>3?` + ${e.length-3} more`:"")))));function Ae(e,t){return void 0!==(null==e?void 0:e.cpu_avg)?(0,R.jsx)(g.EuiToolTip,{content:`${(100*e.cpu_avg).toFixed(4)} %`},(0,R.jsx)("span",{tabIndex:0},(100*e.cpu_avg).toFixed(2)," %")):(0,R.jsx)(U.DQ,{agentPolicy:t})}function Ce(e,t){return null!=e&&e.memory_size_byte_avg?function(e,t=0){if(0===e)return"0 Bytes";const a=t<0?0:t,s=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,s)).toFixed(a))+" "+["Bytes","KB","MB","GB","TB","PB","EB","ZB","YB"][s]}(e.memory_size_byte_avg):(0,R.jsx)(U.DQ,{agentPolicy:t})}var Pe=a(51783),Le=a.n(Pe);function _e(e){const t=Date.parse(e||"")-Date.now();return t<0?"":t<9e5?" The upgrade will start in less than 15 minutes.":t<18e5?" The upgrade will start in less than 30 minutes.":t<36e5?" The upgrade will start in less than 1 hour.":` The upgrade will start in less than ${Math.ceil(t/36e5)} hours.`}function De(e){if(!e||void 0===e.download_percent&&void 0===e.download_rate)return"";let t="";return void 0!==e.download_percent&&(t=`${e.download_percent}%`),void 0!==e.download_rate&&(t+=` at ${Oe(e.download_rate)}`),` (${t.trim()})`}const Oe=e=>{let t=0;const a=[" Bps"," kBps"," MBps"," GBps"];for(;t<a.length-1&&!(e<1024);t++)e/=1024;return e.toFixed(1)+a[t]},Re=e=>{if(!e)return"";const t=new Date(e).toISOString(),a=Date.parse(e)-Date.now(),s=Le().utc(Le().duration(a,"milliseconds").asMilliseconds()).format("HH:mm");return a>0?`Retrying until: ${t} (${s} remaining)`:""},Be=({isAgentUpgradable:e,agent:t,latestAgentVersion:a})=>{var l,n;const i=(0,s.useMemo)((()=>t.upgrade_started_at&&!t.upgraded_at),[t.upgrade_started_at,t.upgraded_at]),o=(0,s.useMemo)((()=>function(e){var t,a,s;switch(null==e?void 0:e.state){case"UPG_REQUESTED":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"calendar"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRequested",defaultMessage:"Upgrade requested"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRequested",defaultMessage:"The agent has requested an upgrade."})};case"UPG_SCHEDULED":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"clock"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeScheduled",defaultMessage:"Upgrade scheduled"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeScheduled",defaultMessage:"The agent has been instructed to upgrade.{upgradeStartDelay}",values:{upgradeStartDelay:_e(null===(t=e.metadata)||void 0===t?void 0:t.scheduled_at)}})};case"UPG_DOWNLOADING":var l,n;return null!=e&&null!==(a=e.metadata)&&void 0!==a&&a.retry_error_msg?{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"download"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),WarningTooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloadingFailed",defaultMessage:"Upgrade failing: {retryMsg}. {retryUntil}",values:{retryMsg:null==e||null===(l=e.metadata)||void 0===l?void 0:l.retry_error_msg,retryUntil:Re(null==e||null===(n=e.metadata)||void 0===n?void 0:n.retry_until)}})}:{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"download"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloading",defaultMessage:"Downloading the new agent artifact version{downloadEstimate}.",values:{downloadEstimate:De(null==e?void 0:e.metadata)}})};case"UPG_EXTRACTING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"package"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeExtracting",defaultMessage:"Upgrade extracting"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeExtracting",defaultMessage:"The new agent artifact is extracting."})};case"UPG_REPLACING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"warning",iconType:"copy"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeReplacing",defaultMessage:"Upgrade replacing"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeReplacing",defaultMessage:"Replacing the agent artifact version."})};case"UPG_RESTARTING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"warning",iconType:"refresh"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRestarting",defaultMessage:"Upgrade restarting"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRestarting",defaultMessage:"The agent is restarting to apply the update."})};case"UPG_WATCHING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"warning",iconType:"inspect"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeMonitoring",defaultMessage:"Upgrade monitoring"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeMonitoring",defaultMessage:"Monitoring the new agent version for errors."})};case"UPG_ROLLBACK":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"danger",iconType:"returnKey"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRolledBack",defaultMessage:"Upgrade rolled back"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRolledBack",defaultMessage:"Upgrade unsuccessful. Rolling back to previous version."})};case"UPG_FAILED":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"danger",iconType:"error"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeFailed",defaultMessage:"Upgrade failed"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeFailed",defaultMessage:"Upgrade failed: {errorMsg}.",values:{errorMsg:null==e||null===(s=e.metadata)||void 0===s?void 0:s.error_msg}})};default:return null}}(t.upgrade_details)),[t.upgrade_details]),r=(0,T.zm)(t,a),d=null!==(l=null===(n=(0,u.UKg)().autoUpgrades)||void 0===n?void 0:n.retryDelays)&&void 0!==l?l:te.Q2q;return t.upgrade_details&&o?(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,R.jsx)(g.EuiFlexItem,{grow:!1},o.Badge),o.TooltipText&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"info",content:o.TooltipText,color:"subdued"})),o.WarningTooltipText&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",content:o.WarningTooltipText,color:"warning"}))):t.upgrade_attempts&&t.upgrade_attempts.length>1&&"updating"===t.status?(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.retryingUpgrade",defaultMessage:"Retrying Upgrade ({retryCount}/{maxRetries} attempts)",values:{retryCount:t.upgrade_attempts.length,maxRetries:d.length}}),color:"subdued"}))):e&&(0,T.vJ)(t,a)?(0,R.jsx)(g.EuiBadge,{color:"hollow",iconType:"sortUp"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeAvailable",defaultMessage:"Upgrade available"})):i?(0,R.jsx)(g.EuiIconTip,{type:"info",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDetailsNotAvailable",defaultMessage:"Detailed upgrade status is available for Elastic Agents on version {minVersion} and higher.",values:{minVersion:"8.12"}}),color:"subdued"}):!e&&r?(0,R.jsx)(g.EuiIconTip,{type:"info",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.notUpgradeable",defaultMessage:"Agent not upgradeable: {reason}",values:{reason:r}}),color:"subdued"}):null},Ne=({hasFleetAddAgentsPrivileges:e,setEnrollmentFlyoutState:t})=>(0,R.jsx)(g.EuiEmptyPrompt,{title:(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.noAgentsPrompt",defaultMessage:"No agents enrolled"})),actions:e?(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>t({isOpen:!0})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})):null}),ze="metrics";function Ue(e){return"string"!=typeof e?"-":e}const He=e=>{const{agents:t,isLoading:a,agentPoliciesIndexedById:l,renderActions:n,sortField:i,sortOrder:o,onTableChange:r,onSelectionChange:d,selected:c,totalAgents:p=0,showUpgradeable:x,pagination:h,pageSizeOptions:E,isUsingFilter:v,setEnrollmentFlyoutState:k,clearFilters:j,queryHasChanged:b}=e,S=(0,u.iO7)(),{getHref:F}=(0,u.iEg)(),M=(0,u.JhS)(),I=(0,s.useCallback)((e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=l[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))}),[l]),T=(0,s.useMemo)((()=>p?x?t.filter((e=>I(e)&&(0,N._3)(e))):t:[]),[t,I,x,p]),A=a&&b?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.loadingAgentsMessage",defaultMessage:"Loading agents…"}):v?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.noFilteredAgentsPrompt",defaultMessage:"No agents found. {clearFiltersLink}",values:{clearFiltersLink:(0,R.jsx)(g.EuiLink,{onClick:()=>j()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):(0,R.jsx)(Ne,{hasFleetAddAgentsPrivileges:S.fleet.addAgents,setEnrollmentFlyoutState:k}),C={sort:{field:i,direction:o}},P=[{field:"active",sortable:!1,width:"85px",name:f.i18n.translate("xpack.fleet.agentList.statusColumnTitle",{defaultMessage:"Status"}),render:(e,t)=>(0,R.jsx)(U.u0,{agent:t})},{field:"local_metadata.host.hostname",sortable:!0,name:f.i18n.translate("xpack.fleet.agentList.hostColumnTitle",{defaultMessage:"Host"}),width:"185px",render:(e,t)=>{var a;return(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"none",direction:"column"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLink,{href:F("agent_details",{agentId:t.id})},Ue(e))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(we,{tags:null!==(a=t.tags)&&void 0!==a?a:[],color:"subdued",size:"xs"})))}},{field:"policy_id",sortable:!0,truncateText:!0,name:f.i18n.translate("xpack.fleet.agentList.policyColumnTitle",{defaultMessage:"Agent policy"}),width:"220px",render:(e,t)=>{const a=l[e];return a&&(0,R.jsx)(w.an,{direction:"column",policy:a,agent:t})}},{field:ze,sortable:!1,name:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes. This includes usage from the Agent and the component it supervises. Possible value ranges from 0 to (number of available CPU cores * 100)"})},(0,R.jsx)("span",{tabIndex:0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.cpuTitle",defaultMessage:"CPU"})," ",(0,R.jsx)(g.EuiIcon,{type:"info"}))),width:"75px",render:(e,t)=>Ae(t.metrics,t.policy_id?l[t.policy_id]:void 0)},{field:ze,sortable:!1,name:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},(0,R.jsx)("span",{tabIndex:0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.memoryTitle",defaultMessage:"Memory"})," ",(0,R.jsx)(g.EuiIcon,{type:"info"}))),width:"90px",render:(e,t)=>Ce(t.metrics,t.policy_id?l[t.policy_id]:void 0)},{field:"last_checkin",sortable:!0,name:f.i18n.translate("xpack.fleet.agentList.lastCheckinTitle",{defaultMessage:"Last activity"}),width:"100px",render:e=>e?(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.lastActivityTooltip",defaultMessage:"Last checked in at {lastCheckin}",values:{lastCheckin:(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit",timeZoneName:"short",hour:"numeric",minute:"numeric"})}})},(0,R.jsx)("span",{tabIndex:0},(0,R.jsx)(m.FormattedRelative,{value:e}))):void 0},{field:"local_metadata.elastic.agent.version",sortable:!0,width:"220px",name:f.i18n.translate("xpack.fleet.agentList.versionTitle",{defaultMessage:"Version"}),render:(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"none",css:(0,y.css)({name:"ovk77c",styles:"min-width:0"}),direction:"column"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",wrap:!0},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{size:"s",className:"eui-textNoWrap"},Ue(e))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Be,{isAgentUpgradable:!(!I(t)||!(0,N._3)(t)),agent:t,latestAgentVersion:M})))))},{name:f.i18n.translate("xpack.fleet.agentList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:n}],width:"100px"}];return(0,R.jsx)(g.EuiBasicTable,{className:"fleet__agentList__table","data-test-subj":"fleetAgentListTable",loading:a,noItemsMessage:A,items:T,itemId:"id",columns:P,pagination:{pageIndex:h.currentPage-1,pageSize:h.pageSize,totalItemCount:p,pageSizeOptions:E},selection:{selected:c,onSelectionChange:d,selectable:I,selectableMessage:(e,t)=>e?"":t.active?t.policy_id&&l[t.policy_id].is_managed?"This action is not available for agents enrolled in an externally managed agent policy":"":"This agent is not active"},onChange:r,sorting:C})},We=()=>{var e,t;const a=(0,u.UKg)();return(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutTitle",defaultMessage:"Max number of online agents reached"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutDescription",defaultMessage:"Fleet supports a maximum of {nbAgents} active agents. You need to unenroll some agents to ensure that all active agents are able to connect and new agents can be enrolled.",values:{nbAgents:(0,R.jsx)(m.FormattedNumber,{value:null!==(e=null===(t=a.internal)||void 0===t?void 0:t.activeAgentsSoftLimit)&&void 0!==e?e:25e3})}}))},Ge=["healthy","unhealthy","orphaned","updating","offline","inactive","unenrolled","uninstalled"];function Ke(e,t){const a="EUI_THEME_AMSTERDAM"===t.themeName;switch(e){case"healthy":return a?t.colors.vis.euiColorVisBehindText0:t.colors.backgroundFilledSuccess;case"offline":case"uninstalled":return t.colors.lightShade;case"inactive":return t.colors.darkShade;case"unhealthy":case"orphaned":return a?t.colors.vis.euiColorVisBehindText5:t.colors.backgroundFilledWarning;case"updating":return a?t.colors.vis.euiColorVisBehindText1:t.colors.backgroundFilledPrimary;case"unenrolled":return t.colors.backgroundBaseDisabled;default:throw new Error(`Unsupported Agent status ${e}`)}}const qe=P()(g.EuiColorPaletteDisplay).withConfig({displayName:"StyledEuiColorPaletteDisplay",componentId:"sc-1wvk6tr-0"})(["&.ingest-agent-status-bar{border:none;border-radius:0;&:after{border:none;}}"]),Ve=({agentStatus:e})=>{const{euiTheme:t}=(0,g.useEuiTheme)(),a=(0,s.useMemo)((()=>Ge.reduce(((a,s)=>{const l=a.length>0?a[a.length-1].stop:0;return a.push({stop:l+(e[s]||0),color:Ke(s,t)}),a}),[])),[e,t]);return 0===a[a.length-1].stop?l().createElement(g.EuiSpacer,{size:"s"}):l().createElement(qe,{"data-test-subj":"agentStatusBar",className:"ingest-agent-status-bar",size:"s",palette:a})},$e=()=>{const{isOpen:e,dismiss:t}=(0,u.we$)("AGENT_EXPORT_CSV");return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTourStep,{content:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourContent",defaultMessage:"Once you have selected the agents, click the action menu to download the CSV file."})),isStepOpen:e,onFinish:t,minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourTitle",defaultMessage:"Download CSV file"}),footerAction:(0,R.jsx)(g.EuiButtonEmpty,{onClick:t},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.genericTourPopover.dismissButton",defaultMessage:"Got it"})),anchorPosition:"upLeft",anchor:"#agentListSelectionText"}))},Ye=P().div.withConfig({displayName:"Divider",componentId:"sc-1e6bwq9-0"})(["width:0;height:",";border-left:",";"],(e=>e.theme.eui.euiSizeL),(e=>e.theme.eui.euiBorderThin)),Qe=P()(g.EuiFlexItem).withConfig({displayName:"FlexItem",componentId:"sc-1e6bwq9-1"})(["height:",";"],(e=>e.theme.eui.euiSizeL)),Xe=P()(g.EuiButtonEmpty).withConfig({displayName:"Button",componentId:"sc-1e6bwq9-2"})([".euiButtonEmpty__text{font-size:",";}"],(e=>e.theme.eui.euiFontSizeXS)),Je=({totalAgents:e,totalManagedAgents:t,selectableAgents:a,managedAgentsOnCurrentPage:s,selectionMode:n,setSelectionMode:i,selectedAgents:o,setSelectedAgents:r})=>{const u="manual"===n&&o.length>0||"query"===n&&e>0,d="manual"===n&&o.length===a&&a<e-s;return l().createElement(l().Fragment,null,l().createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiText,{size:"xs",color:"subdued",id:"agentListSelectionText"},e>M.W?l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgentsWithLimit",defaultMessage:"Showing {count} of {total} agents",values:{count:l().createElement(m.FormattedNumber,{value:M.W}),total:l().createElement(m.FormattedNumber,{value:e})}}):l().createElement(l().Fragment,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgents",defaultMessage:"Showing {count, plural, one {# agent} other {# agents}}",values:{count:e}})," ",l().createElement(g.EuiIconTip,{type:"info",content:l().createElement(m.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsBreakDownTooltip",defaultMessage:" {totalAgents} total agents: {totalSelected} user-managed agents, {totalManagedAgents} on hosted policies",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),l().createElement($e,null)),u?l().createElement(l().Fragment,null,l().createElement(Qe,{grow:!1},l().createElement(Ye,null)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiText,{size:"xs",color:"subdued","data-test-subj":"selectedAgentCountLabel"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.agentsSelected",defaultMessage:"{selectionMode, select, manual { {count, plural, one {# agent} other {# agents}} } other {All agents} } selected",values:{selectionMode:n,count:o.length}})," ","query"===n&&l().createElement(g.EuiIconTip,{type:"info",content:l().createElement(m.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsSelectedTooltip",defaultMessage:"{totalSelected} user-managed agents selected: {totalAgents} total agents, {totalManagedAgents} on hosted policies. Most actions are only available to user-managed agents.",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),d?l().createElement(l().Fragment,null,l().createElement(Qe,{grow:!1},l().createElement(Ye,null)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Xe,{size:"xs",flush:"left","data-test-subj":"selectedEverythingOnAllPagesButton",onClick:()=>i("query")},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.selectAll",defaultMessage:"Select everything on all pages"})))):null,l().createElement(Qe,{grow:!1},l().createElement(Ye,null)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Xe,{size:"xs",flush:"left","data-test-subj":"clearAgentSelectionButton",onClick:()=>{i("manual"),r([])}},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.clearSelection",defaultMessage:"Clear selection"})))):l().createElement(Qe,{grow:!1})))},Ze=(0,s.memo)((({agentStatus:e})=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"m"},Ge.map((t=>(0,R.jsx)(g.EuiFlexItem,{key:t,grow:!1},(0,R.jsx)(et,{status:t,count:e[t]||0}))))))),et=(0,s.memo)((({status:e,count:t})=>{const{euiTheme:a}=(0,g.useEuiTheme)();return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiHealth,{color:Ke(e,a)},(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},function(e){switch(e){case"healthy":return f.i18n.translate("xpack.fleet.agentStatus.healthyLabel",{defaultMessage:"Healthy"});case"offline":return f.i18n.translate("xpack.fleet.agentStatus.offlineLabel",{defaultMessage:"Offline"});case"uninstalled":return f.i18n.translate("xpack.fleet.agentStatus.uninstalledLabel",{defaultMessage:"Uninstalled"});case"inactive":return f.i18n.translate("xpack.fleet.agentStatus.inactiveLabel",{defaultMessage:"Inactive"});case"unenrolled":return f.i18n.translate("xpack.fleet.agentStatus.unenrolledLabel",{defaultMessage:"Unenrolled"});case"unhealthy":return f.i18n.translate("xpack.fleet.agentStatus.unhealthyLabel",{defaultMessage:"Unhealthy"});case"orphaned":return f.i18n.translate("xpack.fleet.agentStatus.orphanedLabel",{defaultMessage:"Orphaned"});case"updating":return f.i18n.translate("xpack.fleet.agentStatus.updatingLabel",{defaultMessage:"Updating"});default:throw new Error(`Unsupported Agent status ${e}`)}}(e)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiNotificationBadge,{size:"s",color:"subdued"},t)))))})),tt=({agentStatus:e,totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:n,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u,clearFilters:d,isUsingFilter:c})=>(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Je,{totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:n,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u})),c?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLink,{onClick:()=>d()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.header.clearFiltersLinkText",defaultMessage:"Clear filters"}))):null),(0,R.jsx)(g.EuiFlexItem,{grow:!1},e&&(0,R.jsx)(Ze,{agentStatus:e}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),e&&(0,R.jsx)(Ve,{agentStatus:e}));var at=a(27548),st=a(55964),lt=a(7195),nt=a(34127),it=a(45804),ot=a(89019);const rt=f.i18n.translate("xpack.fleet.noTagsValue",{defaultMessage:"No Tags"}),ut=({search:e,selectedAgentPolicies:t,selectedTags:a,selectedStatus:s,selectedAgentIds:l})=>{let n="";if(e&&(n=e.trim()),null!=t&&t.length&&(n&&(n=`(${n}) and`),n=`${n} ${M.Ah}.policy_id : (${t.map((e=>`"${e}"`)).join(" or ")})`),null!=a&&a.length)if(n&&(n=`(${n}) and`),a.includes(rt)){const e=a.filter((e=>e!==rt));n=`${n} ((NOT ${M.Ah}.tags : (*))${e.length>0?` or ${M.Ah}.tags : (${e.map((e=>`"${e}"`)).join(" or ")}))`:")"}`}else n=`${n} ${M.Ah}.tags : (${a.map((e=>`"${e}"`)).join(" or ")})`;if(null!=l&&l.length&&(n&&(n=`(${n}) and`),n=`${n} ${M.Ah}.agent.id : (${l.map((e=>`"${e}"`)).join(" or ")})`),null!=s&&s.length){const e=s.map((e=>{switch(e){case"healthy":return N.ir.buildKueryForOnlineAgents();case"unhealthy":return N.ir.buildKueryForErrorAgents();case"offline":return N.ir.buildKueryForOfflineAgents();case"updating":return N.ir.buildKueryForUpdatingAgents();case"inactive":return N.ir.buildKueryForInactiveAgents();case"unenrolled":return N.ir.buildKueryForUnenrolledAgents();case"orphaned":return N.ir.buildKueryForOrphanedAgents();case"uninstalled":return N.ir.buildKueryForUninstalledAgents()}})).filter((e=>void 0!==e)).join(" or ");n=n?`(${n}) and (${e})`:e}return n.trim()},dt="local_metadata.elastic.agent.version",ct="local_metadata.host.hostname",gt=e=>[dt,ct].includes(e)?`${e}.keyword`:e;const pt=[{field:"agent.id",description:f.i18n.translate("xpack.fleet.exportCSV.agentIdField",{defaultMessage:"Agent ID"})},{field:"status",description:f.i18n.translate("xpack.fleet.exportCSV.statusField",{defaultMessage:"Status"})},{field:"local_metadata.host.hostname",description:f.i18n.translate("xpack.fleet.exportCSV.hostnameField",{defaultMessage:"Host Name"})},{field:"policy_id",description:f.i18n.translate("xpack.fleet.exportCSV.policyIdField",{defaultMessage:"Policy ID"})},{field:"last_checkin",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinField",{defaultMessage:"Last Checkin Time"})},{field:"local_metadata.elastic.agent.version",description:f.i18n.translate("xpack.fleet.exportCSV.agentVersionField",{defaultMessage:"Agent Version"})}],mt=[{field:"active",description:f.i18n.translate("xpack.fleet.exportCSV.activeField",{defaultMessage:"Active"})},{field:"audit_unenrolled_reason",description:f.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledReasonField",{defaultMessage:"Audit Unenrolled Reason"})},{field:"audit_unenrolled_time",description:f.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledTimeField",{defaultMessage:"Audit Unenrolled Time"})},{field:"enrolled_at",description:f.i18n.translate("xpack.fleet.exportCSV.enrolledAtField",{defaultMessage:"Enrolled At"})},{field:"last_checkin_message",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinMessageField",{defaultMessage:"Last Checkin Message"})},{field:"last_checkin_status",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinStatusField",{defaultMessage:"Last Checkin Status"})},{field:"last_updated",description:f.i18n.translate("xpack.fleet.exportCSV.lastUpdatedField",{defaultMessage:"Last Updated Time"})},{field:"local_metadata.elastic.agent.build.original",description:f.i18n.translate("xpack.fleet.exportCSV.agentBuildOriginalField",{defaultMessage:"Agent Build Original"})},{field:"local_metadata.elastic.agent.log_level",description:f.i18n.translate("xpack.fleet.exportCSV.logLevelField",{defaultMessage:"Agent Log Level"})},{field:"local_metadata.elastic.agent.snapshot",description:f.i18n.translate("xpack.fleet.exportCSV.agentSnapshotField",{defaultMessage:"Agent Snapshot"})},{field:"local_metadata.elastic.agent.unprivileged",description:f.i18n.translate("xpack.fleet.exportCSV.agentUnprivilegedField",{defaultMessage:"Agent Unprivileged"})},{field:"local_metadata.elastic.agent.upgradeable",description:f.i18n.translate("xpack.fleet.exportCSV.agentUpgradeableField",{defaultMessage:"Agent Upgradeable"})},{field:"local_metadata.host.architecture",description:f.i18n.translate("xpack.fleet.exportCSV.hostArchitectureField",{defaultMessage:"Host Architecture"})},{field:"local_metadata.host.id",description:f.i18n.translate("xpack.fleet.exportCSV.hostIdField",{defaultMessage:"Host ID"})},{field:"local_metadata.host.ip",description:f.i18n.translate("xpack.fleet.exportCSV.hostIpField",{defaultMessage:"Host IP"})},{field:"local_metadata.host.mac",description:f.i18n.translate("xpack.fleet.exportCSV.hostMacField",{defaultMessage:"Host Mac"})},{field:"local_metadata.host.name",description:f.i18n.translate("xpack.fleet.exportCSV.hostNameField",{defaultMessage:"Host Name"})},{field:"local_metadata.os.family",description:f.i18n.translate("xpack.fleet.exportCSV.osFamilyField",{defaultMessage:"OS Family"})},{field:"local_metadata.os.full",description:f.i18n.translate("xpack.fleet.exportCSV.osFullField",{defaultMessage:"OS Full"})},{field:"local_metadata.os.kernel",description:f.i18n.translate("xpack.fleet.exportCSV.osKernelField",{defaultMessage:"OS Kernel"})},{field:"local_metadata.os.name",description:f.i18n.translate("xpack.fleet.exportCSV.osNameField",{defaultMessage:"OS Name"})},{field:"local_metadata.os.platform",description:f.i18n.translate("xpack.fleet.exportCSV.osPlatformField",{defaultMessage:"OS Platform"})},{field:"local_metadata.os.version",description:f.i18n.translate("xpack.fleet.exportCSV.osVersionField",{defaultMessage:"OS Version"})},{field:"tags",description:f.i18n.translate("xpack.fleet.exportCSV.tagsField",{defaultMessage:"Tags"})},{field:"unenrolled_at",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledAtField",{defaultMessage:"Unenrolled At"})},{field:"unenrolled_reason",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledReasonField",{defaultMessage:"Unenrolled Reason"})},{field:"unenrollment_started_at",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledStartedAtField",{defaultMessage:"Unenrolled Started At"})},{field:"unhealthy_reason",description:f.i18n.translate("xpack.fleet.exportCSV.unhealthyReasonField",{defaultMessage:"Unhealthy Reason"})},{field:"updated_at",description:f.i18n.translate("xpack.fleet.exportCSV.updatedAtField",{defaultMessage:"Updated At"})},{field:"upgrade_started_at",description:f.i18n.translate("xpack.fleet.exportCSV.upgradeStartedAtField",{defaultMessage:"Upgrade Started At"})},{field:"upgrade_status",description:f.i18n.translate("xpack.fleet.exportCSV.upgradeStatusField",{defaultMessage:"Upgrade Status"})},{field:"upgraded_at",description:f.i18n.translate("xpack.fleet.exportCSV.upgradedAtField",{defaultMessage:"Upgraded At"})},{field:"user_provided_metadata",description:f.i18n.translate("xpack.fleet.exportCSV.userProvidedMetadataField",{defaultMessage:"User Provided Metadata"})}],ft=({onClose:e,onSubmit:t,agentCount:a})=>{const[l,n]=(0,s.useState)(pt),i=(0,g.useGeneratedHtmlId)(),o=(0,J.uniqBy)([...pt,...mt],"field"),r={selectable:()=>!0,onSelectionChange:e=>{n(e)},initialSelected:pt};return(0,R.jsx)(g.EuiConfirmModal,{"data-test-subj":"agentExportCSVModal",confirmButtonDisabled:0===l.length,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTitle",defaultMessage:"Download table results as a CSV file"}),"aria-labelledby":i,titleProps:{id:i},onCancel:e,onConfirm:()=>t(l.map((e=>({field:e.field})))),cancelButtonText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.confirmButtonLabel",defaultMessage:"Download CSV"})},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.agentsCountText",defaultMessage:"Agents"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiNotificationBadge,{color:"subdued",size:"m"},a)))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSpacer,{size:"s"})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTableDescription",defaultMessage:"Select the table columns to display in the CSV file"}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiInMemoryTable,{tableCaption:"Column",items:o,itemId:"field",columns:[{field:"field",name:"Field",truncateText:!0},{field:"description",name:"Description",truncateText:!0}],selection:r}))))},xt=()=>{const{notifications:e}=(0,u.WeA)(),t=(0,s.useCallback)((async(t,a,s,l)=>{try{const l=await t();if(l.error)throw l.error;const n=!l.data.actionId,i=null!=s?s:f.i18n.translate("xpack.fleet.updateAgentTags.successNotificationTitle",{defaultMessage:"Tag(s) updated"});e.toasts.addSuccess(i),a(n)}catch(t){const a=null!=l?l:f.i18n.translate("xpack.fleet.updateAgentTags.errorNotificationTitle",{defaultMessage:"Tag(s) update failed"});e.toasts.addError(t,{title:a})}}),[e.toasts]);return{updateTags:(0,s.useCallback)((async(e,a,s,l,n)=>{await t((async()=>await(0,u.FA$)(e,{tags:a})),s,l,n)}),[t]),bulkUpdateTags:(0,s.useCallback)((async(e,a,s,l,n,i)=>{await t((async()=>await(0,u.yX1)({agents:e,tagsToAdd:a,tagsToRemove:s,includeInactive:!0})),l,n,i)}),[t])}},ht="fleet.lastSeenInactiveAgentsCount";async function yt(){var e,t;const a=await(0,u.voy)({kuery:"status:online",perPage:0,showInactive:!1});if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0}const Et="fleet.missingEncryptionKeyCalloutHasBeenDismissed",vt=({tagName:e,isTagHovered:t,onTagsUpdated:a})=>{const[n,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(),[u,d]=(0,s.useState)(t),[c,p]=(0,s.useState)(e);(0,s.useEffect)((()=>{d(t||n)}),[t,n]),(0,s.useEffect)((()=>{p(e)}),[e]);const x=(e=!1)=>{i(!1),e?k():v(c)},h=xt(),y=h.bulkUpdateTags,E='tags:"{name}"',v=t=>{if(t===e||!t)return;const s=E.replace("{name}",e);y(s,[t],[e],(s=>a([t],[e],s)),f.i18n.translate("xpack.fleet.renameAgentTags.successNotificationTitle",{defaultMessage:"Tag renamed"}),f.i18n.translate("xpack.fleet.renameAgentTags.errorNotificationTitle",{defaultMessage:"Tag rename failed"}))},k=()=>{const t=E.replace("{name}",e);h.bulkUpdateTags(t,[],[e],(t=>a([],[e],t)),f.i18n.translate("xpack.fleet.deleteAgentTags.successNotificationTitle",{defaultMessage:"Tag deleted"}),f.i18n.translate("xpack.fleet.deleteAgentTags.errorNotificationTitle",{defaultMessage:"Tag delete failed"}))};return(0,R.jsx)(l().Fragment,null,u&&(0,R.jsx)(g.EuiButtonIcon,{iconType:"boxesHorizontal","aria-label":f.i18n.translate("xpack.fleet.tagOptions.tagOptionsToggleButtonLabel",{defaultMessage:"Tag Options"}),color:"text",onClick:e=>{r(e.currentTarget),i(!n)}}),n&&(0,R.jsx)(g.EuiWrappingPopover,{isOpen:!0,button:o,closePopover:x,anchorPosition:"downCenter"},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",alignItems:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldText,{placeholder:f.i18n.translate("xpack.fleet.tagOptions.nameTextFieldPlaceholder",{defaultMessage:"Enter new name for tag"}),value:c,required:!0,onKeyDown:e=>{"Enter"===e.key&&x()},onChange:e=>{const t=e.currentTarget.value;p(Ie(t))}})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiButtonEmpty,{size:"s",color:"danger",onClick:()=>{x(!0)}},(0,R.jsx)(g.EuiIcon,{type:"trash"})," ",(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.tagOptions.deleteText",defaultMessage:"Delete tag"}))))))},kt=P()(g.EuiHighlight).withConfig({displayName:"TruncatedEuiHighlight",componentId:"sc-492jbf-0"})(["width:120px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;"]),jt=({agentId:e,agents:t,allTags:a,selectedTags:n,button:i,onTagsUpdated:o,onClosePopover:r})=>{const u=(0,s.useCallback)(((e,t)=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,onFocusBadge:!1})))),[]),[d,c]=(0,s.useState)(u(a,n)),[p,x]=(0,s.useState)(void 0),[h,y]=(0,s.useState)(!0),[E,v]=(0,s.useState)({}),k=xt();(0,s.useEffect)((()=>{c(u(a,n))}),[a,u,n]);const j=(0,s.useMemo)((()=>d.some((e=>e.label===p))),[d,p]),b=(e,t,s=!0,l=!1)=>{if(s)return o(e);const n=d.filter((e=>"on"===e.checked)).map((e=>e.label)),i=(0,J.difference)(n,t).concat(e),r=(0,J.uniq)(a.concat(i)),g=l?(0,J.difference)(r,t):r;c(u(g,i))},S=async(a,s,l,i)=>{if(e){const t=(0,J.difference)(n,s).concat(a);k.updateTags(e,t,(()=>o(a)),l,i)}else k.bulkUpdateTags(t,a,s,(e=>b(a,s,e)),l,i)},F=l().createElement(g.EuiButtonEmpty,{color:"text","data-test-subj":"createTagBtn",onClick:()=>{p&&S([p],[],f.i18n.translate("xpack.fleet.createAgentTags.successNotificationTitle",{defaultMessage:"Tag created"}),f.i18n.translate("xpack.fleet.createAgentTags.errorNotificationTitle",{defaultMessage:"Tag creation failed"}))}},l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIcon,{type:"plus"})),l().createElement(g.EuiFlexItem,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.tagsAddRemove.createText",defaultMessage:'Create a new tag "{name}"',values:{name:p}}))));return l().createElement(l().Fragment,null,l().createElement(g.EuiWrappingPopover,{isOpen:h,button:i,closePopover:()=>{y(!1),r()},anchorPosition:"leftUp"},l().createElement(g.EuiSelectable,{onFocus:()=>{},"aria-label":f.i18n.translate("xpack.fleet.tagsAddRemove.selectableTagsLabel",{defaultMessage:"Add / remove tags"}),searchable:!0,searchProps:{"data-test-subj":"addRemoveTags",placeholder:f.i18n.translate("xpack.fleet.tagsAddRemove.findOrCreatePlaceholder",{defaultMessage:"Find or create tag..."}),onChange:e=>{x(Ie(e))},value:null!=p?p:""},options:d,renderOption:(e,t)=>l().createElement(g.EuiFlexGroup,{gutterSize:"s",onMouseEnter:()=>v({...E,[e.label]:!0}),onMouseLeave:()=>v({...E,[e.label]:!1})},l().createElement(g.EuiFlexItem,null,l().createElement(kt,{search:t,onClick:()=>{const t="on"===e.checked?[]:[e.label],a="on"===e.checked?[e.label]:[];S(t,a)}},e.label)),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(vt,{tagName:e.label,isTagHovered:E[e.label],onTagsUpdated:(e,t,a)=>b(e,t,a,!0)})))},((e,t)=>l().createElement(s.Fragment,null,t,e))),j&&0!==d.length||""===p?null:F))},bt=({headers:e,onUpdate:t})=>{const a=(0,s.useCallback)(((a,s,l)=>{const n=Object.entries(e);if("key"===l){const e=n.map(((e,t)=>t===a?[s,e[1]]:e));t(Object.fromEntries(e))}else{const e=n.map(((e,t)=>t===a?[e[0],s]:e));t(Object.fromEntries(e))}}),[e,t]);return(0,R.jsx)(l().Fragment,null,e&&Object.entries(e).map((([s,n],i)=>(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:5},(0,R.jsx)(g.EuiFieldText,{placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.headersKeyPlaceholder",{defaultMessage:"Key"}),onChange:e=>{a(i,e.target.value,"key")},value:s,fullWidth:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:5},(0,R.jsx)(g.EuiFieldText,{value:n,placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.headersValuePlaceholder",{defaultMessage:"Value"}),onChange:e=>{a(i,e.target.value,"value")},fullWidth:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:0},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"cross",onClick:()=>{const a=Object.entries(e).filter(((e,t)=>t!==i));t(Object.fromEntries(a))}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"})))),(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",onClick:()=>{t({...e,"":""})}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.addHeaderLabel",defaultMessage:"Add Row"}))))},St=({agents:e,agentCount:t,onClose:a,onSave:n,unsupportedMigrateAgents:i})=>{var o,r,d,c,p,x;const{notifications:h}=(0,u.WeA)(),y=u.L5X,E=u.Ch0,[v,k]=l().useState(!1),[j,b]=l().useState(!1),[S,F]=l().useState({id:"",agents:[],uri:"",enrollment_token:"",settings:{}}),M=(0,g.useGeneratedHtmlId)(),I=(0,s.useMemo)((()=>Array.isArray(e)?e.filter((e=>!i.some((t=>t.id===e.id)))):e),[e,i]),T=(0,s.useMemo)((()=>Array.isArray(I)?I.length:t),[t,I]);return(0,s.useEffect)((()=>{(()=>{if(S.uri)try{new URL(S.uri),b(!0)}catch(e){b(!1)}else b(!1)})(),(()=>{const e=!Array.isArray(I)||I.length>0;S.uri&&S.enrollment_token&&j&&e?k(!0):k(!1)})()}),[S,j,I]),(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlyout,{"data-test-subj":"migrateAgentFlyout",onClose:a,"aria-labelledby":M},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"l"},(0,R.jsx)("h1",{id:M},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.title",defaultMessage:"Migrate {agentCount, plural, one {agent} other {agents}}",values:{agentCount:T}}))),(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.description",defaultMessage:"Move {agentCount, plural, one {this agent} other {these agents}} to a different Fleet Server by specifying a new cluster URL and enrollment token.",values:{agentCount:T}})),Array.isArray(e)&&i.length>0&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiPanel,{color:"warning","data-test-subj":"migrateAgentFlyoutAlertPanel"},(0,R.jsx)(g.EuiText,{color:"warning",className:"eui-alignMiddle"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.warning",defaultMessage:"{icon} {x} of {y} selected agents cannot be migrated as they are either tamper-protected agents, Fleet Server agents, containerized agents, or agents on an unsupported version.",values:{icon:(0,R.jsx)(g.EuiIcon,{type:"warning"}),x:i.length,y:t}})),(0,R.jsx)(g.EuiAccordion,{id:"migrateAgentFlyoutWarningAccordion",buttonContent:(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>{},"aria-label":"View hosts"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.warningAccordion",defaultMessage:"View hosts"})),initialIsOpen:!1},(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiText,null,(0,R.jsx)("ul",null,i.map((e=>{var t,a;return(0,R.jsx)("li",{key:e.id},null===(t=e.local_metadata)||void 0===t||null===(a=t.host)||void 0===a?void 0:a.hostname)})))))))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(g.EuiForm,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.clusterUrlLabel",defaultMessage:"Remote Cluster URL"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.clusterUrlHelpText",defaultMessage:"Enter the URL of the Fleet server in the target cluster you want the agent to migrate to"}),isInvalid:!j&&""!==S.uri,error:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.clusterUrlError",defaultMessage:"Invalid cluster URL"})},(0,R.jsx)(g.EuiFieldText,{isInvalid:!j&&""!==S.uri,placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.clusterUrlPlaceholder",{defaultMessage:"Enter a valid cluster URL"}),fullWidth:!0,onChange:e=>F({...S,uri:e.target.value}),"data-test-subj":"migrateAgentFlyoutClusterUrlInput"})),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenLabel",defaultMessage:"Enrollment Token"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenHelpText",defaultMessage:"Enter a valid enrollment token generated in the target cluster"})},(0,R.jsx)(g.EuiFieldPassword,{"data-test-subj":"migrateAgentFlyoutEnrollmentTokenInput",onChange:e=>F({...S,enrollment_token:e.target.value}),placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenPlaceholder",{defaultMessage:"Enter a valid enrollment token"}),fullWidth:!0})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,"aria-label":"Additional options"},(0,R.jsx)(g.EuiAccordion,{arrowDisplay:"left",id:"migrateAgentFlyoutAdditionalOptions",initialIsOpen:!1,buttonContent:(0,R.jsx)(g.EuiButtonEmpty,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.additionalOptionsLabel",defaultMessage:"Advanced options"}))},(0,R.jsx)(g.EuiPanel,{color:"subdued",hasBorder:!0},(0,R.jsx)(g.EuiAccordion,{id:"tlsCertsSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.tlsCertsLabel",defaultMessage:"TLS & Certs"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.tlsCertsDescriptionLabel",defaultMessage:"Provide optional TLS settings if your target Fleet server uses custom certificates."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:"ca_sha256",fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,ca_sha256:e.target.value}})})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.certAuthLabel",defaultMessage:"Certificate Authorities"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,certificate_authorities:e.target.value}})})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertLabel",defaultMessage:"Elastic Agent Certificate"}),fullWidth:!0},(0,R.jsx)(g.EuiTextArea,{onChange:e=>F({...S,settings:{...S.settings,elastic_agent_cert:e.target.value}}),fullWidth:!0})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertKeyLabel",defaultMessage:"Elastic Agent Certificate Key"}),fullWidth:!0},(0,R.jsx)(g.EuiTextArea,{onChange:e=>F({...S,settings:{...S.settings,elastic_agent_cert_key:e.target.value}}),fullWidth:!0}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiAccordion,{id:"headersSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.headersMainLabel",defaultMessage:"Headers"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.headersDescriptionLabel",defaultMessage:"Custom HTTP headers sent during agent enrollment."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.headersLabel",defaultMessage:"Headers"}),fullWidth:!0},(0,R.jsx)(bt,{headers:(null===(o=S.settings)||void 0===o?void 0:o.headers)||{},onUpdate:e=>F({...S,settings:{...S.settings,headers:e}})})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.proxyHeadersLabel",defaultMessage:"Proxy Headers"}),fullWidth:!0},(0,R.jsx)(bt,{headers:(null===(r=S.settings)||void 0===r?void 0:r.proxy_headers)||{},onUpdate:e=>F({...S,settings:{...S.settings,proxy_headers:e}})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiAccordion,{id:"networkingSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.networkingLabel",defaultMessage:"Networking"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.networkingDescriptionLabel",defaultMessage:"Configure proxy settings if your network requires routing traffic through a proxy server."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.proxyUrlLabel",defaultMessage:"Proxy URL"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,proxy_url:e.target.value}})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiAccordion,{id:"headersSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.agentOptionsLabel",defaultMessage:"Agent Options"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.agentOptionsDescriptionLabel",defaultMessage:"Customize behavior during migration. Control connection handling, staging environments, and token replacement logic."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),1===e.length&&(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.replaceTokenLabel",defaultMessage:"Replace token"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,"data-test-subj":"migrateAgentFlyoutReplaceTokenInput",onChange:e=>{"id"in S&&F({...S,settings:{...S.settings,replace_token:e.target.value}})}})),1===e.length&&(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.stagingLabel",defaultMessage:"Staging"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,staging:e.target.value}})})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.insecurelabel",defaultMessage:"Insecure"}),checked:null!==(d=null===(c=S.settings)||void 0===c?void 0:c.insecure)&&void 0!==d&&d,onChange:e=>F({...S,settings:{...S.settings,insecure:e.target.checked}})})))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.proxyLabel",defaultMessage:"Proxy Disabled"}),checked:null!==(p=null===(x=S.settings)||void 0===x?void 0:x.proxy_disabled)&&void 0!==p&&p,onChange:e=>F({...S,settings:{...S.settings,proxy_disabled:e.target.checked}})})))))))))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiButtonEmpty,{onClick:a,"data-test-subj":"migrateAgentFlyoutCancelButton","aria-label":"Cancel"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.cancelButtonLabel",defaultMessage:"Cancel"})),(0,R.jsx)(g.EuiButton,{disabled:!v,onClick:async()=>{try{Array.isArray(I)?1===I.length?await y({...S,id:I[0].id}):await E({...S,agents:I.map((e=>e.id))}):await E({...S,agents:I}),h.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.successNotificationTitle",{defaultMessage:"Agent migration initiated"}),text:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.successNotificationDescription",{defaultMessage:"The agent migration process has been successfully initiated."})}),n()}catch(e){h.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.errorNotificationTitle",{defaultMessage:"Failed to migrate {agentCount, plural, one {agent} other {agents}}",values:{agentCount:T}}),toastMessage:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.errorNotificationDescription",{defaultMessage:"The agent migration process has failed."})})}},fill:!0,"data-test-subj":"migrateAgentFlyoutSubmitButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.submitButtonLabel",defaultMessage:"Migrate {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:T}}))))))};var Ft=a(89885);const Mt=({children:e,fullWidth:t,useSecretsStorage:a,secretLabelTitle:s,plainTextLabel:n,additionalHelpText:i})=>{const o=(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiIcon,{type:"lock","data-test-subj":"lockIcon"})," ",s," ",(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.secretFormRow.secretLabelTooltip",{defaultMessage:"This value will be stored as a secret."}),type:"question"})),r=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.secretFormRow.secretHelpText",defaultMessage:"{description}{br}This field uses secret storage and requires Fleet Server v{minVersion} or higher.",values:{description:i,br:(0,R.jsx)("br",null),minVersion:Ft.Cd}}),u=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.secretFormRow.plainHelpText",defaultMessage:"{description}{br}Upgrade Fleet Server to v{minVersion} or higher to store this field as a secret.",values:{description:i,br:(0,R.jsx)("br",null),minVersion:Ft.Cd}}),d=a?o:n,c=a?r:u;return(0,R.jsx)(g.EuiFormRow,{fullWidth:t,label:d,helpText:c},e)},It=({agents:e,agentCount:t,unsupportedAgents:a,onClose:n,onSave:i})=>{var o;const{notifications:r}=(0,ot.WeA)(),u=null!==(o=(0,ot.YI3)().isActionSecretsStorageEnabled)&&void 0!==o&&o,d=ot.$Yi,c=ot.pBL,[p,x]=(0,s.useState)(null),h=(0,g.useGeneratedHtmlId)(),y=(0,s.useMemo)((()=>Array.isArray(e)?e.filter((e=>!a.some((t=>t.id===e.id)))):e),[e,a]),E=(0,s.useMemo)((()=>Array.isArray(y)?y.length:t),[t,y]),v=(e,t)=>{x(null===p?{user_info:{[e]:t}}:{user_info:{...p.user_info,[e]:t}})};return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlyout,{"data-test-subj":"changeAgentPrivilegeLevelFlyout",onClose:n,"aria-labelledby":h},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"l"},(0,R.jsx)("h1",{id:h},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.title",defaultMessage:"Remove {agentCount, plural, one {agent} other {agents}} root privilege",values:{agentCount:E}}))),(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.description",defaultMessage:"Change the privilege level of {agentCount, plural, one {this agent} other {these agents}} to unprivileged.",values:{agentCount:E}})),Array.isArray(e)&&a.length>0&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiPanel,{color:"warning","data-test-subj":"changeAgentPrivilegeLevelFlyoutAlertPanel"},(0,R.jsx)(g.EuiText,{color:"warning",className:"eui-alignMiddle"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.warning",defaultMessage:"{icon} Root privilege cannot be removed for {x} of {y} selected agents. These agents are either Fleet Server agents, already unprivileged agents, or agents on an unsupported version.",values:{icon:(0,R.jsx)(g.EuiIcon,{type:"warning"}),x:a.length,y:t}})),(0,R.jsx)(g.EuiAccordion,{id:"changeAgentPrivilegeLevelFlyoutWarningAccordion",buttonContent:(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>{},"aria-label":"View hosts"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.warningAccordion",defaultMessage:"View hosts"})),initialIsOpen:!1},(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiText,null,(0,R.jsx)("ul",null,a.map((e=>{var t,a;return(0,R.jsx)("li",{key:e.id},null===(t=e.local_metadata)||void 0===t||null===(a=t.host)||void 0===a?void 0:a.hostname)})))))))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(g.EuiForm,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.usernameLabel",defaultMessage:"Username (optional)"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.usernameHelpText",defaultMessage:"The username of the user that runs the Elastic Agent"})},(0,R.jsx)(g.EuiFieldText,{placeholder:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.usernamePlaceholder",{defaultMessage:"Specify username"}),fullWidth:!0,onChange:e=>v("username",e.target.value),"data-test-subj":"changeAgentPrivilegeLevelFlyout.usernameInput"})),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userGroupLabel",defaultMessage:"User group (optional)"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userGroupHelpText",defaultMessage:"The group of the user that runs the Elastic Agent"})},(0,R.jsx)(g.EuiFieldText,{placeholder:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userGroupPlaceholder",{defaultMessage:"Specify user group"}),fullWidth:!0,onChange:e=>v("groupname",e.target.value),"data-test-subj":"changeAgentPrivilegeLevelFlyout.userGroupInput"})),(0,R.jsx)(Mt,{fullWidth:!0,useSecretsStorage:u,secretLabelTitle:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.passwordLabel",{defaultMessage:"User password (optional)"}),plainTextLabel:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.passwordLabel",defaultMessage:"User password (optional)"}),additionalHelpText:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.userPasswordHelpText",{defaultMessage:"The password of the user that runs the Elastic Agent"})},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,"data-test-subj":"agentPrivilegeFlyout.passwordSecretInput",onChange:e=>v("password",e.target.value),placeholder:f.i18n.translate("xpack.fleet.settings.agentPrivilegeFlyout.passwordPlaceholder",{defaultMessage:"Specify user password"})})))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiButtonEmpty,{"aria-label":"Cancel",onClick:n,"data-test-subj":"changeAgentPrivilegeLevelFlyoutCancelButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.cancelButtonLabel",defaultMessage:"Cancel"})),(0,R.jsx)(g.EuiButton,{onClick:async()=>{try{Array.isArray(y)?1===y.length?await d({agentId:y[0].id,body:p}):await c({body:{agents:y.map((e=>e.id)),...p}}):await c({body:{agents:y,...p}}),r.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.successNotificationTitle",{defaultMessage:"Agent privilege level change initiated"}),text:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.successNotificationDescription",{defaultMessage:"The agent privilege level change process has been successfully initiated."})}),i()}catch(e){r.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.errorNotificationTitle",{defaultMessage:"Failed to change privilege level for {agentCount, plural, one {agent} other {agents}}",values:{agentCount:E}}),toastMessage:f.i18n.translate("xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.errorNotificationDescription",{defaultMessage:"The agent privilege level change process has failed."})})}},fill:!0,disabled:0===E,"data-test-subj":"changeAgentPrivilegeLevelFlyoutSubmitButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelFlyout.submitButtonLabel",defaultMessage:"Remove privilege for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:E}}))))))},Tt=({nAgentsInTable:e,totalManagedAgentIds:t,selectionMode:a,currentQuery:n,selectedAgents:i,agentsOnCurrentPage:o,refreshAgents:r,allTags:d,agentPolicies:c,sortField:p,sortOrder:x,unsupportedMigrateAgents:h,unsupportedPrivilegeLevelChangeAgents:y})=>{const E=(0,u.RR_)(),v=(0,u.iO7)(),k=E.hasAtLeast(te.l7o),j=E.hasAtLeast(te.NY3),b=N.ZX.get().enableAgentPrivilegeLevelChange,[S,F]=(0,s.useState)(!1),M=()=>F(!1),[I,T]=(0,s.useState)(!1),[w,A]=(0,s.useState)(!1),[C,P]=(0,s.useState)({isOpen:!1,isScheduled:!1,isUpdating:!1}),[L,_]=(0,s.useState)(!1),[D,O]=(0,s.useState)(!1),[B,z]=(0,s.useState)(!1),[H,W]=(0,s.useState)(!1),[G,K]=(0,s.useState)(!1),q=(0,s.useMemo)((()=>{if(t.length){const e=`${te.AhM}.agent.id : (${t.map((e=>`"${e}"`)).join(" or ")})`;return`(${n}) AND NOT (${e})`}return n}),[n,t]),V="manual"===a?i:q,$="manual"===a?i.length:e-(null==t?void 0:t.length),[Y,Q]=(0,s.useState)(),{generateReportingJobCSV:X}=function(){const e=(0,ot.WeA)(),{notifications:t,http:a,uiSettings:s}=e,l=(0,ot.Q14)(),{data:n}=(0,ot.VmO)({enabled:!0}),i=n||'emit("")',o=new nt.ReportingAPIClient(a,s,l);return{generateReportingJobCSV:(a,s,l)=>{const n=o.getDecoratedJobParams(((e,t,a)=>{var s,l;const n=new lt.DataView({spec:{title:".fleet-agents",allowHidden:!0,runtimeFieldMap:{status:{type:"keyword",script:{source:i}}}},fieldFormats:{}});let o;o=Array.isArray(e)?`agent.id:(${e.map((e=>e.id)).join(" OR ")})`:e;const r=gt(null!==(s=null==a?void 0:a.field)&&void 0!==s?s:"enrolled_at"),u=null!==(l=null==a?void 0:a.direction)&&void 0!==l?l:lt.SortDirection.desc,d=(0,be.getSortConfig)(r,u),c={query:{query:"",language:"kuery"},filter:{meta:{index:"fleet-agents",params:{}},query:(0,st.toElasticsearchQuery)((0,st.fromKueryExpression)((0,be.removeSOAttributes)(o)))},fields:t,index:n,sort:d};return{title:"Agent List",objectType:"search",columns:t.map((e=>e.field)),searchSource:c}})(a,s,l));return o.createReportingShareJob("csv_searchsource",n).then((()=>{t.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.modalContent.successfullyQueuedReportNotificationTitle",{defaultMessage:"Queued report for CSV"}),text:(0,it.toMountPoint)((0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.modalContent.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,R.jsx)("a",{href:o.getManagementLink()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),e),"data-test-subj":"queueReportSuccess"})})).catch((e=>{var a;t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.modalContent.notification.reportingErrorTitle",{defaultMessage:"Unable to create report"}),toastMessage:(0,R.jsx)("span",{dangerouslySetInnerHTML:{__html:null===(a=e.body)||void 0===a?void 0:a.message}})})}))}}}(),Z=[{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.addRemoveTags","data-test-subj":"agentBulkActionsAddRemoveTags",defaultMessage:"Add / remove tags"}),icon:(0,R.jsx)(g.EuiIcon,{type:"tag",size:"m"}),disabled:!v.fleet.allAgents,onClick:e=>{Q(e.target.closest("button")),_(!L)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.bulkMigrateAgents","data-test-subj":"agentBulkActionsBulkMigrate",defaultMessage:"Migrate {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:$}}),icon:(0,R.jsx)(g.EuiIcon,{type:"cluster",size:"m"}),disabled:!v.fleet.allAgents||!j,onClick:e=>{M(),W(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.reassignPolicy","data-test-subj":"agentBulkActionsReassign",defaultMessage:"Assign to new policy"}),icon:(0,R.jsx)(g.EuiIcon,{type:"pencil",size:"m"}),disabled:!v.fleet.allAgents,onClick:()=>{M(),T(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.upgradeAgents","data-test-subj":"agentBulkActionsUpgrade",defaultMessage:"Upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:$}}),icon:(0,R.jsx)(g.EuiIcon,{type:"refresh",size:"m"}),disabled:!v.fleet.allAgents,onClick:()=>{M(),P({isOpen:!0,isScheduled:!1,isUpdating:!1})}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.scheduleUpgradeAgents","data-test-subj":"agentBulkActionsScheduleUpgrade",defaultMessage:"Schedule upgrade for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:$}}),icon:(0,R.jsx)(g.EuiIcon,{type:"timeRefresh",size:"m"}),disabled:!v.fleet.allAgents||!k,onClick:()=>{M(),P({isOpen:!0,isScheduled:!0,isUpdating:!1})}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.restartUpgradeAgents","data-test-subj":"agentBulkActionsRestartUpgrade",defaultMessage:"Restart upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:$}}),icon:(0,R.jsx)(g.EuiIcon,{type:"refresh",size:"m"}),disabled:!v.fleet.allAgents,onClick:()=>{M(),P({isOpen:!0,isScheduled:!1,isUpdating:!0})}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.requestDiagnostics","data-test-subj":"agentBulkActionsRequestDiagnostics",defaultMessage:"Request diagnostics for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:$}}),disabled:!v.fleet.readAgents,icon:(0,R.jsx)(g.EuiIcon,{type:"download",size:"m"}),onClick:()=>{M(),O(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.unenrollAgents","data-test-subj":"agentBulkActionsUnenroll",defaultMessage:"Unenroll {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:$}}),disabled:!v.fleet.allAgents,icon:(0,R.jsx)(g.EuiIcon,{type:"trash",size:"m"}),onClick:()=>{M(),A(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.exportAgents","data-test-subj":"bulkAgentExportBtn",defaultMessage:"Export {agentCount, plural, one {# agent} other {# agents}} as CSV",values:{agentCount:$}}),disabled:!v.fleet.readAgents,icon:(0,R.jsx)(g.EuiIcon,{type:"exportAction",size:"m"}),onClick:()=>{M(),z(!0)}}];b&&Z.push({name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.bulkChangeAgentsPrivilegeLevel","data-test-subj":"agentBulkActionsBulkChangeAgentsPrivilegeLevel",defaultMessage:"Remove root privilege for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:$}}),icon:(0,R.jsx)(g.EuiIcon,{type:"lock",size:"m"}),disabled:!v.fleet.allAgents,onClick:()=>{M(),K(!0)}});const ee=[{id:0,items:Z}],ae=(0,s.useMemo)((()=>((e,t,a)=>{const s=e=>e.reduce(((e,t)=>{var s,l;return(e=>{const t=a.find((t=>t.id===e.policy_id));return!!t&&t.is_managed})(t)?e:e.length<1?null!==(l=t.tags)&&void 0!==l?l:[]:(0,J.intersection)(null!==(s=t.tags)&&void 0!==s?s:[],e)}),[]);return Array.isArray(e)?s(t.length>0?t.filter((t=>e.find((e=>e.id===t.id)))):e):s(t)})(V,null!=o?o:[],c)),[V,o,c]);return(0,R.jsx)(l().Fragment,null,I&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.eN,{agents:V,onClose:()=>{T(!1),r()}})),w&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.VH,{agents:V,agentCount:$,onClose:()=>{A(!1),r({refreshTags:!0})}})),B&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(ft,{onSubmit:e=>{X(V,e,{field:p,direction:x}),z(!1)},onClose:()=>{z(!1)},agentCount:$})),C.isOpen&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.YF,{agents:V,agentCount:$,isScheduled:C.isScheduled,isUpdating:C.isUpdating,onClose:()=>{P({isOpen:!1,isScheduled:!1,isUpdating:!1}),r()}})),L&&(0,R.jsx)(jt,{agents:Array.isArray(V)?V.map((e=>e.id)):V,allTags:null!=d?d:[],selectedTags:ae,button:Y,onTagsUpdated:()=>{r({refreshTags:!0})},onClosePopover:()=>{_(!1),M()}}),D&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:V,agentCount:$,onClose:()=>{O(!1)}})),H&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(St,{agents:V,agentCount:$,unsupportedMigrateAgents:h,onClose:()=>{W(!1)},onSave:()=>{W(!1),r()}})),G&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(It,{agents:V,agentCount:$,unsupportedAgents:y,onClose:()=>{K(!1)},onSave:()=>{K(!1),r()}})),(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiPopover,{id:"agentBulkActionsMenu",button:(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"arrowDown",iconSide:"right",onClick:()=>F(!S),"data-test-subj":"agentBulkActionsButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.actions",defaultMessage:"Actions"})),isOpen:S,closePopover:M,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,R.jsx)(g.EuiContextMenu,{initialPanelId:0,panels:ee})))))},wt=({onClickAgentActivity:e,shouldShowTour:t=!1})=>{const{isOpen:a,dismiss:s}=(0,u.we$)("AGENT_ACTIVITY",t);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTourStep,{content:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourContent",defaultMessage:"Review in progress, completed, and scheduled agent action activity history here anytime."})),isStepOpen:a,onFinish:s,minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourTitle",defaultMessage:"Agent activity history"}),anchorPosition:"upCenter",footerAction:(0,R.jsx)(g.EuiButtonEmpty,{onClick:s},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.genericTourPopover.dismissButton",defaultMessage:"Got it"})),anchor:"#agentActivityButton"}),(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>{e()},"data-test-subj":"agentActivityButton",iconType:"clock",id:"agentActivityButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityButton",defaultMessage:"Agent activity"})))};var At=a(97050);const Ct=[{status:"healthy",label:f.i18n.translate("xpack.fleet.agentList.statusHealthyFilterText",{defaultMessage:"Healthy"})},{status:"unhealthy",label:f.i18n.translate("xpack.fleet.agentList.statusUnhealthyFilterText",{defaultMessage:"Unhealthy"})},{status:"orphaned",label:f.i18n.translate("xpack.fleet.agentList.statusOrphanedFilterText",{defaultMessage:"Orphaned"})},{status:"updating",label:f.i18n.translate("xpack.fleet.agentList.statusUpdatingFilterText",{defaultMessage:"Updating"})},{status:"offline",label:f.i18n.translate("xpack.fleet.agentList.statusOfflineFilterText",{defaultMessage:"Offline"})},{status:"inactive",label:f.i18n.translate("xpack.fleet.agentList.statusInactiveFilterText",{defaultMessage:"Inactive"})},{status:"unenrolled",label:f.i18n.translate("xpack.fleet.agentList.statusUnenrolledFilterText",{defaultMessage:"Unenrolled"})},{status:"uninstalled",label:f.i18n.translate("xpack.fleet.agentList.statusUninstalledFilterText",{defaultMessage:"Uninstalled"})}],Pt=P()(g.EuiNotificationBadge).withConfig({displayName:"LeftpaddedNotificationBadge",componentId:"sc-94zpuo-0"})(["margin-left:10px;"]),Lt=({children:e,isOpen:t,onDismiss:a})=>l().createElement(g.EuiTourStep,{content:l().createElement(g.EuiText,{size:"s"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.inactiveAgentsTourStepContent",defaultMessage:"Some agents have become inactive and have been hidden. Use status filters to show inactive or unenrolled agents."})),isStepOpen:t,minWidth:300,step:1,stepsTotal:0,title:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.inactiveAgentsTourStepTitle",defaultMessage:"Inactive agents"}),onFinish:a,anchorPosition:"upCenter",maxWidth:280,footerAction:l().createElement(g.EuiButtonEmpty,{onClick:a},l().createElement(m.FormattedMessage,{id:"xpack.fleet.genericTourPopover.dismissButton",defaultMessage:"Got it"}))},e),_t=e=>{const{euiTheme:t}=(0,g.useEuiTheme)(),{selectedStatus:a,onSelectedStatusChange:n,disabled:i,totalInactiveAgents:o,isOpenByDefault:r=!1}=e,[u,d]=(()=>{const{storage:e}=(0,ot.WeA)(),[t,a]=(0,s.useState)(0);return(0,s.useEffect)((()=>{const t=e.get(ht);t&&a(parseInt(t,10))}),[e]),[t,t=>{e.set(ht,t.toString()),a(t)}]})(),{isHidden:c,isOpen:p,dismiss:f}=(0,At.w)("INACTIVE_AGENTS"),x=(0,s.useMemo)((()=>{const e=o-u;return e<0?0:e}),[u,o]);(0,s.useMemo)((()=>{a.length&&a.includes("inactive")&&x&&d(o)}),[a,x,d,o]),(0,s.useMemo)((()=>{o>0&&u>o&&d(o)}),[u,o,d]);const[h,y]=(0,s.useState)(r),E=e=>{e&&x>0&&!c&&f(),y(e)},v=(0,s.useCallback)((()=>Ct.map((({label:e,status:t})=>({label:e,checked:a.includes(t)?"on":void 0,key:t,append:"inactive"===t&&x>0?l().createElement(Pt,null,x):void 0})))),[a,x]),[k,j]=(0,s.useState)(v());(0,s.useEffect)((()=>{j(v())}),[v]);const b=(0,s.useCallback)((e=>{j(e),e.forEach(((e,t)=>{if(e.checked===k[t].checked);else{const t=e.key;"on"!==e.checked?n([...a.filter((e=>e!==t))]):n([...a,t])}}))}),[n,k,a]);return l().createElement(Lt,{isOpen:x>0&&p,onDismiss:f},l().createElement(g.EuiPopover,{ownFocus:!0,zIndex:Number(t.levels.header)-1,button:l().createElement(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>E(!h),isSelected:h,hasActiveFilters:a.length>0,numActiveFilters:a.length,numFilters:Ct.length,disabled:i,"data-test-subj":"agentList.statusFilter"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.statusFilterText",defaultMessage:"Status"})),isOpen:h,closePopover:()=>E(!1),panelPaddingSize:"none"},l().createElement(g.EuiSelectable,{options:k,onChange:b,"data-test-subj":"agentList.agentStatusFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},(e=>e))))};function Dt(e=Z.DEFAULT_SPACE_ID,t,a){var s,l,n,i,o;if("installed"!==(null==t||null===(s=t.item)||void 0===s?void 0:s.status))return a;const r=t.item.installationInfo;return r&&(null==r?void 0:r.installed_kibana_space_id)!==e&&null!==(l=null===(n=r.additional_spaces_installed_kibana)||void 0===n||null===(i=n[e])||void 0===i||null===(o=i.find((({originId:e})=>e===a)))||void 0===o?void 0:o.id)&&void 0!==l?l:a}const Ot=()=>{const{data:e}=(0,u.E1o)(te.cOw),{spaceId:t}=(0,u.YI3)(),a=(0,u.e3j)(),s=e=>(null==a?void 0:a.getRedirectUrl({dashboardId:e}))||"",n=Dt(t,e,te.K$s.ELASTIC_AGENT_OVERVIEW),i=Dt(t,e,te.K$s.ELASTIC_AGENT_AGENT_INFO),{dashboardExists:o,loading:r}=(e=>{const{dashboard:t}=(0,u.WeA)(),{data:a,isLoading:s}=(0,x.useQuery)({queryKey:["dashboard_exists",e],queryFn:async()=>{try{const a=await t.findDashboardsService(),[s]=await a.findByIds([e]);return"success"===(null==s?void 0:s.status)}catch(e){return!1}}});return{dashboardExists:null!=a&&a,loading:s}})(n);return r||!o?null:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"dashboardApp",href:s(n),"data-test-subj":"ingestOverviewLinkButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.ingestOverviewlinkButton",defaultMessage:"Ingest Overview Metrics"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"dashboardApp",href:s(i),"data-test-subj":"agentInfoLinkButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentInfoLinkButton",defaultMessage:"Agent Info Metrics"})))))},Rt=({selectedAgentPolicies:e,onSelectedAgentPoliciesChange:t,agentPolicies:a})=>{const{euiTheme:l}=(0,g.useEuiTheme)(),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((()=>a.map((t=>({label:t.name,checked:e.includes(t.id)?"on":void 0,key:t.id,"data-test-subj":"agentList.agentPolicyFilterOption"})))),[a,e]),[r,u]=(0,s.useState)(o());return(0,s.useEffect)((()=>{u(o())}),[o]),(0,R.jsx)(g.EuiPopover,{ownFocus:!0,zIndex:Number(l.levels.header)-1,button:(0,R.jsx)(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>i(!n),isSelected:n,hasActiveFilters:e.length>0,numActiveFilters:e.length,numFilters:a.length,disabled:0===a.length,"data-test-subj":"agentList.policyFilter"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.policyFilterText",defaultMessage:"Agent policy"})),isOpen:n,closePopover:()=>i(!1),panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:r,onChange:a=>{u(a),a.forEach(((a,s)=>{if(a.checked===r[s].checked)var l;else{const s=a.key;"on"!==a.checked?(l=s,t(e.filter((e=>e!==l)))):(a=>{t([...e,a])})(s)}}))},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:200}}},(e=>e)))},Bt=({tags:e,selectedTags:t,onSelectedTagsChange:a})=>{const{euiTheme:n}=(0,g.useEuiTheme)(),[i,o]=(0,s.useState)(!1),r=(0,s.useCallback)((()=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,key:e,"data-test-subj":"agentList.tagFilterOption"})))),[e,t]),[u,d]=(0,s.useState)(r());return(0,s.useEffect)((()=>{d(r())}),[r]),(0,R.jsx)(g.EuiPopover,{ownFocus:!0,zIndex:Number(n.levels.header)-1,button:(0,R.jsx)(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>o(!i),isSelected:i,hasActiveFilters:t.length>0,numActiveFilters:t.length,numFilters:e.length,disabled:0===e.length,"data-test-subj":"agentList.tagsFilter"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterText",defaultMessage:"Tags"})),isOpen:i,closePopover:()=>o(!1),panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:u,searchable:!0,onChange:e=>{e.forEach(((e,s)=>{if(e.checked!==u[s].checked){const s=e.key;return"on"!==e.checked?void(e=>{a(t.filter((t=>t!==e)))})(s):void(e=>{a([...t,e])})(s)}})),d(e)},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},((e,t)=>(0,R.jsx)(l().Fragment,null,t,e))),(0,R.jsx)(g.EuiHorizontalRule,{margin:"none"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"center",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"error",color:"danger","data-test-subj":"agentList.tagFilterClearAllBtn",onClick:()=>{a([])}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterClearAllBtnText",defaultMessage:"Clear all"})))))},Nt=({recentErrors:e,onClick:t})=>0===e?null:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.tooltip",defaultMessage:"{recentErrors, plural, one {There is # new agent activity error} other {There are # new agent activity errors}}. Click to view.",values:{recentErrors:e}})},(0,R.jsx)(g.EuiBadge,{color:"warning",onClick:t,onClickAriaLabel:"Open the Agent activity flyout",iconType:"warning",iconOnClick:t,iconOnClickAriaLabel:"Open the Agent activity flyout","data-test-subj":"agentActivityBadge"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.label",defaultMessage:"Review errors"}))),zt=({agentPolicies:e,draftKuery:t,onDraftKueryChange:a,onSubmitSearch:s,selectedAgentPolicies:n,onSelectedAgentPoliciesChange:i,selectedStatus:o,onSelectedStatusChange:r,showUpgradeable:d,onShowUpgradeableChange:c,tags:p,selectedTags:x,onSelectedTagsChange:h,nAgentsInTable:y,totalInactiveAgents:E,totalManagedAgentIds:v,selectionMode:k,currentQuery:j,selectedAgents:b,refreshAgents:S,onClickAddAgent:I,onClickAddFleetServer:T,agentsOnCurrentPage:w,onClickAgentActivity:A,shouldShowAgentActivityTour:C,latestAgentActionErrors:P,sortField:L,sortOrder:_,unsupportedMigrateAgents:D,unsupportedPrivilegeLevelChangeAgents:O})=>{const B=(0,u.iO7)(),{isFirstTimeAgentUser:N,isLoading:z}=(0,at.X)(),{cloud:U}=(0,u.WeA)(),H=f.i18n.translate("xpack.fleet.agentList.noTagsValue",{defaultMessage:"No Tags"}),W=[...p,H];return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"column"},(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,null,!z&&!N&&(0,R.jsx)(Ot,null)),(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"flexEnd"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Nt,{recentErrors:P,onClick:A})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(wt,{onClickAgentActivity:A,shouldShowTour:C})),!B.fleet.addFleetServers||null!=U&&U.isServerlessEnabled?null:(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton.tooltip",defaultMessage:"Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents"})},(0,R.jsx)(g.EuiButton,{onClick:T,"data-test-subj":"addFleetServerButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton",defaultMessage:"Add Fleet Server"})))),B.fleet.addAgents?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addAgentButton.tooltip",defaultMessage:"Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack"})},(0,R.jsx)(g.EuiButton,{fill:!0,onClick:I,"data-test-subj":"addAgentButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})))):null)),(0,R.jsx)(g.EuiFlexItem,{grow:4},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:6},(0,R.jsx)(F.IW,{value:t,fieldPrefix:M.Ah,indexPattern:M.QF,onChange:(e,t)=>{a(e),t&&s(e)},dataTestSubj:"agentList.queryInput"})),(0,R.jsx)(g.EuiFlexItem,{grow:2},(0,R.jsx)(g.EuiFilterGroup,null,(0,R.jsx)(_t,{selectedStatus:o,onSelectedStatusChange:r,totalInactiveAgents:E,disabled:0===e.length}),(0,R.jsx)(Bt,{tags:W,selectedTags:x,onSelectedTagsChange:h}),(0,R.jsx)(Rt,{selectedAgentPolicies:n,onSelectedAgentPoliciesChange:i,agentPolicies:e}),(0,R.jsx)(g.EuiFilterButton,{hasActiveFilters:d,onClick:()=>{c(!d)},"data-test-subj":"agentList.showUpgradeable"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.showUpgradeableFilterLabel",defaultMessage:"Upgrade available"})))),"manual"===k&&b.length||"query"===k&&y>0?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Tt,{nAgentsInTable:y,totalManagedAgentIds:v,selectionMode:k,currentQuery:j,selectedAgents:b,agentsOnCurrentPage:w,refreshAgents:S,allTags:p,agentPolicies:e,sortField:L,sortOrder:_,unsupportedMigrateAgents:D,unsupportedPrivilegeLevelChangeAgents:O})):null))))};var Ut=a(7817);const Ht=({agent:e,agentPolicy:t,onReassignClick:a,onUnenrollClick:l,onGetUninstallCommandClick:n,onUpgradeClick:i,onAddRemoveTagsClick:o,onRequestDiagnosticsClick:r,onMigrateAgentClick:d,onChangeAgentPrivilegeLevelClick:c})=>{const{getHref:p}=(0,u.iEg)(),f=(0,Ut.i)(),x=(0,u.RR_)(),h="unenrolling"===e.status,y=N.ZX.get().enableAgentPrivilegeLevelChange,[E,v]=(0,s.useState)(!1),k=[(0,R.jsx)(g.EuiContextMenuItem,{icon:"inspect",href:p("agent_details",{agentId:e.id}),key:"viewAgent"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.viewActionText",defaultMessage:"View agent"}))];return f.fleet.allAgents&&(0,T.Yq)(e,t)&&k.push((0,R.jsx)(g.EuiContextMenuItem,{icon:"cluster",onClick:()=>{d(),v(!1)},disabled:!e.active||!x.hasAtLeast(te.NY3),key:"migrateAgent","data-test-subj":"migrateAgentMenuItem"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentActionText",defaultMessage:"Migrate agent"}))),f.fleet.allAgents&&!1===(null==t?void 0:t.is_managed)&&(k.push((0,R.jsx)(g.EuiContextMenuItem,{icon:"tag",onClick:e=>{o(e.target.closest("button"))},disabled:!e.active,key:"addRemoveTags"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addRemoveTagsActionText",defaultMessage:"Add / remove tags"})),(0,R.jsx)(g.EuiContextMenuItem,{icon:"pencil",onClick:()=>{a()},disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),key:"reassignPolicy"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,R.jsx)(g.EuiContextMenuItem,{key:"agentUnenrollBtn",disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),icon:"trash",onClick:()=>{l()}},h?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"})),(0,R.jsx)(g.EuiContextMenuItem,{key:"agentUpgradeBtn",icon:"refresh",disabled:!(0,N._3)(e)||!0===(null==t?void 0:t.supports_agentless),onClick:()=>{i()},"data-test-subj":"upgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))),f.fleet.allAgents&&(0,je.isStuckInUpdating)(e)&&k.push((0,R.jsx)(g.EuiContextMenuItem,{key:"agentRestartUpgradeBtn",icon:"refresh",onClick:()=>{i()},"data-test-subj":"restartUpgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))),!f.fleet.allAgents||!e.policy_id||null!=t&&t.supports_agentless||k.push((0,R.jsx)(g.EuiContextMenuItem,{icon:"minusInCircle",onClick:()=>{n(),v(!1)},disabled:!e.active,key:"getUninstallCommand","data-test-subj":"uninstallAgentMenuItem"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.getUninstallCommand",defaultMessage:"Uninstall agent"})))),f.fleet.allAgents&&(0,T.f9)(e,t)&&y&&k.push((0,R.jsx)(g.EuiContextMenuItem,{icon:"lock",onClick:()=>{c(),v(!1)},disabled:!e.active,key:"changeAgentPrivilegeLevel","data-test-subj":"changeAgentPrivilegeLevelMenuItem"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelActionText",defaultMessage:"Remove root privilege"}))),f.fleet.readAgents&&k.push((0,R.jsx)(g.EuiContextMenuItem,{key:"requestAgentDiagnosticsBtn",icon:"download","data-test-subj":"requestAgentDiagnosticsBtn",disabled:!(0,T.fx)(e),onClick:()=>{r()}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))),(0,R.jsx)(F.AK,{isOpen:E,onChange:e=>v(e),items:k})};var Wt=a(61971);const Gt={POLICY_REASSIGN:{inProgressText:"Reassigning",completedText:"assigned to a new policy",cancelledText:"assignment"},UPGRADE:{inProgressText:"Upgrading",completedText:"upgraded",cancelledText:"upgrade"},UNENROLL:{inProgressText:"Unenrolling",completedText:"unenrolled",cancelledText:"unenrollment"},FORCE_UNENROLL:{inProgressText:"Force unenrolling",completedText:"force unenrolled",cancelledText:"force unenrollment"},AUTOMATIC_FORCE_UNENROLL:{inProgressText:"Automatic unenrolling",completedText:"automatically unenrolled",cancelledText:"automatic unenrollment"},UPDATE_TAGS:{inProgressText:"Updating tags of",completedText:"updated tags",cancelledText:"update tags"},CANCEL:{inProgressText:"Cancelling",completedText:"cancelled",cancelledText:""},REQUEST_DIAGNOSTICS:{inProgressText:"Requesting diagnostics for",completedText:"requested diagnostics",cancelledText:"request diagnostics"},SETTINGS:{inProgressText:"Updating settings of",completedText:"updated settings",cancelledText:"update settings"},POLICY_CHANGE:{inProgressText:"Applying policy change on",completedText:"applied policy change",cancelledText:"policy change"},INPUT_ACTION:{inProgressText:"Input action in progress of",completedText:"input action completed",cancelledText:"input action"},MIGRATE:{inProgressText:"Migrating",completedText:"migrated",cancelledText:"migration"},PRIVILEGE_LEVEL_CHANGE:{inProgressText:"Changing privilege level of",completedText:"changed privilege level",cancelledText:"change privilege level"},ACTION:{inProgressText:"Actioning",completedText:"actioned",cancelledText:"action"}},Kt=(e,t)=>{var a;return null!=t&&t.includes("UnenrollInactiveAgentsTask-")?Gt.AUTOMATIC_FORCE_UNENROLL:null!==(a=Gt[null!=e?e:"ACTION"])&&void 0!==a?a:Gt.ACTION},qt=(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivity.inProgressTitle",defaultMessage:"{inProgressText} {nbAgents} {agents}{reassignText}{upgradeText}{failuresText}{automaticIcon}",values:{nbAgents:e.nbAgentsAck>=e.nbAgentsActioned?e.nbAgentsAck:0===e.nbAgentsAck?e.nbAgentsActioned:e.nbAgentsActioned-e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",inProgressText:Kt(e.type,e.actionId).inProgressText,reassignText:"POLICY_REASSIGN"===e.type&&e.newPolicyId?`to ${e.newPolicyId}`:"",upgradeText:"UPGRADE"===e.type?` to version ${e.version}`:"",failuresText:e.nbAgentsFailed>0?`, has ${e.nbAgentsFailed} failure(s)`:"",automaticIcon:t?(0,R.jsx)(g.EuiIconTip,{anchorProps:{style:{display:"flex",alignItems:"center"}},type:"timeRefresh",content:"Triggered by an automatic upgrade"}):null}})),Vt=e=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.startedDescription",defaultMessage:"Started on {date}.",values:{date:$t(e)}}),$t=e=>e?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})," ",(0,R.jsx)(m.FormattedTime,{value:e})):null,Yt=({action:e,onClickViewAgents:t})=>{const a=(0,s.useMemo)((()=>e.nbAgentsActionCreated>1e3),[e]);if("UPDATE_TAGS"===e.type)return null;const l=(0,R.jsx)(g.EuiButtonEmpty,{size:"m",onClick:()=>t(e),"data-test-subj":"agentActivityFlyout.viewAgentsButton",disabled:a},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButton",defaultMessage:"View Agents"}));return a?(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonDisabledMaxTooltip",defaultMessage:"The view agents feature is only available for action impacting less than {agentCount} agents",values:{agentCount:1e3}})},l):"POLICY_CHANGE"===e.type?(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonPolicyChangeTooltip",defaultMessage:"View agents currently assigned to this policy"})},l):l},Qt=(0,Wt.A)("div",{target:"egpilro0"})("width:0;height:50%;border-left:",(e=>e.theme.euiTheme.border.thin),";position:relative;top:50%;transform:translateY(-50%);"),Xt=({action:e,abortUpgrade:t,onClickViewAgents:a,onClickManageAutoUpgradeAgents:n})=>{const{docLinks:i}=(0,u.WeA)(),o=(0,g.useEuiTheme)(),r=e.is_automatic,[d,c]=(0,s.useState)(!1),p=(0,s.useCallback)((async()=>{try{c(!0),await t(e)}finally{c(!1)}}),[e,t]),f=(0,s.useMemo)((()=>{if(!e.startTime)return!1;const t=Date.now();return new Date(e.startTime).getTime()>t}),[e]),x=(0,s.useMemo)((()=>f||e.hasRolloutPeriod),[e,f]);return(0,R.jsx)(g.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:"subdued","data-test-subj":"upgradeInProgressDescription"},(0,R.jsx)("p",null,f&&e.startTime?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduledDescription",defaultMessage:"Scheduled for "}),(0,R.jsx)("strong",null,$t(e.startTime)),". "):(0,R.jsx)(l().Fragment,null,Vt(e.creationTime)," ")))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},f?(0,R.jsx)(g.EuiIcon,{type:"clock"}):(0,R.jsx)(g.EuiLoadingSpinner,{size:"m"})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:o.euiTheme.colors.textPrimary,"data-test-subj":"upgradeInProgressTitle"},f&&e.startTime?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduleTitle",defaultMessage:"{nbAgents} agents scheduled to upgrade to version {version}",values:{nbAgents:e.nbAgentsActioned-e.nbAgentsAck,version:e.version}}):qt(e,r))))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"column",alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Yt,{action:e,onClickViewAgents:a})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Qt,null)),r&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{"data-test-subj":"manageAutoUpgradesButton",onClick:()=>n(e),size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.manageAutoUpgradeAgents",defaultMessage:"Manage auto-upgrade agents"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Qt,null))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,null,(0,R.jsx)(g.EuiLink,{href:i.links.fleet.upgradeElasticAgent,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.guideLink",defaultMessage:"Learn more"}))))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},x?(0,R.jsx)(g.EuiButton,{size:"s",onClick:p,isLoading:d,"data-test-subj":"abortBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.abortUpgradeButtom",defaultMessage:"Cancel"})):null)))))};var Jt=a(57016);const Zt=({agentId:e,datasets:t,logLevels:a,userQuery:s})=>{const l=`${Jt.JQ.name}:${e}`,n=t.length?t.map((e=>`${Jt.Ep.name}:${e}`)).join(" or "):`${Jt.Ep.name}:${Jt.tO} or ${Jt.Ep.name}:${Jt.sn}`,i=a.map((e=>`${Jt.Jt.name}:${e}`)).join(" or "),o=`${l} and (${n})`,r=i?`${o} and (${i})`:o;return s?`(${r}) and (${s})`:r};var ea=a(66764);const ta=e=>new Date(e).getTime(),aa=({logStreamQuery:e,startTime:t,endTime:a})=>{const{share:l}=(0,u.WeA)(),n=(0,ea.getLogsLocatorFromUrlService)(l.url),i=(0,u.iO7)(),o=(0,s.useMemo)((()=>{const s=Le()().toISOString(),l=Le()().subtract(1,"day").toISOString(),i=ta(l),o=ta(s);return null==n?void 0:n.getRedirectUrl({time:a||o,timeRange:{from:(0,ea.getTimeRangeStartFromTime)(t||i),to:(0,ea.getTimeRangeEndFromTime)(a||o)},query:{language:"kuery",query:e}})}),[a,e,n,t]);return i.fleet.readAgents&&o?(0,R.jsx)(g.EuiButton,{href:o,iconType:"discoverApp","data-test-subj":"viewInLogsBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.openInDiscoverUiLinkText",defaultMessage:"Open in Discover"})):null},sa=P()(g.EuiText).withConfig({displayName:"TruncatedEuiText",componentId:"sc-1ioa7tn-0"})(["overflow:hidden;max-height:3rem;text-overflow:ellipsis;"]),la=({action:e})=>{var t;const a=(0,u.WeA)(),s=(0,g.useEuiTheme)(),n=[{field:"hostname",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.hostnameColumnTitle",{defaultMessage:"Host Name"}),render:e=>l().createElement(g.EuiText,{size:"s","data-test-subj":"hostText"},e)},{field:"error",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.errorColumnTitle",{defaultMessage:"Error Message"}),render:e=>l().createElement(g.EuiToolTip,{content:e},l().createElement(sa,{size:"s",color:s.euiTheme.colors.textDanger,"data-test-subj":"errorText"},e))},{field:"agentId",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.actionColumnTitle",{defaultMessage:"Action"}),render:t=>{var s;const n=(null!==(s=e.latestErrors)&&void 0!==s?s:[]).find((e=>e.agentId===t));return l().createElement(v.V,{coreStart:a},((e,t)=>{const a=Le()(t).subtract(5,"m").toISOString(),s=Le()(t).add(5,"m").toISOString(),n=ta(a),i=ta(s),o=Zt({agentId:e,datasets:["elastic_agent"],logLevels:["error"],userQuery:""});return l().createElement(aa,{logStreamQuery:o,startTime:n,endTime:i})})(t,n.timestamp))}}];return l().createElement(l().Fragment,null,l().createElement(g.EuiAccordion,{id:e.actionId+"_errors",buttonContent:"Show errors"},l().createElement(g.EuiBasicTable,{items:null!==(t=e.latestErrors)&&void 0!==t?t:[],columns:n,tableLayout:"auto"})))},na=(0,Wt.A)("div",{target:"eqazjax0"})("width:0;height:50%;border-left:",(e=>e.theme.euiTheme.border.thin),";position:relative;top:50%;transform:translateY(-50%);"),ia=({action:e,onClickViewAgents:t,onClickManageAutoUpgradeAgents:a})=>{const s=(0,g.useEuiTheme)(),n=e.is_automatic,i="POLICY_CHANGE"===e.type&&0===e.nbAgentsActioned?(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivity.policyChangeCompletedTitle",defaultMessage:"Policy changed"})):(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivity.completedTitle",defaultMessage:"{nbAgents} {agents} {completedText}{versionText}{offlineText}{automaticIcon}",values:{nbAgents:e.nbAgentsAck===e.nbAgentsActioned?e.nbAgentsAck:e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",completedText:Kt(e.type,e.actionId).completedText,offlineText:"ROLLOUT_PASSED"===e.status&&e.nbAgentsActioned-e.nbAgentsAck>0?`, ${e.nbAgentsActioned-e.nbAgentsAck} agent(s) offline during the rollout period`:"",versionText:e.version?` to version ${e.version}`:"",automaticIcon:e.is_automatic?(0,R.jsx)(g.EuiIconTip,{anchorProps:{style:{display:"flex",alignItems:"center"}},type:"timeRefresh",content:"Triggered by an automatic upgrade"}):null}}))))),o=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.completedDescription",defaultMessage:"Completed {date}",values:{date:"0001-01-01T00:00:00.000Z"===e.completionTime?null:$t(e.completionTime)}}),r=(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.failureDescription",defaultMessage:"A problem occurred during this operation."})," ",Vt(e.creationTime))),u={IN_PROGRESS:{icon:(0,R.jsx)(g.EuiLoadingSpinner,{size:"m"}),title:(0,R.jsx)(g.EuiText,null,qt(e,e.is_automatic)),titleColor:s.euiTheme.colors.textPrimary,description:(0,R.jsx)(g.EuiText,{color:"subdued"},Vt(e.creationTime))},ROLLOUT_PASSED:{icon:e.nbAgentsFailed>0?(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"danger"}):(0,R.jsx)(g.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"success"}),title:i,titleColor:e.nbAgentsFailed>0?s.euiTheme.colors.textDanger:s.euiTheme.colors.textSuccess,description:e.nbAgentsFailed>0?r:(0,R.jsx)(g.EuiText,{color:"subdued"},o)},COMPLETE:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"success"}),title:i,titleColor:s.euiTheme.colors.textSuccess,description:"POLICY_REASSIGN"===e.type&&e.newPolicyId?(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.reassignCompletedDescription",defaultMessage:"Assigned to {policy}.",values:{policy:e.newPolicyId}})," ",o)):"POLICY_CHANGE"===e.type?(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)("p",null,(0,R.jsx)("b",null,e.policyId)," ",(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.policyChangedDescription",defaultMessage:"changed to revision {rev} at {date}.",values:{rev:e.revision,date:$t(e.creationTime)}}))):(0,R.jsx)(g.EuiText,{color:"subdued"},o)},FAILED:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"danger"}),title:i,titleColor:s.euiTheme.colors.textDanger,description:r},CANCELLED:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"subdued"}),titleColor:s.euiTheme.colors.textSubdued,title:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledTitle",defaultMessage:"Agent {cancelledText} cancelled",values:{cancelledText:Kt(e.type,e.actionId).cancelledText}})),description:(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledDescription",defaultMessage:"Cancelled on {date}",values:{date:$t(e.cancellationTime)}}))},EXPIRED:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"subdued"}),titleColor:s.euiTheme.colors.textSubdued,title:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredTitle",defaultMessage:"Agent {expiredText} expired",values:{expiredText:Kt(e.type,e.actionId).cancelledText}})),description:(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredDescription",defaultMessage:"Expired on {date}",values:{date:$t(e.expiration)}}))}};return(0,R.jsx)(g.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},u[e.status].icon),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:u[e.status].titleColor,"data-test-subj":"statusTitle"},u[e.status].title)))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:"subdued","data-test-subj":"statusDescription"},u[e.status].description)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},"FAILED"===e.status&&e.latestErrors&&e.latestErrors.length>0?(0,R.jsx)(la,{action:e}):null)),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Yt,{action:e,onClickViewAgents:t})),n&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(na,null)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{"data-test-subj":"manageAutoUpgradesButton",onClick:()=>a(e),size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.manageAutoUpgradeAgents",defaultMessage:"Manage auto-upgrade agents"}))))))},oa=({title:e,actions:t,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n})=>(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiPanel,{color:"subdued",hasBorder:!0,borderRadius:"none"},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs",alignItems:"center"},t.some((e=>"IN_PROGRESS"===e.status))&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiHealth,{color:"success"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("b",null,e))))),t.map((e=>"UPGRADE"===e.type&&"IN_PROGRESS"===e.status?(0,R.jsx)(Xt,{action:e,abortUpgrade:a,key:e.actionId,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}):(0,R.jsx)(ia,{action:e,key:e.actionId,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n})))),ra=e=>(0,R.jsx)(g.EuiDatePicker,{"data-test-subj":"agentActivityFlyout.goToDateButton",selected:e.selectedDate,onChange:e.onChangeSelectedDate,maxDate:Le()(),customInput:e.filledStyle?(0,R.jsx)(ua,e):(0,R.jsx)(da,e)}),ua=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,R.jsx)(g.EuiButton,{fill:!0,onClick:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.goToDateButton",defaultMessage:"Go to date"})))),da=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,R.jsx)(g.EuiButtonEmpty,{size:"m",flush:"left",onClick:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.goToDateButton",defaultMessage:"Go to date"})))),ca=()=>(new Date).toISOString().substring(0,10),ga=P()(g.EuiFlyoutBody).withConfig({displayName:"FullHeightFlyoutBody",componentId:"sc-1p58nye-0"})([".euiFlyoutBody__overflowContent{height:100%;}"]),pa=P()(g.EuiFlexGroup).withConfig({displayName:"ButtonsFlexGroup",componentId:"sc-1p58nye-1"})(["padding-left:24px;"]),ma=P().div.withConfig({displayName:"ScrollAnchor",componentId:"sc-1p58nye-2"})(["height:0;margin:0;padding:0;"]),fa=({isFirstLoading:e,currentActions:t,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n,areActionsFullyLoaded:i,onClickShowMore:o,dateFilter:r,onChangeDateFilter:u})=>{const d=l().useRef(null);if(l().useEffect((()=>{var e;null!==(e=d.current)&&void 0!==e&&e.scrollIntoView&&d.current.scrollIntoView()}),[r]),e)return l().createElement(ga,null,l().createElement(g.EuiFlexGroup,{direction:"row",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},l().createElement(g.EuiFlexItem,null,l().createElement(U.Rh,null))));if(0===t.length)return l().createElement(ga,null,l().createElement(ma,{ref:d}),l().createElement(g.EuiFlexGroup,{direction:"column",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiEmptyPrompt,{iconType:"clock",iconColor:"default",title:l().createElement("h2",null," ",l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityText",defaultMessage:"No activity to display"})),titleSize:"m",body:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityDescription",defaultMessage:"Activity feed will appear here as agents are reassigned, upgraded, or unenrolled."})})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ra,{selectedDate:r,onChangeSelectedDate:u,filledStyle:!0})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{onClick:()=>u(null)},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.showMoreButton",defaultMessage:"Clear selected date"})))));const c=t.filter((e=>"IN_PROGRESS"===e.status)),p=t.filter((e=>"IN_PROGRESS"!==e.status)),f=p.filter((e=>e.creationTime.startsWith(ca()))),x=function(e){const t={};return e.filter((e=>!e.creationTime.startsWith(ca()))).forEach((e=>{const a=e.creationTime.substring(0,10);t[a]||(t[a]=[]),t[a].push(e)})),t}(p);return l().createElement(ga,null,l().createElement(ma,{ref:d}),l().createElement(g.EuiFlexGroup,{direction:"column"},l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiFlexGroup,{direction:"column"},c.length>0?l().createElement(oa,{title:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.inProgressTitle",defaultMessage:"In progress"}),actions:c,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}):null,f.length>0?l().createElement(oa,{title:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.todayTitle",defaultMessage:"Today"}),actions:f,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}):null,Object.keys(x).map((e=>l().createElement(oa,{key:e,title:l().createElement(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"}),actions:x[e],abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:n}))))),l().createElement(g.EuiFlexItem,null,l().createElement(pa,{direction:"row",gutterSize:"s",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{size:"m",onClick:o,disabled:i,flush:"left","data-test-subj":"agentActivityFlyout.showMoreButton"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.showMoreButton",defaultMessage:"Show more"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ra,{selectedDate:r,onChangeSelectedDate:u,filledStyle:!1})),r&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{size:"m",onClick:()=>u(null),flush:"left","data-test-subj":"agentActivityFlyout.clearSelectedDateButton"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.clearSelectedDateutton",defaultMessage:"Clear selected date"})))))))},xa=P()(g.EuiFlyoutFooter).withConfig({displayName:"FlyoutFooterWPadding",componentId:"sc-7yfogs-0"})(["padding:16px 24px !important;"]),ha=({onClose:e,onAbortSuccess:t,refreshAgentActivity:a,setSearch:n,setSelectedStatus:i,openManageAutoUpgradeModal:o})=>{const{notifications:r}=(0,u.WeA)(),{data:d}=(0,u.$sk)({perPage:M.W}),[c,p]=(0,s.useState)(20),[x,h]=(0,s.useState)(null),{currentActions:y,abortUpgrade:E,isFirstLoading:v,areActionsFullyLoaded:k}=function(e,t,a,l){const[n,i]=(0,s.useState)(!0),[o,r]=(0,s.useState)([]),[d,c]=(0,s.useState)(0),[g,p]=(0,s.useState)(!1),{notifications:m,overlays:x}=(0,u.WeA)(),h=(0,s.useCallback)((async()=>{try{const e=await(0,u.RYf)({perPage:a,date:null==l?void 0:l.format()});if(i(!1),e.error)throw e.error;if(!e.data)throw new Error("No data");p(d<a),c(e.data.items.length),r(e.data.items)}catch(e){m.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.actionStatus.fetchRequestError",{defaultMessage:"An error happened while fetching action status"})})}}),[a,l,d,m.toasts]);return n&&h(),(0,s.useEffect)((()=>{t&&h()}),[h,t]),(0,s.useEffect)((()=>{h()}),[h,a]),{currentActions:o,abortUpgrade:(0,s.useCallback)((async t=>{try{if(!await x.openConfirm(f.i18n.translate("xpack.fleet.currentUpgrade.confirmDescription",{defaultMessage:"This action will cancel upgrade of {nbAgents, plural, one {# agent} other {# agents}}",values:{nbAgents:t.nbAgentsActioned-t.nbAgentsAck}}),{title:f.i18n.translate("xpack.fleet.currentUpgrade.confirmTitle",{defaultMessage:"Cancel upgrade?"})}))return;await(0,u.DRU)(t.actionId),await Promise.all([h(),e()])}catch(e){m.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.currentUpgrade.abortRequestError",{defaultMessage:"An error happened while cancelling upgrade"})})}}),[h,m.toasts,x,e]),isFirstLoading:n,areActionsFullyLoaded:g}}(t,a,c,x),j=(0,s.useCallback)((e=>{var t;const a=null==d?void 0:d.items.find((t=>t.id===e));return null!==(t=null==a?void 0:a.name)&&void 0!==t?t:e}),[d]),b=(0,s.useMemo)((()=>y.map((e=>{var t,a;return{...e,newPolicyId:j(null!==(t=e.newPolicyId)&&void 0!==t?t:""),policyId:e.policyId?e.policyId:j(null!==(a=e.newPolicyId)&&void 0!==a?a:"")}}))),[y,j]);return l().createElement(l().Fragment,null,l().createElement(g.EuiFlyout,{"data-test-subj":"agentActivityFlyout",onClose:()=>{a=!1,e()},paddingSize:"none",maxWidth:M.MW},l().createElement(g.EuiFlyoutHeader,{"aria-labelledby":"FleetAgentActivityFlyoutTitle"},l().createElement(g.EuiPanel,{borderRadius:"none",hasShadow:!1,hasBorder:!0},l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiTitle,{size:"l"},l().createElement("h1",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.title",defaultMessage:"Agent activity"})))),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{color:"subdued"},l().createElement("p",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.activityLogText",defaultMessage:"Activity log of Elastic Agent operations will appear here."}))))))),l().createElement(fa,{isFirstLoading:v,currentActions:b,abortUpgrade:E,onClickViewAgents:async t=>{try{var a;const{data:s}=await(0,u.DTC)({actionIds:[t.actionId]});if(null!=s&&null!==(a=s.items)&&void 0!==a&&a.length){const e=ut({selectedAgentIds:s.items});n(e)}i(Ge),e()}catch(e){r.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentActivityFlyout.error",{defaultMessage:"Error viewing selected agents"})})}},onClickManageAutoUpgradeAgents:async t=>{e(),o(t.policyId)},areActionsFullyLoaded:k,onClickShowMore:()=>{p(c+10)},dateFilter:x,onChangeDateFilter:e=>{var t;h(null!==(t=null==e?void 0:e.startOf("day"))&&void 0!==t?t:null),p(20)}}),l().createElement(xa,null,l().createElement(g.EuiFlexGroup,{justifyContent:"flexStart"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{onClick:e},l().createElement(g.EuiText,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.closeBtn",defaultMessage:"Close"}))))))))},ya=()=>{var e;const{cloud:t}=(0,u.WeA)();(0,u.ifo)("agent_list");const[a,n]=(0,s.useState)([]),[i,r]=(0,s.useState)("manual"),[d,c]=(0,s.useState)({isOpen:!1}),[p,m]=(0,s.useState)(!1),[h,y]=(0,s.useState)(!1),[E,v]=(0,s.useState)(),k=(0,u.Wdf)(),[j,b]=(0,s.useState)(void 0),[S,I]=(0,s.useState)(void 0),[w,A]=(0,s.useState)(void 0),[C,P]=(0,s.useState)(void 0),[L,_]=(0,s.useState)(void 0),[D,O]=(0,s.useState)(),[B,z]=(0,s.useState)(!1),[H,W]=(0,s.useState)(void 0),[G,K]=(0,s.useState)(void 0),[q,V]=(0,s.useState)(void 0),[$,Y]=(0,s.useState)(!1),{allTags:Q,agentsOnCurrentPage:X,agentsStatus:Z,isLoading:ee,nAgentsInTable:te,totalInactiveAgents:ae,totalManagedAgentIds:se,managedAgentsOnCurrentPage:le,showUpgradeable:ne,setShowUpgradeable:oe,search:re,setSearch:ue,selectedAgentPolicies:de,setSelectedAgentPolicies:ce,sortField:ge,setSortField:pe,sortOrder:me,setSortOrder:fe,selectedStatus:xe,setSelectedStatus:he,selectedTags:ye,setSelectedTags:Ee,allAgentPolicies:ve,agentPoliciesRequest:ke,agentPoliciesIndexedById:Se,pagination:Me,pageSizeOptions:Ie,setPagination:Te,kuery:we,draftKuery:Ae,setDraftKuery:Ce,fetchData:Pe,queryHasChanged:Le,latestAgentActionErrors:_e,setLatestAgentActionErrors:De}=function(){const e=function(){const e=(0,u.iO7)(),t=(0,s.useRef)({}),a=(0,s.useCallback)((async a=>{const s=a.reduce(((e,a)=>(t.current[a]||e.push(a),e)),[]);return s.length&&(await(0,u.mN5)(s,{full:e.fleet.readAgentPolicies,ignoreMissing:!0})).items.forEach((e=>{t.current[e.id]=e})),a.reduce(((e,a)=>(t.current[a]&&e.push(t.current[a]),e)),[])}),[e.fleet.readAgentPolicies]);return(0,s.useMemo)((()=>({fetchPolicies:a})),[a])}(),{notifications:t}=(0,u.WeA)(),a=(0,o.useHistory)(),{urlParams:l,toUrlParams:n}=(0,u.zmo)(),{showAgentless:i}=(0,u.jXQ)(),r=l.kuery||"",d="true"===l.showInactive,[c,g]=(0,s.useState)(!1),[p,m]=(0,s.useState)(r),[h,y]=(0,s.useState)(r),{pagination:E,pageSizeOptions:v,setPagination:k}=(0,u.WQC)(),[j,b]=(0,s.useState)("enrolled_at"),[S,F]=(0,s.useState)("desc"),[I,w]=(0,s.useState)([]),[A,C]=(0,s.useState)(["healthy","unhealthy","orphaned","updating","offline",...d?["inactive"]:[]]),[P,L]=(0,s.useState)([]),_=(0,s.useMemo)((()=>A.some((e=>"inactive"===e))||0===A.length),[A]),D=(0,s.useMemo)((()=>A.some((e=>"unenrolled"===e))||0===A.length),[A]),O=(0,s.useCallback)((e=>{y(e),(""!==e.trim()||l.kuery)&&l.kuery!==e&&a.replace({search:n({...l,kuery:""===e?void 0:e})})}),[l,a,n]);let R=(0,s.useMemo)((()=>ut({search:h,selectedAgentPolicies:I,selectedTags:P,selectedStatus:A})),[h,I,A,P]);R=D&&R?`status:* AND (${R})`:D?"status:*":R;const[B,z]=(0,s.useState)(),[U,H]=(0,s.useState)([]),{data:W}=(0,x.useQuery)({refetchInterval:3e4,queryKey:["get-action-statuses"],initialData:[],queryFn:async()=>{var e;return(null===(e=(await(0,u.RYf)({latest:35e3,perPage:100})).data)||void 0===e?void 0:e.items.filter((e=>{var t,a;return null!==(t=null===(a=e.latestErrors)||void 0===a?void 0:a.length)&&void 0!==t&&t})).map((e=>e.actionId)))||[]}});(0,s.useEffect)((()=>{const e=[...new Set([...U,...W])];(0,J.isEqual)(U,e)||H(e)}),[U,W]);const G=JSON.stringify({pagination:E,sortField:j,sortOrder:S}),K=JSON.stringify({kuery:R,showAgentless:i,showInactive:_,showUpgradeable:c,search:h,selectedTags:P,selectedStatus:A}),{isInitialLoading:q,isFetching:V,data:$,refetch:Y}=(0,x.useQuery)({queryKey:["get-agents-list",K,G],keepPreviousData:!0,queryFn:async()=>{try{var a,s;const[t,n,o,r]=await Promise.all([(0,u.R3_)({page:E.currentPage,perPage:E.pageSize,kuery:R&&""!==R?R:void 0,sortField:gt(j),sortOrder:S,showAgentless:i,showInactive:_,showUpgradeable:c,getStatusSummary:!0,withMetrics:!0}),(0,u.Wwg)({kuery:N.ir.buildKueryForInactiveAgents()}),(0,u.cnO)({kuery:`${M.mm}.is_managed:true`,perPage:M.W,full:!1}),(0,u.FnK)({showInactive:_})]);if(!n.data)throw new Error("Invalid GET /agents_status response");if(o.error)throw new Error(o.error.message);const d=t.statusSummary;if(!d)throw new Error("Invalid GET /agents response - no status summary");const g=t.items.map((e=>e.policy_id)),p=(await e.fetchPolicies(g)).reduce(((e,t)=>(e[t.id]=t,e)),{}),m=(0,T.db)(d),f=[...r.items],x=t.items,y=t.total,v=n.data.results.inactive||0,k=null!==(a=null===(s=o.data)||void 0===s?void 0:s.items)&&void 0!==a?a:[];let b=[],F=0;if(0!==k.length){var l;const e=ut({search:h,selectedAgentPolicies:k.map((e=>e.id)),selectedTags:P,selectedStatus:A}),a=await(0,u.R3_)({kuery:`${e}`,perPage:M.W,showInactive:_}),s=null!==(l=null==a?void 0:a.items)&&void 0!==l?l:[],n=null==s?void 0:s.map((e=>e.id));b=n,F=t.items.map((e=>e.id)).filter((e=>n.includes(e))).length}return{agentPoliciesIndexedById:p,agentsStatus:m,agentsOnCurrentPage:x,nAgentsInTable:y,totalInactiveAgents:v,newAllTags:f,totalManagedAgentIds:b,managedAgentsOnCurrentPage:F,queryKeyFilters:K}}catch(e){throw t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.errorFetchingDataTitle",{defaultMessage:"Error fetching agents"})}),e}},refetchInterval:3e4}),Q=null==$?void 0:$.agentsStatus,X=(0,s.useMemo)((()=>(null==$?void 0:$.agentsOnCurrentPage)||[]),[$]),Z=(null==$?void 0:$.nAgentsInTable)||0,ee=(null==$?void 0:$.totalInactiveAgents)||0,te=(null==$?void 0:$.agentPoliciesIndexedById)||{},ae=(null==$?void 0:$.totalManagedAgentIds)||[],se=(null==$?void 0:$.managedAgentsOnCurrentPage)||0,le=(0,s.useMemo)((()=>(null==$?void 0:$.newAllTags)||[]),[$]);(0,s.useEffect)((()=>{le.length&&!(0,J.isEqual)(le,B)&&z(le)}),[le,B]);const ne=(0,s.useCallback)((async({refreshTags:e=!1}={})=>Y()),[Y]),ie=(0,s.useMemo)((()=>!(0,J.isEqual)(K,null==$?void 0:$.queryKeyFilters)),[K,null==$?void 0:$.queryKeyFilters]),oe=(0,u.$sk)({page:1,perPage:M.W}),re=(0,s.useMemo)((()=>{var e;return(null===(e=oe.data)||void 0===e?void 0:e.items)||[]}),[oe.data]);return{allTags:B,setAllTags:z,agentsOnCurrentPage:X,agentsStatus:Q,isLoading:V,isInitialLoading:q,nAgentsInTable:Z,totalInactiveAgents:ee,totalManagedAgentIds:ae,managedAgentsOnCurrentPage:se,showUpgradeable:c,setShowUpgradeable:g,search:h,setSearch:O,selectedAgentPolicies:I,setSelectedAgentPolicies:w,sortField:j,setSortField:b,sortOrder:S,setSortOrder:F,selectedStatus:A,setSelectedStatus:C,selectedTags:P,setSelectedTags:L,allAgentPolicies:re,agentPoliciesRequest:oe,agentPoliciesIndexedById:te,pagination:E,pageSizeOptions:v,setPagination:k,kuery:R,draftKuery:p,setDraftKuery:m,fetchData:ne,queryHasChanged:ie,latestAgentActionErrors:U,setLatestAgentActionErrors:H}}(),Oe=(0,s.useCallback)((e=>{ue(e),Te({...Me,currentPage:1})}),[ue,Me,Te]),Re=!!(re.trim()||de.length||xe.length||ye.length||ne),Be=(0,s.useCallback)((()=>{Ce(""),ue(""),ce([]),he([]),Ee([]),oe(!1)}),[Ce,ue,ce,he,Ee,oe]),Ne=(0,s.useMemo)((()=>[...Array.isArray(a)?a.filter((e=>{var t;return null===(t=Se[e.policy_id])||void 0===t?void 0:t.is_protected})):[],...Array.isArray(a)?a.filter((e=>{var t,a;return null===(t=Se[e.policy_id])||void 0===t||null===(a=t.package_policies)||void 0===a?void 0:a.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===be.FLEET_SERVER_PACKAGE}))})):[],...Array.isArray(a)?a.filter((e=>!(0,T.gL)(e))):[]]),[a,Se]),ze=(0,s.useMemo)((()=>[...Array.isArray(a)?a.filter((e=>{var t,a,s;return!0===(null===(t=e.local_metadata)||void 0===t||null===(a=t.elastic)||void 0===a||null===(s=a.agent)||void 0===s?void 0:s.unprivileged)})):[],...Array.isArray(a)?a.filter((e=>{var t;return(0,T.jr)((null===(t=Se[e.policy_id])||void 0===t?void 0:t.package_policies)||[])})):[],...Array.isArray(a)?a.filter((e=>{var t,a;return null===(t=Se[e.policy_id])||void 0===t||null===(a=t.package_policies)||void 0===a?void 0:a.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===be.FLEET_SERVER_PACKAGE}))})):[],...Array.isArray(a)?a.filter((e=>!(0,T.Zk)(e))):[]]),[a,Se]),Ue=(0,s.useCallback)((e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=Se[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))}),[Se]),Ge=(0,s.useMemo)((()=>{if(!S||!S.policy_id)return!1;const e=Se[S.policy_id];return!!e&&(0,N.ob)(e)}),[S,Se]),[Ke,qe]=(()=>{const{missingOptionalFeatures:e}=(0,u.YI3)(),{storage:t}=(0,u.WeA)(),[a,l]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=t.get(Et);e&&l(Boolean(e))}),[t]),[(0,s.useMemo)((()=>!(a||!e)&&e.includes("encrypted_saved_object_encryption_key_required")),[e,a]),(0,s.useCallback)((()=>{t.set(Et,"true"),l(!0)}),[t])]})(),{isUnhealthy:Ve}=function(){const e=(0,u.iO7)(),{notifications:t}=(0,u.WeA)(),[a,l]=(0,s.useState)(!0),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((async()=>{try{var e;const t=await(0,u.eK3)();if(t.error)throw t.error;null!==(e=t.data)&&void 0!==e&&e.fleet_server.has_active||i(!0),l(!1)}catch(e){t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.fleetServerUnhealthy.requestError",{defaultMessage:"An error happened while fetching fleet server status"})}),l(!1)}}),[t.toasts]);return(0,s.useEffect)((()=>{e.fleet.addAgents||e.fleet.addFleetServers?o():l(!1)}),[o,e.fleet.addAgents,e.fleet.addFleetServers]),{isLoading:a,isUnhealthy:n}}(),{isFleetServerStandalone:$e}=(0,u.GER)(),Ye=Ve&&!$e,{shouldDisplayAgentSoftLimit:Qe}=function(){var e;const t=null===(e=(0,u.UKg)().internal)||void 0===e?void 0:e.activeAgentsSoftLimit,{data:a}=(0,x.useQuery)(["fetch-total-online-agents"],yt,{enabled:void 0!==t});return{shouldDisplayAgentSoftLimit:!(!t||!a)&&a>t}}(),Xe=(0,s.useCallback)((()=>{k.openFleetServerFlyout()}),[k]),Je=(0,s.useCallback)((()=>{m(!0),De([])}),[m,De]),Ze=({refreshTags:e=!1}={})=>{Pe({refreshTags:e}),Y(!0)};return(0,R.jsx)(l().Fragment,null,p?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(ha,{onAbortSuccess:Pe,onClose:()=>m(!1),openManageAutoUpgradeModal:e=>{v(e),y(!0)},refreshAgentActivity:ee,setSearch:ue,setSelectedStatus:he})):null,h?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(ie.i,{key:E,onClose:()=>y(!1),agentPolicy:ve.find((e=>e.id===E))})):null,d.isOpen?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.rt,{agentPolicy:ve.find((e=>e.id===d.selectedPolicyId)),onClose:()=>{c({isOpen:!1}),Pe(),ke.resendRequest()}})):null,j&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.eN,{agents:[j],onClose:()=>{b(void 0),Ze()}})),S&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.VH,{agents:[S],agentCount:1,onClose:()=>{I(void 0),Ze({refreshTags:!0})},useForceUnenroll:"unenrolling"===S.status,hasFleetServer:Ge})),(null==w?void 0:w.policy_id)&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.pc,{target:"agent",policyId:w.policy_id,onClose:()=>{A(void 0),Ze({refreshTags:!0})}})),C&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.YF,{agents:[C],agentCount:1,onClose:()=>{P(void 0),Ze()},isUpdating:(0,je.isStuckInUpdating)(C)})),H&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:[H],agentCount:1,onClose:()=>{W(void 0)}})),B&&(0,R.jsx)(jt,{agentId:null==L?void 0:L.id,allTags:null!=Q?Q:[],selectedTags:null!==(e=null==L?void 0:L.tags)&&void 0!==e?e:[],button:D,onTagsUpdated:e=>{Ze({refreshTags:!0}),e.length>0&&("No Tags"===ye[0]||we.includes("not tags:*"))&&z(!1)},onClosePopover:()=>{z(!1)}}),G&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(St,{agents:[G],agentCount:1,unsupportedMigrateAgents:[],onClose:()=>{K(void 0)},onSave:()=>{K(void 0),Ze()}})),q&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(It,{agents:[q],agentCount:1,unsupportedAgents:[],onClose:()=>{V(void 0)},onSave:()=>{V(void 0),Ze()}})),Ye&&(0,R.jsx)(l().Fragment,null,null!=t&&t.deploymentUrl?(0,R.jsx)(U.XL,{deploymentUrl:t.deploymentUrl}):(0,R.jsx)(U.T5,{onClickAddFleetServer:Xe}),(0,R.jsx)(g.EuiSpacer,{size:"l"})),Ke&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(U.a4,{onClickHandler:qe}),(0,R.jsx)(g.EuiSpacer,{size:"l"})),Qe&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(We,null),(0,R.jsx)(g.EuiSpacer,{size:"l"})),(0,R.jsx)(zt,{agentPolicies:ve,draftKuery:Ae,onDraftKueryChange:Ce,onSubmitSearch:Oe,selectedAgentPolicies:de,onSelectedAgentPoliciesChange:e=>{"query"===i&&r("manual"),ce(e)},selectedStatus:xe,onSelectedStatusChange:e=>{"query"===i&&r("manual"),he(e)},showUpgradeable:ne,onShowUpgradeableChange:oe,tags:null!=Q?Q:[],selectedTags:ye,onSelectedTagsChange:Ee,nAgentsInTable:te,totalInactiveAgents:ae,totalManagedAgentIds:se,selectionMode:i,currentQuery:we,selectedAgents:a,refreshAgents:Ze,onClickAddAgent:()=>c({isOpen:!0}),onClickAddFleetServer:Xe,agentsOnCurrentPage:X,onClickAgentActivity:Je,shouldShowAgentActivityTour:$,latestAgentActionErrors:_e.length,sortField:ge,sortOrder:me,unsupportedMigrateAgents:Ne,unsupportedPrivilegeLevelChangeAgents:ze}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(tt,{totalAgents:te,totalManagedAgents:se.length||0,agentStatus:Z,selectableAgents:(null==X?void 0:X.filter(Ue).length)||0,managedAgentsOnCurrentPage:le,selectionMode:i,setSelectionMode:r,selectedAgents:a,setSelectedAgents:e=>{n(e),r("manual")},clearFilters:Be,isUsingFilter:Re}),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(He,{agents:X,sortField:ge,pageSizeOptions:Ie,sortOrder:me,isLoading:ee,agentPoliciesIndexedById:Se,renderActions:e=>{const t="string"==typeof e.policy_id?Se[e.policy_id]:void 0;return(null==L?void 0:L.id)!==e.id||(0,J.isEqual)(e.tags,L.tags)||_(e),(0,R.jsx)(Ht,{agent:e,agentPolicy:t,onReassignClick:()=>b(e),onUnenrollClick:()=>I(e),onUpgradeClick:()=>P(e),onAddRemoveTagsClick:t=>{O(t),_(e),z(!B)},onGetUninstallCommandClick:()=>A(e),onRequestDiagnosticsClick:()=>W(e),onMigrateAgentClick:()=>K(e),onChangeAgentPrivilegeLevelClick:()=>V(e)})},onSelectionChange:e=>{if("query"===i&&e.length<a.length){if(!(a.length>0&&0===(0,J.differenceBy)(a,X,"id").length))return n(X.filter((e=>Ue(e))));r("manual")}n(e)},selected:a,showUpgradeable:ne,onTableChange:({page:e,sort:t})=>{const a={...Me,currentPage:e.index+1,pageSize:e.size};Te(a),pe(t.field),fe(t.direction)},pagination:Me,totalAgents:Math.min(te,M.W),isUsingFilter:Re,setEnrollmentFlyoutState:c,clearFilters:Be,queryHasChanged:Le}))};var Ea=a(43609),va=a(94655),ka=a(61215),ja=a(23833),ba=a.n(ja),Sa=a(60362),Fa=a.n(Sa);const Ma=function(e,t={}){const a=l().lazy(e);return l().forwardRef(((e,n)=>{var i;return(0,R.jsx)(s.Suspense,{fallback:null!==(i=t.fallback)&&void 0!==i?i:null},l().createElement(a,{...e,ref:n}))}))}((()=>a.e(741).then(a.bind(a,12741)).then((e=>({default:e.SavedSearchComponent})))));var Ia=a(16524),Ta=a.n(Ia);const wa=(0,s.memo)((({selectedDatasets:e,onToggleDataset:t})=>{const{unifiedSearch:a,data:l}=(0,u.WeA)(),[n,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(!1),[d,c]=(0,s.useState)([Jt.tO]),p=(0,s.useCallback)((()=>i((e=>!e))),[i]),m=(0,s.useCallback)((()=>i(!1)),[i]),x=(0,s.useCallback)((t=>t.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t})))),[e]),[h,y]=(0,s.useState)(x(d));return(0,s.useEffect)((()=>{(async()=>{r(!0);try{const e=(await l.dataViews.getFieldsForWildcard({pattern:Jt.Lr})).reduce(((e,t)=>(e[t.name]=t,e)),{}),t=await l.dataViews.create({title:Jt.Lr,fields:e}),s=await a.autocomplete.getValueSuggestions({indexPattern:t,field:Jt.Ep,query:""});s.length>0&&(c(s.sort()),y(x(s.sort())))}catch(e){c([Jt.tO]),y(x([Jt.tO]))}r(!1)})()}),[l.dataViews,a.autocomplete,x]),(0,R.jsx)(g.EuiPopover,{button:(0,R.jsx)(g.EuiFilterButton,{"data-test-subj":"agentList.datasetFilterBtn",iconType:"arrowDown",onClick:p,isSelected:n,isLoading:o,numFilters:d.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},f.i18n.translate("xpack.fleet.agentLogs.datasetSelectText",{defaultMessage:"Dataset"})),isOpen:n,closePopover:m,panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:h,onChange:e=>{y(e),e.forEach(((e,a)=>{e.checked===h[a].checked||t(e.label)}))},"data-test-subj":"agentList.datasetFilterOptions",isLoading:o,listProps:{paddingSize:"s",style:{minWidth:220}}},(e=>e)))})),Aa=(0,s.memo)((({selectedLevels:e,onToggleLevel:t})=>{const[a,l]=(0,s.useState)(!1),n=(0,s.useCallback)((()=>l((e=>!e))),[]),i=(0,s.useCallback)((()=>l(!1)),[]),[o,r]=(0,s.useState)(te.F$W.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t}))));return(0,R.jsx)(g.EuiPopover,{button:(0,R.jsx)(g.EuiFilterButton,{"data-test-subj":"agentList.logLevelFilterBtn",iconType:"arrowDown",onClick:n,isSelected:a,numFilters:o.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},f.i18n.translate("xpack.fleet.agentLogs.logLevelSelectText",{defaultMessage:"Log level"})),isOpen:a,closePopover:i,panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:o,onChange:e=>{r(e),e.forEach(((e,a)=>{e.checked===o[a].checked||t(e.label)}))},"data-test-subj":"agentList.logLevelFilterOptions",listProps:{paddingSize:"s"}},(e=>e)))})),Ca=[Jt.JQ.name,Jt.Ep.name,Jt.Jt.name],Pa=(0,s.memo)((({query:e,isQueryValid:t,onUpdateQuery:a})=>{const{data:l,unifiedSearch:{ui:{QueryStringInput:n}}}=(0,u.WeA)(),[i,o]=(0,s.useState)();return(0,s.useEffect)((()=>{(async()=>{try{const e=(await l.dataViews.getFieldsForWildcard({pattern:Jt.Lr})||[]).filter((e=>!Ca.includes(e.name)));o(e)}catch(e){o(void 0)}})()}),[l.dataViews]),(0,R.jsx)(n,{iconType:"search",autoSubmit:!0,disableLanguageSwitcher:!0,indexPatterns:i?[{title:Jt.Lr,fields:i}]:[],query:{query:e,language:"kuery"},isInvalid:!t,disableAutoFocus:!0,placeholder:f.i18n.translate("xpack.fleet.agentLogs.searchPlaceholderText",{defaultMessage:"Search logs…"}),onChange:e=>{a(e.query)},onSubmit:e=>{a(e.query,!0)},appName:f.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"})})})),La=P()(g.EuiFlexGroup).withConfig({displayName:"WrapperFlexGroup",componentId:"sc-fcgfrk-0"})(["height:100%;"]),_a=P()(g.EuiFlexItem).withConfig({displayName:"DatePickerFlexItem",componentId:"sc-fcgfrk-1"})(["max-width:312px;"]),Da=(0,ka.createStateContainerReactHelpers)(),Oa=({agentPolicy:e})=>{const{getHref:t}=(0,u.iEg)();return l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiCallOut,{size:"m",color:"primary",iconType:"info",title:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutTitle",defaultMessage:"Log collection is disabled"})},e.is_managed?null:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutDescription",defaultMessage:"Update the agent's policy {settingsLink} to enable logs collection.",values:{settingsLink:l().createElement(g.EuiLink,{href:t("policy_details",{policyId:e.id,tabId:"settings"})},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.settingsLink",defaultMessage:"settings"}))}})))},Ra=(0,s.memo)((({agent:e,agentPolicy:t,state:a})=>{var n,i,o,r;const{application:d,logsDataAccess:{services:{logSourcesService:c}},embeddable:p,data:{search:{searchSource:f},query:{timefilter:{timefilter:x}},dataViews:h}}=(0,u.WeA)(),y=Ta()(c.getFlattenedLogSources),{update:E}=Da.useTransitions(),k=(0,s.useCallback)((e=>{const{min:t,max:a}=x.calculateBounds(e);return t&&a?{start:t.valueOf(),end:a.valueOf()}:void 0}),[x]),j=(0,s.useCallback)((e=>{k(e)&&E({start:e.from,end:e.to})}),[k,E]),b=(0,s.useCallback)((e=>{try{return(0,st.fromKueryExpression)(e),!0}catch(e){return!1}}),[]),[S,F]=(0,s.useState)(a.query),[M,I]=(0,s.useState)(b(a.query)),T=(0,s.useCallback)(((e,t)=>{F(e),b(e)?(I(!0),t&&E({query:e})):I(!1)}),[b,E]),w=(0,s.useMemo)((()=>({language:"kuery",query:Zt({agentId:e.id,datasets:a.datasets,logLevels:a.logLevels,userQuery:a.query})})),[e.id,a.datasets,a.logLevels,a.query]),A=null===(n=e.local_metadata)||void 0===n||null===(i=n.elastic)||void 0===i||null===(o=i.agent)||void 0===o?void 0:o.version;return(0,s.useMemo)((()=>{var e;if(!A)return!1;const t=null===(e=Fa()(A))||void 0===e?void 0:e.version;return!!t&&ba()(t,"7.11.0")}),[A])?l().createElement(La,{direction:"column",gutterSize:"m"},t&&!(null!==(r=t.monitoring_enabled)&&void 0!==r&&r.includes("logs"))&&l().createElement(Oa,{agentPolicy:t}),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexGroup,{gutterSize:"m"},l().createElement(g.EuiFlexItem,null,l().createElement(Pa,{query:S,onUpdateQuery:T,isQueryValid:M})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFilterGroup,null,l().createElement(wa,{selectedDatasets:a.datasets,onToggleDataset:e=>{const t=[...a.datasets],s=t.indexOf(e);s>=0?(t.splice(s,1),E({datasets:t})):E({datasets:[...a.datasets,e]})}}),l().createElement(Aa,{selectedLevels:a.logLevels,onToggleLevel:e=>{const t=[...a.logLevels],s=t.indexOf(e);s>=0?(t.splice(s,1),E({logLevels:t})):E({logLevels:[...a.logLevels,e]})}}))),l().createElement(_a,{grow:!1},l().createElement(g.EuiSuperDatePicker,{showUpdateButton:!1,start:a.start,end:a.end,onTimeChange:({start:e,end:t})=>{j({from:e,to:t})}})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(v.V,{coreStart:{application:d}},l().createElement(aa,{logStreamQuery:w.query,startTime:ta(a.start),endTime:ta(a.end)}))))),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiPanel,{paddingSize:"none",grow:!1},y.value?l().createElement(Ma,{dependencies:{embeddable:p,searchSource:f,dataViews:h},index:y.value,timeRange:{from:a.start,to:a.end},query:w,height:"60vh",displayOptions:{enableDocumentViewer:!0,enableFilters:!1},columns:["@timestamp","event.dataset","component.id","message","error.message"]}):null))):l().createElement(g.EuiCallOut,{size:"m",color:"warning",title:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.oldAgentWarningTitle",defaultMessage:"The Logs view requires Elastic Agent 7.11 or higher. To upgrade an agent, go to the Actions menu, or {downloadLink} a newer version.",values:{downloadLink:l().createElement(g.EuiLink,{href:"https://ela.st/download-elastic-agent",external:!0,target:"_blank"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.downloadLink",defaultMessage:"download"}))}})})})),Ba=(0,s.memo)((({agent:e,agentPolicy:t})=>{const a=(0,s.useMemo)((()=>(0,ka.createStateContainer)({...Jt.ky,...(0,ka.getStateFromKbnUrl)(Jt.CK,window.location.href,{getFromHashQuery:!1})},{update:e=>t=>({...e,...t})})),[]),l=(0,s.useMemo)((()=>Da.connect((e=>({state:e||Jt.ky})))(Ra)),[]),[n,i]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=(0,ka.createKbnUrlStateStorage)({useHashQuery:!1,useHash:!1}),{start:t,stop:s}=(0,ka.syncState)({storageKey:Jt.CK,stateContainer:a,stateStorage:e});return t(),i(!0),()=>{s(),a.set(Jt.ky)}}),[a]),(0,R.jsx)(Da.Provider,{value:a},n?(0,R.jsx)(l,{agent:e,agentPolicy:t}):null)})),Na=(0,s.memo)((({agent:e,onClose:t})=>{var a,s;const l=JSON.stringify(e,null,2),n="string"==typeof(null===(a=e.local_metadata)||void 0===a||null===(s=a.host)||void 0===s?void 0:s.hostname)?e.local_metadata.host.hostname:e.id,{docLinks:i}=(0,u.WeA)(),o=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:t,maxWidth:M.MW,"aria-labelledby":o},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:o},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutTitle",defaultMessage:"''{name}'' agent details",values:{name:n}})))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDescription",defaultMessage:"The JSON below is the raw agent data tracked by Fleet. This data can be useful for debugging or troubleshooting Elastic Agent. For more information, see the {doc}.",values:{doc:(0,R.jsx)(g.EuiLink,{href:i.links.fleet.troubleshooting},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDocLink",defaultMessage:"troubleshooting documentation"}))}}))),(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiCodeBlock,{language:"json",isCopyable:!0},l)),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:t,flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonFlyoutCloseButtonLabel",defaultMessage:"Close"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{iconType:"download",onClick:()=>{const e=document.createElement("a");e.href=`data:text/json;charset=utf-8,${encodeURIComponent(l)}`,e.download=`${n}-agent-details.json`,e.click()}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonDownloadButtonLabel",defaultMessage:"Download JSON"}))))))})),za=(0,s.memo)((({agent:e,assignFlyoutOpenByDefault:t=!1,onCancelReassign:a,agentPolicy:n,onAddRemoveTagsClick:i})=>{const o=(0,u.iO7)(),r=(0,u.RR_)(),d=o.fleet.allAgents,c=(0,va.a)(),[p,f]=(0,s.useState)(t),[x,h]=(0,s.useState)(!1),[y,E]=(0,s.useState)(!1),[v,k]=(0,s.useState)(!1),[j,b]=(0,s.useState)(!1),[S,M]=(0,s.useState)(!1),[I,w]=(0,s.useState)(!1),A="unenrolling"===e.status,C=(0,je.isStuckInUpdating)(e),P=N.ZX.get().enableAgentPrivilegeLevelChange,[L,_]=(0,s.useState)(!1),D=(0,s.useCallback)((e=>{_(e)}),[_]),O=n&&(0,N.ob)(n),B=(0,s.useMemo)((()=>a||(()=>f(!1))),[a,f]),z=[...!d||null!=n&&n.is_managed?[]:[(0,R.jsx)(g.EuiContextMenuItem,{icon:"tag",onClick:e=>{i(e.target.closest("button"))},disabled:!e.active,key:"addRemoveTags"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addRemoveTagsActionText",defaultMessage:"Add / remove tags"})),(0,R.jsx)(g.EuiContextMenuItem,{icon:"pencil",onClick:()=>{f(!0)},disabled:!e.active&&!n||!0===(null==n?void 0:n.supports_agentless),key:"reassignPolicy"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,R.jsx)(g.EuiContextMenuItem,{icon:"refresh",disabled:!(0,N._3)(e)||!0===(null==n?void 0:n.supports_agentless),onClick:()=>{E(!0)},key:"upgradeAgent","data-test-subj":"upgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))],...d&&C?[(0,R.jsx)(g.EuiContextMenuItem,{icon:"refresh",onClick:()=>{E(!0)},key:"restartUpgradeAgent","data-test-subj":"restartUpgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))]:[],(0,R.jsx)(g.EuiContextMenuItem,{icon:"inspect",onClick:()=>{_(!1),b(!j)},key:"agentDetailsJson","data-test-subj":"viewAgentDetailsJsonBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.viewAgentDetailsJsonText",defaultMessage:"View agent JSON"})),...o.fleet.allAgents&&(0,T.Yq)(e,n)?[(0,R.jsx)(g.EuiContextMenuItem,{icon:"cluster",onClick:()=>{_(!1),M(!S)},disabled:!e.active||!r.hasAtLeast(te.NY3),key:"migrateAgent","data-test-subj":"migrateAgentBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentActionText",defaultMessage:"Migrate agent"}))]:[],...o.fleet.allAgents&&(0,T.f9)(e,n)&&P?[(0,R.jsx)(g.EuiContextMenuItem,{icon:"lock",onClick:()=>{_(!1),w(!I)},disabled:!e.active,key:"changeAgentPrivilegeLevel","data-test-subj":"changeAgentPrivilegeLevelBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.changeAgentPrivilegeLevelActionText",defaultMessage:"Remove root privilege"}))]:[],...o.fleet.readAgents?[(0,R.jsx)(g.EuiContextMenuItem,{icon:"download",disabled:!(0,T.fx)(e),onClick:()=>{k(!0)},"data-test-subj":"requestAgentDiagnosticsBtn",key:"requestDiagnostics"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))]:[],...!d||null!=n&&n.is_managed?[]:[(0,R.jsx)(g.EuiContextMenuItem,{icon:"trash",disabled:!d||!e.active||!0===(null==n?void 0:n.supports_agentless),onClick:()=>{h(!0)},key:"unenrollAgent"},A?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"}))]];return(0,R.jsx)(l().Fragment,null,p&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.eN,{agents:[e],onClose:B})),x&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.VH,{agents:[e],agentCount:1,onClose:()=>{h(!1),c()},useForceUnenroll:A,hasFleetServer:O})),y&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.YF,{agents:[e],agentCount:1,onClose:()=>{E(!1),c()},isUpdating:C})),v&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:[e],agentCount:1,onClose:()=>{k(!1)}})),j&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Na,{agent:e,onClose:()=>b(!1)})),S&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(St,{agents:[e],agentCount:1,unsupportedMigrateAgents:[],onClose:()=>{M(!1)},onSave:()=>{M(!1)}})),I&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(It,{agents:[e],agentCount:1,unsupportedAgents:[],onClose:()=>{w(!1)},onSave:()=>{w(!1)}})),(0,R.jsx)(F.AK,{isOpen:L,onChange:D,button:{props:{iconType:"arrowDown",iconSide:"right",color:"primary"},children:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.actionsButton",defaultMessage:"Actions"})},items:z}))})),Ua=P()(g.EuiButton).withConfig({displayName:"EuiButtonCompressed",componentId:"sc-1y6vsns-0"})(["height:32px;"]),Ha=({agent:e,agentPolicy:t})=>{var a,s;const{isInstalled:n,link:i,isLoading:o}=function(e){const{isLoading:t,data:a}=(0,u.E1o)(te.cOw),{spaceId:s}=(0,u.YI3)(),l=function(e,t){var a,s;if("installed"!==(null==t||null===(a=t.item)||void 0===a?void 0:a.status))return!1;const l=t.item.installationInfo;return!(!l||"installed"!==l.install_status)&&(l.installed_kibana_space_id===e||e&&(null===(s=l.additional_spaces_installed_kibana)||void 0===s?void 0:s[e]))}(s,a),n=(0,u.e3j)();return{isLoading:t,isInstalled:l,link:null==n?void 0:n.getRedirectUrl({dashboardId:Dt(s,a,te.K$s.ELASTIC_AGENT_AGENT_METRICS),query:{language:"kuery",query:`elastic_agent.id:${e.id}`}})}}(e),{getHref:r}=(0,u.iEg)(),c=null!==(a=null==t||null===(s=t.monitoring_enabled)||void 0===s?void 0:s.length)&&void 0!==a&&a,p=n&&!o&&c?{href:i}:{disabled:!0},f=l().createElement(Ua,(0,d.default)({},p,{isLoading:o,color:"primary",iconType:"dashboardApp"}),l().createElement(m.FormattedMessage,{"data-test-subj":"agentDetails.viewMoreMetricsButton",id:"xpack.fleet.agentDetails.viewDashboardButtonLabel",defaultMessage:"View more agent metrics"}));return o||c||!t?n?f:l().createElement(g.EuiToolTip,{content:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoIntegrationTooltip",defaultMessage:"Agent dashboard not found, you need to install the elastic_agent integration."})},f):l().createElement(g.EuiToolTip,{content:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoLogsAndMetricsTooltip",defaultMessage:"Logs and metrics for agent are not enabled in the agent policy."})},l().createElement(Ua,{"data-test-subj":"agentDetails.enableLogsAndMetricsButton",isLoading:o,color:"primary",href:r("policy_details",{policyId:t.id,tabId:"settings"}),disabled:null==t?void 0:t.is_managed},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.enableLogsAndMetricsLabel",defaultMessage:"Enable logs and metrics"})))},Wa=P()(g.EuiLink).withConfig({displayName:"TruncatedEuiLink",componentId:"sc-7tcs8-0"})(["overflow:hidden;text-overflow:ellipsis;white-space:nowrap;width:120px;"]),Ga=({outputs:e,isMonitoring:t})=>{var a,n,i,o;const{getHref:r}=(0,u.iEg)(),[d,c]=(0,s.useState)(!1),p=null==e?void 0:e.monitoring,m=null==e?void 0:e.data,x=(0,s.useMemo)((()=>null!=m&&m.integrations?((null==m?void 0:m.integrations)||[]).map(((e,t)=>{var a;return{"data-test-subj":`output-integration-${t}`,label:`${e.integrationPolicyName}: ${e.name}`,href:r("settings_edit_outputs",{outputId:null!==(a=null==e?void 0:e.id)&&void 0!==a?a:""}),iconType:"dot"}})):[]),[r,null==m?void 0:m.integrations]);return l().createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"baseline",responsive:!1,justifyContent:"flexStart"},t?l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Wa,{href:r("settings_edit_outputs",{outputId:null!==(a=null==p||null===(n=p.output)||void 0===n?void 0:n.id)&&void 0!==a?a:""}),title:null==p?void 0:p.output.name,"data-test-subj":"outputNameLink"},null==p?void 0:p.output.name)):l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Wa,{href:r("settings_edit_outputs",{outputId:null!==(i=null==m||null===(o=m.output)||void 0===o?void 0:o.id)&&void 0!==i?i:""}),title:null==m?void 0:m.output.name,"data-test-subj":"outputNameLink"},null==m?void 0:m.output.name)),(null==m?void 0:m.integrations)&&(null==m?void 0:m.integrations.length)>=1&&!t&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiBadge,{color:"hollow","data-test-subj":"outputsIntegrationsNumberBadge",onClick:()=>c(!d),onClickAriaLabel:"Open output integrations popover"},"+",null==m?void 0:m.integrations.length),l().createElement(g.EuiPopover,{"data-test-subj":"outputPopover",isOpen:d,closePopover:()=>c(!1),anchorPosition:"downCenter"},l().createElement(g.EuiPopoverTitle,null,f.i18n.translate("xpack.fleet.AgentPolicyOutputsSummary.popover.title",{defaultMessage:"Output for integrations"})),l().createElement("div",{style:{width:"280px"}},l().createElement(g.EuiListGroup,{listItems:x,color:"primary",size:"s",gutterSize:"none"})))))},Ka=P()(g.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1y4d0ny-0"})(["min-width:0px;"]),qa=(0,s.memo)((({agent:e,agentPolicy:t})=>{var a,s,n,i,o,r,d,c,p,x,h,y,E,v,k,j,b,S,M,I;const T=(0,u.JhS)(),w=(0,u.zQn)(null==t?void 0:t.id),A=null==w||null===(a=w.data)||void 0===a?void 0:a.item;return l().createElement(g.EuiPanel,null,l().createElement(g.EuiDescriptionList,{compressed:!0},l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m","data-test-subj":"agentDetailsOverviewSection"},l().createElement(g.EuiFlexGroup,null,l().createElement(Ka,{grow:5},l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},[{title:l().createElement(g.EuiToolTip,{content:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes"})},l().createElement("span",{tabIndex:0},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTitle",defaultMessage:"CPU"})," ",l().createElement(g.EuiIcon,{type:"info"}))),description:Ae(e.metrics,t)},{title:l().createElement(g.EuiToolTip,{content:l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},l().createElement("span",{tabIndex:0},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTitle",defaultMessage:"Memory"})," ",l().createElement(g.EuiIcon,{type:"info"}))),description:Ce(e.metrics,t)}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return l().createElement(g.EuiFlexGroup,null,l().createElement(Ka,{grow:8},l().createElement(g.EuiDescriptionListTitle,null,e)),l().createElement(Ka,{grow:4},l().createElement(g.EuiToolTip,{position:"top",content:a},l().createElement(g.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))),l().createElement(Ka,{grow:5},l().createElement(g.EuiFlexGroup,{justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Ha,{agent:e,agentPolicy:t}))))),[{title:f.i18n.translate("xpack.fleet.agentDetails.statusLabel",{defaultMessage:"Status"}),description:l().createElement(U.u0,{agent:e,fromDetails:!0})},{title:f.i18n.translate("xpack.fleet.agentDetails.lastActivityLabel",{defaultMessage:"Last activity"}),description:e.last_checkin?$t(e.last_checkin):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.lastCheckinMessageLabel",{defaultMessage:"Last checkin message"}),description:e.last_checkin_message?e.last_checkin_message:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.agentIdLabel",{defaultMessage:"Agent ID"}),description:e.id},{title:f.i18n.translate("xpack.fleet.agentDetails.agentPolicyLabel",{defaultMessage:"Agent policy"}),description:t?l().createElement(F.an,{policy:t,agent:e}):l().createElement(g.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.versionLabel",{defaultMessage:"Agent version"}),description:"string"==typeof(null===(s=e.local_metadata)||void 0===s||null===(n=s.elastic)||void 0===n||null===(i=n.agent)||void 0===i?void 0:i.version)?l().createElement(Va,{gutterSize:"s",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1,className:"eui-textNoWrap"},e.local_metadata.elastic.agent.version),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Be,{isAgentUpgradable:!(!0===(null==t?void 0:t.is_managed)||!(0,N._3)(e)),agent:e,latestAgentVersion:T}))):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.hostNameLabel",{defaultMessage:"Host name"}),description:"string"==typeof(null===(o=e.local_metadata)||void 0===o||null===(r=o.host)||void 0===r?void 0:r.hostname)?e.local_metadata.host.hostname:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.hostIdLabel",{defaultMessage:"Host ID"}),description:"string"==typeof(null===(d=e.local_metadata)||void 0===d||null===(c=d.host)||void 0===c?void 0:c.id)?e.local_metadata.host.id:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.outputForMonitoringLabel",{defaultMessage:"Output for integrations"}),description:A?l().createElement(Ga,{outputs:A}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.outputForMonitoringLabel",{defaultMessage:"Output for monitoring"}),description:A?l().createElement(Ga,{outputs:A,isMonitoring:!0}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.logLevel",{defaultMessage:"Logging level"}),description:"string"==typeof(null===(p=e.local_metadata)||void 0===p||null===(x=p.elastic)||void 0===x||null===(h=x.agent)||void 0===h?void 0:h.log_level)?e.local_metadata.elastic.agent.log_level:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.privilegeModeLabel",{defaultMessage:"Privilege mode"}),description:!0===e.local_metadata.elastic.agent.unprivileged?l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModeUnprivilegedText",defaultMessage:"Running as non-root"}):l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModePrivilegedText",defaultMessage:"Running as root"})},{title:f.i18n.translate("xpack.fleet.agentDetails.releaseLabel",{defaultMessage:"Agent release"}),description:"boolean"==typeof(null===(y=e.local_metadata)||void 0===y||null===(E=y.elastic)||void 0===E||null===(v=E.agent)||void 0===v?void 0:v.snapshot)?!0===e.local_metadata.elastic.agent.snapshot?"snapshot":"stable":"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.platformLabel",{defaultMessage:"Platform"}),description:"string"==typeof(null===(k=e.local_metadata)||void 0===k||null===(j=k.os)||void 0===j?void 0:j.platform)?e.local_metadata.os.platform:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.monitorLogsLabel",{defaultMessage:"Monitor logs"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(b=t.monitoring_enabled)&&void 0!==b&&b.includes("logs")?l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsEnabledText",defaultMessage:"Enabled"}):l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsDisabledText",defaultMessage:"Disabled"}):l().createElement(g.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.monitorMetricsLabel",{defaultMessage:"Monitor metrics"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(S=t.monitoring_enabled)&&void 0!==S&&S.includes("metrics")?l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsEnabledText",defaultMessage:"Enabled"}):l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsDisabledText",defaultMessage:"Disabled"}):l().createElement(g.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.tagsLabel",{defaultMessage:"Tags"}),description:(null!==(M=e.tags)&&void 0!==M?M:[]).length>0?l().createElement(we,{tags:null!==(I=e.tags)&&void 0!==I?I:[]}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.platformLabel",{defaultMessage:"FIPS mode"}),description:!0===e.local_metadata.elastic.agent.fips?l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.fipsModeCompliantText",defaultMessage:"Enabled"}):l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModePrivilegedText",defaultMessage:"Not enabled"})}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return l().createElement(g.EuiFlexGroup,null,l().createElement(Ka,{grow:3},l().createElement(g.EuiDescriptionListTitle,null,e)),l().createElement(Ka,{grow:7},l().createElement(g.EuiToolTip,{position:"top",content:a},l().createElement(g.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))))}));var Va=P()(g.EuiFlexGroup).withConfig({displayName:"_StyledEuiFlexGroup",componentId:"sc-1y4d0ny-1"})(["min-width:0;"]),$a=a(91785);const Ya=P()(g.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1n7kbng-0"})(["min-width:0px;"]),Qa=(0,s.memo)((({agent:e,agentPolicy:t})=>l().createElement(l().Fragment,null,l().createElement(g.EuiFlexGroup,{alignItems:"flexStart"},l().createElement(Ya,null,l().createElement(g.EuiTitle,{size:"s"},l().createElement("h3",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.overviewSectionTitle",defaultMessage:"Overview"}))),l().createElement(g.EuiSpacer,{size:"s"}),l().createElement(qa,{agent:e,agentPolicy:t})),l().createElement(Ya,null,l().createElement(g.EuiTitle,{size:"s"},l().createElement("h3",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.integrationsSectionTitle",defaultMessage:"Integrations"}))),l().createElement(g.EuiSpacer,{size:"s"}),l().createElement($a.P,{agent:e,agentPolicy:t})))))),Xa=({agent:e})=>{const t=(0,u.iO7)(),{notifications:a}=(0,u.WeA)(),{getAbsolutePath:n}=(0,u.iEg)(),[i,o]=(0,s.useState)(!0),[r,d]=(0,s.useState)(!1),[c,p]=(0,s.useState)([]),[x,h]=(0,s.useState)([]),[y,E]=(0,s.useState)([]),[v,k]=(0,s.useState)(1e4),[j,b]=(0,s.useState)(!1),S=(0,s.useCallback)((async()=>{try{const t=await(0,u.uWX)(e.id),a=t.error;if(a)throw a;if(!t.data)throw new Error("No data");const s=t.data.items;h(s),o(!1),s.some((e=>"IN_PROGRESS"===e.status||"AWAITING_UPLOAD"===e.status))?k(3e3):k(1e4)}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.requestDiagnostics.errorLoadingUploadsNotificationTitle",{defaultMessage:"Error loading diagnostics uploads"})})}}),[e.id,a.toasts,k]);(0,s.useEffect)((()=>{S();const e=setInterval((async()=>{S()}),v);return()=>{e&&clearInterval(e)}}),[S,v]),(0,s.useEffect)((()=>{E(x),y.length>0&&x.filter((e=>{const t=y.find((t=>t.id===e.id));return"READY"===e.status&&(!t||"READY"!==(null==t?void 0:t.status))})).forEach((e=>{a.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.requestDiagnostics.readyNotificationTitle",{defaultMessage:"Agent diagnostics {name} ready",values:{name:e.name}})},{toastLifeTimeMs:5e3})}))}),[y,x,a.toasts]),(0,s.useEffect)((()=>{p(r?x:x.filter((e=>"EXPIRED"!==e.status)))}),[x,r]);const F=[{field:"id",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.fileLabelText",{defaultMessage:"File"}),render:e=>{const t=x.find((t=>t.id===e));return"READY"===(null==t?void 0:t.status)?(0,R.jsx)(g.EuiLink,{href:n(null==t?void 0:t.filePath),download:!0,target:"_blank"},(0,R.jsx)(g.EuiIcon,{type:"download"}),"   ",null==t?void 0:t.name):"IN_PROGRESS"===(null==t?void 0:t.status)||"AWAITING_UPLOAD"===(null==t?void 0:t.status)?(0,R.jsx)(g.EuiLink,{color:"subdued",disabled:!0},(0,R.jsx)(g.EuiLoadingSpinner,null),"  ",(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.generatingText",defaultMessage:"Generating diagnostics file..."})):(0,R.jsx)(g.EuiLink,{color:"subdued",disabled:!0},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",direction:"row",alignItems:"center"},null!=t&&t.error?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.errorGeneratingFileMessage",defaultMessage:"Error generating file: {reason}",values:{reason:t.error}}),type:"warning",color:"danger"})):null!=t&&t.status?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:t.status,type:"warning",color:"danger"})):null,(0,R.jsx)(g.EuiFlexItem,null,null==t?void 0:t.name)))}},{field:"id",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.dateLabelText",{defaultMessage:"Date"}),dataType:"date",render:e=>{const t=x.find((t=>t.id===e));return(0,R.jsx)(g.EuiText,{size:"s",color:"READY"===(null==t?void 0:t.status)?"default":"subdued"},(0,g.formatDate)(null==t?void 0:t.createTime,"lll"))}},...t.fleet.allAgents?[{name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.actionsLabelText",{defaultMessage:"Actions"}),width:"70px",actions:[{type:"icon",icon:"trash",color:"danger",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonText",{defaultMessage:"Delete"}),available:e=>"READY"===e.status,description:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonDesc",{defaultMessage:"Delete diagnostics file"}),onClick:e=>{var t;t=e.id,(0,u.A$L)(t).then((({data:e,error:t})=>{t||!1===(null==e?void 0:e.deleted)?a.toasts.addError(t||new Error("Request returned `deleted: false`"),{title:f.i18n.translate("xpack.fleet.requestDiagnostics.errorDeletingUploadNotificationTitle",{defaultMessage:"Error deleting diagnostics file"})}):a.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.requestDiagnostics.successDeletingUploadNotificationTitle",{defaultMessage:"Diagnostics file deleted"})}),S()}))}}]}]:[]],M=(0,R.jsx)(g.EuiButton,{fill:!0,size:"s",onClick:()=>{b(!0)},disabled:!(0,T.fx)(e)||!t.fleet.readAgents},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}));return(0,R.jsx)(l().Fragment,null,j&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:[e],agentCount:1,onClose:()=>{b(!1),S()}})),(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.calloutText",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center",justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,T.fx)(e)?M:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.notSupportedTooltip",defaultMessage:"Requesting agent diagnostics is not supported for agents before version {version}.",values:{version:T.dS}})},M)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.showExpiredFilesLabel",defaultMessage:"Show expired file requests"}),checked:r,onChange:e=>d(e.target.checked)}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),i?(0,R.jsx)(g.EuiSkeletonText,{lines:3}):(0,R.jsx)(g.EuiBasicTable,{items:c,columns:F}))},Ja=(0,s.memo)((({agent:e,agentPolicyLogLevel:t=te.OHG})=>{var a,n,i,o,r,d,c;const p=(0,u.iO7)(),{notifications:x,docLinks:h}=(0,u.WeA)(),[y,E]=(0,s.useState)(!1),[v,k]=(0,s.useState)(!1),j=ba()(null===(a=e.local_metadata)||void 0===a||null===(n=a.elastic)||void 0===n||null===(i=n.agent)||void 0===i?void 0:i.version,"8.15.0",!0),[b,S]=(0,s.useState)(null!==(o=null===(r=e.local_metadata)||void 0===r||null===(d=r.elastic)||void 0===d||null===(c=d.agent)||void 0===c?void 0:c.log_level)&&void 0!==o?o:te.OHG),[F,M]=(0,s.useState)(b),I=(0,s.useCallback)((()=>{k(!0),async function(){try{const a=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:null}}});if(a.error)throw a.error;S(t),M(t),x.toasts.addSuccess(f.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.successText",{defaultMessage:"Reset agent logging level to policy"}))}catch(e){x.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.errorTitleText",{defaultMessage:"Error resetting agent logging level"})})}k(!1)}()}),[e.id,t,x]),T=(0,s.useCallback)((()=>{E(!0),async function(){try{const t=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:F}}});if(t.error)throw t.error;S(F),x.toasts.addSuccess(f.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.successText",{defaultMessage:"Changed agent logging level to ''{logLevel}''",values:{logLevel:F}}))}catch(e){x.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.errorTitleText",{defaultMessage:"Error updating agent logging level"})})}E(!1)}()}),[x,F,e.id]);return(0,s.useEffect)((()=>{F!==b&&T()}),[F,b,T]),(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.selectLogLevelLabelText",defaultMessage:"Agent logging level"}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.selectLogLevelLabelText",defaultMessage:"Sets the log level for the agent. The default log level is {infoText}. {guideLink}",values:{infoText:(0,R.jsx)(g.EuiCode,null,"info"),guideLink:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:h.links.fleet.agentLevelLogging},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.levelGuideLinkText",defaultMessage:"Learn More"}))}}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiSelect,{disabled:y||!p.fleet.allAgents,compressed:!0,fullWidth:!0,id:"selectAgentLogLevel","data-test-subj":"selectAgentLogLevel",value:F,onChange:e=>{M(e.target.value)},options:te.F$W.map((e=>({value:e,text:e})))})),j&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{flush:"both",size:"xs",disabled:!p.fleet.allAgents,isLoading:y||v,iconType:"cross",onClick:I,"data-test-subj":"resetLogLevelBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.resetLogLevelLabelText",defaultMessage:"Reset to policy"})))))})),Za=({agent:e,agentPolicy:t})=>{var a;return(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(Ja,{agent:e,agentPolicyLogLevel:null==t||null===(a=t.advanced_settings)||void 0===a?void 0:a.agent_logging_level})))},es=()=>{var e,t,a;const{params:{agentId:n,tabId:i=""}}=(0,o.useRouteMatch)(),{getHref:r}=(0,u.iEg)(),{showAgentless:d}=(0,u.jXQ)(),{isLoading:c,isInitialRequest:p,error:x,data:h,resendRequest:y}=(0,u.rXq)(n,{pollIntervalMs:5e3,query:{withMetrics:!0}}),{isLoading:E,data:v,sendRequest:k}=(0,u.ZJQ)(null==h||null===(e=h.item)||void 0===e?void 0:e.policy_id),{application:{navigateToApp:j},notifications:b}=(0,u.WeA)(),S=(0,u.g7J)(),M="true"===new URLSearchParams((0,o.useLocation)().search).get("openReassignFlyout"),T=(0,s.useCallback)((()=>{S&&S.onDoneNavigateTo&&j(S.onDoneNavigateTo[0],S.onDoneNavigateTo[1])}),[S,j]),w=null==v?void 0:v.item.supports_agentless,A=null==h||!h.item||w&&!d?null:h.item,C=A&&(null===(t=A.local_metadata)||void 0===t?void 0:t.host),P=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiButtonEmpty,{iconType:"arrowLeft",href:r("agent_list"),flush:"left",size:"xs","aria-label":"View all agents"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.viewAgentListTitle",defaultMessage:"View all agents"}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{className:"eui-textBreakWord"},(0,R.jsx)("h1",null,c&&p?(0,R.jsx)(F.Rh,null):"object"==typeof C&&"string"==typeof(null==C?void 0:C.hostname)?C.hostname:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsTitle",defaultMessage:"Agent ''{id}''",values:{id:n}})))))),[C,n,r,p,c]),[L,_]=(0,s.useState)(),[D,O]=(0,s.useState)(!1),[B,N]=(0,s.useState)();(0,s.useEffect)((()=>{null!=A&&A.active&&(async()=>{try{var e;const t=await(0,u.FnK)({showInactive:"inactive"===(null==A?void 0:A.status)}),a=null!==(e=null==t?void 0:t.items)&&void 0!==e?e:[];N(a)}catch(e){b.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.errorFetchingTagsTitle",{defaultMessage:"Error fetching tags"})})}})()}),[N,b,A]);const z=(0,s.useMemo)((()=>A?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexEnd",alignItems:"center",gutterSize:"s",direction:"row"},!E&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(za,{agent:A,agentPolicy:null==v?void 0:v.item,assignFlyoutOpenByDefault:M,onCancelReassign:S&&S.onDoneNavigateTo?T:void 0,onAddRemoveTagsClick:e=>{_(e),O(!D)}})))):void 0),[v,h,r,E]),U=(0,s.useMemo)((()=>[{id:"details",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.detailsTab",{defaultMessage:"Agent details"}),href:r("agent_details",{agentId:n,tabId:"details"}),isSelected:!i||"details"===i},{id:"logs",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.logsTab",{defaultMessage:"Logs"}),href:r("agent_details_logs",{agentId:n,tabId:"logs"}),isSelected:"logs"===i},{id:"diagnostics",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.diagnosticsTab",{defaultMessage:"Diagnostics"}),href:r("agent_details_diagnostics",{agentId:n,tabId:"diagnostics"}),isSelected:"diagnostics"===i},{id:"settings",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.settingsTab",{defaultMessage:"Settings"}),href:r("agent_details_settings",{agentId:n,tabId:"settings"}),isSelected:"settings"===i}]),[r,n,i]);return(0,R.jsx)(va.U.Provider,{value:{refresh:()=>{y(),k()}}},(0,R.jsx)(I.QA,{leftColumn:P,rightColumn:z,tabs:U},c&&p?(0,R.jsx)(F.Rh,null):x?(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.unexceptedErrorTitle",defaultMessage:"Error loading agent"}),error:x}):A?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(ts,{agent:A,agentPolicy:null==v?void 0:v.item}),D&&(0,R.jsx)(jt,{agentId:null==A?void 0:A.id,allTags:null!=B?B:[],selectedTags:null!==(a=null==A?void 0:A.tags)&&void 0!==a?a:[],button:L,onTagsUpdated:e=>{y(),e.length>0&&N([...new Set([...null!=B?B:[],...e])].sort())},onClosePopover:()=>{O(!1)}})):(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentNotFoundErrorTitle",defaultMessage:"Agent not found"}),error:f.i18n.translate("xpack.fleet.agentDetails.agentNotFoundErrorDescription",{defaultMessage:"Cannot find agent ID {agentId}",values:{agentId:n}})})))},ts=({agent:e,agentPolicy:t})=>((0,u.ifo)("agent_details",{agentHost:"object"==typeof e.local_metadata.host&&"string"==typeof e.local_metadata.host.hostname?e.local_metadata.host.hostname:"-"}),(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.agent_details_logs,render:()=>(0,R.jsx)(Ba,{agent:e,agentPolicy:t})}),(0,R.jsx)(r.Route,{path:M.X5.agent_details_diagnostics,render:()=>(0,R.jsx)(Xa,{agent:e})}),(0,R.jsx)(r.Route,{path:M.X5.agent_details_settings,render:()=>(0,R.jsx)(Za,{agent:e,agentPolicy:t})}),(0,R.jsx)(r.Route,{path:M.X5.agent_details,render:()=>(0,R.jsx)(Qa,{agent:e,agentPolicy:t})}))),as=(0,o.withRouter)((({actionSection:e,title:t,children:a})=>(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceAround"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiPageSection,{color:"transparent"},(0,R.jsx)(g.EuiEmptyPrompt,{color:"plain",iconType:"logoBeats",title:(0,R.jsx)("h2",null,t),body:a,actions:e})))))),ss=(0,m.injectI18n)((({intl:e})=>(0,R.jsx)(as,{title:e.formatMessage({id:"xpack.fleet.noAccess.accessDeniedTitle",defaultMessage:"Access denied"}),actionSection:[]},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.noAccess.accessDeniedDescription",defaultMessage:"You are not authorized to access Elastic Fleet. To use Elastic Fleet, you need a user role that contains All permissions for this application."}))))),ls=()=>{var e;(0,u.ifo)("agent_list");const{agents:t}=(0,u.UKg)(),a=(0,u.iO7)(),s=(0,u.YI3)(),n=(0,u.Wdf)();if(!t.enabled)return null;if(!s.missingRequirements&&s.isLoading)return(0,R.jsx)(F.Rh,null);if(s.error)return(0,R.jsx)(I.gv,null,(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentsInitializationErrorMessageTitle",defaultMessage:"Unable to initialize central management for Elastic Agents"}),error:s.error}));const i=1===(null==s||null===(e=s.missingRequirements)||void 0===e?void 0:e.length)&&"fleet_server"===s.missingRequirements[0],o=a.fleet.allAgents&&(s.forceDisplayInstructions||i);if(!i&&s.missingRequirements&&s.missingRequirements.length>0)return(0,R.jsx)(Ea.O,{missingRequirements:s.missingRequirements});if(!a.fleet.readAgents)return(0,R.jsx)(ss,null);const d=o?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexEnd"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>n.openEnrollmentFlyout(),"data-test-subj":"addAgentBtnTop"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addAgentButton",defaultMessage:"Add Agent"}))))):void 0;return(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.agent_details},(0,R.jsx)(es,null)),(0,R.jsx)(r.Route,{path:M.X5.agents},(0,R.jsx)(I.iW,{section:"agents",rightColumn:d},o?(0,R.jsx)(Ea.Q,{showEnrollmentRecommendation:!1}):(0,R.jsx)(ya,null))))};var ns=a(46048);const is=e=>{const{discover:t}=(0,ot.WeA)(),[a,l]=(0,s.useState)(null);return(0,s.useEffect)((()=>{(async()=>{if(t&&t.locator){const a=await t.locator.getUrl({indexPatternId:"logs-*",timeRange:{from:"now-1h",to:"now",mode:"relative"},filters:[{meta:{alias:"Recently enrolled agents",index:"logs-*"},query:{terms:{"agent.id":e}}}]});l(a)}})()}),[t,e]),a};var os=a(89700);const rs=P()("h1").withConfig({displayName:"CentralTitle",componentId:"sc-ve6hfp-0"})(["text-align:center;"]),us=({children:e})=>l().createElement(l().Fragment,null,l().createElement(g.EuiSpacer,{size:"s"}),l().createElement(g.EuiTitle,{size:"l"},l().createElement(rs,null,e)),l().createElement(g.EuiSpacer,{size:"xl"})),ds=P()(g.EuiText).withConfig({displayName:"SubtitleText",componentId:"sc-ve6hfp-1"})(["max-width:250px;margin:0 auto;text-align:center;"]),cs=P()(g.EuiStepNumber).withConfig({displayName:"CenteredEuiStepNumber",componentId:"sc-ve6hfp-2"})(["margin:0 auto;"]),gs=e=>l().createElement(ys,null,l().createElement(g.EuiImage,(0,d.default)({role:"presentation"},e))),ps=({children:e})=>{const t=(0,g.useIsWithinMaxBreakpoint)("s");return l().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:t?"xs":"l",alignItems:"center",justifyContent:"center",wrap:!0},e)},ms=()=>{const{http:e}=(0,u.WeA)(),t=e.basePath.prepend("/plugins/fleet/assets/");return l().createElement(g.EuiFlexGroup,{alignItems:"center",justifyContent:"spaceEvenly",gutterSize:"none"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ps,null,l().createElement(g.EuiFlexItem,null,l().createElement(cs,{status:"incomplete",number:1})),l().createElement(g.EuiFlexItem,null,l().createElement(Es,null,l().createElement(gs,{alt:"",src:t+"1_install_agent.svg"}))),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStepTitle",defaultMessage:"Install Elastic Agent"}))),l().createElement(ds,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStep",defaultMessage:"Install agents on the hosts that you want to connect to Elastic."}))))),l().createElement(g.EuiShowFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiSpacer,{size:"xl"}))),l().createElement(g.EuiHideFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(gs,{alt:"",src:t+"arrow_right_curve_over.svg"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ps,null,l().createElement(g.EuiFlexItem,null,l().createElement(cs,{status:"incomplete",number:2})),l().createElement(g.EuiFlexItem,null,l().createElement(gs,{alt:"",src:t+"2_add_integration.svg"})),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStepTitle",defaultMessage:"Add the integration"}))),l().createElement(ds,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStep",defaultMessage:"Make a few selections to finalize how Elastic receives your data."}))))),l().createElement(g.EuiShowFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiSpacer,{size:"xl"}))),l().createElement(g.EuiHideFor,{sizes:["s","xs"]},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(gs,{alt:"",src:t+"arrow_right_curve_under.svg"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(ps,null,l().createElement(g.EuiFlexItem,null,l().createElement(cs,{status:"incomplete",number:3})),l().createElement(g.EuiFlexItem,null,l().createElement(gs,{alt:"",src:t+"3_confirm_data.svg"})),l().createElement(g.EuiFlexItem,null,l().createElement(g.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStepTitle",defaultMessage:"Confirm incoming data"}))),l().createElement(ds,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStep",defaultMessage:"Explore and analyze the incoming data."}))))))},fs=P()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-ve6hfp-3"})(["padding-bottom:100px;"]),xs=()=>{const{docLinks:e}=(0,u.WeA)();return l().createElement(g.EuiFlexGroup,{justifyContent:"spaceAround"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiLink,{href:e.links.fleet.elasticAgent,target:"_blank"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.learnMoreLink",defaultMessage:"Learn more about installing Elastic Agent"}))))},hs=({integrationInfo:e,packageInfo:t,isLoading:a,error:s,cancelUrl:n,cancelClickHandler:i,onNext:o})=>{if(s)return l().createElement(F.$D,{title:l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:s});const r=l().createElement(us,null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.pageTitle",defaultMessage:"Ready to add your first integration?"}));return l().createElement(I.QA,{topContent:r},l().createElement(l().Fragment,null,l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(ms,null),l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(g.EuiSpacer,{size:"xxl"}),l().createElement(fs,null,l().createElement(xs,null)),l().createElement(js,{cancelUrl:n,cancelMessage:l().createElement("span",{"data-test-subj":"skipAgentInstallation"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.skipAddAgentButton",defaultMessage:"Add integration only (skip agent installation)"})),cancelClickHandler:i,isLoading:a,onNext:o,noAnimation:!0,actionMessage:l().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentButton",defaultMessage:"Install Elastic Agent"})}),t&&l().createElement(os.I3,{pkgTitle:(null==e?void 0:e.title)||t.title,pkgkey:(0,N.Ku)(t),integration:null==e?void 0:e.name})))};var ys=P()("div").withConfig({displayName:"_StyledDiv",componentId:"sc-ve6hfp-4"})({margin:"0 auto"}),Es=P()("div").withConfig({displayName:"_StyledDiv2",componentId:"sc-ve6hfp-5"})({margin:"0 auto"});const vs=P()(g.EuiBottomBar).withConfig({displayName:"NoAnimationBottomBar",componentId:"sc-113t0u1-0"})(["animation-delay:-99s;#stop bottom bar flying in on step change"]),ks=P()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-113t0u1-1"})(["padding-bottom:100px;"]),js=({isLoading:e,loadingMessage:t,onNext:a,cancelClickHandler:s,cancelUrl:n,actionMessage:i,cancelMessage:o,isDisabled:r=!1,noAnimation:u=!1})=>{const d=u?vs:g.EuiBottomBar;return l().createElement(d,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:n,onClick:s},o||l().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.backButton",defaultMessage:"Go back"})))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"primary",fill:!0,size:"m",isDisabled:r,isLoading:!r&&e,onClick:a},e?t||l().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.loading",defaultMessage:"Loading..."}):i))))},bs=({onNext:e,cancelClickHandler:t,cancelUrl:a,noAnimation:s=!1})=>{const n=s?vs:g.EuiBottomBar;return l().createElement(n,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:a,onClick:t},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.backButton",defaultMessage:"Go back"})))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"primary",fill:!0,size:"m",onClick:e},l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.viewIncomingDataBtn",defaultMessage:"View incoming data"})))))},Ss=({pkgkey:e})=>{const t=e.includes(be.FLEET_KUBERNETES_PACKAGE),{getHref:a}=(0,ot.iEg)(),{getAbsolutePath:s}=(0,ot.iEg)();return l().createElement(g.EuiBottomBar,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:a("integrations_all")},l().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.addAnotherIntegration",defaultMessage:"Add another integration"})))),!t&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"success",fill:!0,size:"m",href:a("integration_details_assets",{pkgkey:e})},l().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.viewDataAssetsButtonText'",defaultMessage:"View assets"}))),t&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"success",fill:!0,size:"m",href:s("/app/dashboards#/view/kubernetes-f4dc26db-1b53-4ea2-a78b-1bfab8ea267c")},l().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData. '",defaultMessage:"View Kubernetes metrics dashboards"})))))},Fs=({troubleshootLink:e,agentIds:t,integration:a})=>{const s=is(t);return l().createElement(g.EuiBottomBar,null,l().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:e,iconType:"popout",target:"_blank"},l().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLinkBottomBar",defaultMessage:"Troubleshooting guide"}))),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButton,{color:"success",fill:!0,href:null!=s?s:""},l().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLogsLink",defaultMessage:"View incoming {integration} logs",values:{integration:null!=a?a:""}})))))},Ms=e=>{const{packageInfo:t,integrationInfo:a,steps:s,currentStep:n,error:i}=e;if(i)return(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:i});const o=s[n].component,r=(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"l",className:"eui-textCenter"},(0,R.jsx)("h1",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.multiPageTitle",defaultMessage:"Set up {title} integration",values:{title:t.title}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ts,{currentStep:n,steps:s.map((e=>e.title))}),(0,R.jsx)(g.EuiSpacer,{size:"xl"}));return(0,R.jsx)(I.QA,{topContent:r,restrictHeaderWidth:866,restrictWidth:866},(0,R.jsx)(o,e),t&&(0,R.jsx)(os.I3,{pkgTitle:(null==a?void 0:a.title)||t.title,pkgkey:(0,N.Ku)(t),integration:null==a?void 0:a.name}))},Is=(e,t,a)=>e===t?a?"complete":"current":e>t?"complete":"incomplete",Ts=({steps:e,currentStep:t=0,currentStepComplete:a=!1})=>{const s=e.map(((e,s)=>({title:e,status:Is(t,s,a),onClick:()=>{}})));return(0,R.jsx)(g.EuiStepsHorizontal,{size:"xs",steps:s})};var ws=a(8683),As=a(29466),Cs=a(4888);var Ps=P()(g.EuiCodeBlock).withConfig({displayName:"_StyledEuiCodeBlock",componentId:"sc-oz6m9j-1"})(["max-width:1100px;"]),Ls=a(62652);const _s=e=>{var t,a;const{cancelUrl:n,onNext:i,cancelClickHandler:o,setIsManaged:r,agentPolicy:u,enrollmentAPIKey:d,fleetServerHost:c,fleetProxy:p,enrolledAgentIds:x}=e,h=(0,ot.WeA)(),{docLinks:y}=h,E=y.links.fleet.troubleshooting,v=(0,ot.JhS)(),[k,j]=(0,s.useState)(!1),[b,S]=(0,s.useState)(!1);if(!d)return(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Enrollment API key not found"});const M="kubernetes"===e.packageInfo.name?"IS_KUBERNETES_MULTIPAGE":"IS_NOT_KUBERNETES",I=(0,T.dF)(null!==(t=null==u?void 0:u.package_policies)&&void 0!==t?t:[]),w=(0,Cs.w)({apiKey:d.api_key,fleetProxy:p,fleetServerHost:c,agentVersion:v||"",showInstallServers:I}),A=[(0,As.YD)({installCommand:w,apiKeyData:{item:d},enrollToken:d.api_key,isK8s:M,selectedApiKeyId:d.id,isComplete:k||!!x.length,fullCopyButton:!0,fleetServerHost:c,onCopy:()=>j(!0),rootIntegrations:(0,T.uo)(null!==(a=null==u?void 0:u.package_policies)&&void 0!==a?a:[]),nonFipsIntegrations:(0,Ls.I)(u)})];return"IS_KUBERNETES_MULTIPAGE"===M&&A.push((({isComplete:e,fullCopyButton:t,onCopy:a})=>{const[n,i]=(0,s.useState)(!1),o=P().pre.withConfig({displayName:"CommandCode",componentId:"sc-oz6m9j-0"})({overflow:"auto"});return{status:e?"complete":void 0,title:f.i18n.translate("xpack.fleet.agentEnrollment.stepKubernetesApplyManifest",{defaultMessage:"Run the apply command"}),children:l().createElement(l().Fragment,null,l().createElement(g.EuiText,null,l().createElement(g.EuiSpacer,{size:"s"}),l().createElement(m.FormattedMessage,{id:"xpack.fleet.agentEnrollment.kubernetesCommandInstructions",defaultMessage:"From the directory where the manifest is downloaded, run the apply command."}),l().createElement(g.EuiSpacer,{size:"m"})),l().createElement(Ps,{onClick:()=>{a&&a()},fontSize:"m",isCopyable:!t,paddingSize:"m"},l().createElement(o,null,"kubectl apply -f elastic-agent-managed-kubernetes.yml")),l().createElement(g.EuiSpacer,{size:"s"}),t&&l().createElement(g.EuiCopy,{textToCopy:"kubectl apply -f elastic-agent-managed-kubernetes.yml"},(e=>l().createElement(g.EuiButton,{color:"primary",iconType:"copyClipboard",size:"m",onClick:()=>(e=>{e(),i(!0),a&&a()})(e)},n?l().createElement(m.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButtonClicked",defaultMessage:"Copied"}):l().createElement(m.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButton",defaultMessage:"Copy to clipboard"})))))}})({isComplete:b||!!x.length,fullCopyButton:!0,onCopy:()=>S(!0)})),A.push((0,As.nV)({selectedPolicyId:null==u?void 0:u.id,troubleshootLink:E,agentCount:x.length,showLoading:!0,poll:k})),v?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.installAgentStepTitle",defaultMessage:"These steps configure and enroll the Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent. As an alternative to Fleet, advanced users can run agents in {standaloneLink}.",values:{standaloneLink:(0,R.jsx)(g.EuiLink,{onClick:()=>r(!1)},"standalone mode")}})),(0,R.jsx)(g.EuiSpacer,{size:"xl"}),(0,R.jsx)(g.EuiSteps,{steps:A}),!!x.length&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(ks,null),(0,R.jsx)(js,{cancelUrl:n,cancelClickHandler:o,onNext:i,actionMessage:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationButton",defaultMessage:"Add the integration"})}))):(0,R.jsx)(g.EuiLoadingSpinner,null)};var Ds=a(96104);const Os=e=>{var t;const{setIsManaged:a,agentPolicy:n,cancelUrl:i,onNext:o,cancelClickHandler:r}=e,u=(0,ot.Q14)(),[d,c]=(0,s.useState)(!1),[p,f]=(0,s.useState)(!1),{yaml:x,onCreateApiKey:h,isCreatingApiKey:y,apiKey:E,downloadYaml:v}=(0,Ds.Pe)(n);if(!n)return(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Agent policy not provided"});const k=(0,Cs.p)({agentVersion:u}),j=[(0,As.N9)({selectedPolicyId:null==n?void 0:n.id,yaml:x,downloadYaml:v,apiKey:E,onCreateApiKey:h,isCreatingApiKey:y,isComplete:p,onCopy:()=>f(!0)}),(0,As.iR)({installCommand:k,isComplete:x&&d,fullCopyButton:!0,onCopy:()=>c(!0),rootIntegrations:(0,T.uo)(null!==(t=null==n?void 0:n.package_policies)&&void 0!==t?t:[]),nonFipsIntegrations:(0,Ls.I)(n)})];return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(Gs,{setIsManaged:a}),(0,R.jsx)(g.EuiSpacer,{size:"xl"}),(0,R.jsx)(g.EuiSteps,{steps:j}),d&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(ks,null),(0,R.jsx)(bs,{cancelUrl:i,onNext:o,cancelClickHandler:r})))};var Rs=a(92604),Bs=a(74892),Ns=a(33342),zs=a(49688),Us=a(43721);const Hs=({children:e})=>{const[t,a]=(0,s.useState)(!1);return(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"column"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"row"},(0,R.jsx)(g.EuiFlexItem,null),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{size:"s",iconType:t?"arrowUp":"arrowDown",iconSide:"right",onClick:()=>a(!t),flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",defaultMessage:"Advanced options"}))))),t&&(0,R.jsx)(g.EuiFlexItem,null,e)))},Ws=({error:e,title:t})=>(0,R.jsx)(F.$D,{title:t||(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.errorTitle",defaultMessage:"Error adding integration"}),error:e}),Gs=({setIsManaged:e})=>(0,R.jsx)(g.EuiCallOut,{title:"Setting up to run Elastic Agent in standalone mode",color:"primary",iconType:"info"},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.standaloneWarning",defaultMessage:"Setting up integrations by running Elastic Agent in standalone mode is advanced. When possible, we recommend using {link} instead. ",values:{link:(0,R.jsx)(g.EuiLink,{href:"#"},"Fleet-managed agents")}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiButton,{onClick:()=>e(!0),color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.switchToManagedButton",defaultMessage:"Enroll in Fleet instead (recommended)"})));var Ks=a(69433),qs=a(30276);const Vs=({agentIds:e,troubleshootLink:t,packageInfo:a})=>{var s;const n=is(e);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.title",defaultMessage:"Confirming data is taking longer than expected"}))),(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.body",defaultMessage:"If the system is not generating data, it may help to generate some to ensure data is being collected correctly. If you're having trouble, see our {troubleshootLink}, or you may check later by viewing {discoverLink}.",values:{troubleshootLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLink",defaultMessage:"troubleshooting guide"})),discoverLink:(0,R.jsx)(g.EuiLink,{external:!0,href:null!=n?n:"",target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLink",defaultMessage:"{integration} logs in Discover",values:{integration:null!==(s=null==a?void 0:a.title)&&void 0!==s?s:""}}))}})),(0,R.jsx)(ks,null),(0,R.jsx)(Fs,{agentIds:e,troubleshootLink:t,integration:null==a?void 0:a.title}))},$s=["agent.ephemeral_id","agent.id","elastic_agent.id","data_stream.namespace","@timestamp"],Ys=P()(g.EuiDescriptionList).withConfig({displayName:"CleanOverflowDescriptionList",componentId:"sc-6co0kl-0"})(["overflow:hidden;max-height:125px;word-break:break-all;white-space:pre-wrap;"]),Qs=P()("pre").withConfig({displayName:"CompressedPre",componentId:"sc-6co0kl-1"})(["&&&{background:none;padding:0 0;}"]),Xs=({hit:e})=>{const t=(0,J.omit)((0,Ks.getFlattenedObject)(e._source),$s),a=Object.entries(t).map((([e,t])=>({title:`${e}:`,description:JSON.stringify(t)})));return l().createElement("pre",null,l().createElement("code",null,l().createElement(Ys,{listItems:a,type:"inline",align:"left",compressed:!0})))},Js=({hit:e})=>{const t=(null==e?void 0:e._source)||{},a=(null==t?void 0:t["@timestamp"])||"-";return l().createElement(g.EuiText,{size:"xs"},l().createElement(Qs,null,a?(0,g.formatDate)(a,"MMM D, YYYY @ HH:mm:ss.SSS"):"-"))},Zs=({dataPreview:e})=>{const t=e.slice(0,5);return l().createElement(l().Fragment,null,t.map((e=>l().createElement("div",{id:e._id},l().createElement(g.EuiFlexGroup,{gutterSize:"xs"},l().createElement(tl,null,l().createElement(Js,{hit:e})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(Xs,{hit:e}))),l().createElement(g.EuiHorizontalRule,{margin:"s"})))))},el=({agentIds:e,packageInfo:t,agentDataConfirmed:a,setAgentDataConfirmed:s,troubleshootLink:n})=>{const{incomingData:i,dataPreview:o,hasReachedTimeout:r}=(0,qs.Tm)({agentIds:e,previewData:!0,stopPollingAfterPreviewLength:5}),{numAgentsWithData:u}=(0,qs.VK)(i,t);return a?l().createElement(l().Fragment,null,l().createElement(g.EuiCallOut,{"data-test-subj":"IncomingDataConfirmedCallOut",title:f.i18n.translate("xpack.fleet.confirmIncomingDataWithPreview.title",{defaultMessage:"Incoming data received from {numAgentsWithData} enrolled { numAgentsWithData, plural, one {agent} other {agents}}.",values:{numAgentsWithData:u}}),color:"success",iconType:"check"}),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(g.EuiText,null,l().createElement("h3",null,l().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.previewTitle",defaultMessage:"Preview of incoming data:"}))),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(Zs,{dataPreview:o})):l().createElement(l().Fragment,null,l().createElement(g.EuiText,null,l().createElement(g.EuiCallOut,{size:"m",color:"primary",iconType:g.EuiLoadingSpinner,title:l().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.listening",defaultMessage:"Listening for incoming data from enrolled agents..."})}),l().createElement(g.EuiSpacer,{size:"m"}),r?l().createElement(Vs,{agentIds:e,troubleshootLink:n,packageInfo:t}):l().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.loading",defaultMessage:"It might take a few minutes for the data to get to Elasticsearch. If you're not seeing any, try generating some to verify. If you're having trouble connecting, check out the {link}.",values:{link:l().createElement(g.EuiLink,{target:"_blank",external:!0,href:n},l().createElement(m.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})),l().createElement(g.EuiSpacer,{size:"m"}),l().createElement(g.EuiSkeletonText,{lines:10}))};var tl=P()(g.EuiFlexItem).withConfig({displayName:"_StyledEuiFlexItem",componentId:"sc-6co0kl-2"})({minWidth:"220px"});const al=({troubleshootLink:e})=>(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)(g.EuiCallOut,{size:"m",color:"primary",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.title",defaultMessage:"Data preview is not available for standalone agents. "})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.description",defaultMessage:"You can check for agent data in the integration asset tab. If you're having trouble seeing data, check out the {link}.",values:{link:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})))),sl={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.installAgentStepTitle",{defaultMessage:"Install Elastic Agent"}),component:e=>{var t;const[a,l]=(0,s.useState)(e.isManaged),[n,i]=(0,s.useState)(!1),{enrolledAgentIds:o}=(0,ws.X)((null===(t=e.agentPolicy)||void 0===t?void 0:t.id)||"",{noLowerTimeLimit:!0,pollImmediately:!0}),r=()=>{e.setEnrolledAgentIds(o),e.onNext()},u={...e,onNext:r,enrolledAgentIds:o,setIsManaged:n?l:e.setIsManaged};if(a)return(0,R.jsx)(_s,u);const d={...e,onNext:r,enrolledAgentIds:o,setIsManaged:e=>{e&&i(!0),l(e)}};return(0,R.jsx)(Os,d)}},ll={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.addIntegrationStepTitle",{defaultMessage:"Add the integration"}),component:e=>{var t;const{onNext:a,onBack:n,isManaged:i,setIsManaged:o,packageInfo:r,integrationInfo:d,agentPolicy:c}=e,{spaceId:p}=(0,u.YI3)(),[x,h]=(0,s.useState)(),{notifications:y}=(0,u.WeA)(),[E,v]=(0,s.useState)("VALID"),[k,b]=(0,s.useState)(),S=(0,j.wsd)(),[M,I]=(0,s.useState)({name:"",description:"",namespace:"",policy_id:"",policy_ids:[""],enabled:!0,inputs:[]}),w=(0,s.useCallback)((e=>{const t=(0,Ns.bS)({...M,...e},r,Rs.Hh);return b(t),Us.debug("Package policy validation results",t),t}),[r,M]),A=(0,s.useCallback)((e=>{const t={...M,...e};I(t),Us.debug("Package policy updated",t);const a=w(t),s=t.package,l=!!a&&(0,Ns.nt)(a);v(s&&!l?"VALID":"INVALID")}),[M,w]),C=(0,s.useCallback)((async({newPackagePolicy:e,force:t})=>{var a;v("LOADING");const{policy:s,forceCreateNeeded:l}=await(0,zs.E)(e),n=await(0,u.H_o)({...s,force:l||t});return v("SUBMITTED"),!n.error&&null!==(a=n.data)&&void 0!==a&&a.item.package&&await(0,ee.i)({currentSpaceId:null!=p?p:Z.DEFAULT_SPACE_ID,pkgName:n.data.item.package.name,pkgVersion:n.data.item.package.version,toasts:y.toasts}),n}),[y.toasts,p]),P=(0,s.useCallback)((async({force:e=!1}={})=>{const t=!!k&&(0,Ns.nt)(k);if("VALID"===E&&t)return void v("INVALID");v("LOADING");const{error:s}=await C({newPackagePolicy:M,force:e});if(s){if((0,Bs.G0)(s))return void(await S(r)?P({force:!0}):v("VALID"));y.toasts.addError(s,{title:"Error"}),v("VALID")}else a()}),[k,C,E,M,y.toasts,S,r,a]);(0,s.useEffect)((()=>{(async()=>{if(!c)return;const{packagePolicy:e,error:t}=await(async(e,t,a)=>{const{data:s,error:l}=await(0,u.TR6)({perPage:te.WaW,page:1,kuery:`${ns.f$}.package.name:${t.name}`}),n={name:(0,T.sW)(t.name,null==s?void 0:s.items),description:"",namespace:"",policy_id:e,policy_ids:[e],enabled:!0,inputs:[]};return{packagePolicy:(0,N.eE)(t,e,n.namespace,n.name,n.description,a),error:l}})(c.id,r,null==d?void 0:d.name);t&&h(t),A(e)})()}),[]);const L=(0,u.fWy)(null!==(t=r.name)&&void 0!==t?t:"","package-policy-create-multi-step"),_=(0,s.useMemo)((()=>L&&(0,R.jsx)(F.BA,null,(0,R.jsx)(L.Component,null))),[L]),D=(0,s.useMemo)((()=>{if("endpoint"!==r.name)return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(os.lS,{packageInfo:r,showOnlyIntegration:null==d?void 0:d.name,packagePolicy:M,updatePackagePolicy:A,validationResults:k,submitAttempted:"INVALID"===E,noTopRule:!0}),k&&(0,R.jsx)(Hs,null,(0,R.jsx)(os.os,{packageInfo:r,packagePolicy:M,updatePackagePolicy:A,validationResults:k,submitAttempted:"INVALID"===E,noAdvancedToggle:!0})))}),[E,null==d?void 0:d.name,r,M,A,k]);return c?x?(0,R.jsx)(Ws,{error:x}):(0,R.jsx)(l().Fragment,null,i?null:(0,R.jsx)(Gs,{setIsManaged:o}),D,_,(0,R.jsx)(ks,null),(0,R.jsx)(js,{cancelClickHandler:i?n:()=>o(!0),onNext:P,isLoading:"LOADING"===E,isDisabled:"INVALID"===E,loadingMessage:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.savingPackagePolicy",defaultMessage:"Saving policy..."}),actionMessage:i?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.confirmIncomingDataButton",defaultMessage:"Confirm incoming data"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.installAgentButton",defaultMessage:"Save and continue"})})):(0,R.jsx)(Ws,{error:f.i18n.translate("xpack.fleet.addIntegration.noAgentPolicy",{defaultMessage:"Error creating agent policy."})})}},nl={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.confirmDataStepTitle",{defaultMessage:"Confirm incoming data"}),component:e=>{const{enrolledAgentIds:t,packageInfo:a,isManaged:n}=e,i=(0,u.WeA)(),[o,r]=(0,s.useState)(!1),{docLinks:d}=i,c=d.links.fleet.troubleshooting,g=(0,R.jsx)(l().Fragment,null,(0,R.jsx)(ks,null),(0,R.jsx)(Ss,{pkgkey:`${a.name}-${a.version}`}));return n?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(el,{agentIds:t,packageInfo:a,agentDataConfirmed:o,setAgentDataConfirmed:r,troubleshootLink:c}),!!o&&g):(0,R.jsx)(l().Fragment,null,(0,R.jsx)(al,{troubleshootLink:c}),g)}},il=[sl,ll,nl],ol=[ll,sl,nl],rl=({queryParamsPolicyId:e,prerelease:t})=>{const{params:a}=(0,o.useRouteMatch)(),{pkgkey:l,policyId:n,integration:i}=a,{pkgName:r,pkgVersion:d}=(0,T.CB)(l),[c,g]=(0,s.useState)(!0),[p,m]=(0,s.useState)(0),[x,h]=(0,s.useState)(!0),{getHref:y}=(0,u.iEg)(),[E,v]=(0,s.useState)([]),k=n||e,{data:j,error:b,isLoading:S}=(0,u.E1o)(r,d,{prerelease:t,full:!0}),{agentPolicy:F,enrollmentAPIKey:M,error:I,isLoading:w}=function(e){const{spaceId:t,isSpaceAwarenessEnabled:a}=(0,ot.YI3)(),[l,n]=(0,s.useState)(!0),[i,o]=(0,s.useState)(),[r,u]=(0,s.useState)(),[d,c]=(0,s.useState)(),[g,p]=(0,s.useState)(),m="fleet-first-agent-policy",x=(0,s.useMemo)((()=>a&&"default"!==t?`${t}:${m}`:m),[a,t]),h=(0,s.useMemo)((()=>Object.freeze((0,_.b)({id:x,name:f.i18n.translate("xpack.fleet.createPackagePolicy.firstAgentPolicyNameText",{defaultMessage:"My first agent policy"})}))),[x]);return(0,s.useEffect)((()=>{(async()=>{var t;n(!0);const a=e||x,{data:s,error:l}=await(async e=>{var t;let a,s;try{a=await(0,ot.Ag1)(e),a.error&&(s=a.error)}catch(e){s=e}return s&&404!==s.statusCode?{error:s}:{data:null===(t=a)||void 0===t?void 0:t.data}})(a),i=null==s?void 0:s.item;if(e&&!i)return n(!1),void o(new Error(`Agent policy ${a} not found`));let r;if(l)return n(!1),void o(l);if(!i){const{data:e,error:t}=await ot.iF6.bind(null,h)();if(t)return n(!1),void o(t);r=e.item,p(!0)}u(i||r);const{data:d,error:g}=await(0,ot.d1z)({page:1,perPage:1,kuery:`policy_id:"${a}"`});g?(n(!1),o(g)):d&&null!==(t=d.items)&&void 0!==t&&t.length?(n(!1),c(d.items[0])):(n(!1),o(new Error(`No enrollment API key found for policy ${a}`)))})()}),[e,h,x]),{isLoading:l,error:i,agentPolicy:r,enrollmentAPIKey:d,created:g}}(k),A=(0,s.useMemo)((()=>null==j?void 0:j.item),[j]),C=(0,s.useMemo)((()=>{var e;if(i)return null==A||null===(e=A.policy_templates)||void 0===e?void 0:e.find((e=>e.name===i))}),[null==A?void 0:A.policy_templates,i]),{fleetServerHost:P,fleetProxy:L,downloadSource:D,isLoadingInitialRequest:O}=(0,u.Dc7)(F),B=y("add_integration_to_policy",{pkgkey:l,useMultiPageLayout:!1,...i?{integration:i}:{},...k?{agentPolicyId:k}:{},...t?{prerelease:"true"}:{}});if(c||!A)return(0,R.jsx)(hs,{isLoading:S||O||w,error:b||I,integrationInfo:C,packageInfo:A,cancelUrl:B,onNext:()=>{g(!1)}});const N=x?il:ol;return(0,R.jsx)(Ms,{fleetServerHost:P,fleetProxy:L,downloadSource:D,agentPolicy:F,enrollmentAPIKey:M,currentStep:p,steps:N,packageInfo:A,integrationInfo:C,cancelUrl:B,onNext:()=>{p!==N.length-1&&m(p+1)},onBack:()=>{0!==p&&m(p-1)},isManaged:x,setIsManaged:e=>{h(e),m(0)},setEnrolledAgentIds:v,enrolledAgentIds:E})},ul=()=>{const{search:e}=(0,o.useLocation)(),{params:t}=(0,o.useRouteMatch)(),a=(0,s.useMemo)((()=>new URLSearchParams(e)),[e]),n=(0,s.useMemo)((()=>a.has("useMultiPageLayout")),[a]),i=(0,s.useMemo)((()=>{var e;return null!==(e=a.get("policyId"))&&void 0!==e?e:void 0}),[a]),[r,d]=l().useState(!1),{pkgName:c,pkgVersion:g}=(0,T.CB)(t.pkgkey),{data:p}=(0,u.ZwD)(),m=(0,s.useMemo)((()=>Boolean(a.get("prerelease"))),[a]);(0,s.useEffect)((()=>{const e=Boolean(null==p?void 0:p.item.prerelease_integrations_enabled)||m;null!=p&&p.item&&d(e)}),[m,null==p?void 0:p.item]);const f={from:"policyId"in t||i?"policy":"package",queryParamsPolicyId:i,prerelease:r,pkgName:c,pkgVersion:g,integration:t.integration};return n?(0,R.jsx)(rl,f):(0,R.jsx)(H.M,f)},dl=({apiKeyId:e,length:t,sendGetAPIKey:a,tokenGetter:l})=>{const{euiTheme:n}=(0,g.useEuiTheme)(),{notifications:i}=(0,ot.WeA)(),[o,r]=(0,s.useState)("HIDDEN"),[u,d]=(0,s.useState)(),c=(0,s.useMemo)((()=>"•".repeat(t)),[t]);return(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs",css:(0,R.css)("font-family:",n.font.familyCode,";",""),"data-test-subj":"apiKeyField"},"VISIBLE"===o?u:c)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:"VISIBLE"===o?f.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):f.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"}),disableScreenReaderOutput:!0},(0,R.jsx)(g.EuiButtonIcon,{"aria-label":"VISIBLE"===o?f.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):f.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"}),color:"text",onClick:async()=>{if("VISIBLE"===o)r("HIDDEN");else if("HIDDEN"===o)try{r("LOADING");const t=await a(e);if(t.error)throw t.error;d(l(t)),r("VISIBLE")}catch(e){i.toasts.addError(e,{title:"Error"}),r("HIDDEN")}},iconType:"VISIBLE"===o?"eyeClosed":"eye","data-test-subj":"showHideTokenButton"}))))};var cl=a(13788);const gl=e=>{const{onCancel:t,onConfirm:a,enrollmentKey:s}=e,l=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":l,title:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.title",{defaultMessage:"Revoke enrollment token"}),titleProps:{id:l},onCancel:t,onConfirm:a,cancelButtonText:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.cancelButton",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.deleteButton",{defaultMessage:"Revoke enrollment token"}),defaultFocusedButton:"confirm",buttonColor:"danger"},(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.description",{defaultMessage:"Are you sure you want to revoke {keyName}? New agents will no longer be able to be enrolled using this token.",values:{keyName:s.name}}),color:"danger"}))},pl=({apiKey:e,refresh:t})=>{const{notifications:a}=(0,u.WeA)(),[n,i]=(0,s.useState)("CONFIRM_HIDDEN");return(0,R.jsx)(l().Fragment,null,"CONFIRM_VISIBLE"===n&&(0,R.jsx)(gl,{enrollmentKey:e,onCancel:()=>i("CONFIRM_HIDDEN"),onConfirm:async()=>{try{const t=await(0,u.TOj)(e.id);if(t.error)throw t.error}catch(e){a.toasts.addError(e,{title:"Error"})}i("CONFIRM_HIDDEN"),t()}}),(0,R.jsx)(g.EuiToolTip,{content:f.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"}),disableScreenReaderOutput:!0},(0,R.jsx)(g.EuiButtonIcon,{"data-test-subj":"enrollmentTokenTable.revokeBtn","aria-label":f.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"}),onClick:()=>i("CONFIRM_VISIBLE"),iconType:"trash",color:"danger"})))},ml="not hidden:true",fl=()=>{var e,t,a;(0,u.ifo)("enrollment_tokens");const[l,n]=(0,s.useState)(!1),[i,o]=(0,s.useState)(""),{pagination:r,setPagination:d,pageSizeOptions:c}=(0,u.WQC)(),p=(0,u.CUP)({page:r.currentPage,perPage:r.pageSize,kuery:""!==i.trim()?`(${i}) and (${ml})`:ml}),x=(0,u.$sk)({page:1,perPage:M.W}),h=x.data?x.data.items:[],y=h.reduce(((e,t)=>(e[t.id]=t,e)),{}),E=null!==(e=null==p||null===(t=p.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0,v=(null==p||null===(a=p.data)||void 0===a?void 0:a.items.filter((e=>{if(!h.length||!e.policy_id)return!1;const t=y[e.policy_id];return!(null!=t&&t.is_managed||null!=t&&t.supports_agentless)})))||[],k=[{field:"name",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.nameTitle",{defaultMessage:"Name"}),render:e=>(0,R.jsx)("span",{className:"eui-textTruncate",title:e},e)},{field:"id",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.secretTitle",{defaultMessage:"Secret"}),width:"215px",render:e=>(0,R.jsx)(dl,{apiKeyId:e,sendGetAPIKey:u.aGY,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.api_key},length:60})},{field:"policy_id",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.policyTitle",{defaultMessage:"Agent policy"}),render:e=>{const t=y[e],a=t?t.name:e;return(0,R.jsx)("span",{className:"eui-textTruncate",title:a},a)}},{field:"created_at",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.createdAtTitle",{defaultMessage:"Created on"}),width:"150px",render:e=>e?(0,R.jsx)(m.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"active",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.activeTitle",{defaultMessage:"Active"}),width:"70px",align:"center",render:e=>(0,R.jsx)(g.EuiIcon,{size:"m",color:e?"success":"danger",type:"dot"})},{field:"actions",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.actionsTitle",{defaultMessage:"Actions"}),width:"70px",render:(e,t)=>{const a=h.find((e=>e.id===t.policy_id));return t.active&&!(null!=a&&a.is_managed)&&(0,R.jsx)(pl,{apiKey:t,refresh:()=>p.refetch()})}}],j=p.isInitialLoading||x.isLoading&&x.isInitialRequest;return(0,R.jsx)(I.iW,{section:"enrollment_tokens"},l&&(0,R.jsx)(F.jY,{agentPolicies:h,onClose:e=>{n(!1),p.refetch()}}),(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.pageDescription",defaultMessage:"Create and revoke enrollment tokens. An enrollment token enables one or more agents to enroll in Fleet and send data."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(cl.I,{value:i,indexPattern:M.Al,fieldPrefix:M.w1,onChange:e=>{d({...r,currentPage:1}),o(e)},dataTestSubj:"enrollmentKeysList.queryInput"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{"data-test-subj":"createEnrollmentTokenButton",fill:!0,iconType:"plusInCircle",onClick:()=>n(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.newKeyButton",defaultMessage:"Create enrollment token"})))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiBasicTable,{"data-test-subj":"enrollmentTokenListTable",loading:j,noItemsMessage:j?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.loadingTokensMessage",defaultMessage:"Loading enrollment tokens..."}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.emptyMessage",defaultMessage:"No enrollment tokens found."}),items:E?v:[],itemId:"id",columns:k,pagination:{pageIndex:r.currentPage-1,pageSize:r.pageSize,totalItemCount:E,pageSizeOptions:c},onChange:({page:e})=>{const t={...r,currentPage:e.index+1,pageSize:e.size};d(t)}}))};var xl=a(50998),hl=a(1442);const yl=f.i18n.translate("xpack.fleet.uninstallTokenList.policyIdTitle",{defaultMessage:"Policy ID"}),El=f.i18n.translate("xpack.fleet.uninstallTokenList.policyNameTitle",{defaultMessage:"Policy name"}),vl=f.i18n.translate("xpack.fleet.uninstallTokenList.createdAtTitle",{defaultMessage:"Created at"}),kl=f.i18n.translate("xpack.fleet.uninstallTokenList.tokenTitle",{defaultMessage:"Token"}),jl=f.i18n.translate("xpack.fleet.uninstallTokenList.actionsTitle",{defaultMessage:"Actions"}),bl=f.i18n.translate("xpack.fleet.uninstallTokenList.viewUninstallCommandLabel",{defaultMessage:"View uninstall command"}),Sl=f.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNamePlaceholder",{defaultMessage:"Search by policy ID or policy name"}),Fl=f.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNameHint",{defaultMessage:"If an Agent policy is deleted, its policy name is also deleted. Use the policy ID to search for uninstall tokens related to deleted Agent policies."}),Ml=({text:e,dataTestSubj:t})=>(0,R.jsx)(g.EuiText,{size:"s",className:"eui-textTruncate",title:e,"data-test-subj":t},e),Il=({onClick:e})=>(0,R.jsx)(g.EuiToolTip,{content:bl,disableScreenReaderOutput:!0},(0,R.jsx)(g.EuiButtonIcon,{"data-test-subj":"uninstallTokensViewCommandButton","aria-label":bl,onClick:e,iconType:"inspect",color:"text"})),Tl=({isLoading:e})=>e?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.loadingTokensMessage",defaultMessage:"Loading uninstall tokens..."}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.emptyMessage",defaultMessage:"No uninstall tokens found."}),wl=()=>{var e,t;(0,u.ifo)("uninstall_tokens");const[a,l]=(0,s.useState)(""),[n,i]=(0,s.useState)(null),{pagination:o,setPagination:r,pageSizeOptions:d}=(0,u.WQC)(),{isLoading:c,data:p}=(0,hl.oH)({perPage:o.pageSize,page:o.currentPage,search:a}),f=null!==(e=null==p?void 0:p.items)&&void 0!==e?e:[],x=null!==(t=null==p?void 0:p.total)&&void 0!==t?t:0,h=(0,s.useMemo)((()=>[{field:"policy_name",name:El,render:e=>null===e?(0,R.jsx)(xl.C,null):(0,R.jsx)(Ml,{text:e})},{field:"policy_id",name:yl,render:e=>(0,R.jsx)(Ml,{text:e,dataTestSubj:"uninstallTokensPolicyIdField"})},{field:"created_at",name:vl,width:"130px",render:e=>e?(0,R.jsx)(m.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"id",name:kl,width:"300px",render:e=>(0,R.jsx)(dl,{apiKeyId:e,sendGetAPIKey:hl.Wz,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.token},length:32})},{field:"actions",name:jl,align:"center",width:"70px",render:(e,{id:t})=>(0,R.jsx)(Il,{onClick:()=>i(t)})}]),[]),y=(0,s.useCallback)((({page:e})=>{r((t=>({...t,currentPage:e.index+1,pageSize:e.size})))}),[r]),E=(0,s.useCallback)((e=>{l(e),r((e=>({...e,currentPage:1})))}),[r]);return(0,R.jsx)(I.iW,{section:"uninstall_tokens"},n&&(0,R.jsx)(F.pc,{onClose:()=>i(null),target:"agent",uninstallTokenId:n}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.pageDescription",defaultMessage:"An uninstall token allows you to use the uninstall command to remove Elastic Agent from a host."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{direction:"row",alignItems:"center"},(0,R.jsx)(g.EuiFieldSearch,{onSearch:E,incremental:!0,fullWidth:!0,maxLength:50,placeholder:Sl,"data-test-subj":"uninstallTokensPolicyIdSearchInput"}),(0,R.jsx)(g.EuiIconTip,{content:Fl,type:"info"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiBasicTable,{"data-test-subj":"uninstallTokenListTable",items:f,columns:h,itemId:"id",loading:c,pagination:{pageIndex:o.currentPage-1,pageSize:o.pageSize,totalItemCount:x,pageSizeOptions:d},onChange:y,noItemsMessage:(0,R.jsx)(Tl,{isLoading:c})}),(0,R.jsx)(g.EuiSpacer,{size:"xl"}))},Al=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-1t6qzy1-0"})(["max-width:250px;"]),Cl=P()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-1t6qzy1-1"})(["min-width:0px;"]),Pl=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(Al,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.managedTooltip",{defaultMessage:"This Fleet server host is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"host_urls",render:e=>l().createElement(Cl,{direction:"column",gutterSize:"xs"},e.map((e=>l().createElement(g.EuiFlexItem,{key:e},l().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.hostUrlsColumnTitle",{defaultMessage:"Host URLs"})},{render:e=>e.is_default?l().createElement(g.EuiIcon,{type:"check","data-test-subj":"fleetServerHostTable.defaultIcon"}):null,width:"200px",name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_preconfigured&&a.fleet.allSettings;return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.deleteButtonTitle",{defaultMessage:"Delete"}),"aria-label":f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.deleteButtonAriaLabel",{defaultMessage:"Delete host"}),"data-test-subj":"fleetServerHostsTable.delete.btn"})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_fleet_server_hosts",{itemId:e.id}),title:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.editButtonTitle",{defaultMessage:"Edit"}),"aria-label":f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.editButtonAriaLabel",{defaultMessage:"Edit host"}),"data-test-subj":"fleetServerHostsTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[n,t,a.fleet.allSettings]);return l().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"settingsFleetServerHostsTable"})},Ll=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{docLinks:s}=(0,u.WeA)(),{getHref:n}=(0,u.iEg)();return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",{"data-test-subj":"fleetServerHostHeader"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionTitle",defaultMessage:"Fleet server hosts"}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionSubtitle",defaultMessage:"Specify the URLs that your agents will use to connect to a Fleet Server. If multiple URLs exist, Fleet will show the first provided URL for enrollment purposes. For more information, see the {guideLink} .",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:s.links.fleet.guide,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetUserGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Pl,{fleetServerHosts:e,deleteFleetServerHost:t}),a.fleet.addFleetServers?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:n("settings_create_fleet_server_hosts"),"data-test-subj":"settings.fleetServerHosts.addFleetServerHostBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostCreateButtonLabel",defaultMessage:"Add Fleet Server"}))):null,(0,R.jsx)(g.EuiSpacer,{size:"m"}))},_l=({output:e,showBadge:t})=>{var a,n;const{notifications:i}=(0,u.WeA)(),[o,r]=(0,s.useState)(),{data:d}=(0,x.useQuery)(["outputHealth",e.id],(()=>(0,u.IaD)(e.id)),{refetchInterval:1e4});(0,s.useEffect)((()=>{null!=d&&d.error&&i.toasts.addError(null==d?void 0:d.error,{title:f.i18n.translate("xpack.fleet.output.errorFetchingOutputHealth",{defaultMessage:"Error fetching output state"})}),r(null==d?void 0:d.data)}),[d,i.toasts]);const c={DEGRADED:(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger",iconType:"error","data-test-subj":"outputHealthDegradedCallout"},(0,R.jsx)("p",{className:"eui-textBreakWord"},f.i18n.translate("xpack.fleet.output.calloutText",{defaultMessage:'Unable to connect to "{name}" at {host}.',values:{name:e.name,host:null!==(a=null===(n=e.hosts)||void 0===n?void 0:n.join(","))&&void 0!==a?a:""}})),(0,R.jsx)("p",null,f.i18n.translate("xpack.fleet.output.calloutPromptText",{defaultMessage:"Please check the details are correct."}))),HEALTHY:(0,R.jsx)(g.EuiCallOut,{title:"Healthy",color:"success",iconType:"check","data-test-subj":"outputHealthHealthyCallout"},(0,R.jsx)("p",null,f.i18n.translate("xpack.fleet.output.successCalloutText",{defaultMessage:"Connection with remote output established."})))},p={DEGRADED:(0,R.jsx)(g.EuiBadge,{color:"danger","data-test-subj":"outputHealthDegradedBadge"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.outputHealth.degradedStatusText",defaultMessage:"Unhealthy"})),HEALTHY:(0,R.jsx)(g.EuiBadge,{color:"success","data-test-subj":"outputHealthHealthyBadge"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.outputHealth.healthyStatusText",defaultMessage:"Healthy"}))},h=new Date((null==o?void 0:o.timestamp)||0).getTime(),y=h?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.outputHealth.timestampTooltipText",defaultMessage:"Last reported {timestamp}",values:{timestamp:(0,R.jsx)(m.FormattedRelative,{value:h})}})):null,E=(null==o?void 0:o.state)&&p[null==o?void 0:o.state]||null;return t?y&&null!=o&&o.state?(0,R.jsx)(g.EuiToolTip,{position:"top",content:y,"data-test-subj":"outputHealthBadgeTooltip"},(0,R.jsx)(l().Fragment,null,E," ")):E:(null==o?void 0:o.state)&&c[o.state]||null},Dl=l().memo((({output:e})=>{const t=(0,s.useMemo)((()=>{const t=[];return e.is_default&&t.push((0,R.jsx)(Ol,{key:"default-output"})),e.is_default_monitoring&&t.push((0,R.jsx)(Rl,{key:"default-monitoring-output"})),t}),[e]);return(0,R.jsx)(g.EuiBadgeGroup,{gutterSize:"xs"},t.map(((e,t)=>e)))})),Ol=()=>(0,R.jsx)(g.EuiBadge,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultOutputBadgeTitle",defaultMessage:"Agent integrations"})),Rl=()=>(0,R.jsx)(g.EuiBadge,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultMonitoringOutputBadgeTitle",defaultMessage:"Agent monitoring"})),Bl=({status:e,onClick:t,onClickAriaLabel:a})=>{const s=t&&a?{onClick:t,onClickAriaLabel:a}:{};return{FAILED:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"danger","data-test-subj":"integrationSyncFailedBadge",iconType:"errorFilled"},s),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.failedText",defaultMessage:"Failed"})),WARNING:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"warning","data-test-subj":"integrationSyncWarningBadge",iconType:"warning"},s),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.warningText",defaultMessage:"Warning"})),COMPLETED:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"success","data-test-subj":"integrationSyncCompletedBadge",iconType:"check"},s),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.completedText",defaultMessage:"Completed"})),SYNCHRONIZING:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"hollow","data-test-subj":"integrationSyncSyncingBadge"},s),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLoadingSpinner,{size:"s"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.syncingText",defaultMessage:"Syncing..."})))),NA:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",justifyContent:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.naText",defaultMessage:"N/A"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.integrationSyncStatus.naTooltip",{defaultMessage:"Integration syncing only applies to remote outputs."}),type:"info",color:"subdued"}))),DISABLED:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",justifyContent:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.disabledText",defaultMessage:"Sync disabled"})," ")),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.integrationSyncStatus.disabledTooltip",{defaultMessage:"Integration syncing is disabled for this remote output. Enable it by clicking the edit icon and updating the output settings."}),type:"info",color:"subdued"})))}[e]},Nl=({id:e,title:t,children:a,isDisabled:l,"data-test-subj":n})=>{const i=(0,s.useMemo)((()=>{if(n)return{"data-test-subj":`${n}-openCloseToggle`}}),[n]),{euiTheme:o}=(0,g.useEuiTheme)();return(0,R.jsx)(g.EuiPanel,{paddingSize:"none",css:(0,R.css)("border:solid 1px ",o.colors.borderBasePlain,";box-shadow:none;border-radius:6px;","")},(0,R.jsx)(g.EuiAccordion,{css:(0,R.css)(".euiAccordion__button{width:90%;}.euiAccordion__triggerWrapper{padding-left:",o.size.m,";}&.euiAccordion-isOpen{.euiAccordion__childWrapper{padding:",o.size.m,";padding-top:0px;}}.ingest-integration-title-button{padding:",o.size.s,";}.euiTableRow:last-child .euiTableRowCell{border-bottom:none;}.euiIEFlexWrapFix{min-width:0;}.euiAccordion__buttonContent{width:100%;}",""),id:e,arrowDisplay:l?"none":"left",buttonClassName:"ingest-integration-title-button",buttonContent:t,arrowProps:i,"data-test-subj":n,isDisabled:l},a))},zl=(0,s.memo)((({integration:e,customAssets:t,syncUninstalledIntegrations:a,"data-test-subj":n})=>{var i,o,r;const[d,c]=(0,s.useState)(void 0);(0,s.useEffect)((()=>{(0,u.rfo)(e.package_name,e.package_version,{prerelease:!0}).then((e=>{c(e.item)}))}),[e.package_name,e.package_version]);const p=Hl([e.sync_status,...t.map((e=>e.sync_status))]).toUpperCase(),{euiTheme:f}=(0,g.useEuiTheme)(),{docLinks:x}=(0,u.WeA)(),h="installed"!==e.install_status.main?f.colors.textDisabled:f.colors.textParagraph;return(0,R.jsx)(Nl,{id:e.package_name,"data-test-subj":n,isDisabled:!(e.error||null!=e&&e.warning||t.length),title:(0,R.jsx)(g.EuiTitle,{size:"xs"},(0,R.jsx)("h3",null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(w.qD,{packageName:e.package_name,version:e.package_version,size:"l",tryApi:!0})),(0,R.jsx)(g.EuiFlexItem,{className:"eui-textTruncate"},d?(0,R.jsx)(g.EuiTitle,{size:"xs",css:(0,R.css)("color:",h,";","")},(0,R.jsx)("p",null,null!==(i=null==d?void 0:d.title)&&void 0!==i?i:"")):(0,R.jsx)(U.Rh,null)))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Bl,{status:p})))))},(0,R.jsx)(l().Fragment,null,(null==e?void 0:e.error)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationErrorTitle",defaultMessage:"Error"}),color:"danger",iconType:"error",size:"s","data-test-subj":"integrationSyncIntegrationErrorCallout"},(0,R.jsx)(g.EuiText,{size:"s"},e.error)),(0,R.jsx)(g.EuiSpacer,{size:"s"})),"warning"===e.sync_status&&(null==e?void 0:e.warning)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationWarningTitle",defaultMessage:"{Warning}",values:{Warning:null===(o=e.warning)||void 0===o?void 0:o.title}}),color:"warning",iconType:"warning",size:"s","data-test-subj":"integrationSyncIntegrationWarningCallout"},(null==e||null===(r=e.warning)||void 0===r?void 0:r.message)&&(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationWarningContent",defaultMessage:"{uninstallWarning}",values:{uninstallWarning:e.warning.message}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiButton,{color:"warning",href:x.links.fleet.remoteESOoutputTroubleshooting,iconType:"popout",target:"blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationWarningButton",defaultMessage:"View troubleshooting guide"})))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),t.map((e=>(0,R.jsx)(g.EuiAccordion,{id:`${e.type}:${e.name}`,key:`${e.type}:${e.name}`,arrowDisplay:e.error?"left":"none",isDisabled:!e.error,buttonContent:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{size:"s"},e.name)),e.is_deleted&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiBadge,{color:"hollow"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.deletedText",defaultMessage:"Deleted"})))),"data-test-subj":`${e.type}:${e.name}-accordion`,extraAction:e.sync_status===Se.um.SYNCHRONIZING?(0,R.jsx)(g.EuiLoadingSpinner,{size:"m"}):(0,R.jsx)(g.EuiIcon,{size:"m",color:e.sync_status===Se.um.FAILED?"danger":"success",type:e.sync_status===Se.um.FAILED?"errorFilled":"checkInCircleFilled"}),paddingSize:"none"},e.error&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.errorTitle",defaultMessage:"Error"}),color:"danger",iconType:"error",size:"s","data-test-subj":"integrationSyncAssetErrorCallout"},(0,R.jsx)(g.EuiText,{size:"s"},e.error)),(0,R.jsx)(g.EuiSpacer,{size:"s"})))))))})),Ul=(0,s.memo)((({onClose:e,syncedIntegrationsStatus:t,outputName:a,syncUninstalledIntegrations:s})=>{var l;const{docLinks:n}=(0,u.WeA)(),i=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:e,"aria-labelledby":i},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h2",{id:i},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.titleText",defaultMessage:"Integration syncing status"}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"s","data-test-subj":"integrationSyncFlyoutHeaderText"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.headerText",defaultMessage:"You're viewing sync activity for {outputName}. Check overall progress and view individual sync statuses from custom assets. {documentationLink}.",values:{outputName:a,documentationLink:(0,R.jsx)(g.EuiLink,{href:`${n.links.fleet.remoteESOoutput}#automatic-integrations-synchronization`,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.documentationLink",defaultMessage:"Learn more"}))}}))),(0,R.jsx)(g.EuiFlyoutBody,null,(null==t?void 0:t.error)&&(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.errorTitle",defaultMessage:"Error"}),color:"danger",iconType:"error",size:"s","data-test-subj":"integrationSyncFlyoutTopErrorCallout"},(0,R.jsx)(g.EuiText,{size:"s"},null==t?void 0:t.error)),(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(null!==(l=null==t?void 0:t.integrations)&&void 0!==l?l:[]).filter((e=>{var t,a;return!("not_installed"===(null===(t=e.install_status)||void 0===t?void 0:t.main)&&"not_installed"===(null===(a=e.install_status)||void 0===a?void 0:a.remote))})).map((e=>{var a;const l=Object.values(null!==(a=null==t?void 0:t.custom_assets)&&void 0!==a?a:{}).filter((t=>t.package_name===e.package_name));return(0,R.jsx)(g.EuiFlexItem,{grow:!1,key:e.package_name},(0,R.jsx)(zl,{"data-test-subj":`${e.package_name}-accordion`,integration:e,customAssets:l,syncUninstalledIntegrations:s}))})))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.closeFlyoutButtonLabel",defaultMessage:"Close"}))))))}));function Hl(e){return e.some((e=>e===Se.um.FAILED))?Se.um.FAILED:e.some((e=>e===Se.um.WARNING))?Se.um.WARNING:e.some((e=>e===Se.um.SYNCHRONIZING))?Se.um.SYNCHRONIZING:Se.um.COMPLETED}const Wl=(0,s.memo)((({output:e})=>{const{data:t,error:a}=(0,u.XMG)(e.id,{enabled:"remote_elasticsearch"===e.type&&e.sync_integrations}),[n,i]=(0,s.useState)(!1),o=(0,s.useMemo)((()=>{var s,l;if("remote_elasticsearch"!==e.type)return"NA";if(!e.sync_integrations)return"DISABLED";if(!a&&!t)return"SYNCHRONIZING";const n=Hl([...(null!==(s=null==t?void 0:t.integrations)&&void 0!==s?s:[]).filter((e=>{var t,a;return!("not_installed"===(null===(t=e.install_status)||void 0===t?void 0:t.main)&&"not_installed"===(null===(a=e.install_status)||void 0===a?void 0:a.remote))})).map((e=>e.sync_status))||[],...Object.values(null!==(l=null==t?void 0:t.custom_assets)&&void 0!==l?l:{}).map((e=>e.sync_status))]).toUpperCase();return null!=a&&a.message||null!=t&&t.error?"FAILED":n}),[e,t,a]);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(Bl,{status:o,onClick:()=>{i(!0)},onClickAriaLabel:"Show details"}),n&&(0,R.jsx)(Ul,{onClose:()=>i(!1),syncedIntegrationsStatus:a?{integrations:[],error:a.message}:t,outputName:e.name,syncUninstalledIntegrations:"remote_elasticsearch"===e.type&&(null==e?void 0:e.sync_uninstalled_integrations)}))})),Gl=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-uvxtm0-0"})(["max-width:250px;"]),Kl=P()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-uvxtm0-1"})(["min-width:0px;"]),ql=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),{enableSyncIntegrationsOnRemote:i}=N.ZX.get(),{cloud:o}=(0,u.WeA)(),r=i&&u.Fjq.isEnterprise()&&!(null!=o&&o.isServerlessEnabled),d=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(Gl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.outputsTable.managedTooltip",{defaultMessage:"This output is managed outside of Fleet."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.outputsTable.nameColumnTitle",{defaultMessage:"Name"})},{width:"172px",render:e=>function(e){switch(e){case"elasticsearch":return f.i18n.translate("xpack.fleet.settings.outputsTable.elasticsearchTypeLabel",{defaultMessage:"Elasticsearch"});case"remote_elasticsearch":return f.i18n.translate("xpack.fleet.settings.outputsTable.remoteElasticsearchTypeLabel",{defaultMessage:"Remote Elasticsearch"});default:return e}}(e.type),name:f.i18n.translate("xpack.fleet.settings.outputsTable.typeColumnTitle",{defaultMessage:"Type"})},{truncateText:!0,render:e=>l().createElement(Kl,{direction:"column",gutterSize:"xs"},(e.hosts||[]).map((e=>l().createElement(g.EuiFlexItem,{key:e},l().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:f.i18n.translate("xpack.fleet.settings.outputsTable.hostColumnTitle",{defaultMessage:"Hosts"})},{render:e=>null!=e&&e.id&&"remote_elasticsearch"===e.type?l().createElement(_l,{output:e,showBadge:!0}):null,name:f.i18n.translate("xpack.fleet.settings.outputsTable.statusColumnTitle",{defaultMessage:"Status"})},...r?[{render:e=>l().createElement(Wl,{output:e}),name:f.i18n.translate("xpack.fleet.settings.outputsTable.integrationSyncColumnTitle",{defaultMessage:"Integration syncing"})}]:[],{render:e=>l().createElement(Dl,{output:e}),width:"200px",name:f.i18n.translate("xpack.fleet.settings.outputSection.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_default_monitoring&&!e.is_preconfigured&&a.fleet.allSettings;return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.outputSection.deleteButtonTitle",{defaultMessage:"Delete"}),"aria-label":f.i18n.translate("xpack.fleet.settings.outputSection.deleteButtonTitle",{defaultMessage:"Delete"})})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_outputs",{outputId:e.id}),title:f.i18n.translate("xpack.fleet.settings.outputSection.editButtonTitle",{defaultMessage:"Edit"}),"aria-label":f.i18n.translate("xpack.fleet.settings.outputSection.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"editOutputBtn"})))},name:f.i18n.translate("xpack.fleet.settings.outputSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a.fleet.allSettings,r]);return l().createElement(g.EuiBasicTable,{columns:d,items:e,"data-test-subj":"settingsOutputsTable"})},Vl=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:n}=(0,u.WeA)();return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputSectionTitle",defaultMessage:"Outputs"}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(g.EuiLink,{href:n.links.fleet.settings,external:!0,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputSectionSubtitle",defaultMessage:"Specify where agents will send data."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(ql,{outputs:e,deleteOutput:t}),a.fleet.allSettings&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_outputs"),"data-test-subj":"addOutputBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputCreateButtonLabel",defaultMessage:"Add output"}))))},$l=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-xsf6c1-0"})(["max-width:250px;"]),Yl=P()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-xsf6c1-1"})(["min-width:0px;"]),Ql=({downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:a})=>{const{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement($l,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.name"},e.name))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,render:e=>l().createElement(Yl,{direction:"column",gutterSize:"xs"},l().createElement(g.EuiFlexItem,{key:e.host},l().createElement("p",{title:e.host,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.host"},e.host))),name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.hostColumnTitle",{defaultMessage:"Host"})},{render:e=>e.is_default?l().createElement(g.EuiIcon,{type:"check","data-test-subj":"editDownloadSourceTable.defaultIcon"}):null,width:"200px",name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&a,i=f.i18n.translate("xpack.fleet.settings.downloadSourceSection.deleteButtonTitle",{defaultMessage:"Delete"}),o=f.i18n.translate("xpack.fleet.settings.downloadSourceSection.editButtonTitle",{defaultMessage:"Edit"});return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{"aria-label":i,color:"text",iconType:"trash",onClick:()=>t(e),title:i,"data-test-subj":"editDownloadSourceTable.delete.btn"})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{"aria-label":o,color:"text",iconType:"pencil",href:n("settings_edit_download_sources",{downloadSourceId:e.id}),title:o,"data-test-subj":"editDownloadSourceTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.downloadSourceSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a]);return l().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"AgentDownloadSourcesTable"})},Xl=({downloadSources:e,deleteDownloadSource:t})=>{const{getHref:a}=(0,u.iEg)(),s=(0,u.iO7)().fleet.allSettings;return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Title",defaultMessage:"Agent Binary Download"}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Subtitle",defaultMessage:"List of sources used by Elastic agents to download their binaries. The default source applies to all agent policies that don't have a specific binary source specified."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ql,{downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:s}),s&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:a("settings_create_download_sources"),"data-test-subj":"addDownloadSourcesBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.CreateButtonLabel",defaultMessage:"Add agent binary source"}))))},Jl=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-czjc9c-0"})(["max-width:250px;"]),Zl=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(Jl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"fleetProxiesTable.name"},e.name)),e.is_preconfigured&&l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.managedTooltip",{defaultMessage:"This proxy is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"url",name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.urlColumnTitle",{defaultMessage:"Url"})},{width:"68px",render:e=>{const s=a.fleet.allSettings&&!e.is_preconfigured,i=f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.deleteButtonTitle",{defaultMessage:"Delete"}),o=f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.editButtonTitle",{defaultMessage:"Edit"});return l().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(g.EuiFlexItem,{grow:!1},s&&l().createElement(g.EuiButtonIcon,{"aria-label":i,color:"text",iconType:"trash",onClick:()=>t(e),title:i,"data-test-subj":"fleetProxiesTable.delete.btn"})),l().createElement(g.EuiFlexItem,{grow:!1},l().createElement(g.EuiButtonIcon,{"aria-label":o,color:"text",iconType:"pencil",href:n("settings_edit_fleet_proxy",{itemId:e.id}),title:o,"data-test-subj":"fleetProxiesTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a.fleet.allSettings]);return l().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"fleetProxiesTable"})},en=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:n}=(0,u.WeA)();return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.title",defaultMessage:"Proxies"}))))),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.subtitle",defaultMessage:"Specify any proxy URLs to be used in Fleet servers, Outputs or Agent binary download sources. For more information see our {docLink}.",values:{docLink:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:n.links.fleet.proxiesSettings},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.link",defaultMessage:"docs"}))}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Zl,{proxies:e,deleteFleetProxy:t}),a.fleet.allSettings&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_fleet_proxy"),"data-test-subj":"addProxyBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.CreateButtonLabel",defaultMessage:"Add proxy"}))))},tn=({})=>{var e,t,a,n,i,o,r,d;const c=(0,u.iO7)(),p=(0,u.YI3)(),{docLinks:x,notifications:h,overlays:y}=(0,u.WeA)(),E=null!==(e=null===(t=(0,u.ZwD)().data)||void 0===t||null===(a=t.item)||void 0===a||null===(n=a.delete_unenrolled_agents)||void 0===n?void 0:n.enabled)&&void 0!==e&&e,v=null!==(i=null===(o=(0,u.ZwD)().data)||void 0===o||null===(r=o.item)||void 0===r||null===(d=r.delete_unenrolled_agents)||void 0===d?void 0:d.is_preconfigured)&&void 0!==i&&i,[k,j]=l().useState(E),{mutateAsync:b}=(0,u.Zd9)(),{showAgentless:S,setShowAgentless:F}=(0,u.jXQ)(),{mutateAsync:M,isLoading:I}=(0,u.X37)();(0,s.useEffect)((()=>{E&&j(E)}),[E]);const T=(0,s.useCallback)((async e=>{try{j(e);const t=await b({delete_unenrolled_agents:{enabled:e,is_preconfigured:!1}});if(t.error)throw t.error}catch(t){j(!e),h.toasts.addError(t,{title:f.i18n.translate("xpack.fleet.errorUpdatingSettings",{defaultMessage:"Error updating settings"})})}}),[b,h.toasts]),w=(0,s.useCallback)((async()=>{if(await y.openConfirm(f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigrationMessage",{defaultMessage:"This migration will enable each space to have its own agent policy and agents. This is a one-way migration and can’t be reversed."}),{title:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigrationTitle",{defaultMessage:"Migrate to Space-Aware Agent Policies?"}),buttonColor:"warning",confirmButtonText:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.confirmButtonText",{defaultMessage:"Confirm and migrate"})}))try{await M(),h.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.successToastTitle",{defaultMessage:"Migration complete"}),text:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.successToastContent",{defaultMessage:"Your cluster now uses space-aware agent policies."})})}catch(e){h.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.errorToastTitle",{defaultMessage:"Migration failed"})})}}),[M,h.toasts,y]);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",{"data-test-subj":"advancedHeader"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSectionTitle",defaultMessage:"Advanced Settings"}))),p.isSpaceAwarenessEnabled?null:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiDescribedFormGroup,{title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.migrateSpaceAwarenessLabel",defaultMessage:"Migrate to space-aware agent policies"})),description:(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.switchLabel",defaultMessage:"Take advantage of improved isolation and management by enabling space-specific agent policies."}))},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiButton,{onClick:w,isLoading:I},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Start migration"}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiDescribedFormGroup,{title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"})),description:(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.switchLabel",defaultMessage:"Switching on this setting will enable auto-deletion of unenrolled agents. For more information, refer to the {docLink}.",values:{docLink:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:x.links.fleet.settings},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.link",defaultMessage:"docs"}))}}))},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiToolTip,{content:v?f.i18n.translate("xpack.fleet.settings.advancedSection.preconfiguredTitle",{defaultMessage:"This setting is preconfigured and cannot be updated."}):void 0},(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"}),checked:k,onChange:e=>T(e.target.checked),disabled:!c.fleet.allSettings||v})))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiDescribedFormGroup,{title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.showAgentlessResourcesLabel",defaultMessage:"Show agentless resources"})),description:(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.showAgentlessResourcesDescription",defaultMessage:"Enable this toggle to display agentless agents and policies in Fleet for debugging and diagnostics purposes. This setting is stored locally and is only visible to you."}))},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.showAgentlessResourcesLabel",defaultMessage:"Show agentless resources"}),checked:S,onChange:e=>{F(e.target.checked),F(e.target.checked)},"data-test-subj":"showAgentlessResourcesSwitch"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},an=({outputs:e,proxies:t,fleetServerHosts:a,deleteOutput:s,deleteFleetServerHost:n,downloadSources:i,deleteDownloadSource:o,deleteFleetProxy:r})=>(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ll,{fleetServerHosts:a,deleteFleetServerHost:n}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Vl,{outputs:e,deleteOutput:s}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Xl,{downloadSources:i,deleteDownloadSource:o}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(en,{proxies:t,deleteFleetProxy:r}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(tn,null));var sn=a(47907),ln=a(54761);const nn=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":s,fullWidth:!0},t.props,{placeholder:a}))),on=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":s},t.props,{placeholder:a}))),rn=()=>(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",size:"s",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.proxyWarning.warningTitle",defaultMessage:"Be aware that changing the proxy settings may cause Elastic Agents to lose connectivity. Please ensure that agents have reachability to the proxy in the context that it is being used for."})});var un=a(79519),dn=a(38684);const cn=({onClose:e,fleetServerHost:t,defaultFleetServerHost:a,proxies:n})=>{var i,o,r;const c=(0,g.useGeneratedHtmlId)(),{docLinks:p,cloud:x}=(0,u.WeA)(),h=(0,dn.ao)(t,e,a),{inputs:y}=h,E=(0,s.useMemo)((()=>n.map((e=>({value:e.id,label:e.name})))),[n]),{enableSSLSecrets:v}=N.ZX.get(),[k,j]=l().useState(!0),[b,S]=l().useState({sslKey:!1,sslESKey:!1}),[F,I]=(0,s.useState)(!0),T=!0===F,w=(0,u.YI3)();return void 0!==w.isSecretsStorageEnabled&&"disabled"===F&&I(w.isSecretsStorageEnabled),(0,s.useEffect)((()=>{k&&(j(!1),T&&v&&(y.sslKeyInput.value&&!y.sslKeySecretInput.value&&(y.sslKeySecretInput.setValue(y.sslKeyInput.value),y.sslKeyInput.clear(),S({...b,sslKey:!0})),y.sslESKeyInput.value&&!y.sslESKeySecretInput.value&&(y.sslESKeySecretInput.setValue(y.sslESKeyInput.value),y.sslESKeyInput.clear(),S({...b,sslESKey:!0}))))}),[y.sslKeyInput,y.sslKeySecretInput,k,j,b,y.sslESKeyInput,y.sslESKeySecretInput,F,T,v]),(0,R.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW,"aria-labelledby":c},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:c},t?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.editTitle",defaultMessage:"Edit Fleet Server"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.addTitle",defaultMessage:"Add Fleet Server"}))),!t&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessInfoText",defaultMessage:"You may create another Fleet Server definition reachable via a proxy. In context of the serverless project, Fleet Service is managed by Elastic. Creation of a new one is therefore not permitted."}))))),(0,R.jsx)(g.EuiFlyoutBody,null,t&&(0,R.jsx)(g.EuiCallOut,{size:"m",color:"warning",iconType:"warning",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutTitle",defaultMessage:"Changing these settings can break your agent connections"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutDescription",defaultMessage:"Invalid settings can break the connection between Elastic Agent and Fleet Server. If this happens, you will need to re-enroll your agents."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiForm,{onSubmit:h.submit},(0,R.jsx)(nn,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:y.nameInput,dataTestSubj:"fleetServerHostsFlyout.nameInput",placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.hostUrlLabel",defaultMessage:"URL"})},(0,R.jsx)(l().Fragment,null,!(null!=x&&x.isServerlessEnabled)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{color:"subdued",size:"relative"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.description",defaultMessage:"Specify multiple URLs to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully. For more information, see the {link} .",values:{link:(0,R.jsx)(g.EuiLink,{href:p.links.fleet.settingsFleetServerHostSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.userGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,R.jsx)(g.EuiSpacer,{size:"m"})),(0,R.jsx)(ln.G,(0,d.default)({},y.hostUrlsInput.props,{id:"fleet-server-inputs",placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.fleetServerHostsInputPlaceholder",{defaultMessage:"Specify host URL"}),isUrl:!0,helpText:(null==x?void 0:x.isServerlessEnabled)&&(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"fleetServerHostsFlyout.proxyIdInput"},null===(i=y.proxyIdInput)||void 0===i?void 0:i.props,{onChange:e=>{var t,a,s;return null==y||null===(t=y.proxyIdInput)||void 0===t?void 0:t.setValue(null!==(a=null==e||null===(s=e[0])||void 0===s?void 0:s.value)&&void 0!==a?a:"")},selectedOptions:""!==(null==y||null===(o=y.proxyIdInput)||void 0===o?void 0:o.value)?E.filter((e=>{var t;return e.value===(null===(t=y.proxyIdInput)||void 0===t?void 0:t.value)})):[],options:E,singleSelection:{asPlainText:!0},isDisabled:null===(r=y.proxyIdInput)||void 0===r?void 0:r.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(rn,null))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},y.isDefaultInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"fleetServerHostsFlyout.isDefaultSwitch"},y.isDefaultInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this Fleet server the default one."})}))),(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(un.k,{inputs:y,useSecretsStorage:v&&T,onToggleSecretAndClearValue:e=>{e?(y.sslKeyInput.clear(),y.sslESKeyInput.clear()):(y.sslKeySecretInput.setValue(""),y.sslESKeySecretInput.setValue("")),S({...b,sslKey:!1,sslESKey:!1}),(e=>{"disabled"!==F&&I(e)})(e)},isConvertedToSecret:b}))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:h.isLoading,isDisabled:h.isDisabled,onClick:h.submit,"data-test-subj":"saveApplySettingsBtn","aria-label":"Save and apply settings"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},gn=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),pn=({})=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalText",defaultMessage:"This action will change agent policies currently using that proxy. Are you sure you wish to continue?"});async function mn(e){var t,a;let s=`${M.mm}.data_output_id:"${e.id}" or ${M.mm}.monitoring_output_id:"${e.id}"`;const l=`${M.f$}.output_id:"${e.id}"`;e.is_default&&(s+=` or (not ${M.mm}.data_output_id:*)`);const n=await(0,u.cnO)({kuery:s,page:1,perPage:M.W,noAgentCount:!0});if(n.error)throw n.error;const i=await(0,u.TR6)({kuery:l,page:1,perPage:M.W});if(i.error)throw n.error;const o=((null===(t=n.data)||void 0===t?void 0:t.items)||[]).map((e=>e.id)),r=((null===(a=i.data)||void 0===a?void 0:a.items)||[]).reduce(((e,t)=>[...e,...t.policy_ids||[]]),[]),d=new Set([...o,...r]),c=d.size;let g=0;if(c>0){var p,m;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:[...d].map((e=>`policy_id:"${e}"`)).join(" or ")});if(e.error)throw e.error;g=null!==(p=null===(m=e.data)||void 0===m?void 0:m.total)&&void 0!==p?p:0}return{agentPolicyCount:c,agentCount:g}}const fn=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),xn=({output:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalText",defaultMessage:"This action will delete {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTextWithCount",defaultMessage:"This action will delete {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name)}}),hn=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),yn=({})=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalText",defaultMessage:"This action will change agent policies currently enrolled in this Fleet Server, to instead enroll in your default Fleet server. Are you sure you wish to continue?"});var En=a(23921);const vn=e=>{var t;const{type:a,inputs:s,useSecretsStorage:n,isConvertedToSecret:i,onToggleSecretAndClearValue:o}=e,r=a===te.gf.Elasticsearch||a===te.gf.RemoteElasticsearch,u=!!s.sslKeySecretInput.value||(null===(t=s.sslCertificateAuthoritiesInput.value)||void 0===t?void 0:t.length)>0||!!s.sslCertificateInput.value||!!s.sslKeySecretInput.value;return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiAccordion,{initialIsOpen:u,id:"advancedSSLOptions","data-test-subj":"advancedSSLOptionsButton",buttonClassName:"ingest-active-button",buttonContent:(0,R.jsx)("div",null,(0,R.jsx)(g.EuiTitle,{size:"xs"},(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.editOutputFlyout.SSLOptionsToggleLabel",defaultMessage:"Authentication"}))),(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)("p",null,(0,R.jsx)(g.EuiTextColor,{color:"subdued"},r?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.SSLOptionsDescription",defaultMessage:"Add these settings only when setting up an mTLS connection"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.editOutputFlyout.SSLOptionsToggleLabel",defaultMessage:"Set up a TLS secure connection"})))))},(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiPanel,{color:"subdued",borderRadius:"none",hasShadow:!1},"download_source"===a?(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.editOutputFlyout.downloadSource.sslWarningCallout",{defaultMessage:"Invalid settings can prevent Elastic Agent from being able to upgrade. If this happens, you will need to provide valid credentials."}),color:"warning",iconType:"warning"}):(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.editOutputFlyout.sslWarningCallout",{defaultMessage:"Invalid settings can break the connection between Elastic Agent and the configured output. If this happens, you will need to provide valid credentials."}),color:"warning",iconType:"warning"}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(ln.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities"}),multiline:!0,sortable:!1},s.sslCertificateAuthoritiesInput.props)),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},s.sslCertificateInput.formRowProps),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},s.sslCertificateInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder",{defaultMessage:"Specify SSL certificate"})}))),n?(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTitle",{defaultMessage:"Client SSL certificate key"})},s.sslKeySecretInput.formRowProps,{useSecretsStorage:n,isConvertedToSecret:i,onToggleSecretStorage:o,cancelEdit:s.sslKeySecretInput.cancelEdit}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},s.sslKeySecretInput.props,{"data-test-subj":"sslKeySecretInput",placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},s.sslKeyInput.formRowProps,{useSecretsStorage:n,onToggleSecretStorage:o,disabled:!n}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},s.sslKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}))};async function kn(e){var t,a,s;let l=`${M.mm}.download_source_id:"${e.id}"`;e.is_default&&(l+=` or (not ${M.mm}.download_source_id:*)`);const n=await(0,u.cnO)({kuery:l,page:1,perPage:M.W});if(n.error)throw n.error;const i=null!==(t=null===(a=n.data)||void 0===a||null===(s=a.items)||void 0===s?void 0:s.length)&&void 0!==t?t:0;let o=0;if(i>0){var r,d,c;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:null===(r=n.data)||void 0===r?void 0:r.items.map((e=>`policy_id:"${e.id}"`)).join(" or ")});if(e.error)throw e.error;o=null!==(d=null===(c=e.data)||void 0===c?void 0:c.total)&&void 0!==d?d:0}return{agentPolicyCount:i,agentCount:o}}const jn=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalText","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTextWithoutCount","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name)}});function bn(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function Sn(e){try{if(!e)return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.HostIsRequiredErrorMessage",{defaultMessage:"Host is required"})];const t=new URL(e);if(!["http:","https:"].includes(t.protocol))throw new Error("Invalid protocol")}catch(e){return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.hostError",{defaultMessage:"Invalid URL"})]}}const Fn=({onClose:e,downloadSource:t,proxies:a})=>{(0,u.ifo)("settings");const n=function(e,t){var a,l,n,i,o,r,d,c,g,p,x,h;const y=(0,u.iO7)(),[E,v]=(0,s.useState)(!1),{notifications:k}=(0,u.WeA)(),{confirm:j}=(0,sn.fl)(),b=!y.fleet.allSettings,S=(0,u.Gez)(null!==(a=null==t?void 0:t.name)&&void 0!==a?a:"",bn,b),F=(0,u.MbH)(null!==(l=null==t?void 0:t.is_default)&&void 0!==l&&l,(null==t?void 0:t.is_default)||b),M=(0,u.Gez)(null!==(n=null==t?void 0:t.host)&&void 0!==n?n:"",Sn,b),I=(0,u.Gez)(null!==(i=null==t?void 0:t.proxy_id)&&void 0!==i?i:"",(()=>{}),b),T=(0,u.U6y)("sslCertificateAuthoritiesComboxBox",null!==(o=null==t||null===(r=t.ssl)||void 0===r?void 0:r.certificate_authorities)&&void 0!==o?o:[],void 0,void 0),w=(0,u.Gez)(null!==(d=null==t||null===(c=t.ssl)||void 0===c?void 0:c.certificate)&&void 0!==d?d:"",void 0,void 0),A=(0,u.Gez)(null!==(g=null==t||null===(p=t.ssl)||void 0===p?void 0:p.key)&&void 0!==g?g:"",void 0,void 0),C=(0,u.YZM)(null==t||null===(x=t.secrets)||void 0===x||null===(h=x.ssl)||void 0===h?void 0:h.key,void 0,void 0),P={nameInput:S,hostInput:M,defaultDownloadSourceInput:F,proxyIdInput:I,sslCertificateInput:w,sslKeyInput:A,sslCertificateAuthoritiesInput:T,sslKeySecretInput:C},L=Object.values(P).some((e=>e.hasChanged)),_=(0,s.useCallback)((()=>{const e=S.validate(),t=M.validate(),a=w.validate(),s=A.validate(),l=C.validate();return e&&t&&a&&s&&l}),[S,M,w,A,C]),D=(0,s.useCallback)((async()=>{try{if(!_())return;v(!0);const a={name:S.value.trim(),host:M.value.trim(),is_default:F.value,proxy_id:I.value||null,ssl:{certificate:w.value,key:A.value||void 0,certificate_authorities:T.value.filter((e=>""!==e))},...!A.value&&C.value&&{secrets:{ssl:{key:C.value||void 0}}}};if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await kn(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),(0,R.jsx)(jn,{agentCount:a,agentPolicyCount:s,downloadSource:e}))}(t,j))return void v(!1);const e=await(0,u.liT)(t.id,a);if(e.error)throw e.error}else{const e=await(0,u.YLO)(a);if(e.error)throw e.error}e(),v(!1)}catch(e){v(!1),k.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.errorToastTitle",{defaultMessage:"Error while saving binary source"})})}}),[j,F.value,t,M.value,S.value,k.toasts,e,I.value,T.value,w.value,A.value,C.value,_]);return{inputs:P,submit:D,isLoading:E,isDisabled:E||t&&!L||b}}(e,t),i=n.inputs,{docLinks:o}=(0,u.WeA)(),r=(0,s.useMemo)((()=>a.map((e=>({value:e.id,label:e.name})))),[a]),[c,p]=l().useState(!0),[x,h]=(0,s.useState)(!0),y=!0===x,[E,v]=l().useState({sslKey:!1}),{enableSSLSecrets:k}=N.ZX.get(),j=(0,u.YI3)();void 0!==j.isSecretsStorageEnabled&&"disabled"===x&&h(j.isSecretsStorageEnabled),(0,s.useEffect)((()=>{c&&(p(!1),y&&k&&i.sslKeyInput.value&&!i.sslKeySecretInput.value&&(i.sslKeySecretInput.setValue(i.sslKeyInput.value),i.sslKeyInput.clear(),v({...E,sslKey:!0})))}),[y,i.sslKeyInput,i.sslKeySecretInput,c,p,E,k]);const b=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW,"aria-labelledby":b},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:b},t?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.editTitle",defaultMessage:"Edit agent binary source","data-test-subj":"editDownloadSourcesFlyout.edit.title"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.createTitle",defaultMessage:"Add new agent binary source","data-test-subj":"editDownloadSourcesFlyout.add.title"})))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(g.EuiForm,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.nameInputLabel",defaultMessage:"Name"})},i.nameInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.nameInput",fullWidth:!0},i.nameInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,R.jsx)(m.FormattedMessage,{"data-test-subj":"editDownloadSourcesFlyout.hostHelpText",id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostsInputDescription",defaultMessage:"Enter the address of the directory containing the binaries to download. {guideLink}",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:o.links.fleet.settings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostInputLabel",defaultMessage:"Host"})},i.hostInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.hostInput",fullWidth:!0},i.hostInput.props,{placeholder:"https://artifacts.elastic.co/downloads"}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdLabel",defaultMessage:"Proxy"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyInputDescription",defaultMessage:"Proxy used for accessing the download source. Currently only the proxy URL is used, headers and certificates are not supported."})},(0,R.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},i.proxyIdInput.props,{onChange:e=>{var t,a;return i.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==i.proxyIdInput.value?r.filter((e=>e.value===i.proxyIdInput.value)):[],options:r,singleSelection:{asPlainText:!0},isDisabled:i.proxyIdInput.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(rn,null),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},i.defaultDownloadSourceInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.isDefaultSwitch"},i.defaultDownloadSourceInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.defaultSwitchLabel",defaultMessage:"Make this host the default for all agent policies."})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(vn,{inputs:i,useSecretsStorage:k&&y,isConvertedToSecret:E.sslKey,onToggleSecretAndClearValue:e=>{e?i.sslKeyInput.clear():i.sslKeySecretInput.setValue(""),v({sslKey:!1}),(e=>{"disabled"!==x&&h(e)})(e)},type:"download_source"}))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:e,flush:"left","data-test-subj":"editDownloadSourcesFlyout.cancelBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:n.isLoading,isDisabled:n.isDisabled,onClick:n.submit,"data-test-subj":"editDownloadSourcesFlyout.submitBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},Mn=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),In=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalText",defaultMessage:"This action will delete {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTextWithoutCount",defaultMessage:"This action will delete {downloadSourceName} agent binary source and it will update its related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name)}}),Tn=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),wn=({})=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalText",defaultMessage:"This action will update agent policies using this proxy. This action can not be undone. Are you sure you wish to continue?"});function An(e){return e&&""!==e?e.match(te.lyu)?void 0:[f.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlError",{defaultMessage:"Invalid URL"})]:[f.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlRequired",{defaultMessage:"URL is required"})]}function Cn(e){if(e&&""!==e){const t=(0,Rs.Hh)(e);if("object"!=typeof t||Object.values(t).some((e=>{const t=typeof e;return"string"!==t&&"number"!==t&&"boolean"!==t})))return[f.i18n.translate("xpack.fleet.settings.fleetProxy.proxyHeadersErrorMessage",{defaultMessage:"Proxy headers is not a valid key: value object."})]}}function Pn(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.fleetProxy.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}const Ln=({onClose:e,fleetProxy:t})=>{const a=function(e,t){var a,l,n,i,o,r;const[d,c]=(0,s.useState)(!1),g=(0,u.iO7)(),{notifications:p}=(0,u.WeA)(),{confirm:m}=(0,sn.fl)(),x=null!==(a=!g.fleet.allSettings||(null==e?void 0:e.is_preconfigured))&&void 0!==a&&a,h=(0,u.Gez)(null!==(l=null==e?void 0:e.name)&&void 0!==l?l:"",Pn,x),y=(0,u.Gez)(null!==(n=null==e?void 0:e.url)&&void 0!==n?n:"",An,x),E=(0,u.Gez)(null!=e&&e.proxy_headers?(0,Rs.Bh)(e.proxy_headers):"",Cn,x),v=(0,u.Gez)(null!==(i=null==e?void 0:e.certificate_authorities)&&void 0!==i?i:"",(()=>{}),x),k=(0,u.Gez)(null!==(o=null==e?void 0:e.certificate)&&void 0!==o?o:"",(()=>{}),x),j=(0,u.Gez)(null!==(r=null==e?void 0:e.certificate_key)&&void 0!==r?r:"",(()=>{}),x),b=(0,s.useMemo)((()=>({nameInput:h,urlInput:y,proxyHeadersInput:E,certificateAuthoritiesInput:v,certificateInput:k,certificateKeyInput:j})),[h,y,E,v,k,j]),S=(0,s.useCallback)((()=>(0,u.C11)(b)),[b]),F=(0,s.useCallback)((async()=>{try{if(!S())return;if(e&&!await m((0,R.jsx)(Tn,null),(0,R.jsx)(wn,null)))return;c(!0);const a={name:h.value,url:y.value,proxy_headers:""===E.value?void 0:(0,Rs.Hh)(E.value),certificate_authorities:v.value,certificate:k.value,certificate_key:j.value};if(e){const t=await(0,u.aCR)(e.id,a);if(t.error)throw t.error}else{const e=await(0,u.nJY)(a);if(e.error)throw e.error}p.toasts.addSuccess(f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.successToastTitle",{defaultMessage:"Fleet proxy saved"})),c(!1),await t()}catch(e){c(!1),p.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.errorToastTitle",{defaultMessage:"An error happened while saving Fleet Server host"})})}}),[e,h.value,y.value,E.value,v.value,k.value,j.value,S,p,m,t]),M=Object.values(b).some((e=>e.hasChanged));return{isLoading:d,isDisabled:d||!M||h.props.isInvalid||y.props.isInvalid,submit:F,inputs:b}}(t,e),{inputs:l}=a,n=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW,"aria-labelledby":n},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:n},t?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.editTitle",defaultMessage:"Edit Proxy"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.addTitle",defaultMessage:"Add Proxy"})))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(rn,null),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiForm,{onSubmit:a.submit},(0,R.jsx)(nn,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:l.nameInput,"data-test-subj":"fleetProxyFlyout.nameInput",placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,R.jsx)(nn,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.urlInputLabel",defaultMessage:"Proxy Url"}),dataTestSubj:"fleetProxyFlyout.urlInput",inputProps:l.urlInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.urlInputPlaceholder",{defaultMessage:"Specify proxy url"})}),(0,R.jsx)(on,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.proxyHeadersLabel",defaultMessage:"Proxy headers"}),dataTestSubj:"fleetProxyFlyout.proxyHeadersInput",inputProps:l.proxyHeadersInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.proxyHeadersPlaceholder",{defaultMessage:"Specify proxy headers"})}),(0,R.jsx)(nn,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesLabel",defaultMessage:"Certificate authorities"}),dataTestSubj:"fleetProxyFlyout.certificateAuthoritiesInput",inputProps:l.certificateAuthoritiesInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesPlaceholder",{defaultMessage:"Specify certificate authorities"})}),(0,R.jsx)(nn,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateLabel",defaultMessage:"Certificate"}),dataTestSubj:"fleetProxyFlyout.certificateInput",inputProps:l.certificateInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificatePlaceholder",{defaultMessage:"Specify certificate"})}),(0,R.jsx)(nn,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateKeyLabel",defaultMessage:"Certificate key"}),dataTestSubj:"fleetProxyFlyout.certificateKeyInput",inputProps:l.certificateKeyInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateKeyPlaceholder",{defaultMessage:"Specify certificate key"})}))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:a.isLoading,isDisabled:a.isDisabled,onClick:a.submit,"data-test-subj":"saveApplySettingsBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))};var _n=a(2912);const Dn=({inputs:e})=>{const{docLinks:t}=(0,u.WeA)(),a=(0,s.useMemo)((()=>te.HDJ.map((e=>({label:e,value:e})))),[]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaTopicsPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopcisTitle",defaultMessage:"Topics"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"editOutputFlyout.kafkaTopicsRadioInput",options:te.HV8,compressed:!0,name:"kafkaTopics"},e.kafkaTopicsInput.props))),(()=>{switch(e.kafkaTopicsInput.value){case te.LXo.Static:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},e.kafkaStaticTopicInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaStaticTopicInput",fullWidth:!0},e.kafkaStaticTopicInput.props)));case te.LXo.Dynamic:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicHelptext",{defaultMessage:"Select a topic from the list. If a topic is not available, create a custom one."}),label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicLabel",defaultMessage:"Topic from field(s). For more info, see our {guideLink}.",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:t.links.fleet.kafkaOutputTopicsSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.kafkaGuideLink",defaultMessage:"docs"}))}})},e.kafkaDynamicTopicInput.formRowProps),(0,R.jsx)(g.EuiComboBox,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaDynamicTopicInput",fullWidth:!0,isClearable:!0,options:a,customOptionText:"Use custom field",singleSelection:{asPlainText:!0}},e.kafkaDynamicTopicInput.props)))}})(),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},On=e=>{const{inputs:t}=e,{props:{onChange:a},value:l,formRowProps:{error:n}}=t.kafkaHeadersInput,[i,o]=(0,s.useState)(!1),r=(0,s.useCallback)(((e,t,s)=>{const n=l.map(((a,l)=>l===e?{...a,[t]:s}:a));a(n)}),[l,a]),u=(0,s.useCallback)((()=>{o(!0);const e=[...l,{key:"",value:""}];a(e)}),[l,a]),c=(0,s.useCallback)((e=>{const t=l.filter(((t,a)=>a!==e));a(t)}),[l,a]),p=1===l.length,x=1===l.length&&(""===l[0].key||""===l[0].value),h=e=>null!=e&&e.length?e.map(((e,t)=>(0,R.jsx)(g.EuiFormErrorText,{key:t},e))):null,y=(0,s.useMemo)((()=>(e,t)=>null==n?void 0:n.filter((a=>a.index===e&&("key"===t?a.hasKeyError:a.hasValueError))).map((e=>e.message))),[n]),E=(0,s.useMemo)((()=>n&&n.filter((e=>void 0===e.index)).map((({message:e})=>e))),[n]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaHeadersPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeadersTitle",defaultMessage:"Headers"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),l.map(((e,t)=>{var a,s,l,n;const o=y(t,"key"),u=y(t,"value");return(0,R.jsx)("div",{key:t},t>0&&(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart",gutterSize:"none",style:{gap:30}},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderKeyInputLabel",defaultMessage:"Key"}),error:h(o),isInvalid:(null!==(a=null==o?void 0:o.length)&&void 0!==a?a:0)>0},(0,R.jsx)(g.EuiFieldText,{isInvalid:(null!==(s=null==o?void 0:o.length)&&void 0!==s?s:0)>0,"data-test-subj":`settingsOutputsFlyout.kafkaHeadersKeyInput${t}`,fullWidth:!0,value:e.key,onChange:e=>r(t,"key",e.target.value),autoFocus:i}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderValueInputLabel",defaultMessage:"Value"}),error:h(u),isInvalid:(null!==(l=null==u?void 0:u.length)&&void 0!==l?l:0)>0},(0,R.jsx)(g.EuiFieldText,{isInvalid:(null!==(n=null==u?void 0:u.length)&&void 0!==n?n:0)>0,"data-test-subj":`settingsOutputsFlyout.kafkaHeadersValueInput${t}`,fullWidth:!0,value:e.value,onChange:e=>r(t,"value",e.target.value)}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1,style:{marginTop:28}},(0,R.jsx)(g.EuiButtonIcon,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersDeleteButton${t}`,color:"text",onClick:()=>c(t),iconType:"cross",disabled:p,"aria-label":f.i18n.translate("xpack.fleet.kafkaHeadersInput.deleteButton",{defaultMessage:"Delete row"})}))))})),h(E),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiButtonEmpty,{"data-test-subj":"kafkaHeaders.multiRowInput.addRowButton",disabled:x,size:"xs",flush:"left",iconType:"plusInCircle",onClick:u},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.kafkaHeadersInput.addRow",defaultMessage:"Add header"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaClientIdLabel",defaultMessage:"Client ID"})},t.kafkaClientIdInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaClientIdInput",fullWidth:!0},t.kafkaClientIdInput.props))))},Rn=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Array.from({length:6},((e,t)=>10*(t+1))).map((e=>({text:e,label:`${e} seconds`})))),[]),l=e=>{switch(e){case te.NAW.DoNotWait:return"No response";case te.NAW.Replica:return"Wait for all replicas to commit";default:case te.NAW.Commit:return"Wait for local commit"}},n=(0,s.useMemo)((()=>Object.keys(te.NAW).map((e=>({text:te.NAW[e],label:l(te.NAW[e])})))),[]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaBrokerSettingsPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaBrokerSettings"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerSettingsTitle",defaultMessage:"Broker settings"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputLabel",defaultMessage:"Broker timeout"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputHelpText",defaultMessage:"Define how long a Kafka server waits for data in the same cluster."})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerTimeoutInput"},t.kafkaBrokerTimeoutInput.props,{options:a}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputLabel",defaultMessage:"Broker reachability timeout"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputHelpText",defaultMessage:"Define how long an Agent would wait for a response from Kafka broker."})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerReachabilityTimeoutInput"},t.kafkaBrokerReachabilityTimeoutInput.props,{options:a}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputLabel",defaultMessage:"ACK Reliability"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputHelpText",defaultMessage:"Reliability level required from the broker."})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerAckReliabilityInputLabel"},t.kafkaBrokerAckReliabilityInput.props,{options:n}))))},Bn=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Object.keys(te.jZS).filter((e=>"None"!==e)).map((e=>({text:te.jZS[e],label:te.jZS[e]})))),[]),n=(0,s.useMemo)((()=>Array.from({length:9},((e,t)=>t+1)).map((e=>({text:e,label:e.toString()})))),[]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaCompressionPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaCompression"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionTitle",defaultMessage:"Compression"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaCompressionSwitch"},t.kafkaCompressionInput.props,{onChange:e=>{e.target.checked||t.kafkaCompressionCodecInput.setValue(te.jZS.None),t.kafkaCompressionInput.setValue(e.target.checked)},label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionSwitchLabel",defaultMessage:"Enable compression"})})),t.kafkaCompressionInput.value?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionCodecInputLabel",defaultMessage:"Codec"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaCompressionCodecInput"},t.kafkaCompressionCodecInput.props,{options:a}))),t.kafkaCompressionCodecInput.value===te.jZS.Gzip&&(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionLevelInputLabel",defaultMessage:"Level"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0},t.kafkaCompressionLevelInput.props,{"data-test-subj":"settingsOutputsFlyout.kafkaCompressionLevelInput",options:n})))):null)},Nn=[{id:te.BwZ.Random,label:"Random","data-test-subj":"kafkaPartitionRandomRadioButton"},{id:te.BwZ.RoundRobin,label:"Round robin","data-test-subj":"kafkaPartitionRoundRobinRadioButton"},{id:te.BwZ.Hash,label:"Hash","data-test-subj":"kafkaPartitionHashRadioButton"}],zn=e=>{const{inputs:t}=e;return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaPartitionPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaPartitionTitle"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTitle",defaultMessage:"Partitioning"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitioningInputLabel",defaultMessage:"Partitioning strategy"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"settingsOutputsFlyout.kafkaPartitioningRadioInput",options:Nn,compressed:!0,name:"kafkaPartitioningStrategy"},t.kafkaPartitionTypeInput.props))),(()=>{switch(t.kafkaPartitionTypeInput.value){case te.BwZ.Random:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRandomInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRandomInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRandomInput",fullWidth:!0},t.kafkaPartitionTypeRandomInput.props)));case te.BwZ.RoundRobin:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRoundRobinInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRoundRobinInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRoundRobinInput",fullWidth:!0},t.kafkaPartitionTypeRoundRobinInput.props)));case te.BwZ.Hash:default:return(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashInputLabel",defaultMessage:"List of fields"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashHelpTextLabel",defaultMessage:"Comma separated."})},(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeHashInput",fullWidth:!0},t.kafkaPartitionTypeHashInput.props))))}})())},Un=[{id:te.N9h.Plain,label:"Plain","data-test-subj":"kafkaSaslPlainRadioButton"},{id:te.N9h.ScramSha256,label:"SCRAM-SHA-256","data-test-subj":"kafkaSaslScramSha256RadioButton"},{id:te.N9h.ScramSha512,label:"SCRAM-SHA-512","data-test-subj":"kafkaSaslScramSha512RadioButton"}],Hn=[{id:te.NB8.None,label:"None","data-test-subj":"kafkaAuthenticationNoneRadioButton"},{id:te.NB8.Userpass,label:"Username / Password","data-test-subj":"kafkaAuthenticationUsernamePasswordRadioButton"},{id:te.NB8.Ssl,label:"SSL","data-test-subj":"kafkaAuthenticationSSLRadioButton"}],Wn=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,[i,o]=l().useState({kafkaAuthPassword:!1,kafkaSslKey:!1}),[r,u]=l().useState(!0);(0,s.useEffect)((()=>{r&&(u(!1),a&&(t.kafkaAuthPasswordInput.value&&!t.kafkaAuthPasswordSecretInput.value&&(t.kafkaAuthPasswordSecretInput.setValue(t.kafkaAuthPasswordInput.value),t.kafkaAuthPasswordInput.clear(),o({...i,kafkaAuthPassword:!0})),t.kafkaSslKeyInput.value&&!t.kafkaSslKeySecretInput.value&&(t.kafkaSslKeySecretInput.setValue(t.kafkaSslKeyInput.value),t.kafkaSslKeyInput.clear(),o({...i,kafkaSslKey:!0}))))}),[a,t.kafkaAuthPasswordInput,t.kafkaAuthPasswordSecretInput,t.kafkaSslKeyInput,t.kafkaSslKeySecretInput,r,u,i]);const c=e=>{e?(t.kafkaAuthPasswordInput.clear(),t.kafkaSslKeyInput.clear()):(t.kafkaAuthPasswordSecretInput.setValue(""),t.kafkaSslKeySecretInput.setValue("")),o({kafkaAuthPassword:!1,kafkaSslKey:!1}),n(e)},p=(0,s.useMemo)((()=>Object.keys(te.i36).map((e=>({text:te.i36[e],label:e})))),[]),x=(0,s.useMemo)((()=>Object.keys(te.zPI).map((e=>({id:te.zPI[e],label:e,"data-test-subj":`kafkaConnectionType${e}RadioButton`})))),[]);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaAuthenticationTitle"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaAuthenticationTitle",defaultMessage:"Authentication"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({name:"kafkaAuthMethod",style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationRadioInput",options:Hn,compressed:!0},t.kafkaAuthMethodInput.props))),(()=>{switch(t.kafkaAuthMethodInput.value){case te.NB8.None:return(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaConnectionTypeLabel",defaultMessage:"Connection"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({name:"kafkaConnectionType",style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaConnectionTypeRadioInput",options:x,compressed:!0},t.kafkaConnectionTypeInput.props)));case te.NB8.Ssl:return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},t.kafkaSslCertificateInput.formRowProps),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslCertificateInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaSslCertificateInputPlaceholder",{defaultMessage:"Specify ssl certificate"})}))),a?(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordSecretInputTitle",{defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeySecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaSslKey,onToggleSecretStorage:c,cancelEdit:t.kafkaSslKeySecretInput.cancelEdit}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":"kafkaSslKeySecretInput"},t.kafkaSslKeySecretInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeyInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:c}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))));default:case te.NB8.Userpass:return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaUsernameInputLabel",defaultMessage:"Username"})},t.kafkaAuthUsernameInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaUsernameInput",fullWidth:!0},t.kafkaAuthUsernameInput.props))),a?(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputtitle",{defaultMessage:"Password"})},t.kafkaAuthPasswordSecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaAuthPassword,onToggleSecretStorage:c,cancelEdit:t.kafkaAuthPasswordSecretInput.cancelEdit}),(0,R.jsx)(g.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordSecretInput",fullWidth:!0},t.kafkaAuthPasswordSecretInput.props))):(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputLabel",defaultMessage:"Password"})},t.kafkaAuthPasswordInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:c}),(0,R.jsx)(g.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordInput",fullWidth:!0},t.kafkaAuthPasswordInput.props))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaSaslInputLabel",defaultMessage:"SASL Mechanism"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({name:"kafkaSaslMechanism",style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaSaslInput",options:Un,compressed:!0},t.kafkaSaslMechanismInput.props))))}})()),t.kafkaConnectionTypeInput.value!==te.zPI.Plaintext||t.kafkaAuthMethodInput.value!==te.NB8.None?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(ln.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaSslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities (optional)"}),multiline:!0,sortable:!1},t.kafkaSslCertificateAuthoritiesInput.props)),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVerificationModeInputLabel",defaultMessage:"Verification mode"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVerificationModeInput"},t.kafkaVerificationModeInput.props,{options:p})))):null)},Gn=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,{docLinks:i}=(0,ot.WeA)(),o=(0,s.useMemo)((()=>te.y6d.map((e=>({text:e,label:e})))),[]);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVersionInputLabel",defaultMessage:"Kafka version"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVersionInput"},t.kafkaVersionInput.props,{options:o}))),(0,R.jsx)(ln.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!0,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHostsInputDescription",defaultMessage:"Specify the URLs that your agents will use to connect to Kafka. {guideLink}.",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:i.links.fleet.kafkaSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.kafkaUserGuideLink",defaultMessage:"Learn more"}))}}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputLabel",{defaultMessage:"Hosts"})},t.kafkaHostsInput.props)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Wn,{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(zn,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Dn,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(On,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Bn,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Rn,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputLabel",defaultMessage:"Key (optional)"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputHelpText",defaultMessage:"If configured, the event key can be extracted from the event using a format string."})},(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaKeyInput",fullWidth:!0},t.kafkaKeyInput.props))))};var Kn=a(9424);const qn=P().div.withConfig({displayName:"CodeEditorContainer",componentId:"sc-1u19e39-0"})(["min-height:0;position:relative;height:116px;"]),Vn=P()(g.EuiTextColor).attrs((e=>({color:"subdued",size:"xs"}))).withConfig({displayName:"CodeEditorPlaceholder",componentId:"sc-1u19e39-1"})(["position:absolute;top:0;left:0;font-family:Menlo,Monaco,'Courier New',monospace;font-size:12px;line-height:21px;pointer-events:none;"]),$n={minimap:{enabled:!1},ariaLabel:f.i18n.translate("xpack.fleet.settings.yamlCodeEditor",{defaultMessage:"YAML Code Editor"}),scrollBeyondLastLine:!1,wordWrap:"on",wrappingIndent:"indent",automaticLayout:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,folding:!1,lineDecorationsWidth:0},Yn=e=>{const{placeholder:t,disabled:a,...s}=e;return a?l().createElement(g.EuiCodeBlock,{style:{height:"116px"},language:"yaml",isCopyable:!1,paddingSize:"s"},l().createElement("pre",null,s.value)):l().createElement(qn,null,l().createElement(Kn.CodeEditor,(0,d.default)({languageId:"yaml",width:"100%",height:"116px",options:$n},s)),(!s.value||""===s.value)&&l().createElement(Vn,null,t))},Qn=e=>t=>{if("object"!=typeof t)return e(null!=t?t:"")};function Xn(e){const t=[],a={};if(e.forEach(((e,s)=>{if(!e)return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostFieldRequiredError",{defaultMessage:"Host is required"})});const l=e.split(":");if(2!==l.length||!l[0]||!l[1])return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostPortError",{defaultMessage:'Invalid format. Expected "host:port" without protocol.'}),index:s});const n=parseInt(l[1],10);(isNaN(n)||n<1||n>65535)&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPortError",{defaultMessage:"Invalid port number. Expected a number between 1 and 65535"}),index:s});const i=a[e]||[];a[e]=[...i,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function Jn(e){const t=[],a={},s=f.i18n.translate("xpack.fleet.settings.outputForm.elasticUrlRequiredError",{defaultMessage:"URL is required"});if(e.forEach(((e,l)=>{try{if(e){const a=new URL(e);["http:","https:"].includes(a.protocol)||t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.invalidProtocolError",{defaultMessage:"Invalid protocol"}),index:l})}else t.push({message:s,index:l})}catch(e){t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.elasticHostError",{defaultMessage:"Invalid URL"}),index:l})}const n=a[e]||[];a[e]=[...n,l]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.elasticHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:s}),t.length)return t}function Zn(e){const t=[],a={};if(e.forEach(((e,s)=>{try{if(e.match(/^http([s]){0,1}:\/\//))return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostProtocolError",{defaultMessage:"Host address must begin with a domain name or IP address"}),index:s});if(new URL(`http://${e}`).host!==e.toLowerCase())throw new Error("Invalid host")}catch(a){0===e.length?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"}),index:s}):t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostError",{defaultMessage:"Invalid Host"}),index:s})}const l=a[e]||[];a[e]=[...l,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostDuplicateError",{defaultMessage:"Duplicate Host"}),index:e})))})),0===e.length&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function ei(e){try{return void(0,Rs.Hh)(e)}catch(e){return[f.i18n.translate("xpack.fleet.settings.outputForm.invalidYamlFormatErrorMessage",{defaultMessage:"Invalid YAML: {reason}",values:{reason:e.message}})]}}function ti(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function ai(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaUsernameIsRequired",{defaultMessage:"Username is required"})]}function si(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPasswordIsRequired",{defaultMessage:"Password is required"})]}const li=Qn(si);function ni(e){if(""!==e&&!e.match(/^[a-zA-Z0-9]+$/))return[f.i18n.translate("xpack.fleet.settings.outputForm.caTrusterdFingerprintInvalidErrorMessage",{defaultMessage:"CA trusted fingerprint should be valid HEX encoded SHA-256 of a CA certificate"})]}function ii(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.serviceTokenRequiredErrorMessage",{defaultMessage:"Service token is required"})]}const oi=Qn(ii);function ri(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kibanaAPIKeyRequiredErrorMessage",{defaultMessage:"Kibana API Key is required"})]}function ui(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.sslCertificateRequiredErrorMessage",{defaultMessage:"SSL certificate is required"})]}function di(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.sslKeyRequiredErrorMessage",{defaultMessage:"SSL key is required"})]}Qn(ri);const ci=Qn(di);function gi(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaDefaultTopicRequiredMessage",{defaultMessage:"Default topic is required"})]}function pi(e){const t=[];if(e.forEach(((e,a)=>{e||t.push(f.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicFieldRequiredMessage",{defaultMessage:"Topic is required"}))})),0===e.length&&t.push(f.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicRequiredMessage",{defaultMessage:"Topic is required"})),t.length)return t}function mi(e){return/^[A-Za-z0-9._-]+$/.test(e)?void 0:[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaClientIdFormattingMessage",{defaultMessage:"Client ID is invalid. Only letters, numbers, dots, underscores, and dashes are allowed."})]}function fi(e){return/^[0-9]+$/.test(e)?void 0:[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPartitioningGroupEventsFormattingMessage",{defaultMessage:"Number of events must be a number"})]}function xi(e){const t=[],a=new Set;if(e.forEach(((e,s)=>{const{key:l,value:n}=e,i=!!l,o=!!n;i&&!o?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingKeyError",{defaultMessage:'Missing value for key "{key}"',values:{key:l}}),index:s,hasKeyError:!1,hasValueError:!0}):!i&&o?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingValueError",{defaultMessage:'Missing key for value "{value}"',values:{value:n}}),index:s,hasKeyError:!0,hasValueError:!1}):i&&o&&(a.has(l)?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersDuplicateKeyError",{defaultMessage:'Duplicate key "{key}"',values:{key:l}}),index:s,hasKeyError:!0,hasValueError:!1}):a.add(l))})),t.length)return t}const hi=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),yi=({output:e,agentCount:t,agentPolicyCount:a})=>(0,R.jsx)(l().Fragment,null,void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalText",defaultMessage:"This action will update {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalTextWithoutCount",defaultMessage:"This action will update {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name)}}),"logstash"===e.type?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",size:"m",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningTitle",defaultMessage:"Logstash output for agent integration is not supported for fleet server and synthetics."})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningMessage",defaultMessage:"Fleet server and synthetics policies will keep using the existing ES output."}))," "):null);const Ei=({enabled:e,inputs:t})=>{const{diskQueueEnabledInput:a,diskQueuePathInput:s,diskQueueMaxSizeInput:n,loadBalanceEnabledInput:i,diskQueueEncryptionEnabled:o,diskQueueCompressionEnabled:r,compressionLevelInput:u,memQueueEvents:c,queueFlushTimeout:p,maxBatchBytes:x}=t,{showExperimentalShipperOptions:h}=N.ZX.get();return e?(0,R.jsx)(g.EuiAccordion,{id:"advancedOutputOptions",arrowDisplay:"left",buttonContent:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.advancedOptionsToggleLabel",defaultMessage:"Advanced options"})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiBetaBadge,{label:"Experimental",color:"subdued"})))},(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},x.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescriptionLabel",defaultMessage:"Maximum Batch Size"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},x.props,{placeholder:"Batching Bytes",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescription",defaultMessage:"Data will be sent to the output when the agent has more events in the queue than this number."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},p.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutLabel",defaultMessage:"Flush Timeout"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},p.props,{placeholder:"Seconds",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutDescription",defaultMessage:"Upon expiry the output queue is flushed and data is written to the output."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},c.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsLabel",defaultMessage:"Memory Queue Size"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},c.props,{placeholder:"Events",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsSizeDescription",defaultMessage:"Maximum number of events that can be stored in the queue. Default is set to 4096. When this queue is full, new events are dropped."}))))),h&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiHorizontalRule,null),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},a.formRowProps),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueSwitch"},a.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchLabel",defaultMessage:"Disk Queue"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchDescription",defaultMessage:"Once enabled, events will be queued on disk if, for some reason, agent is not able to send them."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.formRowProps),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueEncryption"},o.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionLabel",defaultMessage:"Disk Queue Encryption"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionDescription",defaultMessage:"Enable encryption of data written to the disk queue."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueuePathLabel",defaultMessage:"Disk Queue Path"})},s.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.diskQueuePath"},s.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.diskQueuePathPlaceholder",{defaultMessage:"path_data/diskqueue"})}))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},n.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSize",defaultMessage:"Maximum Disk Queue Size"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},n.props,{placeholder:"Bytes",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSizeDescription",defaultMessage:"Limits the disk queue size for spooling of data. When data in the queue exceeds this limit, new events will be dropped."}))))),(0,R.jsx)(g.EuiHorizontalRule,null),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},i.formRowProps),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.loadBalancingSwitch"},i.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingSwitchLabel",defaultMessage:"Load Balancing"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingDescription",defaultMessage:"Once enabled, the agents will balance the load across all the hosts defined for this output. This will increase the number of connections opened by the agent."}))))),(0,R.jsx)(g.EuiHorizontalRule,null),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionSwitch"},r.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchLabel",defaultMessage:"Compression"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSelect,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionLevelSelect",id:"selectCompressionLevel","aria-label":"Use aria labels when no actual label is in use"},u.props))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchDescription",defaultMessage:"Level 1 compression is the fastest, Level 9 however would provide the most compression."})))))))):null},vi=e=>{const{docLinks:t,cloud:a}=(0,u.WeA)(),{inputs:n,useSecretsStorage:i,onToggleSecretStorage:o}=e,[r,c]=l().useState({serviceToken:!1,kibanaAPIKey:!1,sslKey:!1}),{enableSyncIntegrationsOnRemote:p,enableSSLSecrets:x}=N.ZX.get(),h=p&&u.Fjq.isEnterprise()&&!(null!=a&&a.isServerlessEnabled),[y,E]=l().useState(!1),[v,k]=l().useState(!0);(0,s.useEffect)((()=>{if(v&&(k(!1),i)){let e=!1;n.serviceTokenInput.value&&!n.serviceTokenSecretInput.value&&(n.serviceTokenSecretInput.setValue(n.serviceTokenInput.value),n.serviceTokenInput.clear(),e=!0);let t=!1;x&&n.sslKeyInput.value&&!n.sslKeySecretInput.value&&(n.sslKeySecretInput.setValue(n.sslKeyInput.value),n.sslKeyInput.clear(),t=!0),c({...r,serviceToken:e,sslKey:t})}}),[i,n.serviceTokenInput,n.serviceTokenSecretInput,n.kibanaAPIKeyInput,v,k,r,n.sslKeyInput,n.sslKeySecretInput,x]);const j=e=>{e?(n.serviceTokenInput.clear(),n.kibanaAPIKeyInput.clear(),x&&n.sslKeyInput.clear()):(n.serviceTokenSecretInput.setValue(""),x&&n.sslKeyInput.setValue("")),c({...r,serviceToken:!1,kibanaAPIKey:!1,sslKey:!1}),o(e)};return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(ln.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},n.elasticsearchUrlInput.props,{isUrl:!0})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),i?(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",{defaultMessage:"Service token"})},n.serviceTokenSecretInput.formRowProps,{cancelEdit:n.serviceTokenSecretInput.cancelEdit,useSecretsStorage:i,isConvertedToSecret:r.serviceToken,onToggleSecretStorage:j}),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"serviceTokenSecretInput",fullWidth:!0},n.serviceTokenSecretInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))):(0,R.jsx)(En.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",defaultMessage:"Service token"})},n.serviceTokenInput.formRowProps,{useSecretsStorage:i,onToggleSecretStorage:j}),(0,R.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"serviceTokenSecretInput"},n.serviceTokenInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenCalloutText",defaultMessage:"Generate a service token by running this API request in the remote Kibana Console and copy the response value"}),"data-test-subj":"serviceTokenCallout"},(0,R.jsx)(g.EuiCodeBlock,{isCopyable:!0},'POST kbn:/api/fleet/service_tokens\n{\n  "remote": true\n}')),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(vn,{type:n.typeInput.value,inputs:n,useSecretsStorage:x&&i,isConvertedToSecret:r.sslKey,onToggleSecretAndClearValue:j}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),h?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncIntegrationsFormRowLabel",defaultMessage:"If enabled, integration assets will be installed on the remote Elasticsearch cluster"})},n.syncIntegrationsInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},n.syncIntegrationsInput.props,{"data-test-subj":"syncIntegrationsSwitch",label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncIntegrationsSwitchLabel",defaultMessage:"Synchronize integrations"})}))),!0===n.syncIntegrationsInput.value&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsFormRowLabel",defaultMessage:"If enabled, uninstalled integrations will also be uninstalled on the remote Elasticsearch cluster"})},n.syncUninstalledIntegrationsInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},n.syncUninstalledIntegrationsInput.props,{"data-test-subj":"syncUninstalledIntegrationsSwitch",label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsSwitchLabel",defaultMessage:"Uninstall integrations on remote"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{iconType:"info",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.remoteClusterConfigurationCalloutTitle",defaultMessage:"Additional remote cluster configuration required"}),"data-test-subj":"remoteClusterConfigurationCallout"},y?(0,R.jsx)(g.EuiButton,{onClick:()=>E(!1)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.collapseInstructionsButtonLabel",defaultMessage:"Collapse steps"})):(0,R.jsx)(g.EuiButton,{onClick:()=>E(!0),fill:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.viewInstructionButtonLabel",defaultMessage:"View steps"})),y&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.description",defaultMessage:"To sync integrations from this cluster, the remote Elasticsearch output needs additional configuration. {documentationLink}.",values:{documentationLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t.links.fleet.remoteESOoutput},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.documentationLink",defaultMessage:"Learn more"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)("ol",null,(0,R.jsx)("li",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterStep",defaultMessage:"In the remote cluster, open Kibana and go to {appPath}, and follow the steps to add this cluster.",values:{appPath:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterKibanaPath",defaultMessage:"Stack Management > Remote Clusters"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"s"})),(0,R.jsx)("li",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.replicationStep",defaultMessage:"Go to {appPath} and create a follower index using the cluster from Step 1. The leader index is {leaderIndex} from this cluster and should be replicated to the follower index {followerIndex} on the remote cluster.",values:{appPath:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.replicationKibanaPath",defaultMessage:"Stack Management > Cross-Cluster Replication"})),leaderIndex:(0,R.jsx)(g.EuiCode,null,"fleet-synced-integrations"),followerIndex:(0,R.jsx)(g.EuiCode,null,"fleet-synced-integrations-ccr-",(0,J.snakeCase)(n.nameInput.props.value)||"<output name>")}}),(0,R.jsx)(g.EuiSpacer,{size:"s"})),(0,R.jsx)("li",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.configureKibanaStep",defaultMessage:"Below, provide the access details for the remote cluster's Kibana instance."}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.ccsDescription",defaultMessage:"To search accross remote clusters from this cluster, see the {prerequisites}. Once the remote cluster is added, CCS Data Views will be created automatically.",values:{prerequisites:(0,R.jsx)(g.EuiLink,{target:"_blank",href:`${t.links.ccs.guide}#_prerequisites`},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.ccsDocumentationLink",defaultMessage:"CCS prerequisites"}))}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kibanaURLInputLabel",defaultMessage:"Remote Kibana URL"})},n.kibanaURLInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kibanaURLInput",fullWidth:!0},n.kibanaURLInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kibanaURLInputPlaceholder",{defaultMessage:"Specify Kibana URL"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyLabel",defaultMessage:"Remote Kibana API Key"})},n.kibanaAPIKeyInput.formRowProps),(0,R.jsx)(g.EuiFieldPassword,(0,d.default)({fullWidth:!0,type:"dual","data-test-subj":"kibanaAPIKeySecretInput"},n.kibanaAPIKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyPlaceholder",{defaultMessage:"Specify encoded Kibana API Key"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyCalloutText",defaultMessage:"Create an API Key by running this API request in the remote Kibana Console and copy the encoded value"}),"data-test-subj":"kibanaAPIKeyCallout"},(0,R.jsx)(g.EuiCodeBlock,{isCopyable:!0},' POST /_security/api_key\n   {\n     "name": "integration_sync_api_key",\n     "role_descriptors": {\n       "integration_writer": {\n         "cluster": [],\n        "indices":[],\n        "applications": [{\n           "application": "kibana-.kibana",\n             "privileges": ["feature_fleet.read", "feature_fleetv2.read"],\n             "resources": ["*"]\n         }]\n        }\n     }\n   }')),(0,R.jsx)(g.EuiSpacer,{size:"m"}))):null)};var ki=a(40622);function ji(e,t){return`input {\n  elastic_agent {\n    port => 5044 ${e?'\n    ssl_enabled => true\n    ssl_certificate_authorities => ["<ca_path>"]\n    ssl_certificate => "<server_cert_path>"\n    ssl_key => "<server_cert_key_in_pkcs8>"\n    ssl_client_authentication => "required"':""}\n  }\n}\n\noutput {\n  elasticsearch {\n    hosts => "<es_host>"\n    api_key => "<api_key>"\n    data_stream => true\n    ssl_enabled => true\n    # ssl_certificate_authorities => "<elasticsearch_ca_path>"\n  }\n}`.replace("<api_key>",t||"<api_key>")}const bi=({isSSLEnabled:e})=>{const{docLinks:t}=(0,u.WeA)();return(0,R.jsx)(Si,{iconType:"info",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.calloutTitle",defaultMessage:"Additional Logstash configuration required"})},(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.description",defaultMessage:"Add an Elastic Agent pipeline configuration to Logstash to receive events from the Elastic Agent framework. {documentationLink}.",values:{documentationLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t.links.logstash.inputElasticAgent},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.documentationLink",defaultMessage:"Learn more"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Fi,{isSSLEnabled:e})))},Si=({children:e,...t})=>{const[a,n]=(0,s.useState)(!1),i=(0,u.iO7)().fleet.allSettings;return(0,R.jsx)(g.EuiCallOut,t,(0,R.jsx)(g.EuiSpacer,{size:"s"}),a?(0,R.jsx)(g.EuiButton,{onClick:()=>n(!1)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.collapseInstructionsButtonLabel",defaultMessage:"Collapse steps"})):(0,R.jsx)(ki.m,{missingPrivilege:i?void 0:"Settings All",position:"left"},(0,R.jsx)(g.EuiButton,{onClick:()=>n(!0),fill:!0,disabled:!i},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.viewInstructionButtonLabel",defaultMessage:"View steps"}))),a&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),e))},Fi=({isSSLEnabled:e})=>{const{docLinks:t}=(0,u.WeA)(),a=function(){const[e,t]=(0,s.useState)(!1),[a,n]=(0,s.useState)(),i=(0,u.WeA)(),{notifications:o}=i,r=(0,s.useCallback)((async()=>{try{var e;t(!0);const a=await(0,u.waY)();if(a.error)throw a.error;n(null===(e=a.data)||void 0===e?void 0:e.api_key)}catch(e){403===e.statusCode?o.toasts.addDanger({title:f.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"}),text:(0,it.toMountPoint)((0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyPermissions",defaultMessage:"You need the cluster permissions: {clusterPermissions}{br} and the index permissions: {indexPermissions}{br}for indexes: {br}{indexes}",values:{clusterPermissions:(0,R.jsx)(g.EuiCode,null,te.pfJ.join(", ")),indexPermissions:(0,R.jsx)(g.EuiCode,null,te.MVu.join(", ")),indexes:te.xPW.map((e=>(0,R.jsx)(l().Fragment,{key:e},(0,R.jsx)(g.EuiCode,null,e),(0,R.jsx)("br",null)))),br:(0,R.jsx)("br",null)}}),i)},{}):o.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"})})}finally{t(!1)}}),[o.toasts,i]);return(0,s.useMemo)((()=>({isLoading:e,generateApiKey:r,apiKey:a})),[e,r,a])}(),n=(0,u.iO7)().fleet.allSettings,i=(0,s.useMemo)((()=>[{children:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.apiKeyStepDescription",defaultMessage:"We recommend authorizing Logstash to output to Elasticsearch with minimal privileges for Elastic Agent."}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),a.apiKey?(0,R.jsx)(g.EuiCodeBlock,{paddingSize:"m"},(0,R.jsx)("h5",null,"API Key"),a.apiKey,(0,R.jsx)("div",{className:"euiCodeBlock__controls"},(0,R.jsx)("div",{className:"euiCodeBlock__copyButton"},(0,R.jsx)(g.EuiCopy,{textToCopy:a.apiKey},(e=>(0,R.jsx)(g.EuiButtonIcon,{onClick:e,iconType:"copyClipboard",color:"text",disabled:!n,"aria-label":f.i18n.translate("xpack.fleet.settings.logstashInstructions.copyApiKeyButtonLabel",{defaultMessage:"Copy message"})})))))):(0,R.jsx)(g.EuiButton,{isLoading:a.isLoading,onClick:a.generateApiKey,disabled:!n},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyButtonLabel",defaultMessage:"Generate API key"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},{children:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.editPipelineStepDescription",defaultMessage:"Next, open the {pipelineConfFile} file and insert the following content:",values:{pipelineConfFile:(0,R.jsx)(g.EuiCode,null,"elastic-agent-pipeline.conf")}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},ji(e,a.apiKey)))},{children:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.addPipelineStepDescription",defaultMessage:"In your Logstash configuration directory, open the {pipelineFile} file and add the following configuration. Replace the path to your file.",values:{pipelineFile:(0,R.jsx)(g.EuiCode,null,"pipelines.yml")}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},'- pipeline.id: elastic-agent-pipeline\n  path.config: "/etc/path/to/elastic-agent-pipeline.conf"\n'))},{children:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.replaceStepDescription",defaultMessage:"Replace the parts between the brackets with your generated SSL certificate file paths. View {documentationLink} to generate the certificates.",values:{documentationLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t.links.fleet.secureLogstash},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.ourDocumentationLink",defaultMessage:"our documentation"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},{children:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.saveAndRestartStepDescription",defaultMessage:"Save the pipeline and restart Logstash so the changes take effect."}),(0,R.jsx)(g.EuiSpacer,{size:"m"}))}]),[a,t,n,e]);return(0,R.jsx)("ol",null,i.map(((e,t)=>(0,R.jsx)("li",{key:t},e.children))))},Mi=()=>{const{docLinks:e}=(0,u.WeA)();return(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutTitle",defaultMessage:"Additional setup required"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutDescription",defaultMessage:"You must configure an encryption key before configuring this output. {link}",values:{link:(0,R.jsx)(g.EuiLink,{href:e.links.kibana.secureSavedObject,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.link",defaultMessage:"Learn more"}))}}))},Ii=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n,hasEncryptedSavedObjectConfigured:i}=e,{docLinks:o}=(0,u.WeA)(),[r,c]=l().useState(!0),[p,x]=l().useState({sslKey:!1});return(0,s.useEffect)((()=>{r&&(c(!1),a&&t.sslKeyInput.value&&!t.sslKeySecretInput.value&&(t.sslKeySecretInput.setValue(t.sslKeyInput.value),t.sslKeyInput.clear(),x({...p,sslKey:!0})))}),[a,t.sslKeyInput,t.sslKeySecretInput,r,c,p]),(0,R.jsx)(l().Fragment,null,!i&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Mi,null)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiSwitch,(0,d.default)({label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashSSLSwitchLabel",{defaultMessage:"Enable SSL"})},t.logstashEnableSSLInput.props)),!t.logstashEnableSSLInput.value&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashSSLSwitchCalloutTitle",{defaultMessage:"Proceed with caution!"}),color:"warning",iconType:"warning"},(0,R.jsx)("p",null,f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashSSLSwitchCalloutMessage",{defaultMessage:"Using SSL/TLS ensures that your Elastic Agents send encrypted data to trusted Logstash servers, and that your Logstash servers receive data from trusted Elastic Agent clients."})))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(bi,{isSSLEnabled:t.logstashEnableSSLInput.value}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(ln.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!1,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.logstashHostsInputDescription",defaultMessage:"Specify the addresses that your agents will use to connect to Logstash. {guideLink}.",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:o.links.fleet.logstashSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputLabel",{defaultMessage:"Logstash hosts"})},t.logstashHostsInput.props)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),t.logstashEnableSSLInput.value&&(0,R.jsx)(vn,{inputs:t,useSecretsStorage:a,isConvertedToSecret:p.sslKey,onToggleSecretAndClearValue:e=>{e?t.sslKeyInput.clear():t.sslKeySecretInput.setValue(""),x({sslKey:!1}),n(e)},type:t.typeInput.value}))},Ti=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,{cloud:i}=(0,u.WeA)(),[o,r]=l().useState(!0),[c,p]=l().useState({sslKey:!1}),{enableSSLSecrets:x}=N.ZX.get();return(0,s.useEffect)((()=>{o&&(r(!1),a&&x&&t.sslKeyInput.value&&!t.sslKeySecretInput.value&&(t.sslKeySecretInput.setValue(t.sslKeyInput.value),t.sslKeyInput.clear(),p({...c,sslKey:!0})))}),[a,t.sslKeyInput,t.sslKeySecretInput,o,r,c,x]),(0,R.jsx)(l().Fragment,null,(0,R.jsx)(ln.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},t.elasticsearchUrlInput.props,{isUrl:!0,helpText:(null==i?void 0:i.isServerlessEnabled)&&(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputLabel",defaultMessage:"Elasticsearch CA trusted fingerprint (optional)"})},t.caTrustedFingerprintInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0},t.caTrustedFingerprintInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputPlaceholder",{defaultMessage:"Specify Elasticsearch CA trusted fingerprint"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(vn,{type:t.typeInput.value,inputs:t,useSecretsStorage:x&&a,isConvertedToSecret:c.sslKey,onToggleSecretAndClearValue:e=>{e?t.sslKeyInput.clear():t.sslKeySecretInput.setValue(""),p({sslKey:!1}),n(e)}}))},wi=({defaultOutput:e,onClose:t,output:a,proxies:n})=>{(0,u.ifo)("settings");const i=function(e,t,a){var l,n,i,o,r,d,c,g,p,m,x,h,y,E,v,k,j,b,S,F,M,I,T,w,A,C,P,L,_,D,O,B,z,U,H,W,G,K,q,V,$,Y,Q,X,J,Z,ee,ae,se,le,ne,ie,oe,re,ue,de,ce,ge,pe,me,fe,xe,he,ye,Ee,ve,ke,je,be,Se,Fe,Me,Ie,Te,we,Ae,Ce,Pe,Le;const _e=(0,u.YI3)(),De=(0,u.iO7)(),{showExperimentalShipperOptions:Oe}=N.ZX.get(),Re=!(null!==(l=_e.missingOptionalFeatures)&&void 0!==l&&l.includes("encrypted_saved_object_encryption_key_required")),[Be,Ne]=(0,s.useState)(!1),{notifications:ze,cloud:Ue}=(0,u.WeA)(),{confirm:He}=(0,sn.fl)(),We=null!==(n=null==t?void 0:t.is_preconfigured)&&void 0!==n&&n,Ge=null!==(i=null==t?void 0:t.allow_edit)&&void 0!==i?i:[];function Ke(e){return!De.fleet.allSettings||!!We&&!Ge.includes(e)}const qe=(0,u.Gez)(null!==(o=null==t?void 0:t.name)&&void 0!==o?o:"",ti,Ke("name")),Ve=(0,u.Gez)(null!==(r=null==t?void 0:t.type)&&void 0!==r?r:"elasticsearch",void 0,Ke("type")),$e=(0,u.Gez)(null!==(d=null==t?void 0:t.config_yaml)&&void 0!==d?d:"",ei,Ke("config_yaml")),Ye=(0,u.MbH)(null!==(c=null==t?void 0:t.is_default)&&void 0!==c&&c,Ke("is_default")||(null==t?void 0:t.is_default)),Qe=(0,u.MbH)(null!==(g=null==t?void 0:t.is_default_monitoring)&&void 0!==g&&g,Ke("is_default_monitoring")||(null==t?void 0:t.is_default_monitoring)),Xe=(0,u.Gez)(null!==(p=null==t?void 0:t.ca_trusted_fingerprint)&&void 0!==p?p:"",ni,Ke("ca_trusted_fingerprint")),Je=null==Ue?void 0:Ue.isServerlessEnabled,Ze=!Je||null!=t&&t.hosts?(null==t?void 0:t.hosts)||[]:(null==a?void 0:a.hosts)||[],et=Je||Ke("hosts"),tt=(0,u.U6y)("esHostsComboxBox",Ze,Jn,et),at=(0,u.Gez)(null!==(m=null==t?void 0:t.preset)&&void 0!==m?m:(0,_n.lX)(null!==(x=null==t?void 0:t.config_yaml)&&void 0!==x?x:"",Rs.Hh),(()=>{}),Ke("preset")),st=(0,u.Gez)(null!==(h=null==t?void 0:t.service_token)&&void 0!==h?h:"",ii,Ke("service_token")),lt=(0,u.YZM)(null!==(y=null==t||null===(E=t.secrets)||void 0===E?void 0:E.service_token)&&void 0!==y?y:"",oi,Ke("service_token")),nt=(0,u.MbH)(null!==(v=null==t?void 0:t.sync_integrations)&&void 0!==v&&v,Ke("sync_integrations")),it=(0,u.Gez)(null!==(k=null==t?void 0:t.kibana_api_key)&&void 0!==k?k:"",nt.value?ri:void 0,Ke("kibana_api_key")),ot=(0,u.Gez)(null!==(j=null==t?void 0:t.kibana_url)&&void 0!==j?j:"",(e=>function(e,t){try{if(t&&!e)return[f.i18n.translate("xpack.fleet.settings.outputForm.urlRequiredError",{defaultMessage:"URL is required"})];if(!e)return;{const t=new URL(e);if(!["http:","https:"].includes(t.protocol))return[f.i18n.translate("xpack.fleet.settings.outputForm.invalidProtocolError",{defaultMessage:"Invalid protocol"})]}}catch(e){return[f.i18n.translate("xpack.fleet.settings.outputForm.invalidURLError",{defaultMessage:"Invalid URL"})]}}(e,nt.value)),Ke("kibana_url")),rt=(0,u.MbH)(null!==(b=null==t?void 0:t.sync_uninstalled_integrations)&&void 0!==b&&b,Ke("sync_uninstalled_integrations")),ut=null!=t&&t.config_yaml?(0,Rs.Hh)(null==t?void 0:t.config_yaml):{},dt=!(null!=ut&&ut.shipper)||!1===(null==ut||null===(S=ut.shipper)||void 0===S?void 0:S.enabled),ct=(0,u.MbH)(null!==(F=null==t||null===(M=t.shipper)||void 0===M?void 0:M.disk_queue_enabled)&&void 0!==F&&F),gt=(0,u.Gez)(null!==(I=null==t||null===(T=t.shipper)||void 0===T?void 0:T.disk_queue_path)&&void 0!==I?I:"",void 0,null!==(w=!ct.value)&&void 0!==w&&w),pt=(0,u.hp)(null!==(A=null==t||null===(C=t.shipper)||void 0===C?void 0:C.disk_queue_max_size)&&void 0!==A?A:4096,void 0,null!==(P=!ct.value)&&void 0!==P&&P),mt=(0,u.MbH)(null!==(L=null==t||null===(_=t.shipper)||void 0===_?void 0:_.disk_queue_encryption_enabled)&&void 0!==L&&L,null!==(D=!ct.value)&&void 0!==D&&D),ft=(0,u.MbH)(null!==(O=null==t||null===(B=t.shipper)||void 0===B?void 0:B.disk_queue_enabled)&&void 0!==O&&O),xt=(0,u.MbH)(null!==(z=null==t||null===(U=t.shipper)||void 0===U?void 0:U.disk_queue_compression_enabled)&&void 0!==z&&z),ht=Array.from(Array(10).keys()).slice(1).map((e=>({value:`${e}`,text:`Level ${e}`}))),yt=(0,u.aOf)(ht,null!==(H=`${null==t||null===(W=t.shipper)||void 0===W?void 0:W.compression_level}`)&&void 0!==H?H:ht[0].value,null!==(G=!xt.value)&&void 0!==G&&G),Et=(0,u.hp)((null==t||null===(K=t.shipper)||void 0===K?void 0:K.mem_queue_events)||void 0),vt=(0,u.hp)((null==t||null===(q=t.shipper)||void 0===q?void 0:q.queue_flush_timeout)||void 0),kt=(0,u.hp)((null==t||null===(V=t.shipper)||void 0===V?void 0:V.max_batch_bytes)||void 0),jt=Ke("ssl"),bt=(0,u.MbH)("logstash"!==(null==t?void 0:t.type)||Boolean(null==t?void 0:t.ssl),jt),St=(0,u.U6y)("logstashHostsComboxBox",null!==($=null==t?void 0:t.hosts)&&void 0!==$?$:[],Zn,Ke("hosts")),Ft=(0,u.U6y)("sslCertificateAuthoritiesComboxBox",null!==(Y=null==t||null===(Q=t.ssl)||void 0===Q?void 0:Q.certificate_authorities)&&void 0!==Y?Y:[],void 0,jt),Mt=(0,u.Gez)(null!==(X=null==t||null===(J=t.ssl)||void 0===J?void 0:J.certificate)&&void 0!==X?X:"","logstash"===(null==t?void 0:t.type)&&bt.value?ui:void 0,jt),It=(0,u.Gez)(null!==(Z=null==t||null===(ee=t.ssl)||void 0===ee?void 0:ee.key)&&void 0!==Z?Z:"","logstash"===(null==t?void 0:t.type)&&bt.value?di:void 0,jt),Tt=(0,u.YZM)(null==t||null===(ae=t.secrets)||void 0===ae||null===(se=ae.ssl)||void 0===se?void 0:se.key,"logstash"===(null==t?void 0:t.type)&&bt.value?ci:void 0,jt),wt=(0,u.Gez)(null!==(le=null==t?void 0:t.proxy_id)&&void 0!==le?le:"",(()=>{}),Ke("proxy_id")),At=t,Ct=(0,u.Gez)(null!==(ne=null==At?void 0:At.version)&&void 0!==ne?ne:"1.0.0",void 0,Ke("version")),Pt=(0,u.U6y)("kafkaHostsComboBox",null!==(ie=null==t?void 0:t.hosts)&&void 0!==ie?ie:[],Xn,Ke("hosts")),Lt=(0,u.RIP)(null!==(oe=null==At?void 0:At.auth_type)&&void 0!==oe?oe:te.NB8.None,Ke("auth_type")),_t=(0,u.RIP)(null!==(re=null==At?void 0:At.connection_type)&&void 0!==re?re:te.zPI.Plaintext,Ke("connection_type")),Dt=(0,u.Gez)(null!==(ue=null==At?void 0:At.username)&&void 0!==ue?ue:void 0,Lt.value===te.NB8.Userpass?ai:void 0,Ke("username")),Ot=(0,u.Gez)(null!==(de=null==At?void 0:At.password)&&void 0!==de?de:void 0,Lt.value===te.NB8.Userpass?si:void 0,Ke("password")),Rt=(0,u.YZM)(null==At||null===(ce=At.secrets)||void 0===ce?void 0:ce.password,Lt.value===te.NB8.Userpass?li:void 0,Ke("password")),Bt=(0,u.U6y)("kafkaSslCertificateAuthoritiesComboBox",null!==(ge=null==At||null===(pe=At.ssl)||void 0===pe?void 0:pe.certificate_authorities)&&void 0!==ge?ge:[],void 0,jt),Nt=(0,u.Gez)(null==At||null===(me=At.ssl)||void 0===me?void 0:me.certificate,Lt.value===te.NB8.Ssl?ui:void 0,jt),zt=(0,u.Gez)(null==At||null===(fe=At.ssl)||void 0===fe?void 0:fe.key,Lt.value===te.NB8.Ssl?di:void 0,jt),Ut=(0,u.YZM)(null==At||null===(xe=At.secrets)||void 0===xe||null===(he=xe.ssl)||void 0===he?void 0:he.key,Lt.value===te.NB8.Ssl?ci:void 0,jt),Ht=(0,u.Gez)(null!==(ye=null==At||null===(Ee=At.ssl)||void 0===Ee?void 0:Ee.verification_mode)&&void 0!==ye?ye:te.i36.Full,void 0,jt),Wt=(0,u.RIP)(null!==(ve=null==At||null===(ke=At.sasl)||void 0===ke?void 0:ke.mechanism)&&void 0!==ve?ve:te.N9h.Plain,Ke("sasl")),Gt=(0,u.RIP)(null!==(je=null==At?void 0:At.partition)&&void 0!==je?je:te.BwZ.Random,Ke("partition")),Kt=(0,u.Gez)(null!=At&&null!==(be=At.random)&&void 0!==be&&be.group_events?`${At.random.group_events}`:"1",Gt.value===te.BwZ.Random?fi:void 0,Ke("partition")),qt=(0,u.Gez)(null==At||null===(Se=At.hash)||void 0===Se?void 0:Se.hash,void 0,Ke("partition")),Vt=(0,u.Gez)(null!=At&&null!==(Fe=At.round_robin)&&void 0!==Fe&&Fe.group_events?`${At.round_robin.group_events}`:"1",Gt.value===te.BwZ.RoundRobin?fi:void 0,Ke("partition")),$t=(0,u.RIP)(null!=At&&At.topic&&null!=At&&null!==(Me=At.topic)&&void 0!==Me&&Me.includes("%{[")?te.LXo.Dynamic:te.LXo.Static,Ke("topic")),Yt=(0,u.Gez)(null!=(Qt=At)&&null!==(Xt=Qt.topic)&&void 0!==Xt&&Xt.includes("%{[")?"":(null==Qt?void 0:Qt.topic)||"",$t.value===te.LXo.Static?gi:void 0,Ke("topic"));var Qt,Xt;const Jt=(0,u.whI)("kafkaDynamicTopicComboBox",function(e){var t;if(null==e||!e.topic||null!=e&&e.topic&&(null===(t=e.topic)||void 0===t||!t.includes("%{[")))return[];const a=e.topic.match(/(%\{\[)(\S*)(\]\})/),s=null!=a&&a.length?a[2]:"";return[{label:s,value:s}]}(At),$t.value===te.LXo.Dynamic?pi:void 0,Ke("topic")),Zt=(0,u.kt3)("kafkaHeadersComboBox",null!==(Ie=null==At?void 0:At.headers)&&void 0!==Ie?Ie:[{key:"",value:""}],xi,Ke("headers")),ea=(0,u.Gez)(null!==(Te=null==At?void 0:At.client_id)&&void 0!==Te?Te:"Elastic",mi,Ke("client_id")),ta=(0,u.MbH)(!(null==At||!At.compression||At.compression===te.jZS.None),Ke("compression")),aa=(0,u.Gez)(`${null!==(we=null==At?void 0:At.compression_level)&&void 0!==we?we:4}`,void 0,Ke("compression_level")),sa=(0,u.Gez)(null!=At&&At.compression&&At.compression!==te.jZS.None?At.compression:te.jZS.Gzip,void 0,Ke("compression")),la=(0,u.Gez)(`${null!==(Ae=null==At?void 0:At.timeout)&&void 0!==Ae?Ae:30}`,void 0,Ke("broker_timeout")),na=(0,u.Gez)(`${null!==(Ce=null==At?void 0:At.broker_timeout)&&void 0!==Ce?Ce:30}`,void 0,Ke("timeout")),ia=(0,u.Gez)(`${null!==(Pe=null==At?void 0:At.required_acks)&&void 0!==Pe?Pe:te.NAW.Commit}`,void 0,Ke("required_acks")),oa=(0,u.Gez)(null==At?void 0:At.key,void 0,Ke("key")),ra=(0,u.MbH)(null!==(Le=null==t?void 0:t.write_to_logs_streams)&&void 0!==Le&&Le,!1),ua=Ve.value===te.gf.Logstash,da=Ve.value===te.gf.Kafka,ca=Ve.value===te.gf.RemoteElasticsearch,ga={nameInput:qe,typeInput:Ve,elasticsearchUrlInput:tt,diskQueueEnabledInput:ct,diskQueuePathInput:gt,diskQueueEncryptionEnabled:mt,diskQueueMaxSizeInput:pt,diskQueueCompressionEnabled:xt,compressionLevelInput:yt,logstashEnableSSLInput:bt,logstashHostsInput:St,presetInput:at,additionalYamlConfigInput:$e,defaultOutputInput:Ye,defaultMonitoringOutputInput:Qe,caTrustedFingerprintInput:Xe,serviceTokenInput:st,serviceTokenSecretInput:lt,kibanaAPIKeyInput:it,syncIntegrationsInput:nt,kibanaURLInput:ot,syncUninstalledIntegrationsInput:rt,sslCertificateInput:Mt,sslKeyInput:It,sslKeySecretInput:Tt,sslCertificateAuthoritiesInput:Ft,proxyIdInput:wt,loadBalanceEnabledInput:ft,memQueueEvents:Et,queueFlushTimeout:vt,maxBatchBytes:kt,kafkaVersionInput:Ct,kafkaHostsInput:Pt,kafkaVerificationModeInput:Ht,kafkaAuthMethodInput:Lt,kafkaConnectionTypeInput:_t,kafkaAuthUsernameInput:Dt,kafkaAuthPasswordInput:Ot,kafkaAuthPasswordSecretInput:Rt,kafkaSaslMechanismInput:Wt,kafkaPartitionTypeInput:Gt,kafkaPartitionTypeRandomInput:Kt,kafkaPartitionTypeHashInput:qt,kafkaPartitionTypeRoundRobinInput:Vt,kafkaHeadersInput:Zt,kafkaClientIdInput:ea,kafkaCompressionInput:ta,kafkaCompressionLevelInput:aa,kafkaCompressionCodecInput:sa,kafkaBrokerTimeoutInput:la,kafkaBrokerReachabilityTimeoutInput:na,kafkaBrokerAckReliabilityInput:ia,kafkaKeyInput:oa,kafkaSslCertificateAuthoritiesInput:Bt,kafkaSslCertificateInput:Nt,kafkaSslKeyInput:zt,kafkaSslKeySecretInput:Ut,kafkaTopicsInput:$t,kafkaStaticTopicInput:Yt,kafkaDynamicTopicInput:Jt,writeToStreams:ra},pa=Object.values(ga).some((e=>e.hasChanged)),ma=(0,s.useCallback)((()=>{const e=qe.validate(),t=tt.validate(),a=Pt.validate(),s=Dt.validate(),l=Ot.validate(),n=Rt.validate(),i=ea.validate(),o=Nt.validate(),r=zt.validate(),u=Ut.validate(),d=Zt.validate(),c=St.validate(),g=$e.validate(),p=Xe.validate(),m=st.validate(),f=lt.validate(),x=it.validate(),h=ot.validate(),y=Mt.validate(),E=It.validate(),v=Tt.validate(),k=gt.validate(),j=Kt.validate(),b=Vt.validate(),S=Yt.validate(),F=Jt.validate(),M=zt.value?r:u,I=Ot.value?l:n;return ua?c&&g&&e&&y&&(E||v):da?e&&a&&o&&M&&s&&I&&d&&g&&i&&j&&b&&S&&F:ca?t&&g&&e&&(st.value&&m||lt.value&&f)&&(!nt.value&&h||nt.value&&it.value&&x&&h):t&&g&&e&&p&&k}),[qe,tt,Pt,Dt,Ot,Rt,ea,Nt,zt,Ut,Zt,St,$e,Xe,st,lt,it,nt,ot,Mt,It,Tt,gt,Kt,Vt,Yt,Jt,ua,da,ca]),fa=(0,s.useCallback)((async()=>{try{if(!ma())return;Ne(!0);let a={};dt||(a={shipper:{mem_queue_events:Et.value?Number(Et.value):null,queue_flush_timeout:vt.value?Number(vt.value):null,max_batch_bytes:kt.value?Number(kt.value):null}}),!dt&&Oe&&(a={...a,shipper:{disk_queue_enabled:ct.value,disk_queue_path:ct.value&&gt.value?gt.value:"",disk_queue_max_size:ct.value&&pt.value?pt.value:null,disk_queue_encryption_enabled:ct.value&&mt.value,disk_queue_compression_enabled:xt.value,compression_level:xt.value?Number(yt.value):null,loadbalance:ft.value}});const s=""!==wt.value?wt.value:null,l=(()=>{const e=e=>{if(void 0!==e){const t=parseInt(e,10);if(!isNaN(t))return t}};switch(Ve.value){case te.gf.Kafka:const l=Bt.value.filter((e=>""!==e)).length,n=function(e){const t={};return!e.kafkaSslKeyInput.value&&e.kafkaSslKeySecretInput.value&&(t.ssl={key:e.kafkaSslKeySecretInput.value}),!e.kafkaAuthPasswordInput.value&&e.kafkaAuthPasswordSecretInput.value&&(t.password=e.kafkaAuthPasswordSecretInput.value),Object.keys(t).length?t:null}({kafkaSslKeyInput:zt,kafkaSslKeySecretInput:Ut,kafkaAuthPasswordInput:Ot,kafkaAuthPasswordSecretInput:Rt});return{name:qe.value,type:te.gf.Kafka,hosts:Pt.value,is_default:Ye.value,is_default_monitoring:Qe.value,config_yaml:$e.value,..._t.value!==te.zPI.Plaintext||Lt.value!==te.NB8.None?{ssl:{...l?{certificate_authorities:Bt.value.filter((e=>""!==e))}:{},...Lt.value===te.NB8.Ssl?{certificate:Nt.value,key:zt.value}:{},verification_mode:Ht.value}}:{},proxy_id:s,client_id:ea.value||void 0,version:Ct.value,...oa.value?{key:oa.value}:{},compression:ta.value?sa.value:te.jZS.None,...ta.value&&sa.value===te.jZS.Gzip?{compression_level:e(aa.value)}:{},auth_type:Lt.value,...Lt.value===te.NB8.None?{connection_type:_t.value}:{},...Lt.value===te.NB8.Userpass&&Dt.value?{username:Dt.value}:{},...Lt.value===te.NB8.Userpass&&Ot.value?{password:Ot.value}:{},...Lt.value===te.NB8.Userpass&&Wt.value?{sasl:{mechanism:Wt.value}}:{},partition:Gt.value,...Gt.value===te.BwZ.Random&&Kt.value?{random:{group_events:e(Kt.value)}}:{},...Gt.value===te.BwZ.RoundRobin&&Vt.value?{round_robin:{group_events:e(Vt.value)}}:{},...Gt.value===te.BwZ.Hash&&qt.value?{hash:{hash:qt.value}}:{},...$t.value===te.LXo.Static&&Yt.value?{topic:Yt.value}:$t.value===te.LXo.Dynamic&&Jt.value?{topic:`%{[${Jt.value}]}`}:{},headers:Zt.value,timeout:e(la.value),broker_timeout:e(na.value),required_acks:e(ia.value),...a,...n?{secrets:n}:{}};case te.gf.Logstash:return{name:qe.value,type:te.gf.Logstash,hosts:St.value,is_default:Ye.value,is_default_monitoring:Qe.value,config_yaml:$e.value,ssl:bt.value?{certificate:Mt.value,key:It.value||void 0,certificate_authorities:Ft.value.filter((e=>""!==e))}:null,...!It.value&&Tt.value&&{secrets:{ssl:bt.value?{key:Tt.value}:void 0}},proxy_id:s,...a};case te.gf.RemoteElasticsearch:let i;var t;return!st.value&&lt.value&&(i={service_token:lt.value}),!It.value&&Tt.value&&(i={...null!==(t=i)&&void 0!==t?t:{},ssl:{key:Tt.value}}),{name:qe.value,type:te.gf.RemoteElasticsearch,hosts:tt.value,is_default:Ye.value,is_default_monitoring:Qe.value,preset:at.value,config_yaml:$e.value,service_token:st.value||void 0,kibana_api_key:it.value||void 0,...i?{secrets:i}:{},sync_integrations:nt.value,kibana_url:ot.value||null,sync_uninstalled_integrations:rt.value,proxy_id:s,write_to_logs_streams:ra.value,...a,ssl:{certificate:Mt.value,key:It.value||void 0,certificate_authorities:Ft.value.filter((e=>""!==e))}};case te.gf.Elasticsearch:default:return{name:qe.value,type:te.gf.Elasticsearch,hosts:tt.value,is_default:Ye.value,is_default_monitoring:Qe.value,preset:at.value,config_yaml:$e.value,ca_trusted_fingerprint:Xe.value,proxy_id:s,write_to_logs_streams:ra.value,...a,ssl:{certificate:Mt.value,key:It.value||void 0,certificate_authorities:Ft.value.filter((e=>""!==e))},...!It.value&&Tt.value&&{secrets:{ssl:{key:Tt.value}}}}}})();if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await mn(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,R.jsx)(hi,null),(0,R.jsx)(yi,{agentCount:a,agentPolicyCount:s,output:e}))}(t,He))return void Ne(!1);const e=await(0,u.xEL)(t.id,l);if(e.error)throw e.error}else{const e=await(0,u.S6i)(l);if(e.error)throw e.error}e(),Ne(!1)}catch(e){Ne(!1),ze.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.outputForm.errorToastTitle",{defaultMessage:"Error while saving output"})})}}),[ma,dt,Oe,wt.value,t,e,Et.value,vt.value,kt.value,ct.value,gt.value,pt.value,mt.value,xt.value,yt.value,ft.value,Ve.value,Bt.value,zt,Ut,Ot,Rt,qe.value,Pt.value,Ye.value,Qe.value,$e.value,_t.value,Lt.value,Nt.value,Ht.value,ea.value,Ct.value,oa.value,ta.value,sa.value,aa.value,Dt.value,Wt.value,Gt.value,Kt.value,Vt.value,qt.value,$t.value,Yt.value,Jt.value,Zt.value,la.value,na.value,ia.value,bt.value,St.value,Mt.value,It.value,Ft.value,Tt.value,tt.value,at.value,st.value,lt.value,it.value,nt.value,rt.value,ot.value,Xe.value,ra.value,He,ze.toasts]);return{inputs:ga,submit:fa,isLoading:Be,hasEncryptedSavedObjectConfigured:Re,isShipperEnabled:!dt,isDisabled:Be||t&&!pa||ua&&!Re}}(t,a,e),o=i.inputs,{docLinks:r,cloud:c}=(0,u.WeA)(),p=(0,u.YI3)(),x=!(null==c||!c.isServerlessEnabled),[h,y]=(0,s.useState)("disabled");void 0!==p.isSecretsStorageEnabled&&"disabled"===h&&y(p.isSecretsStorageEnabled);const E=e=>{"disabled"!==h&&y(e)},v=!0===h,k=(0,s.useMemo)((()=>n.map((e=>({value:e.id,label:e.name})))),[n]),j=o.typeInput.value===te.gf.RemoteElasticsearch,b=o.typeInput.value===te.gf.Elasticsearch,S=!!o.typeInput.value&&(0,_n.$N)(o.typeInput.value),F=!(null!=c&&c.isServerlessEnabled),I=[{value:te.gf.Elasticsearch,text:"Elasticsearch"},...F?[{value:te.gf.RemoteElasticsearch,text:"Remote Elasticsearch"}]:[],{value:te.gf.Logstash,text:"Logstash"},{value:te.gf.Kafka,text:"Kafka"}],T=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:t,maxWidth:M.MW,"aria-labelledby":T},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:T},a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.editTitle",defaultMessage:"Edit output"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.createTitle",defaultMessage:"Add new output"})))),(0,R.jsx)(g.EuiFlyoutBody,null,(null==a?void 0:a.is_preconfigured)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiCallOut,{announceOnMount:!0,iconType:"lock",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutTitle",defaultMessage:"This output is managed outside of Fleet"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutDescription",defaultMessage:"Most actions related to this output are unavailable. Refer to your kibana config for more detail."})),(0,R.jsx)(g.EuiSpacer,{size:"m"})),(0,R.jsx)(g.EuiForm,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.nameInputLabel",defaultMessage:"Name"})},o.nameInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.nameInput",fullWidth:!0},o.nameInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.typeInputLabel",defaultMessage:"Type"}))},(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.typeInput"},o.typeInput.props,{options:I})),b||j?(0,R.jsx)(l().Fragment,null,x?null:(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiCallOut,{announceOnMount:!0,"data-test-subj":`settingsOutputsFlyout.${o.typeInput.value}OutputTypeCallout`,title:(()=>{switch(o.typeInput.value){default:case te.gf.Elasticsearch:return f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esOutputTypeCallout",{defaultMessage:"This output type does not support connectivity to a remote Elasticsearch cluster, please use the Remote Elasticsearch type for that."});case te.gf.RemoteElasticsearch:return f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESOutputTypeCallout",{defaultMessage:"Remote Elasticsearch output does not support connectivity to a serverless project."})}})(),iconType:"alert",color:"warning",size:"s",heading:"p"})),j?(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.remoteESTypeText",defaultMessage:"Enter your output hosts, service token for your remote cluster, and any advanced YAML configuration. Learn more about how to use these parameters in {doc}.",values:{doc:(0,R.jsx)(g.EuiLink,{href:r.links.fleet.remoteESOoutput,target:"_blank"},f.i18n.translate("xpack.fleet.settings.editOutputFlyout.docLabel",{defaultMessage:"our documentation"}))}}))):null):null)),(e=>{switch(e){case te.gf.Logstash:return(0,R.jsx)(Ii,{inputs:o,useSecretsStorage:v,onToggleSecretStorage:E,hasEncryptedSavedObjectConfigured:i.hasEncryptedSavedObjectConfigured});case te.gf.Kafka:return(0,R.jsx)(Gn,{inputs:o,useSecretsStorage:v,onToggleSecretStorage:E});case te.gf.RemoteElasticsearch:return(0,R.jsx)(vi,{inputs:o,useSecretsStorage:v,onToggleSecretStorage:E});case te.gf.Elasticsearch:default:return(0,R.jsx)(Ti,{inputs:o,useSecretsStorage:v,onToggleSecretStorage:E})}})(o.typeInput.value),j?null:(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},o.proxyIdInput.props,{onChange:e=>{var t,a;return o.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==o.proxyIdInput.value?k.filter((e=>e.value===o.proxyIdInput.value)):[],options:k,singleSelection:{asPlainText:!0},isDisabled:o.proxyIdInput.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(rn,null))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultOutputInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},o.defaultOutputInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentIntegrations}.",values:{boldAgentIntegrations:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentIntegrationsBold",defaultMessage:"agent integrations"}))}})}))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultMonitoringOutputInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},o.defaultMonitoringOutputInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultMontoringOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentMonitoring}.",values:{boldAgentMonitoring:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentMonitoringBold",defaultMessage:"agent monitoring"}))}})}))),S&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningLabel",defaultMessage:"Performance tuning"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpText",defaultMessage:"Performance tuning presets are curated output settings for common use cases. You can also select {custom} to specify your own settings in the Advanced YAML Configuration box below. For a detailed list of settings configured by each preset, see {link}.",values:{custom:(0,R.jsx)("strong",null,"Custom"),link:(0,R.jsx)(g.EuiLink,{href:r.links.fleet.performancePresets,external:!0,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpTextLink",defaultMessage:"our documentation"}))}})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.presetInput"},o.presetInput.props,{onChange:e=>o.presetInput.setValue(e.target.value),disabled:o.presetInput.props.disabled||(0,_n.o8)(o.additionalYamlConfigInput.value,Rs.Hh),options:[{value:"balanced",text:"Balanced"},{value:"custom",text:"Custom"},{value:"throughput",text:"Throughput"},{value:"scale",text:"Scale"},{value:"latency",text:"Latency"}]})))),(b||j)&&(0,R.jsx)(g.EuiFormRow,{helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.writeToStreamsHelpText",defaultMessage:"When enabled, agents will be granted additional permissions to write data to {streamsLink}. To learn more, refer to the {learnMore} documentation.",values:{streamsLink:(0,R.jsx)(g.EuiLink,{href:r.links.observability.logsStreams,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.streamsLink",defaultMessage:"Streams"})),learnMore:(0,R.jsx)(g.EuiLink,{href:r.links.observability.wiredStreams,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.learnMore",defaultMessage:"wired streams"}))}})},(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.writeToStreamsLabel",defaultMessage:"Allow agents to write to Streams"}),checked:o.writeToStreams.value,onChange:e=>o.writeToStreams.setValue(e.target.checked)})),S&&(0,_n.o8)(o.additionalYamlConfigInput.value,Rs.Hh)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{announceOnMount:!0,color:"warning",iconType:"alert",size:"s",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarning",defaultMessage:'Performance tuning preset must be "Custom" due to presence of reserved key in advanced YAML configuration'})},(0,R.jsx)(g.EuiAccordion,{id:"performanceTuningMustBeCustomWarningDetails",buttonContent:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarningDetails",defaultMessage:"Show reserved keys"})},(0,R.jsx)("ul",null,te.uhU.map((e=>(0,R.jsx)("li",{key:e},(0,R.jsx)(g.EuiCode,null,e)))))))),(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({label:(0,R.jsx)(g.EuiLink,{href:r.links.fleet.esSettings,external:!0,target:"_blank"},f.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputLabel",{defaultMessage:"Advanced YAML configuration"}))},o.additionalYamlConfigInput.formRowProps,{fullWidth:!0}),(0,R.jsx)(Yn,{value:o.additionalYamlConfigInput.value,onChange:e=>{(0,_n.o8)(e,Rs.Hh)&&o.presetInput.setValue("custom"),o.additionalYamlConfigInput.setValue(e)},disabled:o.additionalYamlConfigInput.props.disabled,placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputPlaceholder",{defaultMessage:"# YAML settings here will be added to the output section of each agent policy."})})),(0,R.jsx)(Ei,{enabled:i.isShipperEnabled,inputs:o})),null!=a&&a.id&&"remote_elasticsearch"===a.type?(0,R.jsx)(_l,{output:a}):null),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:t,flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:i.isLoading,isDisabled:i.isDisabled,onClick:i.submit,"data-test-subj":"saveApplySettingsBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},Ai=(0,sn.$H)((()=>{var e,t,a,l,n,i,d,c,p;(0,u.ifo)("settings");const m=(0,o.useHistory)(),x=(0,u.Wdf)(),{outputs:h,fleetServerHosts:y,downloadSources:E,proxies:v}={outputs:(0,u.Eiq)(),fleetServerHosts:(0,u.OVZ)(),downloadSources:(0,u.SFz)(),proxies:(0,u.qyb)()},k=null===(e=h.data)||void 0===e?void 0:e.items.filter((e=>!e.is_internal)),j=null===(t=y.data)||void 0===t?void 0:t.items.filter((e=>!e.is_internal)),{deleteOutput:b}=function(e){const{confirm:t}=(0,sn.fl)(),{notifications:a}=(0,u.WeA)();return{deleteOutput:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:l}=await mn(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,R.jsx)(fn,null),(0,R.jsx)(xn,{output:s,agentCount:a,agentPolicyCount:l}),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteOutputs.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const n=await(0,u.pE1)(s.id);if(n.error)throw n.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteOutputs.errorToastTitle",{defaultMessage:"Error deleting output"})})}}),[t,a.toasts,e])}}(h.resendRequest),{deleteDownloadSource:S}=function(e){const{confirm:t}=(0,sn.fl)(),{notifications:a}=(0,u.WeA)();return{deleteDownloadSource:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:l}=await kn(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,R.jsx)(Mn,null),(0,R.jsx)(In,{"data-test-subj":"editDownloadSourcesDeleteModal.confirmModalText",downloadSource:s,agentCount:a,agentPolicyCount:l}),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteDownloadSource.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const n=await(0,u.taj)(s.id);if(n.error)throw n.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteDownloadSource.errorToastTitle",{defaultMessage:"Error deleting agent binary source."})})}}),[t,a.toasts,e])}}(E.resendRequest),{deleteFleetServerHost:T}=function(e){const{confirm:t}=(0,sn.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetServerHost:(0,s.useCallback)((async s=>{try{if(!await t((0,R.jsx)(hn,null),(0,R.jsx)(yn,null),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.D7A)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.errorToastTitle",{defaultMessage:"Error deleting Fleet Server hosts"})})}}),[t,a.toasts,e])}}(y.resendRequest),{deleteFleetProxy:w}=function(e){const{confirm:t}=(0,sn.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetProxy:(0,s.useCallback)((async s=>{try{if(!await t((0,R.jsx)(gn,null),(0,R.jsx)(pn,null),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteFleetProxy.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.mwZ)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteFleetProxy.errorToastTitle",{defaultMessage:"Error deleting proxy"})})}}),[t,a.toasts,e])}}(v.resendRequest),A=h.resendRequest,C=E.resendRequest,P=y.resendRequest,L=v.resendRequest,_=(0,s.useCallback)((()=>{x.closeFleetServerFlyout(),A(),C(),P(),L(),m.replace(M.tn.settings()[1])}),[x,A,C,P,L,m]),{cloud:D}=(0,u.WeA)(),O=null==D?void 0:D.isServerlessEnabled;return h.isLoading&&h.isInitialRequest||!k||y.isLoading&&y.isInitialRequest||!j||E.isLoading&&E.isInitialRequest||null===(a=E.data)||void 0===a||!a.items||v.isLoading&&v.isInitialRequest||null===(l=v.data)||void 0===l||!l.items?(0,R.jsx)(I.iW,{section:"settings"},(0,R.jsx)(F.Rh,null)):(0,R.jsx)(I.iW,{section:"settings"},(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.settings_edit_fleet_server_hosts},(e=>{var t,a;const s=j.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return s?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(cn,{proxies:null!==(t=null===(a=v.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:_,fleetServerHost:s})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})})),(0,R.jsx)(r.Route,{path:M.X5.settings_create_fleet_server_hosts},(0,R.jsx)(g.EuiPortal,null,O?(0,R.jsx)(cn,{proxies:null!==(n=null===(i=v.data)||void 0===i?void 0:i.items)&&void 0!==n?n:[],onClose:_,defaultFleetServerHost:null===(d=y.data)||void 0===d?void 0:d.items.find((e=>e.id===te.Z24))}):(0,R.jsx)(F.Jh,{onClose:_}))),(0,R.jsx)(r.Route,{path:M.X5.settings_create_outputs},(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(wi,{proxies:v.data.items,onClose:_,defaultOutput:O?null===(c=h.data)||void 0===c?void 0:c.items.find((e=>e.id===te.VE)):void 0}))),(0,R.jsx)(r.Route,{path:M.X5.settings_create_fleet_proxy},(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Ln,{onClose:_}))),(0,R.jsx)(r.Route,{path:M.X5.settings_edit_fleet_proxy},(e=>{var t;const a=null===(t=v.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return a?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Ln,{onClose:_,fleetProxy:a})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})})),(0,R.jsx)(r.Route,{path:M.X5.settings_edit_outputs},(e=>{var t,a,s;const l=k.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.outputId)===t.id}));return l?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(wi,{proxies:null!==(t=null===(a=v.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:_,output:l,defaultOutput:O?null===(s=h.data)||void 0===s?void 0:s.items.find((e=>e.id===te.VE)):void 0})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})})),(0,R.jsx)(r.Route,{path:M.X5.settings_create_download_sources},(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fn,{onClose:_,proxies:(null==v||null===(p=v.data)||void 0===p?void 0:p.items)||[]}))),(0,R.jsx)(r.Route,{path:M.X5.settings_edit_download_sources},(e=>{var t,a;const s=null===(t=E.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.downloadSourceId)===t.id}));return s?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fn,{onClose:_,downloadSource:s,proxies:(null==v||null===(a=v.data)||void 0===a?void 0:a.items)||[]})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})}))),(0,R.jsx)(an,{deleteFleetProxy:w,proxies:v.data.items,outputs:k,fleetServerHosts:j,deleteOutput:b,deleteFleetServerHost:T,downloadSources:E.data.items,deleteDownloadSource:S}))})),Ci=({value:e})=>(0,R.jsx)(Kn.CodeEditor,{isCopyable:!0,languageId:"",height:"600px",width:"100%",options:{minimap:{enabled:!1},scrollBeyondLastLine:!1,readOnly:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,lineDecorationsWidth:0,overviewRulerBorder:!1},value:e}),Pi=async()=>{const e=await(0,u.cnO)({full:!0,perPage:100,sortOrder:"asc"});if(e.error)throw new Error(e.error.message);return e};var Li=a(10885);const _i=async()=>{var e;const t=await(0,u.OQl)({prerelease:!0});if(t.error)throw new Error(t.error.message);return null===(e=t.data)||void 0===e?void 0:e.items.filter((({status:e})=>"installed"===e))},Di=({name:e,setName:t,type:a,setNamesStatus:l})=>{const{data:n,status:i}=(0,x.useQuery)(["debug-saved-object-names",a],(()=>(async e=>{var t;const a=await(0,u.w$b)({method:"post",path:T.xw.getSavedObjectNamesPath(),body:{type:e},version:te.BoD.internal.v1});if(a.error)throw new Error(a.error.message);return null===(t=a.data)||void 0===t?void 0:t.aggregations.names.buckets})(a)),{refetchOnWindowFocus:!1});(0,s.useEffect)((()=>{l(i)}),[i,l]);const o=(null!=n?n:[]).map((e=>({label:e.key,value:e.key}))),r=o.find((t=>t.value===e)),d=r?[r]:[];return(0,R.jsx)(g.EuiComboBox,{prepend:"Name","aria-label":f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),placeholder:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),fullWidth:!0,options:o,singleSelection:{asPlainText:!0},selectedOptions:d,isLoading:"loading"===i,onChange:e=>{e.length?t(e[0].value):t(void 0)}})},Oi=async()=>{var e,t;const a=`${M.mm}.is_preconfigured:true`,s=await(0,u.cnO)({kuery:a,perPage:100,full:!0});if(s.error)throw new Error(s.error.message);return null!==(e=null===(t=s.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},Ri=async()=>{var e,t;const a=await(0,u.W1E)();if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},Bi=new x.QueryClient,Ni=[{title:f.i18n.translate("xpack.fleet.debug.HealthCheckStatus.title",{defaultMessage:"Health Check Status"}),id:"healthCheckStatus",component:(0,R.jsx)((()=>{var e;const[t,a]=(0,s.useState)(),{data:n}=(0,u.OVZ)(),i=(0,s.useMemo)((()=>{var e;return null!==(e=null==n?void 0:n.items)&&void 0!==e?e:[]}),[null==n?void 0:n.items]);(0,s.useEffect)((()=>{const e=i.find((e=>!0===e.is_default));e&&a(e)}),[i]);const o=(0,s.useMemo)((()=>(null==t?void 0:t.id)||""),[null==t?void 0:t.id]),[r,d]=(0,s.useState)(),[c,p]=(0,s.useState)(),{data:h}=(0,x.useQuery)(["fleetServerHealth",o],(()=>(0,u.RUT)({id:o})),{refetchInterval:1e4,enabled:!!o});(0,s.useEffect)((()=>{d(null==h?void 0:h.data),null!=h&&h.error&&p(h.error)}),[h]);const y=(0,s.useMemo)((()=>[...i.map((e=>({inputDisplay:`${e.name} (${e.host_urls[0]})`,value:e.id})))]),[i]);return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.description",defaultMessage:"Select the host used to enroll Fleet Server. The connection is refreshed every {interval}s.",values:{interval:10}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,R.jsx)(g.EuiSuperSelect,{fullWidth:!0,"data-test-subj":"fleetDebug.fleetServerHostsSelect","aria-label":f.i18n.translate("xpack.fleet.debug.healthCheckPanel.fleetServerHostsSelectAriaLabel",{defaultMessage:"Fleet Server hosts"}),prepend:(0,R.jsx)(g.EuiText,{size:"relative",color:""},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fleetServerHostsLabel",defaultMessage:"Fleet Server Hosts"})),onChange:e=>{d(void 0),a(i.find((t=>t.id===e)))},valueOfSelected:null==t?void 0:t.id,options:y})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},null!=r&&r.status&&o===(null==r?void 0:r.host_id)?(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.status",defaultMessage:"Status:"})),(0,R.jsx)(g.EuiFlexItem,null,(e=>{if(!e)return null;let t;switch(e){case"HEALTHY":t="success";break;case"UNHEALTHY":t="warning";break;default:t="subdued"}return(0,R.jsx)(g.EuiHealth,{color:t},e)})(null==r?void 0:r.status))):null)),c&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==c?void 0:c.message)&&void 0!==e?e:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fetchError",defaultMessage:"Message: {errorMessage}",values:{errorMessage:null==c?void 0:c.message}}))))}),null)},{title:f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.title",{defaultMessage:"Agent Policy Debugger"}),id:"agentPolicyDebugger",component:(0,R.jsx)((()=>{var e,t;const{getHref:a}=(0,u.iEg)(),[n,i]=(0,s.useState)(),{data:o,status:r}=(0,x.useQuery)(["debug-agent-policies"],Pi),d=null!==(e=null==o||null===(t=o.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[],c=d.map((e=>({label:`${e.name} - ${e.id}`,value:e.id}))),p=n?[c.find((e=>e.value===n))]:[],h=d.find((e=>e.id===n)),y=()=>{i(void 0),Bi.invalidateQueries(["debug-agent-policies"])};return"error"===r?(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.fetchError",defaultMessage:"Error fetching Agent Policies"})):(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.description",defaultMessage:"Search for an Agent Policy using its name or {codeId} value. Use the code block below to diagnose any potential issues with the policy's configuration.",values:{codeId:(0,R.jsx)(g.EuiCode,null,"id")}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),fullWidth:!0,options:c,singleSelection:{asPlainText:!0},selectedOptions:p,isLoading:"loading"===r,onChange:e=>{e.length?i(e[0].value):i(void 0)}})),n&&(0,R.jsx)(A.wq,{agentPolicy:h,hasFleetServer:(0,N.ob)(h)},(e=>(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"danger",onClick:()=>e(n,y)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyForm.deletePolicyActionText",defaultMessage:"Delete policy"}))))))),n&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiLink,{target:"_blank",href:a("policy_details",{policyId:n})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ci,{value:JSON.stringify(h,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.title",{defaultMessage:"Integration Debugger"}),id:"integrationDebugger",component:(0,R.jsx)((()=>{var e,t,a,n,i;const{http:o,notifications:r}=(0,u.WeA)(),{getHref:d}=(0,u.iEg)(),[c,p]=(0,s.useState)(),[h,y]=(0,s.useState)(!1),[E,v]=(0,s.useState)(!1),k=(0,x.useQuery)(["debug-integrations"],_i),j=(0,g.useGeneratedHtmlId)(),b=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)({pkgName:e.name,pkgVersion:e.version},{force:!0});if(t.error)throw r.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.error",{defaultMessage:"Error uninstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),v(!1),new Error(t.error.message);return r.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.success",{defaultMessage:"Successfully uninstalled {integrationTitle}",values:{integrationTitle:e.title}})),p(void 0),v(!1),Bi.invalidateQueries(["debug-integrations"]),t.data})),S=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)({pkgName:e.name,pkgVersion:e.version},{force:!0});if(t.error)throw r.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),y(!1),new Error(t.error.message);const a=await(0,u.Q8y)(e.name,e.version);if(a.error)throw r.toasts.addError(new Error(a.error.message),{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:a.error.message}),y(!1),new Error(a.error.message);return r.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.success",{defaultMessage:"Successfully reinstalled {integrationTitle}",values:{integrationTitle:e.title}})),p(void 0),y(!1),Bi.invalidateQueries(["debug-integrations"]),a.data}));if("error"===k.status)return(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.fetchError",defaultMessage:"Error fetching installed Integrations"}));const F=null!==(e=null===(t=k.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id,icon:(0,Li.d)(e,o.basePath)}))))&&void 0!==e?e:[],M=c?[F.find((e=>e.value===c))]:[],I=null===(a=k.data)||void 0===a?void 0:a.find((e=>e.id===c));return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.description",defaultMessage:"Use this tool to uninstall or reinstall installed integrations."})),(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallationDescription",defaultMessage:"Reinstalling an integration will uninstall and then immediately install it again. This can be useful in restoring broken or malformed integration installations when a user hasn't done much customization."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),placeholder:f.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),fullWidth:!0,options:F,singleSelection:{asPlainText:!0},selectedOptions:M,isDisabled:"loading"===k.status,prepend:M.length>0?(0,R.jsx)(g.EuiButtonEmpty,null,(0,R.jsx)(g.EuiIcon,{type:null!==(n=null===(i=M[0])||void 0===i?void 0:i.icon)&&void 0!==n?n:"fleetApp"})):void 0,renderOption:(e,t,a)=>(0,R.jsx)("span",{className:a},(0,R.jsx)(g.EuiIcon,{type:e.icon})," ",(0,R.jsx)(g.EuiHighlight,{search:t},e.label)),onChange:e=>{e.length?p(e[0].value):p(void 0)}})),I&&(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{color:"primary",onClick:()=>y(!0)},"Reinstall")),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{color:"danger",onClick:()=>v(!0)},"Uninstall")),h&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":j,title:`Reinstall ${I.title}`,titleProps:{id:j},onCancel:()=>y(!1),onConfirm:()=>S.mutate(I),isLoading:S.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelReinstall",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmReinstall",{defaultMessage:"Reinstall"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallModal",defaultMessage:"Are you sure you want to reinstall {integrationTitle}?",values:{integrationTitle:I.title}})),E&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":j,title:`Uninstall ${I.title}`,titleProps:{id:j},onCancel:()=>v(!1),onConfirm:()=>b.mutate(I),isLoading:b.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelUninstall",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmUninstall",{defaultMessage:"Uninstall"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.uninstallModal",defaultMessage:"Are you sure you want to uninstall {integrationTitle}?",values:{integrationTitle:I.title}})))),I&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiLink,{target:"_blank",href:d("integration_details_overview",{pkgkey:(0,N.Ku)({name:I.name,version:I.version})})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.viewIntegrationLink",defaultMessage:"View integration settings in Integrations UI"}))))}),null)},{title:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.title",{defaultMessage:"Saved Object Debugger"}),id:"savedObjectDebugger",component:(0,R.jsx)((()=>{const e=[{value:`${te.mm9}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.agentPolicyLabel",{defaultMessage:"Agent policy"})},{value:`${te.RNf}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packagePolicyLabel",{defaultMessage:"Integration policy"})},{value:`${te.Lmx}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.outputLabel",{defaultMessage:"Output"})},{value:`${te.fAG}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packageLabel",{defaultMessage:"Packages"})},{value:`${te.y_r}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.downloadSourceLabel",{defaultMessage:"Download Sources"})},{value:`${te.twQ}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.fleetServerHostLabel",{defaultMessage:"Fleet Server Hosts"})}],[t,a]=(0,s.useState)(e[0].value),[n,i]=(0,s.useState)(),[o,r]=(0,s.useState)(),{data:d,status:c}=(0,x.useQuery)(["debug-saved-objects",t,n],(()=>(async(e,t)=>{var a;if(!e||!t)return[];const s=await(0,u.w$b)({method:"post",path:T.xw.getSavedObjectsPath(),body:{type:e,name:t},version:te.BoD.internal.v1});if(s.error)throw new Error(s.error.message);return null===(a=s.data)||void 0===a?void 0:a.saved_objects})(t,n)));return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.description",defaultMessage:"Search for Fleet-related saved objects by selecting a type and name. Use the code block below to diagnose any potential issues."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 300px;\n          "},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiSelect,{prepend:"Type",id:"soType",options:e,value:t,onChange:e=>(e=>{a(e.target.value),i(void 0)})(e),"aria-label":f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectTypeLabel",{defaultMessage:"Select saved object type"})}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(Di,{name:n,setName:i,type:t,setNamesStatus:r})))),d&&("error"===c||"error"===o)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.fetchError",defaultMessage:"Error fetching Saved Objects"}))),(d||"loading"===c)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ci,{value:JSON.stringify(d,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.title",{defaultMessage:"Fleet Index Debugger"}),id:"fleetIndexDebugger",component:(0,R.jsx)((()=>{var e,t,a,n;const i=[{label:be.AGENTS_INDEX,value:be.AGENTS_INDEX},{label:be.AGENT_ACTIONS_INDEX,value:be.AGENT_ACTIONS_INDEX},{label:M.Al,value:M.Al}],[o,r]=(0,s.useState)(),{data:d,status:c}=(0,x.useQuery)(["debug-indices",o],(()=>(async e=>e?await(0,u.w$b)({method:"post",path:T.xw.getIndexPath(),body:{index:e},version:be.API_VERSIONS.internal.v1}):null)(o)),{retry:!1}),p=o?[i.find((e=>e.value===o))]:[];return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.description",defaultMessage:"Search for the contents of Fleet indices. Use the code block below to diagnose any potential issues. "}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiComboBox,{prepend:"Index","aria-label":f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),placeholder:f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),fullWidth:!0,options:i,singleSelection:{asPlainText:!0},selectedOptions:p,isLoading:"loading"===c,onChange:e=>{e.length?r(e[0].value):r(void 0)}})))),(null==d?void 0:d.error)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==d||null===(t=d.error)||void 0===t||null===(a=t.error)||void 0===a?void 0:a.reason)&&void 0!==e?e:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.fetchError",defaultMessage:"Error fetching index data"}))),d&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ci,{value:JSON.stringify(null===(n=d.data)||void 0===n?void 0:n.hits,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.title",{defaultMessage:"Preconfiguration Debugger"}),id:"preconfigurationDebugger",component:(0,R.jsx)((()=>{var e,t,a,n;const{getHref:i}=(0,u.iEg)(),{notifications:o}=(0,u.WeA)(),[r,d]=(0,s.useState)(),[c,p]=(0,s.useState)(!1),[h,y]=(0,s.useState)(!1),E=(0,x.useQuery)(["debug-preconfigured-policies"],Oi),v=null!==(e=null===(t=E.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],k=r?[v.find((({value:e})=>e===r))]:[],j=null===(a=E.data)||void 0===a?void 0:a.find((e=>e.id===r)),b=(0,x.useMutation)((async e=>{const t=await(0,u.W$e)(e);if(t.error)throw o.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetError",{defaultMessage:"Error resetting policy"}),toastMessage:t.error.message}),new Error(t.error.message);return o.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetSuccess",{defaultMessage:"Successfully reset policy"})),Bi.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),p(!1),t.data})),S=(0,x.useMutation)((async()=>{const e=await(0,u.Vg9)();if(e.error)throw o.toasts.addError(e.error,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllError",{defaultMessage:"Error resetting policies"}),toastMessage:e.error.message}),new Error(e.error.message);return o.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllSuccess",{defaultMessage:"Successfully reset policies"})),Bi.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),y(!1),e.data})),F=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.description",defaultMessage:"This tool can be used to reset preconfigured policies that are managed via {codeKibanaYml}. This includes Fleet's default policies that may exist in cloud environments.",values:{codeKibanaYml:(0,R.jsx)(g.EuiCode,null,"kibana.yml")}})),(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetInstructions",defaultMessage:'You may reset a single preconfigured policy or use the "Reset all" button to reset all preconfigured policies at once.'}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),fullWidth:!0,options:v,singleSelection:{asPlainText:!0},selectedOptions:k,onChange:e=>{e.length?d(e[0].value):d(void 0)}})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"warning",isDisabled:!r,onClick:()=>p(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetButton",defaultMessage:"Reset"})))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"danger",isDisabled:!(null!==(n=E.data)&&void 0!==n&&n.length),onClick:()=>y(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllButton",defaultMessage:"Reset all"}))))),c&&j&&r&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":F,title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalTitle",{defaultMessage:"Reset {policyName}",values:{policyName:j.name}}),titleProps:{id:F},onCancel:()=>p(!1),onConfirm:()=>b.mutate(r),isLoading:b.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalConfirm",{defaultMessage:"Reset"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetModalBody",defaultMessage:"Are you sure you want to reset {policyName}?",values:{policyName:j.name}})),h&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":F,title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalTitle",{defaultMessage:"Reset all preconfigured policies"}),titleProps:{id:F},onCancel:()=>y(!1),onConfirm:()=>S.mutate(),isLoading:S.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalConfirm",{defaultMessage:"Reset all"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllModalBody",defaultMessage:"Are you sure you want to reset all preconfigured policies?"})),r&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiLink,{target:"_blank",href:i("policy_details",{policyId:r})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ci,{value:JSON.stringify(j,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.title",{defaultMessage:"Orphaned Integration Policy Debugger"}),id:"orphanedIntegrationPolicyDebugger",component:(0,R.jsx)((()=>{var e;const{notifications:t}=(0,u.WeA)(),[a,n]=(0,s.useState)(),[i,o]=(0,s.useState)(!1),[r,d]=(0,s.useState)(!1),{data:c}=(0,x.useQuery)(["debug-orphaned-policies"],Ri),p=null!==(e=null==c?void 0:c.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],h=a?[p.find((({value:e})=>e===a))]:[],y=null==c?void 0:c.find((e=>e.id===a)),E=(0,x.useMutation)((async e=>{const a=await(0,u.Ot1)({packagePolicyIds:[e],force:!0});if(a.error)throw t.toasts.addError(a.error,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteError",{defaultMessage:"Error deleting policy"}),toastMessage:a.error.message}),new Error(a.error.message);return t.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteSuccess",{defaultMessage:"Successfully deleted orphaned policy"})),Bi.invalidateQueries(["debug-orphaned-policies"]),n(void 0),o(!1),a.data})),v=(0,x.useMutation)((async()=>{const e=await(0,u.Ot1)({packagePolicyIds:null==c?void 0:c.map((e=>e.id)),force:!0});if(e.error)throw t.toasts.addError(e.error,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllError",{defaultMessage:"Error deleting orphaned policies"}),toastMessage:e.error.message}),new Error(e.error.message);return t.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllSuccess",{defaultMessage:"Successfully deleted all orphaned policies"})),Bi.invalidateQueries(["debug-orphaned-policies"]),n(void 0),d(!1),e.data})),k=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.description",defaultMessage:'This tool can be used to delete "orphaned" integration policies that have been unlinked from their parent agent policy objects'})),(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteOptions",defaultMessage:'You may delete a single orphaned integration policy or use the "Delete all" button to delete all orphaned integration policies at once.'}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),fullWidth:!0,options:p,singleSelection:{asPlainText:!0},selectedOptions:h,onChange:e=>{e.length?n(e[0].value):n(void 0)}})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"warning",isDisabled:!a,onClick:()=>o(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteButton",defaultMessage:"Delete"})))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"danger",isDisabled:!(null!=c&&c.length),onClick:()=>d(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllButton",defaultMessage:"Delete all"}))))),i&&y&&a&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":k,title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalTitle",{defaultMessage:"Delete {policyName}",values:{policyName:y.name}}),titleProps:{id:k},onCancel:()=>o(!1),onConfirm:()=>E.mutate(a),isLoading:E.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDelete",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDelete",{defaultMessage:"Delete"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalBody",defaultMessage:"Are you sure you want to delete {policyName}?",values:{policyName:y.name}})),r&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":k,title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalTitle",{defaultMessage:"Delete all orphaned integration policies"}),titleProps:{id:k},onCancel:()=>d(!1),onConfirm:()=>v.mutate(),isLoading:v.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDeleteAll",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDeleteAll",{defaultMessage:"Delete all"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalBody",defaultMessage:"Are you sure you want to delete all orphaned integration policies?"})),a&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ci,{value:JSON.stringify(y,null,2)})))}),null)}],zi=({isInitialized:e,setupError:t})=>{const{chrome:a}=(0,u.WeA)(),{getHref:s}=(0,u.iEg)();return a.docTitle.change(["Debug","Fleet"]),(0,R.jsx)(x.QueryClientProvider,{client:Bi},(0,R.jsx)(g.EuiPage,{paddingSize:"xl"},(0,R.jsx)(g.EuiPageBody,{panelled:!0},(0,R.jsx)(g.EuiPageSection,null,(0,R.jsx)(g.EuiPageHeader,{pageTitle:f.i18n.translate("xpack.fleet.debug.pageTitle",{defaultMessage:"Fleet Debugging Dashboard"}),iconType:"wrench"}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{color:"danger",iconType:"warning",title:"Danger zone"},(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.description",defaultMessage:"This page provides an interface for directly managing Fleet's underlying data and diagnosing issues. Be aware that these debugging tools can be {strongDestructive} in nature and can result in {strongLossOfData}. Please proceed with caution.",values:{strongDestructive:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.destructive",defaultMessage:"destructive"})),strongLossOfData:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.lossOfData",defaultMessage:"loss of data"}))}}))),!e&&(null==t?void 0:t.message)&&(0,R.jsx)(l().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{color:"danger",iconType:"warning",title:"Setup error"},(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.initializationError.description",defaultMessage:"{message}. You can use this page to debug the error.",values:{message:null==t?void 0:t.message}}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiPageSection,null,Ni.map((({title:e,id:t,component:a})=>(0,R.jsx)("div",{key:t},(0,R.jsx)(g.EuiAccordion,{id:t,initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTitle,{size:"l"},(0,R.jsx)("h2",null,e))},(0,R.jsx)(g.EuiSpacer,{size:"m"}),a),(0,R.jsx)(g.EuiHorizontalRule,null)))),(0,R.jsx)(g.EuiTitle,{size:"l"},(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.usefulLinks.title",defaultMessage:"Useful links"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiListGroup,{listItems:[{label:f.i18n.translate("xpack.fleet.debug.usefulLinks.viewAgents",{defaultMessage:"View Agents in Fleet UI"}),href:s("agent_list"),iconType:"agentApp",target:"_blank"},{label:f.i18n.translate("xpack.fleet.debug.usefulLinks.troubleshootingGuide",{defaultMessage:"Troubleshooting Guide"}),href:"https://www.elastic.co/guide/en/fleet/current/fleet-troubleshooting.html",iconType:"popout",target:"_blank"}]})))),(0,R.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}))},Ui=new x.QueryClient({defaultOptions:{queries:{networkMode:"always"},mutations:{networkMode:"always"}}}),Hi=(0,s.memo)((({children:e})=>{(0,u.ifo)("base");const t=(0,u.WeA)(),{notifications:a}=t,n=(0,u.iO7)(),i=n.fleet.readEnrollmentTokens||n.fleet.readAgents||n.fleet.readAgentPolicies||n.fleet.readSettings,r=n.integrations.all,[d,c]=(0,s.useState)(!1),[g,p]=(0,s.useState)(),[x,h]=(0,s.useState)(!1),[y,E]=(0,s.useState)(null),v=!!(0,o.useRouteMatch)(M.X5.add_integration_to_policy),k=!!(0,o.useRouteMatch)(M.X5.debug);return(0,s.useEffect)((()=>{(async()=>{c(!1),p(void 0),h(!1),E(null);try{var e;c(!0);const n=await(0,u.nXS)();if(c(!1),null!==(e=n.data)&&void 0!==e&&e.success){try{var t,s;const e=await(0,u.i0)();e.error&&E(e.error),null!==(t=e.data)&&void 0!==t&&null!==(s=t.nonFatalErrors)&&void 0!==s&&s.length&&a.toasts.addError(e.data.nonFatalErrors[0],{title:f.i18n.translate("xpack.fleet.setup.uiPreconfigurationErrorTitle",{defaultMessage:"Configuration error"})}),i||p("MISSING_PRIVILEGES"),!r&&v&&p("MISSING_PRIVILEGES")}catch(e){E(e)}h(!0)}else{var l;p((null===(l=n.data)||void 0===l?void 0:l.error)||"REQUEST_ERROR")}}catch(e){p("REQUEST_ERROR")}})()}),[a.toasts,i,r,v]),d||g?(0,R.jsx)(S.x,{isAddIntegrationsPath:v},d?(0,R.jsx)(F.Rh,null):(0,R.jsx)(S.L,{callingApplication:"Fleet",error:g})):k?(0,R.jsx)(zi,{setupError:y,isInitialized:x}):!x||y?(0,R.jsx)(S.x,{isAddIntegrationsPath:v},y?(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.initializationErrorMessageTitle",defaultMessage:"Unable to initialize Fleet"}),error:y}):(0,R.jsx)(F.uq,null)):(0,R.jsx)(l().Fragment,null,e)})),Wi=(0,s.memo)((({children:e,startServices:t,config:a,history:s,kibanaVersion:l,extensions:n,routerHistory:i,fleetStatus:o})=>{const g=(0,c.A)(t.theme.theme$,t.theme.getTheme()).darkMode;return(0,R.jsx)(p.KibanaRenderContextProvider,(0,d.default)({},t,{theme:t.theme,modify:{breakpoint:{xxl:1600}}}),(0,R.jsx)(v.V,{coreStart:{application:t.application}},(0,R.jsx)(E.KibanaContextProvider,{services:{...t}},(0,R.jsx)(u.QOw.Provider,{value:a},(0,R.jsx)(u.g4O.Provider,{value:l},(0,R.jsx)(k.EuiThemeProvider,{darkMode:g},(0,R.jsx)(x.QueryClientProvider,{client:Ui},(0,R.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}),(0,R.jsx)(u.K8T.Provider,{value:n},(0,R.jsx)(u.aOH,{defaultFleetStatus:o},(0,R.jsx)(b.M,null,(0,R.jsx)(r.Router,{history:s},(0,R.jsx)(j.hn1,{startServices:t},(0,R.jsx)(u.iGT,null,e)))))))))))))})),Gi=(0,s.memo)((({setHeaderActionMenu:e,isReadOnly:t})=>{const a=(0,u.WeA)(),{euiTheme:s}=(0,g.useEuiTheme)(),n=l().useMemo((()=>(0,y.css)("color:",s.colors.textParagraph,";","")),[s]),{TopNavMenu:i}=a.navigation.ui,o=[];return t&&o.push({label:f.i18n.translate("xpack.fleet.appNavigation.readOnlyBtn",{defaultMessage:"Read-only"}),disableButton:!0,className:n,iconType:"glasses",tooltip:f.i18n.translate("xpack.fleet.appNavigation.readOnlyTooltip",{defaultMessage:"You can view most Fleet settings, but your current privileges don't allow you to perform all actions."}),run:()=>{}}),o.push({label:f.i18n.translate("xpack.fleet.appNavigation.giveFeedbackButton",{defaultMessage:"Give feedback"}),iconType:"popout",run:()=>window.open("https://ela.st/fleet-feedback")}),(0,R.jsx)(i,{appName:f.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"}),config:o,setMenuMountPoint:e})})),Ki=({children:e,setHeaderActionMenu:t,isReadOnly:a})=>(0,R.jsx)(l().Fragment,null,(0,R.jsx)(Gi,{setHeaderActionMenu:t,isReadOnly:a}),e),qi=(0,s.memo)((({setHeaderActionMenu:e})=>{var t;const a=(0,u.Wdf)(),s=(0,u.YI3)(),n=(0,u.iO7)();return(0,R.jsx)(l().Fragment,null,(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.agents,key:M.X5.agents},n.fleet.readAgents?(0,R.jsx)(Ki,{setHeaderActionMenu:e,isReadOnly:!n.fleet.allAgents},(0,R.jsx)(ls,null)):(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents Read"})))),(0,R.jsx)(r.Route,{path:M.X5.policies},n.fleet.readAgentPolicies?(0,R.jsx)(Ki,{setHeaderActionMenu:e,isReadOnly:!n.fleet.allAgentPolicies},(0,R.jsx)(he,null)):(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agent policies Read"})))),(0,R.jsx)(r.Route,{path:M.X5.enrollment_tokens},n.fleet.allAgents?(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(fl,null)):(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),(0,R.jsx)(r.Route,{path:M.X5.uninstall_tokens},n.fleet.allAgents?(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(wl,null)):(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),(0,R.jsx)(r.Route,{path:M.X5.data_streams},(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(ke,null))),(0,R.jsx)(r.Route,{path:M.X5.settings},n.fleet.readSettings?(0,R.jsx)(Ki,{setHeaderActionMenu:e,isReadOnly:!n.fleet.allSettings},(0,R.jsx)(Ai,null)):(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(Ki,{setHeaderActionMenu:e},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Settings Read"})))),(0,R.jsx)(r.Route,{path:M.X5.add_integration_to_policy},(0,R.jsx)(ul,null)),(0,R.jsx)(r.Route,{render:({location:e})=>{if(!(""===e.pathname&&e.hash.length>0)){const e=n.fleet.readAgents?M.X5.agents:n.fleet.readAgentPolicies?M.X5.policies:M.X5.settings;return(0,R.jsx)(o.Redirect,{to:e})}const t=e.hash.replace(/^#(\/fleet)?/,"");return(0,R.jsx)(o.Redirect,{to:{...e,pathname:t,hash:void 0}})}})),a.isEnrollmentFlyoutOpen&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.rt,{defaultMode:!s.isReady||null!==(t=s.missingRequirements)&&void 0!==t&&t.includes("fleet_server")?"standalone":"managed",isIntegrationFlow:!0,onClose:()=>a.closeEnrollmentFlyout()})),a.isFleetServerFlyoutOpen&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.Jh,{onClose:()=>a.closeFleetServerFlyout()})))})),Vi=({startServices:e,config:t,history:a,kibanaVersion:s,extensions:l,setHeaderActionMenu:n})=>(0,R.jsx)(Wi,{startServices:e,config:t,history:a,kibanaVersion:s,extensions:l},(0,R.jsx)(Hi,null,(0,R.jsx)(qi,{setHeaderActionMenu:n})));function $i(e,{element:t,history:a,setHeaderActionMenu:s},l,n,o){return i().render((0,R.jsx)(Vi,{startServices:e,config:l,history:a,kibanaVersion:n,extensions:o,setHeaderActionMenu:s}),t),()=>{i().unmountComponentAtNode(t)}}const Yi=e=>{e.chrome.docTitle.reset(),e.chrome.setBreadcrumbs([]),u.Fjq.stop()}}}]);