"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../../common/constants");
var _api_privileges = require("../../constants/api_privileges");
var _errors = require("../schema/errors");
var _cloud_connector = require("../../types/rest_spec/cloud_connector");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // POST /api/fleet/cloud_connectors
  router.versioned.post({
    path: _constants.CLOUD_CONNECTOR_API_ROUTES.CREATE_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [{
          anyRequired: [_api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.ALL]
        }]
      }
    },
    summary: 'Create cloud connector',
    options: {
      tags: ['oas-tag:Fleet cloud connectors'],
      availability: {
        since: '9.2.0',
        stability: 'experimental'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _cloud_connector.CreateCloudConnectorRequestSchema,
      response: {
        200: {
          body: () => _cloud_connector.CreateCloudConnectorResponseSchema,
          description: 'Indicates a successful call.'
        },
        400: {
          body: _errors.genericErrorResponse,
          description: 'Indicates a bad request call.'
        }
      }
    }
  }, _handlers.createCloudConnectorHandler);

  // GET /api/fleet/cloud_connectors
  router.versioned.get({
    path: _constants.CLOUD_CONNECTOR_API_ROUTES.LIST_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [{
          anyRequired: [_api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.READ, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.READ]
        }]
      }
    },
    summary: 'Get cloud connectors',
    options: {
      tags: ['oas-tag:Fleet cloud connectors'],
      availability: {
        since: '9.2.0',
        stability: 'experimental'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _cloud_connector.GetCloudConnectorsRequestSchema,
      response: {
        200: {
          body: () => _cloud_connector.GetCloudConnectorsResponseSchema,
          description: 'Indicates a successful call.'
        },
        400: {
          body: _errors.genericErrorResponse,
          description: 'Indicates a bad request call.'
        }
      }
    }
  }, _handlers.getCloudConnectorsHandler);

  // GET /api/fleet/cloud_connectors/{cloudConnectorId}
  router.versioned.get({
    path: _constants.CLOUD_CONNECTOR_API_ROUTES.INFO_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [{
          anyRequired: [_api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.READ, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.READ]
        }]
      }
    },
    summary: 'Get cloud connector',
    options: {
      tags: ['oas-tag:Fleet cloud connectors'],
      availability: {
        since: '9.2.0',
        stability: 'experimental'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _cloud_connector.GetCloudConnectorRequestSchema,
      response: {
        200: {
          body: () => _cloud_connector.GetCloudConnectorResponseSchema,
          description: 'Indicates a successful call.'
        },
        400: {
          body: _errors.genericErrorResponse,
          description: 'Indicates a bad request call.'
        }
      }
    }
  }, _handlers.getCloudConnectorHandler);

  // PUT /api/fleet/cloud_connectors/{cloudConnectorId}
  router.versioned.put({
    path: _constants.CLOUD_CONNECTOR_API_ROUTES.UPDATE_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [{
          anyRequired: [_api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.ALL]
        }]
      }
    },
    summary: 'Update cloud connector',
    options: {
      tags: ['oas-tag:Fleet cloud connectors'],
      availability: {
        since: '9.2.0',
        stability: 'experimental'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _cloud_connector.UpdateCloudConnectorRequestSchema,
      response: {
        200: {
          body: () => _cloud_connector.UpdateCloudConnectorResponseSchema,
          description: 'Indicates a successful call.'
        },
        400: {
          body: _errors.genericErrorResponse,
          description: 'Indicates a bad request call.'
        }
      }
    }
  }, _handlers.updateCloudConnectorHandler);

  // DELETE /api/fleet/cloud_connectors/{cloudConnectorId}
  router.versioned.delete({
    path: _constants.CLOUD_CONNECTOR_API_ROUTES.DELETE_PATTERN,
    security: {
      authz: {
        requiredPrivileges: [{
          anyRequired: [_api_privileges.FLEET_API_PRIVILEGES.AGENT_POLICIES.ALL, _api_privileges.FLEET_API_PRIVILEGES.INTEGRATIONS.ALL]
        }]
      }
    },
    summary: 'Delete cloud connector (supports force deletion)',
    options: {
      tags: ['oas-tag:Fleet cloud connectors'],
      availability: {
        since: '9.2.0',
        stability: 'experimental'
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _cloud_connector.DeleteCloudConnectorRequestSchema,
      response: {
        200: {
          body: () => _cloud_connector.DeleteCloudConnectorResponseSchema,
          description: 'Indicates a successful call.'
        },
        400: {
          body: _errors.genericErrorResponse,
          description: 'Indicates a bad request call.'
        }
      }
    }
  }, _handlers.deleteCloudConnectorHandler);
};
exports.registerRoutes = registerRoutes;