"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPackageUnverified = isPackageUnverified;
exports.isVerificationError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isPackageUnverified(pkg, packageVerificationKeyId) {
  if (!('installationInfo' in pkg) || !pkg.installationInfo) return false;
  const {
    verification_status: verificationStatus,
    verification_key_id: verificationKeyId
  } = pkg === null || pkg === void 0 ? void 0 : pkg.installationInfo;
  const isKeyOutdated = !!verificationKeyId && verificationKeyId !== packageVerificationKeyId;
  const isUnverified = verificationStatus === 'unverified' || verificationStatus === 'verified' && isKeyOutdated;
  return isUnverified;
}
const isVerificationError = err => {
  var _err$attributes;
  return err && 'attributes' in err && ((_err$attributes = err.attributes) === null || _err$attributes === void 0 ? void 0 : _err$attributes.type) === 'verification_failed';
};
exports.isVerificationError = isVerificationError;