"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendDeleteDownloadSource = sendDeleteDownloadSource;
exports.sendPostDownloadSource = sendPostDownloadSource;
exports.sendPutDownloadSource = sendPutDownloadSource;
exports.useDefaultDownloadSource = useDefaultDownloadSource;
exports.useGetDownloadSources = useGetDownloadSources;
var _services = require("../../services");
var _constants = require("../../../common/constants");
var _use_request = require("./use_request");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetDownloadSources() {
  return (0, _use_request.useRequest)({
    method: 'get',
    path: _services.downloadSourceRoutesService.getListPath(),
    version: _constants.API_VERSIONS.public.v1
  });
}
function useDefaultDownloadSource() {
  var _downloadSourcesReque;
  const downloadSourcesRequest = useGetDownloadSources();
  const downloadSource = (_downloadSourcesReque = downloadSourcesRequest.data) === null || _downloadSourcesReque === void 0 ? void 0 : _downloadSourcesReque.items.find(o => o.is_default);
  return {
    downloadSource,
    refresh: downloadSourcesRequest.resendRequest
  };
}
function sendPutDownloadSource(downloadSourceId, body) {
  return (0, _use_request.sendRequest)({
    method: 'put',
    path: _services.downloadSourceRoutesService.getUpdatePath(downloadSourceId),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}
function sendPostDownloadSource(body) {
  return (0, _use_request.sendRequest)({
    method: 'post',
    path: _services.downloadSourceRoutesService.getCreatePath(),
    version: _constants.API_VERSIONS.public.v1,
    body
  });
}
function sendDeleteDownloadSource(downloadSourceId) {
  return (0, _use_request.sendRequest)({
    method: 'delete',
    path: _services.downloadSourceRoutesService.getDeletePath(downloadSourceId),
    version: _constants.API_VERSIONS.public.v1
  });
}