"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardsCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/spaces-plugin/common");
var _eui = require("@elastic/eui");
var _models = require("../../../../../../../../common/types/models");
var _hooks = require("../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/dashboards_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardsCell = ({
  package: {
    title,
    installationInfo
  }
}) => {
  const {
    spaceId = _common.DEFAULT_SPACE_ID
  } = (0, _hooks.useFleetStatus)();
  const core = (0, _hooks.useStartServices)();
  const packageTagQueryClause = (0, _react.useMemo)(() => {
    const ast = _eui.Ast.create([]);
    return new _eui.Query(ast.addOrFieldValue('tag', title, true, 'eq')).text;
  }, [title]);
  const link = core.http.basePath.prepend(`/app/dashboards#/list?s=${packageTagQueryClause}`);
  const dashboardsCount = (0, _react.useMemo)(() => {
    if (!installationInfo) {
      return 0;
    }
    return getDashboardsCount(installationInfo, spaceId);
  }, [installationInfo, spaceId]);
  if (dashboardsCount === 0) {
    return '-';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "installedIntegrationsDashboardsLink",
    href: link,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, dashboardsCount);
};
exports.DashboardsCell = DashboardsCell;
const getDashboardsCount = (installation, spaceId) => {
  var _installation$additio;
  const assets = installation.installed_kibana_space_id === spaceId ? installation.installed_kibana : installation === null || installation === void 0 ? void 0 : (_installation$additio = installation.additional_spaces_installed_kibana) === null || _installation$additio === void 0 ? void 0 : _installation$additio[spaceId];
  if (!assets || assets.length === 0) {
    return 0;
  }
  return assets.filter(({
    type
  }) => type === _models.KibanaSavedObjectType.dashboard).length;
};