"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalDataTagsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_advanced_fields/custom_fields/global_data_tags_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function parseValue(value) {
  if (typeof value === 'number') {
    return value;
  }
  if (!value.match(/^[0-9]*$/)) {
    return value.trim();
  }
  const parsedValue = Number(value);
  return isNaN(parsedValue) ? value.trim() : parsedValue;
}
const GlobalDataTagsTable = ({
  updateAgentPolicy,
  globalDataTags,
  isDisabled
}) => {
  const {
    overlays
  } = (0, _hooks.useStartServices)();
  const [editTags, setEditTags] = (0, _react.useState)({});
  // isAdding indicates whether a new row is currently being added to the table.
  // When true, the table will display "Confirm" and "Cancel" actions for the new row
  // to allow the user to either confirm the addition or cancel it.
  const [isAdding, setIsAdding] = (0, _react.useState)(false);
  const [newTag, setNewTag] = (0, _react.useState)({
    name: '',
    value: ''
  });
  const [newTagErrors, setNewTagErrors] = (0, _react.useState)({
    name: '',
    value: ''
  });
  const [errors, setErrors] = (0, _react.useState)({});
  const handleAddField = () => {
    setIsAdding(true);
    setNewTag({
      name: '',
      value: ''
    });
  };
  const handleEditChange = (0, _react.useCallback)((e, index) => {
    const newTargetValue = e.target.value;
    const newTargetName = e.target.name;
    setEditTags(prevValue => {
      let tag = prevValue[index];
      if (!tag) {
        tag = {
          name: '',
          value: ''
        };
      }
      return {
        ...prevValue,
        [index]: {
          ...tag,
          [newTargetName]: newTargetValue
        }
      };
    });
    setErrors(prevErrors => ({
      ...prevErrors,
      [index]: {
        ...prevErrors[index],
        [newTargetName]: null
      }
    }));
  }, []);
  const handleNewTagChange = (0, _react.useCallback)(e => {
    setNewTag({
      ...newTag,
      [e.target.name]: e.target.value
    });
    setNewTagErrors({
      ...newTagErrors,
      [e.target.name]: null
    });
  }, [newTag, newTagErrors]);
  const validateTag = (0, _react.useCallback)((tag, index) => {
    const trimmedName = tag.name.trim();
    const trimmedValue = tag.value.toString().trim();
    let nameError = '';
    let valueError = '';
    if (!trimmedName) {
      nameError = 'Name cannot be empty';
    } else if (/\s/.test(trimmedName)) {
      nameError = 'Name cannot contain spaces';
    } else if (globalDataTags.some((t, i) => i !== index && t.name === trimmedName)) {
      nameError = 'Name must be unique';
    }
    if (!trimmedValue) {
      valueError = 'Value cannot be empty';
    }
    return {
      nameError,
      valueError,
      isValid: !nameError && !valueError
    };
  }, [globalDataTags]);
  const confirmNewTagChanges = (0, _react.useCallback)(() => {
    const {
      nameError,
      valueError,
      isValid
    } = validateTag(newTag);
    if (!isValid) {
      setNewTagErrors({
        name: nameError,
        value: valueError
      });
      return;
    }
    const updatedTags = [...globalDataTags, {
      ...newTag,
      name: newTag.name.trim(),
      value: parseValue(newTag.value)
    }];
    updateAgentPolicy({
      global_data_tags: updatedTags
    });
    setNewTag({
      name: '',
      value: ''
    });
    setIsAdding(false);
    setNewTagErrors({
      name: '',
      value: ''
    });
  }, [globalDataTags, newTag, updateAgentPolicy, validateTag]);
  const confirmEditChanges = (0, _react.useCallback)(index => {
    const tag = editTags[index];
    const {
      nameError,
      valueError,
      isValid
    } = validateTag(tag, index);
    if (!isValid) {
      setErrors(prevErrors => ({
        ...prevErrors,
        [index]: {
          name: nameError,
          value: valueError
        }
      }));
      return;
    }
    const updatedTags = globalDataTags.map((t, i) => i === index ? {
      ...tag,
      name: tag.name.trim(),
      value: parseValue(tag.value)
    } : t);
    updateAgentPolicy({
      global_data_tags: updatedTags
    });
    setEditTags(prevValue => {
      const newValue = {
        ...prevValue
      };
      delete newValue[index];
      return newValue;
    });
    setErrors(prevErrors => {
      const newErrors = {
        ...prevErrors
      };
      delete newErrors[index];
      return newErrors;
    });
  }, [globalDataTags, updateAgentPolicy, validateTag, editTags]);
  const handleStartEdit = (0, _react.useCallback)(index => {
    setEditTags(prevValue => ({
      ...prevValue,
      [index]: {
        ...globalDataTags[index]
      }
    }));
    setErrors(prevErrors => ({
      ...prevErrors,
      [index]: {
        name: null,
        value: null
      }
    }));
  }, [globalDataTags]);
  const cancelNewTagChanges = () => {
    setNewTag({
      name: '',
      value: ''
    });
    setIsAdding(false);
    setNewTagErrors({
      name: '',
      value: ''
    });
  };
  const cancelEditChanges = index => {
    setEditTags(prevValue => {
      const newValue = {
        ...prevValue
      };
      delete newValue[index];
      return newValue;
    });
    setErrors(prevErrors => {
      const newErrors = {
        ...prevErrors
      };
      delete newErrors[index];
      return newErrors;
    });
  };
  const deleteTag = (0, _react.useCallback)(async index => {
    var _globalDataTags$index;
    const res = await overlays.openConfirm(_i18n.i18n.translate('xpack.fleet.globalDataTagsTable.deleteModalText', {
      defaultMessage: 'Removing the field will affect the next sync. This action cannot be undone.'
    }), {
      title: _i18n.i18n.translate('xpack.fleet.globalDataTagsTable.deleteModalTitle', {
        defaultMessage: 'Remove the {tag} field?',
        values: {
          tag: (_globalDataTags$index = globalDataTags[index].name) !== null && _globalDataTags$index !== void 0 ? _globalDataTags$index : ''
        }
      }),
      buttonColor: 'danger',
      cancelButtonText: _i18n.i18n.translate('xpack.fleet.globalDataTagsTable.deleteModalCancelButtonText', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.fleet.globalDataTagsTable.deleteModalConfirmButtonText', {
        defaultMessage: 'Remove'
      })
    });
    if (!res) {
      return;
    }
    const updatedTags = globalDataTags.filter((_, i) => i !== index);
    setEditTags(prevValue => {
      const newValue = {
        ...prevValue
      };
      delete newValue[index];
      return newValue;
    });
    updateAgentPolicy({
      global_data_tags: updatedTags
    });
    setErrors(prevErrors => {
      const {
        [index]: removedError,
        ...remainingErrors
      } = prevErrors;
      return remainingErrors;
    });
  }, [globalDataTags, overlays, updateAgentPolicy]);
  const columns = (0, _react.useMemo)(() => [{
    valign: 'top',
    field: 'name',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.globalDataTagsTable.nameColumnName",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 11
      }
    }),
    render: (name, item) => {
      const index = globalDataTags.indexOf(item);
      const isEditing = !!editTags[index];
      const isAddingRow = isAdding && item === newTag;
      const error = isAddingRow ? newTagErrors : errors[index] || {};
      return isEditing || isAddingRow ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        isInvalid: !!error.name,
        error: error.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 283,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        placeholder: _i18n.i18n.translate('xpack.fleet.globalDataTagsTable.namePlaceholder', {
          defaultMessage: 'Name'
        }),
        "data-test-subj": "globalDataTagsNameInput",
        value: isEditing ? editTags[index].name : newTag.name,
        name: "name",
        onChange: e => isEditing ? handleEditChange(e, index) : handleNewTagChange(e),
        isInvalid: !!error.name,
        compressed: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 15
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 297,
          columnNumber: 13
        }
      }, name);
    }
  }, {
    valign: 'top',
    field: 'value',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.globalDataTagsTable.ValueColumnName",
      defaultMessage: "Value",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 11
      }
    }),
    render: (value, item) => {
      const index = globalDataTags.indexOf(item);
      const isEditing = !!editTags[index];
      const isAddingRow = isAdding && item === newTag;
      const error = isAddingRow ? newTagErrors : errors[index] || {};
      return isEditing || isAddingRow ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        isInvalid: !!error.value,
        error: error.value,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 316,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        placeholder: _i18n.i18n.translate('xpack.fleet.globalDataTagsTable.valuePlaceHolder', {
          defaultMessage: 'Value'
        }),
        "data-test-subj": "globalDataTagsValueInput",
        value: isEditing ? editTags[index].value : newTag.value,
        name: "value",
        onChange: e => isEditing ? handleEditChange(e, index) : handleNewTagChange(e),
        isInvalid: !!error.value,
        compressed: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 15
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 13
        }
      }, value);
    }
  }, {
    actions: [{
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.globalDataTagsTable.ActionsColumnName",
        defaultMessage: "Confirm/Edit",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 15
        }
      }),
      render: item => {
        const index = globalDataTags.indexOf(item);
        const isEditing = !!editTags[index];
        const isAddingRow = isAdding && item === newTag;
        return isEditing || isAddingRow ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 348,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 349,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          size: "xs",
          color: "primary",
          iconType: "checkInCircleFilled",
          onClick: isAdding ? confirmNewTagChanges : () => confirmEditChanges(index),
          "aria-label": "Confirm",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 350,
            columnNumber: 21
          }
        }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": "Edit",
          iconType: "pencil",
          color: "text",
          "data-test-subj": `globalDataTagEditField${index}Btn`,
          isDisabled: isDisabled,
          onClick: () => handleStartEdit(index),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 360,
            columnNumber: 17
          }
        });
      }
    }, {
      name: 'Cancel/Delete',
      render: item => {
        const index = globalDataTags.indexOf(item);
        const isEditing = !!editTags[index];
        const isAddingRow = isAdding && item === newTag;
        return isEditing || isAddingRow ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          alignItems: "center",
          gutterSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 379,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 380,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          size: "xs",
          color: "danger",
          iconType: "errorFilled",
          onClick: isAddingRow ? cancelNewTagChanges : () => cancelEditChanges(index),
          "aria-label": "Cancel",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 381,
            columnNumber: 21
          }
        }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": "Delete",
          iconType: "trash",
          color: "text",
          "data-test-subj": `globalDataTagDeleteField${index}Btn`,
          isDisabled: isDisabled,
          onClick: () => deleteTag(index),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 391,
            columnNumber: 17
          }
        });
      }
    }]
  }], [confirmEditChanges, confirmNewTagChanges, editTags, errors, globalDataTags, handleEditChange, handleNewTagChange, isAdding, newTag, newTagErrors, deleteTag, handleStartEdit, isDisabled]);
  const items = isAdding ? [...globalDataTags, newTag] : globalDataTags;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, globalDataTags.length === 0 && !isAdding ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "l",
    className: "eui-textCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.globalDataTagsTable.noFieldsMessage",
    defaultMessage: "This policy has no custom fields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 436,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    onClick: handleAddField,
    style: {
      marginTop: '16px'
    },
    disabled: isDisabled,
    "data-test-subj": "globalDataTagAddFieldBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.globalDataTagsTable.addFieldBtn",
    defaultMessage: "Add field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 446,
      columnNumber: 17
    }
  }))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    onClick: handleAddField,
    style: {
      marginTop: '16px'
    },
    isDisabled: isDisabled || isAdding,
    "data-test-subj": "globalDataTagAddAnotherFieldBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.globalDataTagsTable.addAnotherFieldBtn",
    defaultMessage: "Add another field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 17
    }
  }))))));
};
exports.GlobalDataTagsTable = GlobalDataTagsTable;