"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendActionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/cell-actions/constants");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/legend_action_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const hasFilterCellAction = actions => {
  return actions.some(({
    type
  }) => type === _constants.FILTER_CELL_ACTION_TYPE);
};
const LegendActionPopover = ({
  label,
  onFilter,
  legendCellValueActions = []
}) => {
  const [popoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [ref, onClose] = (0, _charts.useLegendAction)();
  const panels = (0, _react.useMemo)(() => {
    const defaultFilterActions = [{
      id: 'filterIn',
      displayName: _i18n.i18n.translate('expressionXY.legend.filterForValueButtonAriaLabel', {
        defaultMessage: 'Filter for'
      }),
      'data-test-subj': `legend-${label}-filterIn`,
      iconType: 'plusInCircle',
      execute: () => {
        setPopoverOpen(false);
        onFilter();
      }
    }, {
      id: 'filterOut',
      displayName: _i18n.i18n.translate('expressionXY.legend.filterOutValueButtonAriaLabel', {
        defaultMessage: 'Filter out'
      }),
      'data-test-subj': `legend-${label}-filterOut`,
      iconType: 'minusInCircle',
      execute: () => {
        setPopoverOpen(false);
        onFilter({
          negate: true
        });
      }
    }];
    const allActions = [...(!hasFilterCellAction(legendCellValueActions) ? defaultFilterActions : []), ...legendCellValueActions];
    const legendCellValueActionPanelItems = allActions.map(action => ({
      name: action.displayName,
      'data-test-subj': `legend-${label}-${action.id}`,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: action.iconType,
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 13
        }
      }),
      onClick: () => {
        action.execute();
        setPopoverOpen(false);
      }
    }));
    return [{
      id: 'main',
      title: label,
      items: legendCellValueActionPanelItems
    }];
  }, [label, legendCellValueActions, onFilter]);
  const Button = /*#__PURE__*/_react.default.createElement("div", {
    tabIndex: 0,
    ref: ref,
    role: "button",
    "aria-pressed": "false",
    css: {
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center',
      height: '100%',
      marginLeft: 4,
      marginRight: 4
    },
    "data-test-subj": `legend-${label}`,
    onKeyPress: () => setPopoverOpen(!popoverOpen),
    onClick: () => setPopoverOpen(!popoverOpen),
    "aria-label": _i18n.i18n.translate('expressionXY.legend.legendActionsAria', {
      defaultMessage: 'Legend actions'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "boxesVertical",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: Button,
    isOpen: popoverOpen,
    closePopover: () => {
      setPopoverOpen(false);
      onClose();
    },
    panelPaddingSize: "none",
    anchorPosition: "upLeft",
    title: _i18n.i18n.translate('expressionXY.legend.filterOptionsLegend', {
      defaultMessage: '{legendDataLabel}, filter options',
      values: {
        legendDataLabel: label
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: "main",
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }));
};
exports.LegendActionPopover = LegendActionPopover;