"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportDefinitionCol = ReportDefinitionCol;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_series_storage = require("../../hooks/use_series_storage");
var _report_definition_field = require("./report_definition_field");
var _text_report_definition_field = require("./text_report_definition_field");
var _kpi_over_time_config = require("../../configurations/synthetics/kpi_over_time_config");
var _synthetics = require("../../configurations/constants/field_names/synthetics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/series_editor/columns/report_definition_col.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ReportDefinitionCol({
  seriesId,
  series,
  seriesConfig
}) {
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const {
    reportDefinitions: selectedReportDefinitions = {},
    textReportDefinitions: selectedTextReportDefinitions = {}
  } = series;
  const {
    definitionFields,
    textDefinitionFields
  } = seriesConfig;
  const onChange = (field, value) => {
    if (!(value !== null && value !== void 0 && value[0])) {
      delete selectedReportDefinitions[field];
      setSeries(seriesId, {
        ...series,
        reportDefinitions: {
          ...selectedReportDefinitions
        }
      });
    } else {
      setSeries(seriesId, {
        ...series,
        reportDefinitions: {
          ...selectedReportDefinitions,
          [field]: value
        }
      });
    }
  };
  const onChangeTextDefinitionField = (field, value) => {
    if ((0, _lodash.isEmpty)(value)) {
      delete selectedTextReportDefinitions[field];
      setSeries(seriesId, {
        ...series,
        textReportDefinitions: {
          ...selectedTextReportDefinitions
        }
      });
    } else {
      setSeries(seriesId, {
        ...series,
        textReportDefinitions: {
          ...selectedTextReportDefinitions,
          [field]: value
        }
      });
    }
  };
  const hasFieldDataSelected = field => {
    var _series$reportDefinit;
    return !(0, _lodash.isEmpty)((_series$reportDefinit = series.reportDefinitions) === null || _series$reportDefinit === void 0 ? void 0 : _series$reportDefinit[field]);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, definitionFields.map(field => {
    var _selectedReportDefini;
    const fieldStr = typeof field === 'string' ? field : field.field;
    const singleSelection = typeof field !== 'string' && field.singleSelection;
    const nestedField = typeof field !== 'string' && field.nested;
    const filters = typeof field !== 'string' ? field.filters : undefined;
    const isNonStepMetric = !(0, _kpi_over_time_config.isStepLevelMetric)(series.selectedMetricField);
    const hideNestedStep = nestedField === _synthetics.SYNTHETICS_STEP_NAME && isNonStepMetric;
    if (hideNestedStep && nestedField && ((_selectedReportDefini = selectedReportDefinitions[nestedField]) === null || _selectedReportDefini === void 0 ? void 0 : _selectedReportDefini.length) > 0) {
      setSeries(seriesId, {
        ...series,
        reportDefinitions: {
          ...selectedReportDefinitions,
          [nestedField]: []
        }
      });
    }
    let nestedFieldElement;
    if (nestedField && hasFieldDataSelected(fieldStr) && !hideNestedStep) {
      nestedFieldElement = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: nestedField,
        grow: 1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_report_definition_field.ReportDefinitionField, {
        seriesId: seriesId,
        series: series,
        seriesConfig: seriesConfig,
        field: nestedField,
        onChange: onChange,
        keepHistory: false,
        singleSelection: singleSelection,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: fieldStr,
      grow: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_report_definition_field.ReportDefinitionField, {
      seriesId: seriesId,
      series: series,
      seriesConfig: seriesConfig,
      field: fieldStr,
      onChange: onChange,
      singleSelection: singleSelection,
      filters: filters,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    })), nestedFieldElement);
  }), textDefinitionFields === null || textDefinitionFields === void 0 ? void 0 : textDefinitionFields.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: field,
      grow: 1,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_text_report_definition_field.TextReportDefinitionField, {
      seriesId: seriesId,
      series: series,
      seriesConfig: seriesConfig,
      field: field,
      onChange: onChangeTextDefinitionField,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    }));
  }));
}