"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUrlSearch = void 0;
var _elasticsearch_fieldnames = require("../../configurations/constants/elasticsearch_fieldnames");
var _use_filter_values = require("../../series_editor/use_filter_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUrlSearch = ({
  series,
  query,
  seriesId,
  seriesConfig
}) => {
  const {
    values,
    loading
  } = (0, _use_filter_values.useFilterValues)({
    series,
    seriesId,
    field: _elasticsearch_fieldnames.TRANSACTION_URL,
    baseFilters: seriesConfig.baseFilters,
    label: seriesConfig.labels[_elasticsearch_fieldnames.TRANSACTION_URL]
  }, query);
  return {
    values,
    loading
  };
};
exports.useUrlSearch = useUrlSearch;