"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationList = void 0;
var _react = require("@emotion/react");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _react2 = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _eventAnnotationComponents = require("@kbn/event-annotation-components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/event_annotation_listing/public/components/group_editor_flyout/group_editor_controls/annotation_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnnotationList = ({
  annotations,
  selectAnnotation,
  update: updateAnnotations
}) => {
  const [newAnnotationId, setNewAnnotationId] = (0, _react2.useState)((0, _uuid.v4)());
  (0, _react2.useEffect)(() => {
    setNewAnnotationId((0, _uuid.v4)());
  }, [annotations.length]);
  const addAnnotationText = _i18n.i18n.translate('eventAnnotationListing.annotationList.add', {
    defaultMessage: 'Add annotation'
  });
  const addNewAnnotation = (0, _react2.useCallback)(sourceAnnotationId => {
    const source = sourceAnnotationId ? annotations.find(({
      id
    }) => id === sourceAnnotationId) : undefined;
    const newAnnotation = (0, _eventAnnotationCommon.createCopiedAnnotation)(newAnnotationId, new Date().toISOString(), source);
    if (!source) {
      selectAnnotation(newAnnotation);
    }
    updateAnnotations([...annotations, newAnnotation]);
  }, [annotations, newAnnotationId, selectAnnotation, updateAnnotations]);
  const reorderAnnotations = (0, _react2.useCallback)((sourceAnnotation, targetAnnotation) => {
    if (!sourceAnnotation || sourceAnnotation.id === targetAnnotation.id) {
      return annotations;
    }
    const newAnnotations = annotations.filter(c => c.id !== sourceAnnotation.id);
    const targetPosition = newAnnotations.findIndex(c => c.id === targetAnnotation.id);
    const targetIndex = annotations.indexOf(sourceAnnotation);
    const sourceIndex = annotations.indexOf(targetAnnotation);
    newAnnotations.splice(targetIndex < sourceIndex ? targetPosition + 1 : targetPosition, 0, sourceAnnotation);
    return updateAnnotations(newAnnotations);
  }, [annotations, updateAnnotations]);
  const [{
    dragging
  }] = (0, _domDragDrop.useDragDropContext)();
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        background-color: ${_uiTheme.euiThemeVars.euiColorLightestShade};
        padding: ${_uiTheme.euiThemeVars.euiSizeS};
        border-radius: ${_uiTheme.euiThemeVars.euiBorderRadius};
        overflow: visible;

        .domDragDrop-group {
          padding: ${_uiTheme.euiThemeVars.euiSizeXS} ${_uiTheme.euiThemeVars.euiSizeS};
          margin: -${_uiTheme.euiThemeVars.euiSizeS} -${_uiTheme.euiThemeVars.euiSizeS} 0 -${_uiTheme.euiThemeVars.euiSizeS};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_domDragDrop.ReorderProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, annotations.map((annotation, index) => /*#__PURE__*/_react2.default.createElement("div", {
    key: index,
    css: (0, _react.css)`
              position: relative; // this is to properly contain the absolutely-positioned drop target in Droppable
              & + div {
                margin-top: ${_uiTheme.euiThemeVars.euiSizeS};
              }
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_domDragDrop.Draggable, {
    dragType: "move",
    order: [index],
    key: annotation.id,
    value: {
      id: annotation.id,
      humanData: {
        label: annotation.label
      }
    },
    reorderableGroup: annotations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_domDragDrop.Droppable, {
    order: [index],
    key: annotation.id,
    value: {
      id: annotation.id,
      humanData: {
        label: annotation.label
      }
    },
    dropTypes: dragging && dragging.id !== annotation.id ? ['reorder'] : [],
    reorderableGroup: annotations,
    onDrop: source => {
      const sourceAnnotation = source ? annotations.find(({
        id
      }) => id === source.id) : undefined;
      reorderAnnotations(sourceAnnotation, annotation);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_visualizationUiComponents.DimensionButton, {
    groupLabel: _i18n.i18n.translate('eventAnnotationListing.groupEditor.addAnnotation', {
      defaultMessage: 'Annotations'
    }),
    onClick: () => selectAnnotation(annotation),
    onRemoveClick: () => updateAnnotations(annotations.filter(({
      id
    }) => id !== annotation.id)),
    accessorConfig: (0, _eventAnnotationComponents.getAnnotationAccessor)(annotation),
    label: annotation.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_visualizationUiComponents.DimensionTrigger, {
    label: annotation.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 19
    }
  }))))))), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          margin-top: ${_uiTheme.euiThemeVars.euiSizeXS};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_domDragDrop.Droppable, {
    order: [annotations.length],
    getCustomDropTarget: _domDragDrop.DropTargetSwapDuplicateCombine.getCustomDropTarget,
    getAdditionalClassesOnDroppable: _domDragDrop.DropTargetSwapDuplicateCombine.getAdditionalClassesOnDroppable,
    dropTypes: dragging ? ['duplicate_compatible'] : [],
    value: {
      id: 'addAnnotation',
      humanData: {
        label: addAnnotationText
      }
    },
    onDrop: ({
      id: sourceId
    }) => addNewAnnotation(sourceId),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_visualizationUiComponents.EmptyDimensionButton, {
    dataTestSubj: "addAnnotation",
    label: addAnnotationText,
    ariaLabel: addAnnotationText,
    onClick: () => addNewAnnotation(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }))));
};
exports.AnnotationList = AnnotationList;