"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dispatchStates = dispatchStates;
var _after_complete = require("./after_complete");
var _after_not = require("./after_not");
var _after_operator = require("./after_operator");
var _empty_expression = require("./empty_expression");
var _in_function = require("./in_function");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const handlers = {
  in_function: _in_function.suggestInFunction,
  after_operator: _after_operator.suggestAfterOperator,
  after_complete: _after_complete.suggestAfterComplete,
  after_not: _after_not.suggestAfterNot,
  empty_expression: _empty_expression.suggestForEmptyExpression
};
async function dispatchStates(context, position) {
  const handler = handlers[position];
  return handler(context);
}