"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../../complete_items");
var _sources = require("../../../definitions/utils/sources");
var _metadata = require("../../options/metadata");
var _recommended_queries = require("../../options/recommended_queries");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _shared = require("../../../definitions/utils/shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  const innerText = query.substring(0, cursorPosition);
  if ((0, _helpers.withinQuotes)(innerText)) {
    return [];
  }
  const suggestions = [];
  const indexes = (0, _sources.getSourcesFromCommands)([command], 'index');
  // Function to add suggestions based on canRemoveQuote
  const addSuggestionsBasedOnQuote = definitions => {
    suggestions.push(...definitions);
  };
  const metadataSuggestions = (0, _metadata.getMetadataSuggestions)(command, innerText);
  if (metadataSuggestions) {
    return metadataSuggestions;
  }
  const metadataOverlap = (0, _shared.getOverlapRange)(innerText, 'METADATA');

  // TS /
  if (indexes.length === 0) {
    const timeseriesIndices = context === null || context === void 0 ? void 0 : context.timeSeriesSources;
    if (!timeseriesIndices) {
      return [];
    }
    return (0, _sources.specialIndicesToSuggestions)(timeseriesIndices);
  }
  // TS something /
  else if (indexes.length > 0 && /\s$/.test(innerText) && !(0, _shared.isRestartingExpression)(innerText)) {
    var _context$editorExtens;
    suggestions.push(_metadata.metadataSuggestion);
    suggestions.push(_complete_items.commaCompleteItem);
    suggestions.push(_complete_items.pipeCompleteItem);
    suggestions.push(...(await (0, _recommended_queries.getRecommendedQueriesSuggestions)((_context$editorExtens = context === null || context === void 0 ? void 0 : context.editorExtensions) !== null && _context$editorExtens !== void 0 ? _context$editorExtens : {
      recommendedFields: [],
      recommendedQueries: []
    })));
  }
  // TS something MET/
  else if (indexes.length > 0 && /^TS\s+\S+\s+/i.test(innerText) && metadataOverlap) {
    suggestions.push(_metadata.metadataSuggestion);
  }
  // TS someth/
  // TS something/
  // TS something, /
  else if (indexes.length) {
    var _context$sources, _context$editorExtens2;
    const sources = (_context$sources = context === null || context === void 0 ? void 0 : context.sources) !== null && _context$sources !== void 0 ? _context$sources : [];
    const recommendedQuerySuggestions = await (0, _recommended_queries.getRecommendedQueriesSuggestions)((_context$editorExtens2 = context === null || context === void 0 ? void 0 : context.editorExtensions) !== null && _context$editorExtens2 !== void 0 ? _context$editorExtens2 : {
      recommendedFields: [],
      recommendedQueries: []
    });
    const additionalSuggestions = await (0, _sources.additionalSourcesSuggestions)(innerText, sources, indexes.map(({
      name
    }) => name), recommendedQuerySuggestions);
    addSuggestionsBasedOnQuote(additionalSuggestions);
  }
  return suggestions;
}