"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _i18n = require("@kbn/i18n");
var _utils = require("../../../definitions/utils");
var _is = require("../../../ast/is");
var _types = require("../../../definitions/types");
var _validation = require("../../../definitions/utils/validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validate = (command, ast, context, callbacks) => {
  const changePointCommand = command;
  const messages = [];

  // validate change point value column
  const valueArg = changePointCommand.args[0];
  if ((0, _is.isColumn)(valueArg)) {
    const columnName = valueArg.name;
    let valueColumnType;
    if (context !== null && context !== void 0 && context.columns.has(columnName)) {
      var _context$columns$get;
      valueColumnType = context === null || context === void 0 ? void 0 : (_context$columns$get = context.columns.get(columnName)) === null || _context$columns$get === void 0 ? void 0 : _context$columns$get.type;
    }
    if (valueColumnType && !(0, _types.isNumericType)(valueColumnType)) {
      messages.push(_utils.errors.changePointWrongFieldType(valueArg, valueColumnType));
    }
  }

  // validate ON column
  const defaultOnColumnName = '@timestamp';
  const onColumn = changePointCommand.args.find(arg => (0, _is.isOptionNode)(arg) && arg.name === 'on');
  const hasDefaultOnColumn = context === null || context === void 0 ? void 0 : context.columns.has(defaultOnColumnName);
  if (!onColumn && !hasDefaultOnColumn) {
    messages.push({
      location: changePointCommand.location,
      text: _i18n.i18n.translate('kbn-esql-ast.esql.validation.changePointOnFieldMissing', {
        defaultMessage: '[CHANGE_POINT] Default {defaultOnColumnName} column is missing',
        values: {
          defaultOnColumnName
        }
      }),
      type: 'error',
      code: 'changePointOnFieldMissing'
    });
  }
  messages.push(...(0, _validation.validateCommandArguments)(
  // exclude AS option from generic validation
  {
    ...changePointCommand,
    args: changePointCommand.args.filter(arg => !((0, _is.isOptionNode)(arg) && arg.name === 'as'))
  }, ast, context, callbacks));
  return messages;
};
exports.validate = validate;