"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateLatestTransform = generateLatestTransform;
var _get_elasticsearch_query_or_throw = require("../helpers/get_elasticsearch_query_or_throw");
var _generate_metric_aggregations = require("./generate_metric_aggregations");
var _constants_entities = require("../../../../common/constants_entities");
var _generate_component_id = require("../helpers/generate_component_id");
var _generate_metadata_aggregations = require("./generate_metadata_aggregations");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateLatestTransform(definition) {
  var _definition$latest$se, _definition$latest$se2, _definition$latest$se3, _definition$latest$se4, _definition$latest$se5, _definition$latest$se6, _definition$latest$se7;
  return generateTransformPutRequest({
    definition,
    filter: generateFilters(definition),
    transformId: (0, _generate_component_id.generateLatestTransformId)(definition),
    frequency: (_definition$latest$se = (_definition$latest$se2 = definition.latest.settings) === null || _definition$latest$se2 === void 0 ? void 0 : _definition$latest$se2.frequency) !== null && _definition$latest$se !== void 0 ? _definition$latest$se : _constants_entities.ENTITY_DEFAULT_LATEST_FREQUENCY,
    syncDelay: (_definition$latest$se3 = (_definition$latest$se4 = definition.latest.settings) === null || _definition$latest$se4 === void 0 ? void 0 : _definition$latest$se4.syncDelay) !== null && _definition$latest$se3 !== void 0 ? _definition$latest$se3 : _constants_entities.ENTITY_DEFAULT_LATEST_SYNC_DELAY,
    docsPerSecond: (_definition$latest$se5 = definition.latest.settings) === null || _definition$latest$se5 === void 0 ? void 0 : _definition$latest$se5.docsPerSecond,
    maxPageSearchSize: (_definition$latest$se6 = (_definition$latest$se7 = definition.latest.settings) === null || _definition$latest$se7 === void 0 ? void 0 : _definition$latest$se7.maxPageSearchSize) !== null && _definition$latest$se6 !== void 0 ? _definition$latest$se6 : _constants_entities.ENTITY_DEFAULT_MAX_PAGE_SEARCH_SIZE
  });
}
const generateTransformPutRequest = ({
  definition,
  filter,
  transformId,
  frequency,
  syncDelay,
  docsPerSecond,
  maxPageSearchSize
}) => {
  var _definition$latest$se8, _definition$latest$se9;
  return {
    transform_id: transformId,
    _meta: {
      definition_version: definition.version,
      managed: definition.managed
    },
    defer_validation: true,
    timeout: (_definition$latest$se8 = definition.latest.settings) === null || _definition$latest$se8 === void 0 ? void 0 : _definition$latest$se8.timeout,
    source: {
      index: definition.indexPatterns,
      query: filter
    },
    dest: {
      index: `${(0, _generate_component_id.generateLatestIndexName)({
        id: 'noop'
      })}`,
      pipeline: (0, _generate_component_id.generateLatestIngestPipelineId)(definition)
    },
    frequency,
    sync: {
      time: {
        field: ((_definition$latest$se9 = definition.latest.settings) === null || _definition$latest$se9 === void 0 ? void 0 : _definition$latest$se9.syncField) || definition.latest.timestampField,
        delay: syncDelay
      }
    },
    settings: {
      deduce_mappings: false,
      unattended: true,
      docs_per_second: docsPerSecond,
      max_page_search_size: maxPageSearchSize
    },
    pivot: {
      group_by: {
        ...definition.identityFields.reduce((acc, id) => ({
          ...acc,
          [`entity.identity.${id.field}`]: {
            terms: {
              field: id.field
            }
          }
        }), {})
      },
      aggs: {
        ...(0, _generate_metric_aggregations.generateLatestMetricAggregations)(definition),
        ...(0, _generate_metadata_aggregations.generateLatestMetadataAggregations)(definition),
        'entity.last_seen_timestamp': {
          max: {
            field: definition.latest.timestampField
          }
        }
      }
    }
  };
};
function generateFilters(definition) {
  const filter = {
    bool: {
      must: [],
      must_not: []
    }
  };
  if (definition.filter) {
    filter.bool.must.push((0, _get_elasticsearch_query_or_throw.getElasticsearchQueryOrThrow)(definition.filter));
  }
  definition.identityFields.forEach(({
    field
  }) => {
    filter.bool.must.push({
      exists: {
        field
      }
    });
    filter.bool.must_not.push({
      term: {
        [field]: ''
      } // identity field can't be empty
    });
  });
  filter.bool.must.push({
    range: {
      [definition.latest.timestampField]: {
        gte: `now-${definition.latest.lookbackPeriod}`
      }
    }
  });
  filter.bool.must_not.push({
    terms: {
      _tier: _constants.TRANSFORM_IGNORED_SLOW_TIERS
    }
  });
  return filter;
}