"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityDefinitionQuerySchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityDefinitionQuerySchema = exports.getEntityDefinitionQuerySchema = _zod.z.object({
  page: _zod.z.optional(_zod.z.coerce.number()),
  perPage: _zod.z.optional(_zod.z.coerce.number()),
  includeState: _zod.z.optional(_zodHelpers.BooleanFromString).default(false)
});