"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetSearchPlaygroundChrome = exports.SetSearchChrome = exports.SetEnterpriseSearchContentChrome = exports.SetEnterpriseSearchApplicationsChrome = exports.SetAnalyticsChrome = void 0;
var _react = require("react");
var _kea = require("kea");
var _constants = require("../../../../common/constants");
var _kibana = require("../kibana");
var _generate_breadcrumbs = require("./generate_breadcrumbs");
var _generate_title = require("./generate_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helpers for setting Kibana chrome (breadcrumbs, doc titles) on React view mount
 * @see https://github.com/elastic/kibana/blob/main/src/core/packages/chrome/browser-internal/src/chrome_service.tsx
 *
 * Example usage (don't forget to i18n.translate() page titles!):
 *
 * <SetAppSearchPageChrome trail={['Engines', 'Example Engine Name, 'Curations']} />
 * Breadcrumb output: Enterprise Search > App Search > Engines > Example Engine Name > Curations
 * Title output: Curations - Example Engine Name - Engines - App Search - Elastic
 *
 * <SetWorkplaceSearchChrome />
 * Breadcrumb output: Enterprise Search > Workplace Search
 * Title output: Workplace Search - Elastic
 */

const SetSearchChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.searchTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useSearchBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail.join('|')]);
  return null;
};
exports.SetSearchChrome = SetSearchChrome;
const SetAnalyticsChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.analyticsTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useAnalyticsBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetAnalyticsChrome = SetAnalyticsChrome;
const SetEnterpriseSearchContentChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.enterpriseSearchContentTitle)(title);
  const crumbs = (0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchContentBreadcrumbs)(crumbs);
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetEnterpriseSearchContentChrome = SetEnterpriseSearchContentChrome;
const SetSearchPlaygroundChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.generateTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchApplicationsBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)(trail));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};
exports.SetSearchPlaygroundChrome = SetSearchPlaygroundChrome;
const SetEnterpriseSearchApplicationsChrome = ({
  trail = []
}) => {
  const {
    setBreadcrumbs,
    setDocTitle
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const title = reverseArray(trail);
  const docTitle = (0, _generate_title.searchApplicationsTitle)(title);
  const breadcrumbs = (0, _generate_breadcrumbs.useEnterpriseSearchApplicationsBreadcrumbs)((0, _generate_breadcrumbs.useGenerateBreadcrumbs)([_constants.SEARCH_APPS_TITLE, ...trail]));
  (0, _react.useEffect)(() => {
    setBreadcrumbs(breadcrumbs);
    setDocTitle(docTitle);
  }, [trail]);
  return null;
};

// Small util - performantly reverses an array without mutating the original array
exports.SetEnterpriseSearchApplicationsChrome = SetEnterpriseSearchApplicationsChrome;
const reverseArray = array => array.slice().reverse();