"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlInferencePipelineProcessorsCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _kibana_logic = require("../../../../shared/kibana/kibana_logic");
var _licensing = require("../../../../shared/licensing");
var _index_name_logic = require("../index_name_logic");
var _inference_pipeline_card = require("./inference_pipeline_card");
var _add_ml_inference_button = require("./ml_inference/add_ml_inference_button");
var _text_expansion_callout = require("./ml_inference/text_expansion_callout/text_expansion_callout");
var _pipelines_logic = require("./pipelines_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference_pipeline_processors_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MlInferencePipelineProcessorsCard = () => {
  var _capabilities$ml$canG, _capabilities$ml, _inferencePipelines$m;
  const {
    capabilities,
    isCloud
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    mlInferencePipelineProcessors: inferencePipelines
  } = (0, _kea.useValues)(_pipelines_logic.PipelinesLogic);
  const {
    fetchMlInferenceProcessors,
    openAddMlInferencePipelineModal
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  (0, _react.useEffect)(() => {
    fetchMlInferenceProcessors({
      indexName
    });
  }, [indexName]);
  const hasMLPermissions = (_capabilities$ml$canG = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$ml = capabilities.ml) === null || _capabilities$ml === void 0 ? void 0 : _capabilities$ml.canGetTrainedModels) !== null && _capabilities$ml$canG !== void 0 ? _capabilities$ml$canG : false;
  const isGated = !isCloud && !hasPlatinumLicense;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, hasMLPermissions && !isGated && /*#__PURE__*/_react.default.createElement(_text_expansion_callout.TextExpansionCallOut, {
    isDismissable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 40
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_add_ml_inference_button.AddMLInferencePipelineButton, {
    onClick: () => openAddMlInferencePipelineModal(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })), (_inferencePipelines$m = inferencePipelines === null || inferencePipelines === void 0 ? void 0 : inferencePipelines.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `${index}-${item.pipelineName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_inference_pipeline_card.InferencePipelineCard, (0, _extends2.default)({}, item, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }))))) !== null && _inferencePipelines$m !== void 0 ? _inferencePipelines$m : null);
};
exports.MlInferencePipelineProcessorsCard = MlInferencePipelineProcessorsCard;