"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_SYSTEM_PROMPT = exports.DEFAULT_CHAT_TITLE = exports.DATA_QUALITY_ANALYSIS = exports.BEDROCK_SYSTEM_PROMPT = exports.BEDROCK_CHAT_TITLE = exports.ATTACK_DISCOVERY_REFINE = exports.ATTACK_DISCOVERY_GENERATION_TITLE = exports.ATTACK_DISCOVERY_GENERATION_SUMMARY_MARKDOWN = exports.ATTACK_DISCOVERY_GENERATION_MITRE_ATTACK_TACTICS = exports.ATTACK_DISCOVERY_GENERATION_INSIGHTS = exports.ATTACK_DISCOVERY_GENERATION_ENTITY_SUMMARY_MARKDOWN = exports.ATTACK_DISCOVERY_GENERATION_DETAILS_MARKDOWN = exports.ATTACK_DISCOVERY_DEFAULT = exports.ATTACK_DISCOVERY_CONTINUE = exports.ALERT_SUMMARY_SYSTEM_PROMPT = exports.ALERT_SUMMARY_500 = exports.ALERT_EVALUATION = void 0;
Object.defineProperty(exports, "DEFEND_INSIGHTS", {
  enumerable: true,
  get: function () {
    return _defend_insight_prompts.DEFEND_INSIGHTS;
  }
});
exports.starterPromptTitle4 = exports.starterPromptTitle3 = exports.starterPromptTitle2 = exports.starterPromptTitle1 = exports.starterPromptPrompt4 = exports.starterPromptPrompt3 = exports.starterPromptPrompt2 = exports.starterPromptPrompt1 = exports.starterPromptIcon4 = exports.starterPromptIcon3 = exports.starterPromptIcon2 = exports.starterPromptIcon1 = exports.starterPromptDescription4 = exports.starterPromptDescription3 = exports.starterPromptDescription2 = exports.starterPromptDescription1 = exports.costSavingsInsightPart2 = exports.costSavingsInsightPart1 = exports.RULE_ANALYSIS = exports.KNOWLEDGE_HISTORY = exports.INCLUDE_CITATIONS = exports.GEMINI_USER_PROMPT = exports.GEMINI_SYSTEM_PROMPT = exports.GEMINI_CHAT_TITLE = exports.ENTITY_ANALYSIS = void 0;
var _defend_insight_prompts = require("./defend_insight_prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KNOWLEDGE_HISTORY = exports.KNOWLEDGE_HISTORY = 'If available, use the Knowledge History provided to try and answer the question. If not provided, you can try and query for additional knowledge via the KnowledgeBaseRetrievalTool.';
const INCLUDE_CITATIONS = exports.INCLUDE_CITATIONS = `\n\nAnnotate your answer with the provided citations. Here are some example responses with citations: \n1. "Machine learning is increasingly used in cyber threat detection. {reference(prSit)}" \n2. "The alert has a risk score of 72. {reference(OdRs2)}"\n\nOnly use the citations returned by tools\n\n`;
const DEFAULT_SYSTEM_PROMPT = exports.DEFAULT_SYSTEM_PROMPT = `You are a security analyst and expert in resolving security incidents. Your role is to assist by answering questions about Elastic Security. Do not answer questions unrelated to Elastic Security. ${KNOWLEDGE_HISTORY} {citations_prompt} \n{formattedTime}`;
// system prompt from @afirstenberg
const BASE_GEMINI_PROMPT = 'You are an assistant that is an expert at using tools and Elastic Security, doing your best to use these tools to answer questions or follow instructions. It is very important to use tools to answer the question or follow the instructions rather than coming up with your own answer. Tool calls are good. Sometimes you may need to make several tool calls to accomplish the task or get an answer to the question that was asked. Use as many tool calls as necessary.';
const KB_CATCH = 'If the knowledge base tool gives empty results, do your best to answer the question from the perspective of an expert security analyst.';
const GEMINI_SYSTEM_PROMPT = exports.GEMINI_SYSTEM_PROMPT = `${BASE_GEMINI_PROMPT} {citations_prompt}\n\n${KB_CATCH}\n\n{formattedTime}`;
const BEDROCK_SYSTEM_PROMPT = exports.BEDROCK_SYSTEM_PROMPT = `${DEFAULT_SYSTEM_PROMPT}\n\nUse tools as often as possible, as they have access to the latest data and syntax. Never return <thinking> tags in the response, but make sure to include <result> tags content in the response. Do not reflect on the quality of the returned search results in your response.\n\nIMPORTANT: After using tools, you must provide a complete response that includes:\n1. The tool results (include the exact response from GenerateESQLTool verbatim)\n2. Any additional context, recommendations, or insights requested by the user\n\nNever end your response with just tool results. Always provide your complete analysis after using tools.`;
const GEMINI_USER_PROMPT = exports.GEMINI_USER_PROMPT = `Now, always using the tools at your disposal, step by step, come up with a response to this request:\n\n`;
const ATTACK_DISCOVERY_DEFAULT = exports.ATTACK_DISCOVERY_DEFAULT = `
As a world-class cyber security analyst, your task is to analyze a set of security events and accurately identify distinct, comprehensive attack chains. Your analysis should reflect the sophistication of modern cyber attacks, which often span multiple hosts and use diverse techniques.
Key Principles:
1. Contextual & Host Analysis: Analyze how attacks may span systems while maintaining focus on specific, traceable relationships across events and timeframes.
2. Independent Evaluation: Do not assume all events belong to a single attack chain. Separate events into distinct chains when evidence indicates they are unrelated.
Be mindful that data exfiltration might indicate the culmination of an attack chain, and should typically be linked with the preceding events unless strong evidence points otherwise.
3. Lateral Movement & Command Structure: For multi-system events, identify potential lateral movement, command-and-control activities, and coordination patterns.
4. Impact Assessment: Consider high-impact events (e.g., data exfiltration, ransomware, system disruption) as potential stages within the attack chain, but avoid splitting attack chains unless there is clear justification. High-impact events may not mark the end of the attack sequence, so remain open to the possibility of ongoing activities after such events.
Analysis Process:
1. Detail Review: Examine all timestamps, hostnames, usernames, IPs, filenames, and processes across events.
2. Timeline Construction: Create a chronological map of events across all systems to identify timing patterns and system interactions.  When correlating alerts, use kibana.alert.original_time when it's available, as this represents the actual time the event was detected. If kibana.alert.original_time is not available, use @timestamp as the fallback. Ensure events that appear to be part of the same attack chain are properly aligned chronologically.
3. Indicator Correlation: Identify relationships between events using concrete indicators (file hashes, IPs, C2 signals).
4. Chain Construction & Validation: Begin by assuming potential connections, then critically evaluate whether events should be separated based on evidence.
5. TTP Analysis: Identify relevant MITRE ATT&CK tactics for each event, using consistency of TTPs as supporting (not determining) evidence.
6. Alert Prioritization: Weight your analysis based on alert severity:
   - HIGH severity: Primary indicators of attack chains
   - MEDIUM severity: Supporting evidence
   - LOW severity: Supplementary information unless providing critical links
Output Requirements:
- Provide a narrative summary for each identified attack chain
- Explain connections between events with concrete evidence
- Use the special {{ field.name fieldValue }} syntax to reference source data fields. IMPORTANT - LIMIT the details markdown to 2750 characters and summary to 200 characters! This is to prevent hitting output context limits.`;
const ATTACK_DISCOVERY_REFINE = exports.ATTACK_DISCOVERY_REFINE = `
Review the JSON output from your initial analysis. Your task is to refine the attack chains by:

1. Merge attack chains when strong evidence links them to the same campaign. Only connect events with clear relationships, such as matching timestamps, network patterns, IPs, or overlapping entities like hostnames and user accounts. Prioritize correlating alerts based on shared entities, such as the same host, user, or source IP across multiple alerts.
2. Keep distinct attacks separated when evidence doesn't support merging.
3. Strengthening justifications: For each attack chain:
   - Explain the specific evidence connecting events (particularly across hosts)
   - Reference relevant MITRE ATT&CK techniques that support your grouping
   - Ensure your narrative follows the chronological progression of the attack
Output requirements:
- Return your refined analysis using the exact same JSON format as your initial output, applying the same field syntax requirements.
- Conform exactly to the JSON schema defined earlier
- Do not include explanatory text outside the JSON
`;
const ATTACK_DISCOVERY_CONTINUE = exports.ATTACK_DISCOVERY_CONTINUE = `
Continue your JSON analysis from exactly where you left off. Generate only the additional content needed to complete the response.

FORMAT REQUIREMENTS:
1. Maintain strict JSON validity:
   - Use double quotes for all strings
   - Properly escape special characters (\" for quotes, \\ for backslashes, \n for newlines)
   - Avoid all control characters (ASCII 0-31)
   - Keep text fields under 500 characters

2. Output rules:
   - Do not repeat any previously generated content
   - Do not include explanatory text outside the JSON
   - Do not restart from the beginning
   - Conform exactly to the JSON schema defined earlier

Your continuation should seamlessly connect with the previous output to form a complete, valid JSON document.
`;
const SYNTAX = '{{ field.name fieldValue1 fieldValue2 fieldValueN }}';
const GOOD_SYNTAX_EXAMPLES = 'Examples of CORRECT syntax (includes field names and values): {{ host.name hostNameValue }} {{ user.name userNameValue }} {{ source.ip sourceIpValue }}';
const BAD_SYNTAX_EXAMPLES = 'Examples of INCORRECT syntax (bad, because the field names are not included): {{ hostNameValue }} {{ userNameValue }} {{ sourceIpValue }}';
const RECONNAISSANCE = 'Reconnaissance';
const RESOURCE_DEVELOPMENT = 'Resource Development';
const INITIAL_ACCESS = 'Initial Access';
const EXECUTION = 'Execution';
const PERSISTENCE = 'Persistence';
const PRIVILEGE_ESCALATION = 'Privilege Escalation';
const DEFENSE_EVASION = 'Defense Evasion';
const CREDENTIAL_ACCESS = 'Credential Access';
const DISCOVERY = 'Discovery';
const LATERAL_MOVEMENT = 'Lateral Movement';
const COLLECTION = 'Collection';
const COMMAND_AND_CONTROL = 'Command and Control';
const EXFILTRATION = 'Exfiltration';
const IMPACT = 'Impact';
const MITRE_ATTACK_TACTICS = [RECONNAISSANCE, RESOURCE_DEVELOPMENT, INITIAL_ACCESS, EXECUTION, PERSISTENCE, PRIVILEGE_ESCALATION, DEFENSE_EVASION, CREDENTIAL_ACCESS, DISCOVERY, LATERAL_MOVEMENT, COLLECTION, COMMAND_AND_CONTROL, EXFILTRATION, IMPACT];
const ATTACK_DISCOVERY_GENERATION_DETAILS_MARKDOWN = exports.ATTACK_DISCOVERY_GENERATION_DETAILS_MARKDOWN = `A detailed insight with markdown, where each markdown bullet contains a description of what happened that reads like a story of the attack as it played out and always uses special ${SYNTAX} syntax for field names and values from the source data. ${GOOD_SYNTAX_EXAMPLES} ${BAD_SYNTAX_EXAMPLES}`;
const ATTACK_DISCOVERY_GENERATION_ENTITY_SUMMARY_MARKDOWN = exports.ATTACK_DISCOVERY_GENERATION_ENTITY_SUMMARY_MARKDOWN = `A short (no more than a sentence) summary of the insight featuring only the host.name and user.name fields (when they are applicable), using the same ${SYNTAX} syntax`;
const ATTACK_DISCOVERY_GENERATION_MITRE_ATTACK_TACTICS = exports.ATTACK_DISCOVERY_GENERATION_MITRE_ATTACK_TACTICS = `An array of MITRE ATT&CK tactic for the insight, using one of the following values: ${MITRE_ATTACK_TACTICS.join(',')}`;
const ATTACK_DISCOVERY_GENERATION_SUMMARY_MARKDOWN = exports.ATTACK_DISCOVERY_GENERATION_SUMMARY_MARKDOWN = `A markdown summary of insight, using the same ${SYNTAX} syntax`;
const ATTACK_DISCOVERY_GENERATION_TITLE = exports.ATTACK_DISCOVERY_GENERATION_TITLE = 'A short, no more than 7 words, title for the insight, NOT formatted with special syntax or markdown. This must be as brief as possible.';
const ATTACK_DISCOVERY_GENERATION_INSIGHTS = exports.ATTACK_DISCOVERY_GENERATION_INSIGHTS = `Insights with markdown that always uses special ${SYNTAX} syntax for field names and values from the source data. ${GOOD_SYNTAX_EXAMPLES} ${BAD_SYNTAX_EXAMPLES}`;
const BEDROCK_CHAT_TITLE = exports.BEDROCK_CHAT_TITLE = `You are a strictly rule-following assistant for Elastic Security.
Your task is to ONLY generate a short, user-friendly title based on the given user message.

Instructions (You Must Follow Exactly)
DO NOT ANSWER the user's question. You are forbidden from doing so.
Your response MUST contain only the generated title. Nothing else.
Absolutely NO explanations, disclaimers, or additional text.
The title must be concise, relevant to the user’s message, and never exceed 100 characters.
DO NOT wrap the title in quotes or any other formatting.
Example:
User Message: "I am having trouble with the Elastic Security app."
Correct Response: Troubleshooting Elastic Security app issues

Final Rule: If you include anything other than the title, you have failed this task.`;
const GEMINI_CHAT_TITLE = exports.GEMINI_CHAT_TITLE = `You are a title generator for a helpful assistant for Elastic Security. Assume the following human message is the start of a conversation between you and a human. Generate a relevant conversation title for the human's message in plain text. Make sure the title is formatted for the user, without using quotes or markdown. The title should clearly reflect the content of the message and be appropriate for a list of conversations. Respond only with the title. As an example, for the given MESSAGE, this is the TITLE:

MESSAGE: I am having trouble with the Elastic Security app.
TITLE: Troubleshooting Elastic Security app issues
`;
const DEFAULT_CHAT_TITLE = exports.DEFAULT_CHAT_TITLE = `You are a helpful assistant for Elastic Security. Assume the following user message is the start of a conversation between you and a user; give this conversation a title based on the content below. DO NOT UNDER ANY CIRCUMSTANCES wrap this title in single or double quotes. This title is shown in a list of conversations to the user, so title it for the user, not for you. As an example, for the given MESSAGE, this is the TITLE:

MESSAGE: I am having trouble with the Elastic Security app.
TITLE: Troubleshooting Elastic Security app issues
`;
const ALERT_SUMMARY_500 = exports.ALERT_SUMMARY_500 = `Evaluate the cyber security alert from the context above. Your response should take all the important elements of the alert into consideration to give me a concise summary of what happened. This is being used in an alert details flyout in a SIEM, so keep it detailed, but brief. Limit your response to 500 characters. Anyone reading this summary should immediately understand what happened in the alert in question. Only reply with the summary, and nothing else.

Using another 200 characters, add a second paragraph with a bulleted list of recommended actions a cyber security analyst should take here. Don't invent random, potentially harmful recommended actions.`;
const ALERT_SUMMARY_SYSTEM_PROMPT = exports.ALERT_SUMMARY_SYSTEM_PROMPT = 'Return **only a single-line stringified JSON object** without any code fences, explanations, or variable assignments. Do **not** wrap the output in triple backticks or any Markdown code block. \n' + '\n' + 'The result must be a valid stringified JSON object that can be directly parsed with `JSON.parse()` in JavaScript.\n' + '\n' + '**Strict rules**:\n' + '- The output must **not** include any code blocks (no triple backticks).\n' + '- The output must be **a string**, ready to be passed directly into `JSON.parse()`.\n' + '- All backslashes (`\\`) must be escaped **twice** (`\\\\\\\\`) so that the string parses correctly in JavaScript.\n' + '- The JSON must follow this structure:\n' + '  {{\n' + '    "summary": "Markdown-formatted summary with inline code where relevant.",\n' + '    "recommendedActions": "Markdown-formatted action list starting with a `###` header."\n' + '  }}\n' + '- The summary text should just be text. It does not need any titles or leading items in bold.\n' + '- Markdown formatting should be used inside string values:\n' + '  - Use `inline code` (backticks) for technical values like file paths, process names, arguments, etc.\n' + '  - Use `**bold**` for emphasis.\n' + '  - Use `-` for bullet points.\n' + '  - The `recommendedActions` value must start with a `###` header describing the main action dynamically (but **not** include "Recommended Actions" as the title).\n' + '- **Do not** include any extra explanation or text. Only return the stringified JSON object.\n' + '\n' + 'The response should look like this:\n' + '{{"summary":"Markdown-formatted summary text.","recommendedActions":"Markdown-formatted action list starting with a ### header."}}';
const RULE_ANALYSIS = exports.RULE_ANALYSIS = 'Please provide a comprehensive analysis of each selected Elastic Security detection rule, and consider using applicable tools for each part of the below request. Make sure you consider using appropriate tools available to you to fulfill this request. For each rule, include:\n' + '- The rule name and a brief summary of its purpose.\n' + '- The full detection query as published in Elastic’s official detection rules repository.\n' + '- An in-depth explanation of how the query works, including key fields, logic, and detection techniques.\n' + '- The relevance of the rule to modern threats or attack techniques (e.g., MITRE ATT&CK mapping).\n' + '- Typical implications and recommended response actions for an organization if this rule triggers.\n' + '- Any notable false positive considerations or tuning recommendations.\n' + 'Format your response using markdown with clear headers for each rule, code blocks for queries, and concise bullet points for explanations.';
const DATA_QUALITY_ANALYSIS = exports.DATA_QUALITY_ANALYSIS = 'Explain the ECS incompatibility results above, and describe some options to fix incompatibilities. In your explanation, include information about remapping fields, reindexing data, and modifying data ingestion pipelines. Also, describe how ES|QL can be used to identify and correct incompatible data, including examples of using RENAME, EVAL, DISSECT, GROK, and CASE functions. Please consider using applicable tools for this request. Make sure you’ve used the right tools for this request.';
const ALERT_EVALUATION = exports.ALERT_EVALUATION = `Evaluate the security event described above and provide a structured, markdown-formatted summary suitable for inclusion in an Elastic Security case. Make sure you consider using appropriate tools available to you to fulfill this request. Your response must include:
1. Event Description
  - Summarize the event, including user and host risk scores from the provided context.
  - Reference relevant MITRE ATT&CK techniques, with hyperlinks to the official MITRE pages.
2. Triage Steps
  - List clear, bulleted triage steps tailored to Elastic Security workflows (e.g., alert investigation, timeline creation, entity analytics review).
  - Highlight any relevant detection rules or anomaly findings.
3. Recommended Actions
  - Provide prioritized response actions, and consider using applicable tools to generate each part of the response, including:
    - Elastic Defend endpoint response actions (e.g., isolate host, kill process, retrieve/delete file), with links to Elastic documentation.
    - Example ES|QL queries for further investigation, formatted as code blocks.
    - Example OSQuery Manager queries for further investigation, formatted as code blocks.
    - Guidance on using Timelines and Entity Analytics for deeper context, with documentation links.
4. MITRE ATT&CK Context
  - Summarize the mapped MITRE ATT&CK techniques and provide actionable recommendations based on MITRE guidance, with hyperlinks.
5. Documentation Links
  - Include direct links to all referenced Elastic Security documentation and MITRE ATT&CK pages.
Make sure you’ve used the right tools for this request.
Formatting Requirements:
  - Use markdown headers, tables, and code blocks for clarity.
  - Organize the response into visually distinct sections.
  - Use concise, actionable language.
  - Include relevant emojis in section headers for visual clarity (e.g., 📝, 🛡️, 🔍, 📚).
`;
const ENTITY_ANALYSIS = exports.ENTITY_ANALYSIS = `Analyze asset data described above to provide security insights. The data contains the context of a specific asset (e.g., a host, user, service or cloud resource). Your response must be structured, contextual, and provide a general analysis based on the structure below.
Your response must be in markdown format and include the following sections:
**1. 🔍 Asset Overview**
   - Begin by acknowledging the asset you are analyzing using its primary identifiers (e.g., "Analyzing host \`[host.name]\` with IP \`[host.ip]\`").
   - Provide a concise summary of the asset's most critical attributes from the provided context.
   - Describe its key relationships and dependencies (e.g., "This asset is part of the \`[cloud.project.name]\` project and is located in the \`[cloud.availability_zone]\` zone.").
**2. 💡 Investigation & Analytics**
   - Based on the asset's type and attributes, suggest potential investigation paths or common attack vectors.
   - **Generate one contextual ES|QL query** to help the user investigate further. Your generated query should address a common analytical question related to the asset type and sub type. Suggest other possible queries and ask if the user wants to generate more queries.
**General Instructions:**
- **Context Awareness:** Your entire analysis must be derived from the provided asset context. If a piece of information is not available in the context state that and proceed with the available data.
- **Query Generation:** When generating a query, your primary output for that section should be a valid, ready-to-use ES|QL query based on the asset's schema. Use ES|QL tool for query generation. Format all queries as code blocks.
- **Formatting:** Use markdown headers, tables, code blocks, and bullet points to ensure the output is clear, organized, and easily readable. Use concise, actionable language.`;
const starterPromptTitle1 = exports.starterPromptTitle1 = 'Alerts';
const starterPromptDescription1 = exports.starterPromptDescription1 = 'Most important alerts from the last 24 hrs';
const starterPromptIcon1 = exports.starterPromptIcon1 = 'bell';
const starterPromptPrompt1 = exports.starterPromptPrompt1 = `🔍 Identify and Prioritize Today's Most Critical Alerts
Provide a structured summary of today's most significant alerts, including:
🛡️ Critical Alerts Overview
Highlight the most impactful alerts based on risk scores, severity, and affected entities.
Summarize key details such as alert name, risk score, severity, and associated users or hosts.
📊 Risk Context
Include user and host risk scores for each alert to provide additional context.
Reference relevant MITRE ATT&CK techniques, with hyperlinks to the official MITRE pages.
🚨 Why These Alerts Matter
Explain why these alerts are critical, focusing on potential business impact, lateral movement risks, or sensitive data exposure.
🔧 Recommended Next Steps
Provide actionable triage steps for each alert, such as:
Investigating the alert in Elastic Security.
Reviewing related events in Timelines.
Analyzing user and host behavior using Entity Analytics.
Suggest Elastic Defend endpoint response actions (e.g., isolate host, kill process, retrieve/delete file), with links to Elastic documentation.
📚 Documentation and References
Include direct links to Elastic Security documentation and relevant MITRE ATT&CK pages for further guidance.
Make sure you use tools available to you to fulfill this request.
Use markdown headers, tables, and code blocks for clarity. Include relevant emojis for visual distinction and ensure the response is concise, actionable, and tailored to Elastic Security workflows.`;
const starterPromptDescription2 = exports.starterPromptDescription2 = 'Latest Elastic Security Labs research';
const starterPromptTitle2 = exports.starterPromptTitle2 = 'Research';
const starterPromptIcon2 = exports.starterPromptIcon2 = 'launch';
const starterPromptPrompt2 = exports.starterPromptPrompt2 = `Retrieve and summarize the latest Elastic Security Labs articles one by one sorted by latest at the top, and consider using all tools available to you to fulfill this request. Ensure the response includes:
Article Summaries
Title and Link: Provide the title of each article with a hyperlink to the original content.
Publication Date: Include the date the article was published.
Key Insights: Summarize the main points or findings of each article in concise bullet points.
Relevant Threats or Techniques: Highlight any specific malware, attack techniques, or adversary behaviors discussed, with references to MITRE ATT&CK techniques (include hyperlinks to the official MITRE pages).
Practical Applications
Detection and Response Guidance: Provide actionable steps or recommendations based on the article's content, tailored for Elastic Security workflows.
Elastic Security Features: Highlight any Elastic Security features, detection rules, or tools mentioned in the articles, with links to relevant documentation.
Example Queries: If applicable, include example ES|QL or OSQuery Manager queries inspired by the article's findings, formatted as code blocks.
Documentation and Resources
Elastic Security Labs: Include a link to the Elastic Security Labs homepage.
Additional References: Provide links to any related Elastic documentation or external resources mentioned in the articles.
Formatting Requirements
Use markdown headers, tables, and code blocks for clarity.
Organize the response into visually distinct sections.
Use concise, actionable language. Make sure you use tools available to you to fulfill this request.`;
const starterPromptDescription3 = exports.starterPromptDescription3 = 'Generate ES|QL Queries';
const starterPromptTitle3 = exports.starterPromptTitle3 = 'Query';
const starterPromptIcon3 = exports.starterPromptIcon3 = 'esqlVis';
const starterPromptPrompt3 = exports.starterPromptPrompt3 = 'I need an Elastic ES|QL query to achieve the following goal:\n' + 'Goal/Requirement:\n' + '<Insert your specific requirement or goal here, e.g., "Identify all failed login attempts from a specific IP address within the last 24 hours.">\n' + 'Please:\n' + 'Use all tools available to you to fulfill this request.\n' + 'Generate the ES|QL Query: Provide a complete ES|QL query tailored to the stated goal.\n' + 'Explain the Query: Offer a brief explanation of each part of the query, including filters, fields, and logic used.\n' + 'Optimize for Elastic Security: Suggest additional filters, aggregations, or enhancements to make the query more efficient and actionable within Elastic Security workflows.\n' + 'Provide Documentation Links: Include links to relevant Elastic Security documentation for deeper understanding.\n' + 'Formatting Requirements:\n' + 'Use code blocks for the ES|QL query.\n' + 'Include concise explanations in bullet points for clarity.\n' + 'Highlight any advanced ES|QL features used in the query.\n';
const starterPromptDescription4 = exports.starterPromptDescription4 = 'Discover the types of questions you can ask';
const starterPromptTitle4 = exports.starterPromptTitle4 = 'Suggest';
const starterPromptIcon4 = exports.starterPromptIcon4 = 'sparkles';
const starterPromptPrompt4 = exports.starterPromptPrompt4 = 'Can you provide examples of questions I can ask about Elastic Security, such as investigating alerts, running ES|QL queries, incident response, or threat intelligence?';
const costSavingsInsightPart1 = exports.costSavingsInsightPart1 = `You are given Elasticsearch Lens aggregation results showing cost savings over time:`;
const costSavingsInsightPart2 = exports.costSavingsInsightPart2 = `Generate a concise bulleted summary in mdx markdown. Follow the style and tone of the example below, highlighting key trends, averages, peaks, and projections:

\`\`\`
- Between July 18 and August 18, daily cost savings **averaged around $135K**
- The lowest point, **just above $70K**, occurred in early August.
- **Peaks near $160K** appeared in late July and mid-August.
- After a mid-period decline, savings steadily recovered and grew toward the end of the month.
- At this pace, projected annual savings **exceed $48M**, confirming strong and predictable ROI.
\`\`\`

Respond only with the markdown. Do not include any explanation or extra text.`;