"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteConversation = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteConversation = async ({
  esClient,
  conversationIndex,
  id,
  logger
}) => {
  try {
    const response = await esClient.deleteByQuery({
      query: {
        ids: {
          values: [id]
        }
      },
      conflicts: 'proceed',
      index: conversationIndex,
      refresh: true
    });
    if (!response.deleted && response.deleted === 0) {
      logger.error(`Error deleting conversation by id: ${id}`);
      throw Error('No conversation has been deleted');
    }
    return response.deleted;
  } catch (err) {
    logger.error(`Error deleting conversation: ${err} with id: ${id}`);
    throw err;
  }
};
exports.deleteConversation = deleteConversation;