"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttackDiscoveryScheduleToApi = void 0;
var _transform_attack_discovery_schedule_actions_props_to_api = require("../transform_attack_discovery_schedule_actions_props_to_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformAttackDiscoveryScheduleToApi = attackDiscoverySchedule => {
  var _transformAttackDisco;
  return {
    id: attackDiscoverySchedule.id,
    name: attackDiscoverySchedule.name,
    created_by: attackDiscoverySchedule.createdBy,
    updated_by: attackDiscoverySchedule.updatedBy,
    created_at: attackDiscoverySchedule.createdAt,
    updated_at: attackDiscoverySchedule.updatedAt,
    enabled: attackDiscoverySchedule.enabled,
    params: {
      alerts_index_pattern: attackDiscoverySchedule.params.alertsIndexPattern,
      api_config: attackDiscoverySchedule.params.apiConfig,
      end: attackDiscoverySchedule.params.end,
      query: attackDiscoverySchedule.params.query,
      filters: attackDiscoverySchedule.params.filters,
      combined_filter: attackDiscoverySchedule.params.combinedFilter,
      size: attackDiscoverySchedule.params.size,
      start: attackDiscoverySchedule.params.start
    },
    schedule: attackDiscoverySchedule.schedule,
    actions: (_transformAttackDisco = (0, _transform_attack_discovery_schedule_actions_props_to_api.transformAttackDiscoveryScheduleActionsPropsToApi)(attackDiscoverySchedule.actions)) !== null && _transformAttackDisco !== void 0 ? _transformAttackDisco : [],
    last_execution: attackDiscoverySchedule.lastExecution
  };
};
exports.transformAttackDiscoveryScheduleToApi = transformAttackDiscoveryScheduleToApi;