"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformInternalReplacements = exports.replaceNewlineLiterals = exports.getTacticMetadata = exports.getTacticLabel = exports.getOriginalAlertIds = exports.RESOURCE_DEVELOPMENT = exports.RECONNAISSANCE = exports.PRIVILEGE_ESCALATION = exports.PERSISTENCE = exports.MITRE_ATTACK_TACTICS_SUBSET = exports.LATERAL_MOVEMENT = exports.INITIAL_ACCESS = exports.IMPACT = exports.EXFILTRATION = exports.EXECUTION = exports.DISCOVERY = exports.DEFENSE_EVASION = exports.CREDENTIAL_ACCESS = exports.COMMAND_AND_CONTROL = exports.COLLECTION = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RECONNAISSANCE = exports.RECONNAISSANCE = 'Reconnaissance';
const RESOURCE_DEVELOPMENT = exports.RESOURCE_DEVELOPMENT = 'Resource Development';
const INITIAL_ACCESS = exports.INITIAL_ACCESS = 'Initial Access';
const EXECUTION = exports.EXECUTION = 'Execution';
const PERSISTENCE = exports.PERSISTENCE = 'Persistence';
const PRIVILEGE_ESCALATION = exports.PRIVILEGE_ESCALATION = 'Privilege Escalation';
const DEFENSE_EVASION = exports.DEFENSE_EVASION = 'Defense Evasion';
const CREDENTIAL_ACCESS = exports.CREDENTIAL_ACCESS = 'Credential Access';
const DISCOVERY = exports.DISCOVERY = 'Discovery';
const LATERAL_MOVEMENT = exports.LATERAL_MOVEMENT = 'Lateral Movement';
const COLLECTION = exports.COLLECTION = 'Collection';
const COMMAND_AND_CONTROL = exports.COMMAND_AND_CONTROL = 'Command and Control';
const EXFILTRATION = exports.EXFILTRATION = 'Exfiltration';
const IMPACT = exports.IMPACT = 'Impact';

/** A subset of the Mitre Attack Tactics */
const MITRE_ATTACK_TACTICS_SUBSET = exports.MITRE_ATTACK_TACTICS_SUBSET = [RECONNAISSANCE, RESOURCE_DEVELOPMENT, INITIAL_ACCESS, EXECUTION, PERSISTENCE, PRIVILEGE_ESCALATION, DEFENSE_EVASION, CREDENTIAL_ACCESS, DISCOVERY, LATERAL_MOVEMENT, COLLECTION, COMMAND_AND_CONTROL, EXFILTRATION, IMPACT];
const getTacticLabel = tactic => {
  switch (tactic) {
    case RECONNAISSANCE:
      return i18n.RECONNAISSANCE;
    case RESOURCE_DEVELOPMENT:
      return i18n.RESOURCE_DEVELOPMENT;
    case INITIAL_ACCESS:
      return i18n.INITIAL_ACCESS;
    case EXECUTION:
      return i18n.EXECUTION;
    case PERSISTENCE:
      return i18n.PERSISTENCE;
    case PRIVILEGE_ESCALATION:
      return i18n.PRIVILEGE_ESCALATION;
    case DEFENSE_EVASION:
      return i18n.DEFENSE_EVASION;
    case CREDENTIAL_ACCESS:
      return i18n.CREDENTIAL_ACCESS;
    case DISCOVERY:
      return i18n.DISCOVERY;
    case LATERAL_MOVEMENT:
      return i18n.LATERAL_MOVEMENT;
    case COLLECTION:
      return i18n.COLLECTION;
    case COMMAND_AND_CONTROL:
      return i18n.COMMAND_AND_CONTROL;
    case EXFILTRATION:
      return i18n.EXFILTRATION;
    case IMPACT:
      return i18n.IMPACT;
    default:
      return tactic;
  }
};
exports.getTacticLabel = getTacticLabel;
const getTacticMetadata = attackDiscovery => MITRE_ATTACK_TACTICS_SUBSET.map((tactic, i) => ({
  detected: attackDiscovery.mitreAttackTactics === undefined ? false : attackDiscovery.mitreAttackTactics.includes(tactic),
  name: getTacticLabel(tactic),
  index: i
}));

/**
 * The LLM sometimes returns a string with newline literals.
 * This function replaces them with actual newlines
 */
exports.getTacticMetadata = getTacticMetadata;
const replaceNewlineLiterals = markdown => markdown.replace(/\\n/g, '\n');
exports.replaceNewlineLiterals = replaceNewlineLiterals;
const getOriginalAlertIds = ({
  alertIds,
  replacements
}) => {
  return alertIds.map(alertId => {
    var _replacements$alertId;
    return replacements != null ? (_replacements$alertId = replacements[alertId]) !== null && _replacements$alertId !== void 0 ? _replacements$alertId : alertId : alertId;
  });
};
exports.getOriginalAlertIds = getOriginalAlertIds;
const transformInternalReplacements = internal => {
  return internal.reduce((acc, r) => r.uuid != null && r.value != null ? {
    ...acc,
    [r.uuid]: r.value
  } : acc, {});
};
exports.transformInternalReplacements = transformInternalReplacements;