"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformAlertSummaryBulkActionResponse = exports.PerformAlertSummaryBulkActionRequestBody = exports.NormalizedAlertSummaryError = exports.AlertSummaryUpdateProps = exports.AlertSummaryResponse = exports.AlertSummaryDetailsInError = exports.AlertSummaryCreateProps = exports.AlertSummaryBulkCrudActionResults = exports.AlertSummaryBulkCrudActionResponse = exports.AlertSummaryBulkActionSkipResult = exports.AlertSummaryBulkActionSkipReason = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
var _common_attributes2 = require("../conversations/common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Bulk AlertSummary Actions API endpoint
 *   version: 1
 */

const AlertSummaryBulkActionSkipReason = exports.AlertSummaryBulkActionSkipReason = _zod.z.literal('ALERT_SUMMARY_NOT_MODIFIED');
const AlertSummaryBulkActionSkipResult = exports.AlertSummaryBulkActionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  alertId: _zod.z.string().optional(),
  skip_reason: AlertSummaryBulkActionSkipReason
});
const AlertSummaryDetailsInError = exports.AlertSummaryDetailsInError = _zod.z.object({
  alertId: _zod.z.string().optional(),
  id: _zod.z.string()
});
const NormalizedAlertSummaryError = exports.NormalizedAlertSummaryError = _zod.z.object({
  message: _zod.z.string(),
  status_code: _zod.z.number().int(),
  err_code: _zod.z.string().optional(),
  alert_summaries: _zod.z.array(AlertSummaryDetailsInError)
});
const AlertSummaryResponse = exports.AlertSummaryResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  alertId: _common_attributes.NonEmptyString,
  timestamp: _common_attributes.NonEmptyTimestamp.optional(),
  summary: _zod.z.string(),
  recommendedActions: _zod.z.string().optional(),
  replacements: _common_attributes2.Replacements,
  updatedAt: _zod.z.string().optional(),
  updatedBy: _zod.z.string().optional(),
  createdAt: _zod.z.string().optional(),
  createdBy: _zod.z.string().optional(),
  users: _zod.z.array(_common_attributes.User).optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string().optional()
});
const AlertSummaryBulkCrudActionResults = exports.AlertSummaryBulkCrudActionResults = _zod.z.object({
  updated: _zod.z.array(AlertSummaryResponse),
  created: _zod.z.array(AlertSummaryResponse),
  deleted: _zod.z.array(_zod.z.string()),
  skipped: _zod.z.array(AlertSummaryBulkActionSkipResult)
});
const AlertSummaryBulkCrudActionResponse = exports.AlertSummaryBulkCrudActionResponse = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  alert_summaries_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: AlertSummaryBulkCrudActionResults,
    summary: _common_attributes.BulkCrudActionSummary,
    errors: _zod.z.array(NormalizedAlertSummaryError).optional()
  })
});
const AlertSummaryCreateProps = exports.AlertSummaryCreateProps = _zod.z.object({
  alertId: _zod.z.string(),
  summary: _zod.z.string(),
  recommendedActions: _zod.z.string().optional(),
  replacements: _common_attributes2.Replacements
});
const AlertSummaryUpdateProps = exports.AlertSummaryUpdateProps = _zod.z.object({
  id: _zod.z.string(),
  summary: _zod.z.string().optional(),
  recommendedActions: _zod.z.string().optional(),
  replacements: _common_attributes2.Replacements.optional()
});
const PerformAlertSummaryBulkActionRequestBody = exports.PerformAlertSummaryBulkActionRequestBody = _zod.z.object({
  delete: _common_attributes.BulkActionBase.optional(),
  create: _zod.z.array(AlertSummaryCreateProps).optional(),
  update: _zod.z.array(AlertSummaryUpdateProps).optional()
});
const PerformAlertSummaryBulkActionResponse = exports.PerformAlertSummaryBulkActionResponse = AlertSummaryBulkCrudActionResponse;