"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageReady = void 0;
var _react = require("react");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const usePageReady = ({
  customInitialLoad,
  isReady,
  isRefreshing,
  customMetrics,
  meta
}) => {
  const {
    onPageReady,
    onPageRefreshStart
  } = (0, _.usePerformanceContext)();
  const prevIsRefreshing = (0, _usePrevious.default)(isRefreshing);
  const [isInitialLoadInternal, setIsInitialLoadInternal] = (0, _react.useState)(true);
  const isInitialLoad = customInitialLoad ? customInitialLoad.value : isInitialLoadInternal;
  (0, _react.useEffect)(() => {
    // Skip until either the page is ready for the first time or a refresh cycle begins
    if (isInitialLoad && !isReady) return;

    // Initial load flow
    if (isReady && isInitialLoad) {
      onPageReady({
        customMetrics,
        meta
      });
      customInitialLoad === null || customInitialLoad === void 0 ? void 0 : customInitialLoad.onInitialLoadReported();
      setIsInitialLoadInternal(false);
      return;
    }

    // Refresh flow (only after the initial load has been reported)
    if (!prevIsRefreshing && isRefreshing) {
      onPageRefreshStart();
    } else if (prevIsRefreshing && !isRefreshing) {
      onPageReady({
        customMetrics,
        meta
      });
    }
  }, [customInitialLoad, customMetrics, isInitialLoad, isReady, isRefreshing, meta, onPageReady, onPageRefreshStart, prevIsRefreshing]);
};
exports.usePageReady = usePageReady;