"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDataTableRecord = buildDataTableRecord;
exports.buildDataTableRecordList = buildDataTableRecordList;
var _dataService = require("@kbn/data-service");
var _get_doc_id = require("./get_doc_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Build a record for data grid
 * @param doc the document returned from Elasticsearch
 * @param dataView this current data view
 * @param isAnchor determines if the given doc is the anchor doc when viewing surrounding documents
 */
function buildDataTableRecord(doc, dataView, isAnchor, options) {
  return {
    id: (0, _get_doc_id.getDocId)(doc),
    raw: doc,
    flattened: (0, _dataService.flattenHit)(doc, dataView, {
      includeIgnoredValues: true,
      flattenedFieldsComparator: options === null || options === void 0 ? void 0 : options.flattenedFieldsComparator
    }),
    isAnchor
  };
}

/**
 * Helper to build multiple DataTableRecords at once, saved a bit of testing code lines
 * @param records Array of documents returned from Elasticsearch
 * @param dataView this current data view
 */
function buildDataTableRecordList({
  records,
  dataView,
  processRecord
}) {
  const buildRecordOptions = {
    flattenedFieldsComparator: (0, _dataService.getFlattenedFieldsComparator)(dataView)
  };
  return records.map(doc => {
    const record = buildDataTableRecord(doc, dataView, undefined, buildRecordOptions);
    return processRecord ? processRecord(record) : record;
  });
}