"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchEmbeddablFieldStatsTableComponent = SearchEmbeddablFieldStatsTableComponent;
var _react = _interopRequireWildcard(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _field_stats_table = require("../../application/main/components/field_stats_table");
var _initialize_fetch = require("../initialize_fetch");
var _use_discover_services = require("../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/embeddable/components/search_embeddable_field_stats_table_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SearchEmbeddablFieldStatsTableComponent({
  api,
  dataView,
  onAddFilter,
  stateManager
}) {
  var _services$dataVisuali, _savedSearch$columns;
  const [fetchContext, savedSearch] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.fetchContext$, api.savedSearch$);
  const isEsql = (0, _react.useMemo)(() => (0, _initialize_fetch.isEsqlMode)(savedSearch), [savedSearch]);
  const services = (0, _use_discover_services.useDiscoverServices)();

  // Quit early if we know it's in ES|QL mode
  if (isEsql && (_services$dataVisuali = services.dataVisualizer) !== null && _services$dataVisuali !== void 0 && _services$dataVisuali.FieldStatsUnavailableMessage) {
    return /*#__PURE__*/_react.default.createElement(services.dataVisualizer.FieldStatsUnavailableMessage, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTable, {
    dataView: dataView,
    columns: (_savedSearch$columns = savedSearch.columns) !== null && _savedSearch$columns !== void 0 ? _savedSearch$columns : [],
    savedSearch: savedSearch,
    filters: fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.filters,
    query: fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.query,
    onAddFilter: onAddFilter,
    searchSessionId: fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.searchSessionId,
    isEsqlMode: isEsql,
    timeRange: fetchContext === null || fetchContext === void 0 ? void 0 : fetchContext.timeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
}