"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlLocatorGetLocation = void 0;
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const esqlLocatorGetLocation = async ({
  discoverAppLocator,
  dataViews
}) => {
  var _await$getIndexForESQ;
  const indexName = (_await$getIndexForESQ = await (0, _esqlUtils.getIndexForESQLQuery)({
    dataViews
  })) !== null && _await$getIndexForESQ !== void 0 ? _await$getIndexForESQ : '*';
  const dataView = await (0, _esqlUtils.getESQLAdHocDataview)(`from ${indexName}`, dataViews);
  const esql = (0, _esqlUtils.getInitialESQLQuery)(dataView, true);
  const params = {
    query: {
      esql
    }
  };
  return await discoverAppLocator.getLocation(params);
};
exports.esqlLocatorGetLocation = esqlLocatorGetLocation;