"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDatasetQualityTableColumns = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../common/constants");
var _data_stream_stat = require("../../../../common/data_streams_stats/data_stream_stat");
var _hooks = require("../../../hooks");
var _common = require("../../common");
var _quality_indicator = require("../../quality_indicator");
var _dataset_quality_details_link = require("./dataset_quality_details_link");
var _quality_stat_percentage_link = require("./quality_stat_percentage_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const nameColumnName = _i18n.i18n.translate('xpack.datasetQuality.nameColumnName', {
  defaultMessage: 'Data set name'
});
const namespaceColumnName = _i18n.i18n.translate('xpack.datasetQuality.namespaceColumnName', {
  defaultMessage: 'Namespace'
});
const typeColumnName = _i18n.i18n.translate('xpack.datasetQuality.typeColumnName', {
  defaultMessage: 'Type'
});
const sizeColumnName = _i18n.i18n.translate('xpack.datasetQuality.sizeColumnName', {
  defaultMessage: 'Size'
});
const degradedDocsColumnName = _i18n.i18n.translate('xpack.datasetQuality.degradedDocsColumnName', {
  defaultMessage: 'Degraded docs (%)'
});
const failedDocsColumnName = _i18n.i18n.translate('xpack.datasetQuality.failedDocsColumnName', {
  defaultMessage: 'Failed docs (%)'
});
const datasetQualityColumnName = _i18n.i18n.translate('xpack.datasetQuality.datasetQualityColumnName', {
  defaultMessage: 'Data set quality'
});
const lastActivityColumnName = _i18n.i18n.translate('xpack.datasetQuality.lastActivityColumnName', {
  defaultMessage: 'Last activity'
});
const actionsColumnName = _i18n.i18n.translate('xpack.datasetQuality.actionsColumnName', {
  defaultMessage: 'Actions'
});
const openActionName = _i18n.i18n.translate('xpack.datasetQuality.openActionName', {
  defaultMessage: 'Open'
});
const inactiveDatasetActivityColumnDescription = _i18n.i18n.translate('xpack.datasetQuality.inactiveDatasetActivityColumnDescription', {
  defaultMessage: 'No activity in the selected timeframe'
});
const inactiveDatasetActivityColumnTooltip = _i18n.i18n.translate('xpack.datasetQuality.inactiveDatasetActivityColumnTooltip', {
  defaultMessage: 'Try expanding the time range above for more results'
});
const degradedDocsDescription = (quality, minimimPercentage, comparator = '') => _i18n.i18n.translate('xpack.datasetQuality.degradedDocsQualityDescription', {
  defaultMessage: '{quality} -{comparator} {minimimPercentage}%',
  values: {
    quality,
    minimimPercentage,
    comparator
  }
});
const degradedDocsColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.degradedDocsColumnTooltip",
  defaultMessage: "The percentage of documents with the {ignoredProperty} property in your data set.",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }, "_ignored")
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 108,
    columnNumber: 3
  }
});
const failedDocsColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.failedDocsColumnTooltip",
  defaultMessage: "The percentage of docs sent to failure store due to an issue during ingestion. Failed documents are only captured if the failure store is explicitly enabled.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 3
  }
});
const datasetQualityColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.datasetQualityColumnTooltip",
  defaultMessage: "Quality is based on the percentage of degraded and failed docs in a data set. {visualQueue}",
  values: {
    visualQueue: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "poor",
      description: ` ${degradedDocsDescription('Poor', _constants.POOR_QUALITY_MINIMUM_PERCENTAGE, ' greater than')}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "degraded",
      description: ` ${degradedDocsDescription('Degraded', _constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE, ' greater than')}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityIndicator, {
      quality: "good",
      description: ` ${degradedDocsDescription('Good', _constants.DEGRADED_QUALITY_MINIMUM_PERCENTAGE)}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    })))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 129,
    columnNumber: 3
  }
});
const getDatasetQualityTableColumns = ({
  fieldFormats,
  canUserMonitorAnyDataset,
  canUserMonitorAnyDataStream,
  loadingDataStreamStats,
  loadingDocStats,
  loadingDegradedStats,
  loadingFailedStats,
  showFullDatasetNames,
  isActiveDataset,
  timeRange,
  urlService,
  canReadFailureStore
}) => {
  return [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      "data-test-subj": "datasetQualityNameColumn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 9
      }
    }, nameColumnName),
    field: 'title',
    sortable: true,
    render: (title, dataStreamStat) => {
      const {
        integration,
        name,
        rawName
      } = dataStreamStat;
      return /*#__PURE__*/_react.default.createElement(_dataset_quality_details_link.DatasetQualityDetailsLink, {
        urlService: urlService,
        dataStream: rawName,
        timeRange: timeRange,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 208,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 214,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
        integration: integration,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 15
        }
      }, title), showFullDatasetNames && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("em", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 19
        }
      }, name))));
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      "data-test-subj": "datasetQualityNamespaceColumn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 9
      }
    }, namespaceColumnName),
    field: 'namespace',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }, dataStreamStat.namespace),
    width: '160px'
  }, {
    name: typeColumnName,
    field: 'type',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 9
      }
    }, dataStreamStat.type),
    width: '160px'
  }, ...(canUserMonitorAnyDataset && canUserMonitorAnyDataStream ? [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      "data-test-subj": "datasetQualitySizeColumn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 15
      }
    }, sizeColumnName),
    field: 'sizeBytes',
    sortable: true,
    render: (_, dataStreamStat) => {
      var _dataStreamStat$userP, _dataStreamStat$userP2;
      return /*#__PURE__*/_react.default.createElement(_common.PrivilegesWarningIconWrapper, {
        title: `sizeBytes-${dataStreamStat.title}`,
        hasPrivileges: (_dataStreamStat$userP = (_dataStreamStat$userP2 = dataStreamStat.userPrivileges) === null || _dataStreamStat$userP2 === void 0 ? void 0 : _dataStreamStat$userP2.canMonitor) !== null && _dataStreamStat$userP !== void 0 ? _dataStreamStat$userP : true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
        width: "60px",
        height: "20px",
        borderRadius: "m",
        isLoading: loadingDataStreamStats || loadingDocStats,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 19
        }
      }, (0, _eui.formatNumber)(_data_stream_stat.DataStreamStat.calculateFilteredSize(dataStreamStat), _constants.BYTE_NUMBER_FORMAT)));
    },
    width: '100px'
  }] : []), {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      "data-test-subj": "datasetQualityQualityColumn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 11
      }
    }, datasetQualityColumnName)),
    nameTooltip: {
      content: datasetQualityColumnTooltip,
      icon: 'question'
    },
    field: 'quality',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_quality_indicator.DatasetQualityIndicator, {
      isLoading: loadingDegradedStats || loadingFailedStats || loadingDocStats,
      quality: dataStreamStat.quality,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 9
      }
    }),
    width: '140px'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      "data-test-subj": "datasetQualityPercentageColumn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 11
      }
    }, degradedDocsColumnName)),
    nameTooltip: {
      content: degradedDocsColumnTooltip,
      icon: 'question'
    },
    field: 'degradedDocs.percentage',
    sortable: true,
    render: (_, dataStreamStat) => /*#__PURE__*/_react.default.createElement(_quality_stat_percentage_link.QualityStatPercentageLink, {
      isLoading: loadingDegradedStats,
      dataStreamStat: dataStreamStat,
      timeRange: timeRange,
      accessor: "degradedDocs",
      query: {
        language: 'kuery',
        query: _constants.DEGRADED_DOCS_QUERY
      },
      fewDocStatsTooltip: degradedDocsCount => _i18n.i18n.translate('xpack.datasetQuality.fewDegradedDocsTooltip', {
        defaultMessage: '{degradedDocsCount} degraded docs in this data set.',
        values: {
          degradedDocsCount
        }
      }),
      dataTestSubj: "datasetQualityDegradedDocsPercentageLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 9
      }
    }),
    width: '140px'
  }, ...(canReadFailureStore ? [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      "data-test-subj": "datasetQualityFailedPercentageColumn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 17
      }
    }, failedDocsColumnName)),
    nameTooltip: {
      content: failedDocsColumnTooltip,
      icon: 'question'
    },
    field: 'failedDocs.percentage',
    sortable: true,
    render: (_, dataStreamStat) => {
      var _dataStreamStat$userP3, _dataStreamStat$userP4, _dataStreamStat$userP5;
      if (!dataStreamStat.hasFailureStore && (_dataStreamStat$userP3 = dataStreamStat.userPrivileges) !== null && _dataStreamStat$userP3 !== void 0 && _dataStreamStat$userP3.canReadFailureStore) {
        const FailureStoreHoverLink = () => {
          const [hovered, setHovered] = _react.default.useState(false);
          const locator = urlService.locators.get('INDEX_MANAGEMENT_LOCATOR_ID');
          const params = {
            page: 'data_streams_details',
            dataStreamName: dataStreamStat.rawName
          };
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: _i18n.i18n.translate('xpack.datasetQuality.failureStore.notEnabled', {
              defaultMessage: 'Failure store is not enabled for this data stream. Enable failure store.'
            }),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 364,
              columnNumber: 21
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(params),
            target: "_blank",
            external: false,
            "data-test-subj": "datasetQualitySetFailureStoreLink",
            onMouseEnter: () => setHovered(true),
            onMouseLeave: () => setHovered(false),
            css: {
              fontWeight: 'normal'
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 370,
              columnNumber: 23
            }
          }, hovered ? _i18n.i18n.translate('xpack.datasetQuality.failureStore.enable', {
            defaultMessage: 'Set failure store'
          }) : _i18n.i18n.translate('xpack.datasetQuality.failureStore.notAvailable', {
            defaultMessage: 'N/A'
          })));
        };
        return /*#__PURE__*/_react.default.createElement(FailureStoreHoverLink, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 390,
            columnNumber: 24
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_common.PrivilegesWarningIconWrapper, {
        title: `sizeBytes-${dataStreamStat.title}`,
        hasPrivileges: (_dataStreamStat$userP4 = (_dataStreamStat$userP5 = dataStreamStat.userPrivileges) === null || _dataStreamStat$userP5 === void 0 ? void 0 : _dataStreamStat$userP5.canReadFailureStore) !== null && _dataStreamStat$userP4 !== void 0 ? _dataStreamStat$userP4 : true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_quality_stat_percentage_link.QualityStatPercentageLink, {
        isLoading: loadingFailedStats,
        dataStreamStat: dataStreamStat,
        timeRange: timeRange,
        accessor: "failedDocs",
        selector: _constants.FAILURE_STORE_SELECTOR,
        fewDocStatsTooltip: failedDocsCount => _i18n.i18n.translate('xpack.datasetQuality.fewFailedDocsTooltip', {
          defaultMessage: '{failedDocsCount} failed docs in this data set.',
          values: {
            failedDocsCount
          }
        }),
        dataTestSubj: "datasetQualityFailedDocsPercentageLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 19
        }
      }));
    },
    width: '140px'
  }] : []), ...(canUserMonitorAnyDataset && canUserMonitorAnyDataStream ? [{
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
      "data-test-subj": "datasetQualityLastActivityColumn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 15
      }
    }, lastActivityColumnName),
    field: 'lastActivity',
    render: timestamp => /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
      width: "200px",
      height: "20px",
      borderRadius: "m",
      isLoading: loadingDataStreamStats,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 15
      }
    }, !isActiveDataset(timestamp) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 437,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 438,
        columnNumber: 21
      }
    }, inactiveDatasetActivityColumnDescription), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: inactiveDatasetActivityColumnTooltip,
      type: "info",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 21
      }
    })) : fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]).convert(timestamp)),
    width: '300px',
    sortable: true
  }] : []), {
    name: actionsColumnName,
    render: dataStreamStat => /*#__PURE__*/_react.default.createElement(RedirectLink, {
      dataStreamStat: dataStreamStat,
      title: openActionName,
      timeRange: timeRange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 9
      }
    }),
    width: '100px'
  }];
};
exports.getDatasetQualityTableColumns = getDatasetQualityTableColumns;
const RedirectLink = ({
  dataStreamStat,
  title,
  timeRange
}) => {
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetRedirectLinkTelemetry)({
    rawName: dataStreamStat.rawName
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat: `${dataStreamStat.rawName},${dataStreamStat.rawName}${_constants.FAILURE_STORE_SELECTOR}`,
    sendTelemetry,
    timeRangeConfig: timeRange
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "datasetQualityLogsExplorerLinkLink"
  }, redirectLinkProps.linkProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 489,
      columnNumber: 5
    }
  }), title);
};