"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _translations = require("../../../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/filters/charts_filter_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartsFilterPopover = exports.ChartsFilterPopover = /*#__PURE__*/(0, _react.memo)(({
  children,
  closePopover,
  filterName,
  hasActiveFilters,
  isPopoverOpen,
  numActiveFilters,
  numFilters,
  onButtonClick,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filterGroupPopover'
  });
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": getTestId(`${filterName}-popoverButton`),
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: numFilters,
    hasActiveFilters: hasActiveFilters,
    numActiveFilters: numActiveFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, _translations.FILTER_NAMES[filterName]), [filterName, getTestId, hasActiveFilters, isPopoverOpen, numActiveFilters, numFilters, onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, children);
});
ChartsFilterPopover.displayName = 'ChartsFilterPopover';