"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _data_table = require("./data_table");
var _data_table_selector = require("./data_table_selector");
var _download_options = require("./download_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/utils/table_inspector_view/components/data_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class DataViewComponent extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "onUpdateData", tables => {
      const keys = Object.keys(tables);
      const datatable = keys.length ? tables[keys[0]] : undefined;
      if (datatable) {
        this.setState({
          datatable
        });
      }
    });
    (0, _defineProperty2.default)(this, "selectTable", datatable => {
      if (datatable !== this.state.datatable) {
        this.setState({
          datatable
        });
      }
    });
  }
  static getDerivedStateFromProps(nextProps, state) {
    var _nextProps$adapters$t;
    if (state && nextProps.adapters === state.adapters) {
      return null;
    }
    const {
      tables,
      initialSelectedTable
    } = (_nextProps$adapters$t = nextProps.adapters.tables) !== null && _nextProps$adapters$t !== void 0 ? _nextProps$adapters$t : {};
    const keys = Object.keys(tables);
    const intialTableKey = keys.includes(initialSelectedTable) ? initialSelectedTable : keys[0];
    const datatable = keys.length ? tables[intialTableKey] : undefined;
    return {
      adapters: nextProps.adapters,
      datatable
    };
  }
  componentDidMount() {
    this.props.adapters.tables.on('change', this.onUpdateData);
  }
  componentWillUnmount() {
    this.props.adapters.tables.removeListener('change', this.onUpdateData);
  }
  static renderNoData() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.noDataAvailableTitle",
        defaultMessage: "No data available",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.noDataAvailableDescription",
        defaultMessage: "The element did not provide any data.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 15
        }
      }))),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    });
  }
  render() {
    var _this$props$options;
    if (!this.state.datatable) {
      return DataViewComponent.renderNoData();
    }
    const datatables = Object.values(this.state.adapters.tables.tables);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, datatables.length > 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      role: "status",
      "aria-live": "polite",
      "aria-atomic": "true",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "inspectorDataViewSelectorLabel",
      id: "data.inspector.table.tablesDescription",
      defaultMessage: "There are {tablesCount, plural, one {# table} other {# tables} } in total",
      values: {
        tablesCount: datatables.length
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_data_table_selector.TableSelector, {
      tables: datatables,
      selectedTable: this.state.datatable,
      onTableChanged: this.selectTable,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_download_options.DataDownloadOptions, {
      title: ((_this$props$options = this.props.options) === null || _this$props$options === void 0 ? void 0 : _this$props$options.fileName) || this.props.title,
      uiSettings: this.props.uiSettings,
      datatables: datatables,
      fieldFormats: this.props.fieldFormats,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_data_table.DataTableFormat, {
      data: this.state.datatable,
      uiSettings: this.props.uiSettings,
      fieldFormats: this.props.fieldFormats,
      uiActions: this.props.uiActions,
      isFilterable: this.props.isFilterable,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    }));
  }
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
var _default = exports.default = DataViewComponent;
module.exports = exports.default;