"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardResolveMetaSchema = exports.dashboardMetaSchema = void 0;
exports.getDashboardAPICreateResultSchema = getDashboardAPICreateResultSchema;
exports.getDashboardAPIItemSchema = getDashboardAPIItemSchema;
exports.getDashboardDataSchema = getDashboardDataSchema;
exports.getDashboardItemSchema = getDashboardItemSchema;
exports.getDashboardResponseAttributesSchema = getDashboardResponseAttributesSchema;
exports.getDashboardStateSchema = getDashboardStateSchema;
exports.getDashboardStorageSchema = getDashboardStorageSchema;
exports.getPanelSchema = getPanelSchema;
exports.getSectionSchema = getSectionSchema;
exports.panelGridDataSchema = exports.optionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _dataServiceServer = require("@kbn/data-service-server");
var _controlsSchemas = require("@kbn/controls-schemas");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _esQueryServer = require("@kbn/es-query-server");
var _kibana_services = require("../../../kibana_services");
var _content_management = require("../../../../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const apiError = _configSchema.schema.object({
  error: _configSchema.schema.string(),
  message: _configSchema.schema.string(),
  statusCode: _configSchema.schema.number(),
  metadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
const panelGridDataSchema = exports.panelGridDataSchema = _configSchema.schema.object({
  x: _configSchema.schema.number({
    meta: {
      description: 'The x coordinate of the panel in grid units'
    }
  }),
  y: _configSchema.schema.number({
    meta: {
      description: 'The y coordinate of the panel in grid units'
    }
  }),
  w: _configSchema.schema.number({
    defaultValue: _content_management.DEFAULT_PANEL_WIDTH,
    min: 1,
    max: _content_management.DASHBOARD_GRID_COLUMN_COUNT,
    meta: {
      description: 'The width of the panel in grid units'
    }
  }),
  h: _configSchema.schema.number({
    defaultValue: _content_management.DEFAULT_PANEL_HEIGHT,
    min: 1,
    meta: {
      description: 'The height of the panel in grid units'
    }
  })
});
function getPanelSchema() {
  return _configSchema.schema.object({
    config: _configSchema.schema.oneOf([...(_kibana_services.embeddableService ? _kibana_services.embeddableService.getEmbeddableSchemas() : []), _configSchema.schema.object({}, {
      unknowns: 'allow'
    })]),
    type: _configSchema.schema.string({
      meta: {
        description: 'The embeddable type'
      }
    }),
    grid: panelGridDataSchema,
    /**
     * `uid` was chosen as a name instead of `id` to avoid bwc issues with legacy dashboard URL state that used `id` to
     * represent ids of library items in by-reference panels. This was previously called `panelIndex` in DashboardPanelState.
     * In the stored object, `uid` continues to map to `panelIndex`.
     */
    uid: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'The unique ID of the panel.'
      }
    })),
    version: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: "The version was used to store Kibana version information from versions 7.3.0 -> 8.11.0. As of version 8.11.0, the versioning information is now per-embeddable-type and is stored on the embeddable's input. (config in this type).",
        deprecated: true
      }
    }))
  });
}
const sectionGridDataSchema = _configSchema.schema.object({
  y: _configSchema.schema.number({
    meta: {
      description: 'The y coordinate of the section in grid units'
    }
  })
});
function getSectionSchema() {
  return _configSchema.schema.object({
    title: _configSchema.schema.string({
      meta: {
        description: 'The title of the section.'
      }
    }),
    collapsed: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'The collapsed state of the section.'
      },
      defaultValue: false
    })),
    grid: sectionGridDataSchema,
    panels: _configSchema.schema.arrayOf(getPanelSchema(), {
      meta: {
        description: 'The panels that belong to the section.'
      },
      defaultValue: []
    }),
    uid: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'The unique ID of the section.'
      }
    }))
  });
}
const dashboardMetaSchema = exports.dashboardMetaSchema = _configSchema.schema.object({
  updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  managed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  error: _configSchema.schema.maybe(apiError),
  version: _configSchema.schema.string()
});
const optionsSchema = exports.optionsSchema = _configSchema.schema.object({
  hidePanelTitles: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.hidePanelTitles,
    meta: {
      description: 'Hide the panel titles in the dashboard.'
    }
  })),
  useMargins: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.useMargins,
    meta: {
      description: 'Show margins between panels in the dashboard layout.'
    }
  })),
  syncColors: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.syncColors,
    meta: {
      description: 'Synchronize colors between related panels in the dashboard.'
    }
  })),
  syncTooltips: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.syncTooltips,
    meta: {
      description: 'Synchronize tooltips between related panels in the dashboard.'
    }
  })),
  syncCursor: _configSchema.schema.maybe(_configSchema.schema.boolean({
    defaultValue: _content_management.DEFAULT_DASHBOARD_OPTIONS.syncCursor,
    meta: {
      description: 'Synchronize cursor position between related panels in the dashboard.'
    }
  }))
});
function getDashboardStateSchema() {
  return {
    controlGroupInput: _configSchema.schema.maybe(_controlsSchemas.controlsGroupSchema),
    description: _configSchema.schema.string({
      defaultValue: '',
      meta: {
        description: 'A short description.'
      }
    }),
    filters: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_esQueryServer.filterSchema)),
    options: _configSchema.schema.maybe(optionsSchema),
    panels: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([getPanelSchema(), getSectionSchema()]), {
      defaultValue: []
    }),
    query: _configSchema.schema.maybe(_esQueryServer.querySchema),
    refreshInterval: _configSchema.schema.maybe(_dataServiceServer.refreshIntervalSchema),
    tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
      meta: {
        description: 'An array of tags ids applied to this dashboard'
      }
    }))),
    timeRange: _configSchema.schema.maybe(_esQueryServer.timeRangeSchema),
    timeRestore: _configSchema.schema.boolean({
      defaultValue: false,
      meta: {
        description: 'Whether to restore time upon viewing this dashboard'
      }
    }),
    title: _configSchema.schema.string({
      meta: {
        description: 'A human-readable title for the dashboard'
      }
    }),
    version: _configSchema.schema.maybe(_configSchema.schema.number({
      meta: {
        deprecated: true
      }
    }))
  };
}
function getDashboardDataSchema() {
  return _configSchema.schema.object({
    ...getDashboardStateSchema(),
    references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_contentManagementUtils.referenceSchema)),
    spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  });
}
function getDashboardAPIItemSchema() {
  return _configSchema.schema.object({
    data: getDashboardDataSchema(),
    meta: dashboardMetaSchema,
    type: _configSchema.schema.string(),
    id: _configSchema.schema.string()
  });
}
function getDashboardAPICreateResultSchema() {
  return _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    data: getDashboardDataSchema(),
    meta: dashboardMetaSchema
  }, {
    unknowns: 'forbid'
  });
}
function getDashboardResponseAttributesSchema() {
  return _configSchema.schema.object({
    ...getDashboardStateSchema(),
    references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_contentManagementUtils.referenceSchema)),
    spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  });
}
function getDashboardStorageSchema() {
  return _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    version: _configSchema.schema.maybe(_configSchema.schema.string()),
    createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
    updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
    createdBy: _configSchema.schema.maybe(_configSchema.schema.string()),
    updatedBy: _configSchema.schema.maybe(_configSchema.schema.string()),
    managed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    error: _configSchema.schema.maybe(apiError),
    attributes: _configSchema.schema.object(getDashboardStateSchema()),
    references: _configSchema.schema.arrayOf(_contentManagementUtils.referenceSchema),
    namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    originId: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  });
}
const dashboardResolveMetaSchema = exports.dashboardResolveMetaSchema = {
  outcome: _configSchema.schema.oneOf([_configSchema.schema.literal('exactMatch'), _configSchema.schema.literal('aliasMatch'), _configSchema.schema.literal('conflict')]),
  aliasTargetId: _configSchema.schema.maybe(_configSchema.schema.string()),
  aliasPurpose: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('savedObjectConversion'), _configSchema.schema.literal('savedObjectImport')]))
};
function getDashboardItemSchema() {
  return _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    version: _configSchema.schema.maybe(_configSchema.schema.string()),
    createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
    updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
    createdBy: _configSchema.schema.maybe(_configSchema.schema.string()),
    updatedBy: _configSchema.schema.maybe(_configSchema.schema.string()),
    managed: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    error: _configSchema.schema.maybe(apiError),
    attributes: _configSchema.schema.object(getDashboardStateSchema()),
    references: _configSchema.schema.arrayOf(_contentManagementUtils.referenceSchema),
    namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    originId: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    unknowns: 'allow'
  });
}