"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSettingsType = exports.uiSettingsGlobalType = void 0;
var _migrations = require("./migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The `config` object type contains many attributes that are defined by consumers.
 */

const uiSettingsType = exports.uiSettingsType = {
  name: 'config',
  hidden: false,
  namespaceType: 'single',
  mappings: {
    dynamic: false,
    properties: {
      buildNum: {
        type: 'keyword'
      }
    }
  },
  management: {
    importableAndExportable: true,
    getInAppUrl() {
      return {
        path: `/app/management/kibana/settings`,
        uiCapabilitiesPath: 'advancedSettings.show'
      };
    },
    getTitle(obj) {
      return `Advanced Settings [${obj.id}]`;
    }
  },
  migrations: _migrations.migrations,
  modelVersions: _migrations.modelVersions
};
const uiSettingsGlobalType = exports.uiSettingsGlobalType = {
  name: 'config-global',
  hidden: false,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      buildNum: {
        type: 'keyword'
      }
    }
  },
  management: {
    importableAndExportable: true,
    getInAppUrl() {
      return {
        path: `/app/management/kibana/settings`,
        uiCapabilitiesPath: 'advancedSettings.show'
      };
    },
    getTitle(obj) {
      return `Global Settings [${obj.id}]`;
    }
  }
};