"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CapabilitiesProvider = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Service identifier to register a capabilities provider.
 * @see {@link CapabilitiesSetup}
 * @example
 * ```ts
 * bind(CapabilitiesProvider).toConstantValue(() => {
 *   something: { read: true },
 * });
 * ```
 * @public
 */
const CapabilitiesProvider = exports.CapabilitiesProvider = Symbol('CapabilitiesProvider');