"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestionAggregationBuilder = void 0;
var _options_list_all_suggestions = require("./options_list_all_suggestions");
var _options_list_exact_match = require("./options_list_exact_match");
var _options_list_search_suggestions = require("./options_list_search_suggestions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Suggestion aggregations
 */
const getSuggestionAggregationBuilder = request => {
  const {
    searchString,
    searchTechnique,
    allowExpensiveQueries
  } = request;
  const hasSearchString = searchString && searchString.length > 0;
  if (!hasSearchString) {
    // the field type only matters when there is a search string; so, if no search string,
    // return generic "fetch all" aggregation builder
    return (0, _options_list_all_suggestions.getAllSuggestionsAggregationBuilder)();
  } else if (!allowExpensiveQueries || searchTechnique === 'exact') {
    // if `allowExpensiveQueries` is false, only support exact match searching; also, field type
    // once again does not matter when building an exact match aggregation
    return (0, _options_list_exact_match.getExactMatchAggregationBuilder)();
  } else {
    // at this point, the type of the field matters - so, fetch the type-specific search agg
    return (0, _options_list_search_suggestions.getSearchSuggestionsAggregationBuilder)(request);
  }
};
exports.getSuggestionAggregationBuilder = getSuggestionAggregationBuilder;