"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSaveCurrentTextObject = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _contexts = require("../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const WAIT_MS = 500;
const useSaveCurrentTextObject = () => {
  const promiseChainRef = (0, _react.useRef)(Promise.resolve());
  const {
    services: {
      objectStorageClient
    }
  } = (0, _contexts.useServicesContext)();
  const {
    currentTextObject
  } = (0, _contexts.useEditorReadContext)();

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  return (0, _react.useCallback)((0, _lodash.throttle)(text => {
    const {
      current: promise
    } = promiseChainRef;
    if (!currentTextObject) return;
    promise.finally(() => objectStorageClient.text.update({
      ...currentTextObject,
      text,
      updatedAt: Date.now()
    }));
  }, WAIT_MS, {
    trailing: true
  }), [objectStorageClient, currentTextObject]);
};
exports.useSaveCurrentTextObject = useSaveCurrentTextObject;